/*
 * Decompiled with CFR 0.152.
 */
package org.joni.encoding.specific;

import org.joni.IntHolder;
import org.joni.encoding.specific.ASCIIEncoding;
import org.joni.encoding.specific.UTF16BEEncoding;
import org.joni.encoding.unicode.UnicodeEncoding;

public final class UTF16LEEncoding
extends UnicodeEncoding {
    public static final UTF16LEEncoding INSTANCE = new UTF16LEEncoding();

    protected UTF16LEEncoding() {
        super(UTF16BEEncoding.UTF16EncLen);
    }

    public int length(byte c) {
        return this.EncLen[(c & 0xFF) + 1];
    }

    public String toString() {
        return "UTF-16LE";
    }

    public int maxLength() {
        return 4;
    }

    public int minLength() {
        return 2;
    }

    public boolean isFixedWidth() {
        return false;
    }

    public boolean isNewLine(byte[] bytes, int p2, int end2) {
        return p2 + 1 < end2 && bytes[p2] == 10 && bytes[p2 + 1] == 0;
    }

    private static boolean isSurrogateFirst(int c) {
        return c >= 216 && c <= 219;
    }

    public int mbcToCode(byte[] bytes, int p2, int end2) {
        int code = UTF16LEEncoding.isSurrogateFirst(bytes[p2 + 1] & 0xFF) ? (((bytes[p2 + 1] & 0x27) << 2) + ((bytes[p2 + 0] & 0xFF & 0xC0) >> 6) + 1 << 16) + (((bytes[p2 + 0] & 0xFF & 0x3F) << 2) + (bytes[p2 + 2] & 0x23) << 8) + bytes[p2 + 3] & 0xFF : (bytes[p2 + 1] & 0xFF) * 256 + (bytes[p2 + 0] & 0xFF);
        return code;
    }

    public int codeToMbcLength(int code) {
        return code > 65535 ? 4 : 2;
    }

    public int codeToMbc(int code, byte[] bytes, int p2) {
        int p_ = p2;
        if (code > 65535) {
            int plane = code >>> 16;
            int high = (code & 0xFF00) >>> 8;
            bytes[p_++] = (byte)(((plane & 3) << 6) + (high >>> 2));
            bytes[p_++] = (byte)((plane >>> 2) + 216);
            bytes[p_++] = (byte)(code & 0xFF);
            bytes[p_] = (byte)((high & 2) + 220);
            return 4;
        }
        bytes[p_++] = (byte)(code & 0xFF);
        bytes[p_++] = (byte)((code & 0xFF00) >>> 8);
        return 2;
    }

    public int mbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end2, byte[] fold) {
        int p2 = pp.value;
        int foldP = 0;
        if (UTF16LEEncoding.isAscii(bytes[p2] & 0xFF) && bytes[p2 + 1] == 0) {
            fold[foldP++] = ASCIIEncoding.AsciiToLowerCaseTable[bytes[p2] & 0xFF];
            fold[foldP] = 0;
            pp.value += 2;
            return 2;
        }
        return super.mbcCaseFold(flag, bytes, pp, end2, fold);
    }

    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        sbOut.value = 0;
        return super.ctypeCodeRange(ctype);
    }

    private static boolean isSurrogateSecond(int c) {
        return c >= 220 && c <= 223;
    }

    public int leftAdjustCharHead(byte[] bytes, int p2, int end2) {
        if (end2 <= p2) {
            return end2;
        }
        if ((end2 - p2) % 2 == 1) {
            --end2;
        }
        if (UTF16LEEncoding.isSurrogateSecond(bytes[end2 + 1] & 0xFF) && end2 > p2 + 1) {
            end2 -= 2;
        }
        return end2;
    }

    public boolean isReverseMatchAllowed(byte[] bytes, int p2, int end2) {
        return false;
    }
}

