/*
 * Decompiled with CFR 0.152.
 */
package org.joni.encoding;

import org.joni.IntHolder;
import org.joni.encoding.AbstractEncoding;
import org.joni.encoding.specific.ASCIIEncoding;
import org.joni.exception.ValueException;

public abstract class MultiByteEncoding
extends AbstractEncoding {
    protected final int[] EncLen;

    protected MultiByteEncoding(int[] EncLen, short[] CTypeTable) {
        super(CTypeTable);
        this.EncLen = EncLen;
    }

    public int length(byte c) {
        return this.EncLen[c & 0xFF];
    }

    public boolean isSingleByte() {
        return false;
    }

    protected final int mbnMbcToCode(byte[] bytes, int p2, int end2) {
        int len = this.length(bytes[p2]);
        int n = bytes[p2++] & 0xFF;
        if (len == 1) {
            return n;
        }
        for (int i = 1; i < len && p2 < end2; ++i) {
            int c = bytes[p2++] & 0xFF;
            n <<= 8;
            n += c;
        }
        return n;
    }

    protected final int mbnMbcCaseFold(int flag, byte[] bytes, IntHolder pp, int end2, byte[] lower) {
        int p2 = pp.value++;
        int lowerP = 0;
        if (MultiByteEncoding.isAscii(bytes[p2] & 0xFF)) {
            lower[lowerP] = ASCIIEncoding.AsciiToLowerCaseTable[bytes[p2] & 0xFF];
            return 1;
        }
        int len = this.length(bytes[p2]);
        for (int i = 0; i < len; ++i) {
            lower[lowerP++] = bytes[p2++];
        }
        pp.value += len;
        return len;
    }

    protected final int mb2CodeToMbcLength(int code) {
        return (code & 0xFF00) != 0 ? 2 : 1;
    }

    protected final int mb4CodeToMbcLength(int code) {
        if ((code & 0xFF000000) != 0) {
            return 4;
        }
        if ((code & 0xFF0000) != 0) {
            return 3;
        }
        if ((code & 0xFF00) != 0) {
            return 2;
        }
        return 1;
    }

    protected final int mb2CodeToMbc(int code, byte[] bytes, int p2) {
        int p_ = p2;
        if ((code & 0xFF00) != 0) {
            bytes[p_++] = (byte)(code >>> 8 & 0xFF);
        }
        bytes[p_++] = (byte)(code & 0xFF);
        if (this.length(bytes[p2]) != p_ - p2) {
            throw new ValueException("invalid code point value");
        }
        return p_ - p2;
    }

    protected final int mb4CodeToMbc(int code, byte[] bytes, int p2) {
        int p_ = p2;
        if ((code & 0xFF000000) != 0) {
            bytes[p_++] = (byte)(code >>> 24 & 0xFF);
        }
        if ((code & 0xFF0000) != 0 || p_ != p2) {
            bytes[p_++] = (byte)(code >>> 16 & 0xFF);
        }
        if ((code & 0xFF00) != 0 || p_ != p2) {
            bytes[p_++] = (byte)(code >>> 8 & 0xFF);
        }
        bytes[p_++] = (byte)(code & 0xFF);
        if (this.length(bytes[p2]) != p_ - p2) {
            throw new ValueException("invalid code point value");
        }
        return p_ - p2;
    }

    protected final boolean mb2IsCodeCType(int code, int ctype) {
        if (code < 128) {
            return this.isCodeCTypeInternal(code, ctype);
        }
        if (MultiByteEncoding.isWordGraphPrint(ctype)) {
            return this.codeToMbcLength(code) > 1;
        }
        return false;
    }

    protected final boolean mb4IsCodeCType(int code, int ctype) {
        return this.mb2IsCodeCType(code, ctype);
    }
}

