/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.openide.filesystems.FileObject;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static final String DEFAULT_NAME = "name";

    public static String guessName(CompilationInfo compilationInfo, TreePath treePath) {
        ExpressionTree expressionTree = (ExpressionTree)treePath.getLeaf();
        String string = Utilities.getName(expressionTree);
        if (string == null) {
            Object object;
            if (expressionTree instanceof LiteralTree && (object = ((LiteralTree)expressionTree).getValue()) != null && object instanceof String) {
                return Utilities.guessLiteralName((String)object);
            }
            return DEFAULT_NAME;
        }
        Scope scope = compilationInfo.getTrees().getScope(treePath);
        int n = 0;
        boolean bl = true;
        String string2 = string;
        block0: while (bl) {
            string2 = string + (n != 0 ? String.valueOf(n) : "");
            bl = false;
            for (Element element : compilationInfo.getElementUtilities().getLocalMembersAndVars(scope, (ElementUtilities.ElementAcceptor)new VariablesFilter())) {
                if (!string2.equals(element.getSimpleName().toString())) continue;
                ++n;
                bl = true;
                continue block0;
            }
        }
        return string2;
    }

    private static String guessLiteralName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() == 0) {
            return DEFAULT_NAME;
        }
        char c = string.charAt(0);
        if (Character.isJavaIdentifierStart(string.charAt(0))) {
            stringBuffer.append(c);
        }
        for (int i = 1; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == ' ') {
                stringBuffer.append('_');
                continue;
            }
            if (Character.isJavaIdentifierPart(c2)) {
                stringBuffer.append(c2);
            }
            if (i > 40) break;
        }
        if (stringBuffer.length() == 0) {
            return DEFAULT_NAME;
        }
        return stringBuffer.toString();
    }

    public static String getName(TypeMirror typeMirror) {
        if (typeMirror.getKind().isPrimitive()) {
            return "" + Character.toLowerCase(typeMirror.getKind().name().charAt(0));
        }
        switch (typeMirror.getKind()) {
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                return Utilities.firstToLower(declaredType.asElement().getSimpleName().toString());
            }
            case ARRAY: {
                return Utilities.getName(((ArrayType)typeMirror).getComponentType());
            }
        }
        return null;
    }

    public static String getName(ExpressionTree expressionTree) {
        return Utilities.getName((Tree)expressionTree);
    }

    public static String getName(Tree tree) {
        return Utilities.adjustName(Utilities.getNameRaw(tree));
    }

    private static String getNameRaw(Tree tree) {
        if (tree == null) {
            return null;
        }
        switch (tree.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)tree).getName().toString();
            }
            case METHOD_INVOCATION: {
                return Utilities.getName(((MethodInvocationTree)tree).getMethodSelect());
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)tree).getIdentifier().toString();
            }
            case NEW_CLASS: {
                return Utilities.firstToLower(Utilities.getName(((NewClassTree)tree).getIdentifier()));
            }
            case PARAMETERIZED_TYPE: {
                return Utilities.firstToLower(Utilities.getName(((ParameterizedTypeTree)tree).getType()));
            }
        }
        return null;
    }

    static String adjustName(String string) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (string.startsWith("get") && string.length() > 3) {
            string2 = string.substring(3);
        }
        if (string.startsWith("is") && string.length() > 2) {
            string2 = string.substring(2);
        }
        if (string2 != null) {
            return Utilities.firstToLower(string2);
        }
        if (SourceVersion.isKeyword(string)) {
            return "a" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        }
        return string;
    }

    private static String firstToLower(String string) {
        if (string.length() == 0) {
            return null;
        }
        String string2 = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        if (SourceVersion.isKeyword(string2)) {
            string2 = "a" + string;
        }
        return string2;
    }

    public static ChangeInfo commitAndComputeChangeInfo(FileObject fileObject, final ModificationResult modificationResult, final Object object) throws IOException {
        ChangeInfo changeInfo;
        block5: {
            List list = modificationResult.getDifferences(fileObject);
            changeInfo = null;
            modificationResult.commit();
            try {
                if (list == null) break block5;
                for (ModificationResult.Difference difference : list) {
                    if (difference.getNewText() == null) continue;
                    final PositionRef positionRef = difference.getStartPosition();
                    StyledDocument styledDocument = positionRef.getCloneableEditorSupport().getDocument();
                    if (styledDocument == null) {
                        styledDocument = positionRef.getCloneableEditorSupport().openDocument();
                    }
                    final Position[] positionArray = new Position[2];
                    final StyledDocument styledDocument2 = styledDocument;
                    styledDocument.render(new Runnable(){

                        public void run() {
                            try {
                                int[] nArray = modificationResult.getSpan(object);
                                if (nArray != null) {
                                    positionArray[0] = styledDocument2.createPosition(nArray[0]);
                                    positionArray[1] = styledDocument2.createPosition(nArray[1]);
                                } else {
                                    positionArray[0] = NbDocument.createPosition((Document)styledDocument2, (int)positionRef.getOffset(), (Position.Bias)Position.Bias.Backward);
                                    positionArray[1] = positionArray[0];
                                }
                            }
                            catch (BadLocationException badLocationException) {
                                Exceptions.printStackTrace((Throwable)badLocationException);
                            }
                        }
                    });
                    if (positionArray[0] != null) {
                        changeInfo = new ChangeInfo(fileObject, positionArray[0], positionArray[1]);
                    }
                    break;
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return changeInfo;
    }

    public static boolean isMethodHeaderInsideGuardedBlock(CompilationInfo compilationInfo, MethodTree methodTree) {
        try {
            Document document = compilationInfo.getDocument();
            if (document instanceof GuardedDocument) {
                GuardedDocument guardedDocument = (GuardedDocument)document;
                int n = (int)compilationInfo.getTrees().getSourcePositions().getStartPosition(compilationInfo.getCompilationUnit(), methodTree);
                int n2 = (int)compilationInfo.getTrees().getSourcePositions().getEndPosition(compilationInfo.getCompilationUnit(), methodTree);
                return (guardedDocument.getGuardedBlockChain().compareBlock(n, n2) & 1) != 0;
            }
            return false;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            return false;
        }
    }

    public static TypeMirror resolveCapturedType(CompilationInfo compilationInfo, TypeMirror typeMirror) {
        TypeMirror typeMirror2 = Utilities.resolveCapturedTypeInt(compilationInfo, typeMirror);
        if (typeMirror2.getKind() == TypeKind.WILDCARD) {
            TypeMirror typeMirror3 = ((WildcardType)typeMirror2).getExtendsBound();
            if (typeMirror3 != null) {
                return typeMirror3;
            }
            return compilationInfo.getElements().getTypeElement("java.lang.Object").asType();
        }
        return typeMirror2;
    }

    private static TypeMirror resolveCapturedTypeInt(CompilationInfo compilationInfo, TypeMirror typeMirror) {
        WildcardType wildcardType = SourceUtils.resolveCapturedType((TypeMirror)typeMirror);
        if (wildcardType != null) {
            return wildcardType;
        }
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)typeMirror;
            LinkedList<TypeMirror> linkedList = new LinkedList<TypeMirror>();
            for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                linkedList.add(Utilities.resolveCapturedTypeInt(compilationInfo, typeMirror2));
            }
            return compilationInfo.getTypes().getDeclaredType((TypeElement)declaredType.asElement(), linkedList.toArray(new TypeMirror[0]));
        }
        return typeMirror;
    }

    public static <T extends Tree> T copyComments(WorkingCopy workingCopy, Tree tree, T t) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        for (Comment comment : workingCopy.getTreeUtilities().getComments(tree, true)) {
            treeMaker.addComment(t, comment, true);
        }
        for (Comment comment : workingCopy.getTreeUtilities().getComments(tree, false)) {
            treeMaker.addComment(t, comment, false);
        }
        return t;
    }

    public static TypeMirror convertIfAnonymous(TypeMirror typeMirror) {
        Element element;
        EnumSet<ElementKind> enumSet = EnumSet.of(ElementKind.METHOD, ElementKind.FIELD);
        if (typeMirror instanceof DeclaredType && ((element = ((DeclaredType)typeMirror).asElement()).getSimpleName().length() == 0 || enumSet.contains((Object)element.getEnclosingElement().getKind()))) {
            List<? extends TypeMirror> list = ((TypeElement)element).getInterfaces();
            typeMirror = list.isEmpty() ? ((TypeElement)element).getSuperclass() : list.get(0);
        }
        return typeMirror;
    }

    private static final class VariablesFilter
    implements ElementUtilities.ElementAcceptor {
        private static final Set<ElementKind> ACCEPTABLE_KINDS = EnumSet.of(ElementKind.ENUM_CONSTANT, ElementKind.EXCEPTION_PARAMETER, ElementKind.FIELD, ElementKind.LOCAL_VARIABLE, ElementKind.PARAMETER);

        private VariablesFilter() {
        }

        public boolean accept(Element element, TypeMirror typeMirror) {
            return ACCEPTABLE_KINDS.contains((Object)element.getKind());
        }
    }
}

