/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.errors.ErrorFixesFakeHint;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class AddParameterOrLocalFix
implements Fix {
    private FileObject file;
    private TypeMirrorHandle type;
    private String name;
    private boolean parameter;
    private TreePathHandle[] tpHandle;

    public AddParameterOrLocalFix(CompilationInfo compilationInfo, TypeMirror typeMirror, String string, boolean bl, int n) {
        this.file = compilationInfo.getFileObject();
        if (typeMirror.getKind() == TypeKind.NULL) {
            typeMirror = compilationInfo.getElements().getTypeElement("java.lang.Object").asType();
        }
        this.type = TypeMirrorHandle.create((TypeMirror)typeMirror);
        this.name = string;
        this.parameter = bl;
        TreePath treePath = compilationInfo.getTreeUtilities().pathFor(n + 1);
        this.tpHandle = new TreePathHandle[1];
        this.tpHandle[0] = TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo);
    }

    public String getText() {
        return this.parameter ? NbBundle.getMessage(AddParameterOrLocalFix.class, (String)"LBL_FIX_Create_Parameter", (Object)this.name) : NbBundle.getMessage(AddParameterOrLocalFix.class, (String)"LBL_FIX_Create_Local_Variable", (Object)this.name);
    }

    public ChangeInfo implement() throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.file);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeMirror typeMirror = AddParameterOrLocalFix.this.type.resolve((CompilationInfo)workingCopy);
                if (typeMirror == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve proposed type.");
                    return;
                }
                TreeMaker treeMaker = workingCopy.getTreeMaker();
                TreePath treePath = AddParameterOrLocalFix.this.tpHandle[0].resolve((CompilationInfo)workingCopy);
                if (treePath.getLeaf().getKind() != Tree.Kind.IDENTIFIER) {
                    return;
                }
                assert (treePath.getLeaf().getKind() == Tree.Kind.IDENTIFIER);
                TreePath treePath2 = AddParameterOrLocalFix.this.findMethod(treePath);
                if (treePath2 == null) {
                    ErrorHintsProvider.LOG.log(Level.INFO, "Cannot resolve target method.");
                    return;
                }
                MethodTree methodTree = (MethodTree)treePath2.getLeaf();
                if (AddParameterOrLocalFix.this.parameter) {
                    Object object;
                    if (methodTree == null) {
                        Logger.getLogger("global").log(Level.WARNING, "Add parameter - cannot find the method.");
                    }
                    Element element = workingCopy.getTrees().getElement(treePath2);
                    int n = methodTree.getParameters().size();
                    if (element != null && (element.getKind() == ElementKind.METHOD || element.getKind() == ElementKind.CONSTRUCTOR) && (object = (ExecutableElement)element).isVarArgs()) {
                        n = object.getParameters().size() - 1;
                    }
                    object = treeMaker.insertMethodParameter(methodTree, n, treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)AddParameterOrLocalFix.this.name, treeMaker.Type(typeMirror), null));
                    workingCopy.rewrite((Tree)methodTree, (Tree)object);
                } else if (ErrorFixesFakeHint.isCreateLocalVariableInPlace()) {
                    AddParameterOrLocalFix.this.resolveLocalVariable(workingCopy, treePath, treeMaker, typeMirror);
                } else {
                    AddParameterOrLocalFix.this.resolveLocalVariable55(workingCopy, treePath, treeMaker, typeMirror);
                }
            }
        }).commit();
        return null;
    }

    private void resolveLocalVariable55(WorkingCopy workingCopy, TreePath treePath, TreeMaker treeMaker, TypeMirror typeMirror) {
        StatementTree statementTree;
        String string = ((IdentifierTree)treePath.getLeaf()).getName().toString();
        TreePath treePath2 = this.findMethod(treePath);
        if (treePath2 == null) {
            return;
        }
        int n = 0;
        MethodTree methodTree = (MethodTree)treePath2.getLeaf();
        BlockTree blockTree = methodTree.getBody();
        if (methodTree.getReturnType() == null && !blockTree.getStatements().isEmpty() && (statementTree = blockTree.getStatements().get(0)).getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
            Element element = workingCopy.getTrees().getElement(treePath2);
            TreePath treePath3 = new TreePath(new TreePath(new TreePath(treePath2, blockTree), statementTree), ((ExpressionStatementTree)statementTree).getExpression());
            Element element2 = workingCopy.getTrees().getElement(treePath3);
            if (element != null && element2 != null && element.getKind() == ElementKind.CONSTRUCTOR && element2.getKind() == ElementKind.CONSTRUCTOR) {
                n = 1;
            }
        }
        statementTree = treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)string, treeMaker.Type(typeMirror), null);
        workingCopy.rewrite((Tree)blockTree, (Tree)workingCopy.getTreeMaker().insertBlockStatement(blockTree, n, statementTree));
    }

    private void resolveLocalVariable(WorkingCopy workingCopy, TreePath treePath, TreeMaker treeMaker, TypeMirror typeMirror) {
        Tree tree;
        String string = ((IdentifierTree)treePath.getLeaf()).getName().toString();
        final Element element = workingCopy.getTrees().getElement(treePath);
        TreePath treePath2 = this.findMethod(treePath);
        if (treePath2 == null) {
            return;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FirstUsage
        extends TreePathScanner<TreePath, Void> {
            private TreePath found;

            FirstUsage() {
            }

            @Override
            public TreePath visitIdentifier(IdentifierTree identifierTree, Void void_) {
                if (identifierTree.getName().contentEquals(element.getSimpleName())) {
                    if (this.found == null) {
                        this.found = this.getCurrentPath();
                    }
                    return AddParameterOrLocalFix.this.findStatement(this.getCurrentPath());
                }
                return null;
            }

            @Override
            public TreePath visitBlock(BlockTree blockTree, Void void_) {
                TreePath treePath = null;
                TreePath treePath2 = null;
                for (StatementTree statementTree : blockTree.getStatements()) {
                    TreePath treePath3 = (TreePath)this.scan(statementTree, null);
                    if (treePath3 != null && treePath == null) {
                        treePath = treePath3;
                        treePath2 = new TreePath(this.getCurrentPath(), statementTree);
                    }
                    if (treePath3 == statementTree || treePath == null || treePath.getLeaf() == treePath2.getLeaf()) continue;
                    treePath = treePath2;
                }
                super.visitBlock(blockTree, void_);
                return treePath;
            }

            @Override
            public TreePath reduce(TreePath treePath, TreePath treePath2) {
                if (treePath2 == null) {
                    return treePath;
                }
                return treePath2;
            }
        }
        FirstUsage firstUsage = new FirstUsage();
        TreePath treePath3 = (TreePath)firstUsage.scan(treePath2, null);
        if (treePath3 == null || !this.isStatement(treePath3.getLeaf())) {
            Logger.getLogger("global").log(Level.WARNING, "Add local variable - cannot find a statement.");
            return;
        }
        StatementTree statementTree = (StatementTree)treePath3.getLeaf();
        if (statementTree.getKind() == Tree.Kind.EXPRESSION_STATEMENT && (tree = ((ExpressionStatementTree)statementTree).getExpression()).getKind() == Tree.Kind.ASSIGNMENT) {
            AssignmentTree assignmentTree = (AssignmentTree)tree;
            VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)string, treeMaker.Type(typeMirror), assignmentTree.getExpression());
            variableTree = Utilities.copyComments(workingCopy, statementTree, variableTree);
            workingCopy.rewrite((Tree)statementTree, (Tree)variableTree);
            return;
        }
        tree = treePath3.getParentPath().getLeaf();
        VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(EnumSet.noneOf(Modifier.class)), (CharSequence)string, treeMaker.Type(typeMirror), null);
        if (tree.getKind() == Tree.Kind.BLOCK) {
            BlockTree blockTree = (BlockTree)tree;
            BlockTree blockTree2 = treeMaker.insertBlockStatement(blockTree, blockTree.getStatements().indexOf(statementTree), (StatementTree)variableTree);
            workingCopy.rewrite((Tree)blockTree, (Tree)blockTree2);
        } else {
            BlockTree blockTree = treeMaker.Block(Arrays.asList(variableTree, statementTree), false);
            workingCopy.rewrite((Tree)statementTree, (Tree)blockTree);
        }
    }

    private TreePath findStatement(TreePath treePath) {
        TreePath treePath2 = treePath;
        while (treePath2.getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT) {
            if (this.isStatement(treePath2.getLeaf())) {
                return treePath2;
            }
            treePath2 = treePath2.getParentPath();
        }
        return null;
    }

    private TreePath findMethod(TreePath treePath) {
        for (TreePath treePath2 = treePath; treePath2 != null; treePath2 = treePath2.getParentPath()) {
            if (treePath2.getLeaf().getKind() != Tree.Kind.METHOD) continue;
            return treePath2;
        }
        return null;
    }

    private boolean isStatement(Tree tree) {
        Class<? extends Tree> clazz = tree.getKind().asInterface();
        return StatementTree.class.isAssignableFrom(clazz);
    }

    String toDebugString(CompilationInfo compilationInfo) {
        return "AddParameterOrLocalFix:" + this.name + ":" + ((Object)this.type.resolve(compilationInfo)).toString() + ":" + this.parameter;
    }

    boolean isParameter() {
        return this.parameter;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AddParameterOrLocalFix addParameterOrLocalFix = (AddParameterOrLocalFix)object;
        if (!(this.name == addParameterOrLocalFix.name || this.name != null && this.name.equals(addParameterOrLocalFix.name))) {
            return false;
        }
        return this.parameter == addParameterOrLocalFix.parameter;
    }

    public int hashCode() {
        int n = 7;
        n = 97 * n + (this.name != null ? this.name.hashCode() : 0);
        n = 97 * n + (this.parameter ? 1 : 0);
        return n;
    }
}

