/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.EqualsHashCodeGenerator;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MissingHashCode
extends AbstractHint {
    volatile transient boolean[] stop = new boolean[]{false};

    public MissingHashCode() {
        super(true, true, AbstractHint.HintSeverity.WARNING, new String[0]);
    }

    @Override
    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD);
    }

    @Override
    public List<ErrorDescription> run(CompilationInfo compilationInfo, TreePath treePath) {
        this.stop = new boolean[1];
        Element element = compilationInfo.getTrees().getElement(treePath);
        if (element == null) {
            return null;
        }
        Element element2 = element.getEnclosingElement();
        ExecutableElement[] executableElementArray = EqualsHashCodeGenerator.overridesHashCodeAndEquals((CompilationInfo)compilationInfo, (Element)element2, (boolean[])this.stop);
        if (element != executableElementArray[0] && element != executableElementArray[1]) {
            return null;
        }
        String string = null;
        if (executableElementArray[0] == null && executableElementArray[1] != null) {
            string = "MSG_GenEquals";
        }
        if (executableElementArray[1] == null && executableElementArray[0] != null) {
            string = "MSG_GenHashCode";
        }
        if (string != null) {
            List<FixImpl> list = Collections.singletonList(new FixImpl(string, TreePathHandle.create((Element)element2, (CompilationInfo)compilationInfo), compilationInfo.getFileObject()));
            int[] nArray = compilationInfo.getTreeUtilities().findNameSpan((MethodTree)treePath.getLeaf());
            if (nArray != null) {
                ErrorDescription errorDescription = ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)NbBundle.getMessage(MissingHashCode.class, (String)string), list, (FileObject)compilationInfo.getFileObject(), (int)nArray[0], (int)nArray[1]);
                return Collections.singletonList(errorDescription);
            }
        }
        return null;
    }

    @Override
    public String getId() {
        return this.getClass().getName();
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(MissingHashCode.class, (String)"MSG_MissingHashCode");
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(MissingHashCode.class, (String)"HINT_MissingHashCode");
    }

    @Override
    public void cancel() {
        this.stop[0] = true;
    }

    public Preferences getPreferences() {
        return null;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FixImpl
    implements Fix,
    Runnable,
    Task<WorkingCopy> {
        private TreePathHandle handle;
        private FileObject file;
        private String msg;
        private boolean fieldFound;
        private static final Set<Tree.Kind> DECLARATION = EnumSet.of(Tree.Kind.CLASS, Tree.Kind.METHOD, Tree.Kind.VARIABLE);

        public FixImpl(String string, TreePathHandle treePathHandle, FileObject fileObject) {
            this.handle = treePathHandle;
            this.file = fileObject;
            this.msg = string;
        }

        public String getText() {
            return NbBundle.getMessage(MissingHashCode.class, (String)this.msg);
        }

        public ChangeInfo implement() throws IOException {
            ModificationResult modificationResult = JavaSource.forFileObject((FileObject)this.file).runModificationTask((Task)this);
            if (this.fieldFound) {
                EventQueue.invokeLater(this);
            } else {
                modificationResult.commit();
            }
            return null;
        }

        @Override
        public void run() {
            try {
                EditorCookie editorCookie = (EditorCookie)DataObject.find((FileObject)this.file).getLookup().lookup(EditorCookie.class);
                JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                if (jEditorPaneArray == null) {
                    return;
                }
                EqualsHashCodeGenerator.invokeEqualsHashCode((TreePathHandle)this.handle, (JTextComponent)jEditorPaneArray[0]);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }

        public void run(WorkingCopy workingCopy) throws Exception {
            workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            for (Element element : this.handle.resolveElement((CompilationInfo)workingCopy).getEnclosedElements()) {
                if (element.getKind() != ElementKind.FIELD) continue;
                this.fieldFound = true;
                return;
            }
            EqualsHashCodeGenerator.generateEqualsAndHashCode((WorkingCopy)workingCopy, (TreePath)this.handle.resolve((CompilationInfo)workingCopy));
        }

        public String toString() {
            return "Fix";
        }
    }
}

