/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.validation.reference;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.VariableReference;
import org.netbeans.modules.bpel.model.api.references.BpelReferenceable;
import org.netbeans.modules.soa.validation.core.QuickFix;
import org.netbeans.modules.soa.validation.util.SetUtil;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.Referenceable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QuickFix {
    private QuickFix() {
    }

    static QuickFix.Adapter get(BpelEntity bpelEntity, Reference<Referenceable> reference) {
        if (reference.getType().isAssignableFrom(VariableDeclaration.class) && bpelEntity instanceof VariableReference) {
            return new SetVariable((VariableReference)bpelEntity, reference.getRefString());
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetVariable
    extends QuickFix.Adapter {
        private String myName;
        private VariableReference myReference;

        SetVariable(VariableReference variableReference, String string) {
            this.myReference = variableReference;
            this.myName = string;
        }

        public String doFix() {
            Variable[] variableArray = this.getAppropriateVariables();
            if (variableArray == null) {
                return null;
            }
            Variable variable = variableArray[0];
            this.myReference.setVariable(this.myReference.createReference((BpelReferenceable)variable, VariableDeclaration.class));
            return UI.i18n(QuickFix.class, (String)"QUICK_FIX_Change_varibale_name", (String)variable.getName());
        }

        private Variable[] getAppropriateVariables() {
            BpelModel bpelModel = ((BpelEntity)this.myReference).getBpelModel();
            if (bpelModel == null) {
                return null;
            }
            Process process = bpelModel.getProcess();
            if (process == null) {
                return null;
            }
            VariableContainer variableContainer = process.getVariableContainer();
            if (variableContainer == null) {
                return null;
            }
            Variable[] variableArray = variableContainer.getVariables();
            if (variableArray == null) {
                return null;
            }
            List list = SetUtil.getAppropriate(this.toList(variableArray), (String)this.myName);
            if (list.size() == 0) {
                return null;
            }
            Variable[] variableArray2 = new Variable[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                variableArray2[i] = (Variable)list.get(i);
            }
            return variableArray2;
        }

        private List<Named> toList(Variable[] variableArray) {
            LinkedList<Named> linkedList = new LinkedList<Named>();
            for (Variable variable : variableArray) {
                linkedList.add((Named)variable);
            }
            return linkedList;
        }
    }
}

