/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.metadata.model.jdbc.oracle;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.metadata.model.api.MetadataException;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCCatalog;
import org.netbeans.modules.db.metadata.model.jdbc.JDBCSchema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSchema
extends JDBCSchema {
    private static final Logger LOGGER = Logger.getLogger(OracleSchema.class.getName());

    public OracleSchema(JDBCCatalog jDBCCatalog, String string, boolean bl, boolean bl2) {
        super(jDBCCatalog, string, bl, bl2);
    }

    @Override
    public String toString() {
        return "OracleSchema[name='" + this.name + "',default=" + this._default + ",synthetic=" + this.synthetic + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createTables() {
        LOGGER.log(Level.FINE, "Initializing tables in {0}", this);
        LinkedHashMap<String, Table> linkedHashMap = new LinkedHashMap<String, Table>();
        try {
            DatabaseMetaData databaseMetaData = this.jdbcCatalog.getJDBCMetadata().getDmd();
            Set<String> set = this.getRecycleBinTables(databaseMetaData);
            ResultSet resultSet = databaseMetaData.getTables(this.jdbcCatalog.getName(), this.name, "%", new String[]{"TABLE"});
            try {
                while (resultSet.next()) {
                    String string = resultSet.getString("TABLE_NAME");
                    if (!set.contains(string)) {
                        Table table = this.createJDBCTable(string).getTable();
                        linkedHashMap.put(string, table);
                        LOGGER.log(Level.FINE, "Created table {0}", table);
                        continue;
                    }
                    LOGGER.log(Level.FINE, "Ignoring recycle bin table ''{0}''", string);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw new MetadataException(sQLException);
        }
        this.tables = Collections.unmodifiableMap(linkedHashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getRecycleBinTables(DatabaseMetaData databaseMetaData) {
        try {
            if (databaseMetaData.getDatabaseMajorVersion() < 10) {
                return Collections.emptySet();
            }
            HashSet<String> hashSet = new HashSet<String>();
            Statement statement = databaseMetaData.getConnection().createStatement();
            try {
                ResultSet resultSet = statement.executeQuery("SELECT OBJECT_NAME FROM RECYCLEBIN WHERE TYPE = 'TABLE'");
                try {
                    while (resultSet.next()) {
                        hashSet.add(resultSet.getString("OBJECT_NAME"));
                    }
                }
                finally {
                    resultSet.close();
                }
            }
            finally {
                statement.close();
            }
            return hashSet;
        }
        catch (SQLException sQLException) {
            LOGGER.log(Level.INFO, "Error while analyzing the recycle bin", sQLException);
            return Collections.emptySet();
        }
    }
}

