/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.welcome.content;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.modules.welcome.content.BackgroundPanel;
import org.netbeans.modules.welcome.content.Constants;
import org.netbeans.modules.welcome.content.Utils;
import org.openide.util.ImageUtilities;

public class ContentSection
extends BackgroundPanel
implements Constants {
    private static final int PANEL_MAX_WIDTH = 800;
    private int location;
    private boolean maxSize;
    private Image center;
    private JLabel lblTitle;

    public ContentSection(String string, int n, JComponent jComponent, boolean bl) {
        super(new GridBagLayout());
        this.location = n;
        this.maxSize = bl;
        this.lblTitle = new JLabel(string);
        this.lblTitle.setFont(SECTION_HEADER_FONT);
        this.lblTitle.setHorizontalAlignment(4);
        this.lblTitle.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        this.lblTitle.setForeground(Utils.getColor("SectionHeaderColor"));
        this.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)jComponent, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(8, 12, 6, 12));
        String string2 = null;
        switch (n) {
            case 2: {
                string2 = "section_upper_right.png";
                break;
            }
            case 8: {
                string2 = "section_upper_left.png";
                break;
            }
            case 6: {
                string2 = "section_bottom_left.png";
                break;
            }
            case 4: {
                string2 = "section_bottom_right.png";
            }
        }
        this.center = ImageUtilities.loadImage((String)("org/netbeans/modules/welcome/resources/" + string2));
    }

    protected void paintComponent(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.center.getWidth(null);
        int n4 = this.center.getHeight(null);
        graphics.setColor(Utils.getColor("SectionHeaderColor"));
        switch (this.location) {
            case 2: {
                graphics.drawImage(this.center, 1, n2 - n4 - 1, null);
                graphics.drawLine(0, n2 - 1, n - 13, n2 - 1);
                graphics.drawLine(0, 25, 0, n2);
                break;
            }
            case 8: {
                graphics.drawImage(this.center, n - n3, n2 - n4 - 1, null);
                graphics.drawLine(13, n2 - 1, n, n2 - 1);
                break;
            }
            case 6: {
                graphics.drawImage(this.center, n - n3, 0, null);
                break;
            }
            case 4: {
                graphics.drawImage(this.center, 1, 0, null);
                graphics.drawLine(0, 0, 0, n2 - 25);
            }
        }
    }

    public void setSize(Dimension dimension) {
        if (this.maxSize && dimension.width > 800) {
            dimension = new Dimension(dimension);
            dimension.width = 800;
        }
        super.setSize(dimension);
    }

    public void setBounds(Rectangle rectangle) {
        if (this.maxSize && rectangle.width > 800) {
            rectangle = new Rectangle(rectangle);
            rectangle.width = 800;
        }
        super.setBounds(rectangle);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.maxSize && n3 > 800) {
            n3 = 800;
        }
        super.setBounds(n, n2, n3, n4);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.maxSize && dimension.width > 800) {
            dimension = new Dimension(dimension);
            dimension.width = 800;
        }
        return dimension;
    }

    public Rectangle getTitleBounds() {
        Rectangle rectangle = this.lblTitle.getBounds();
        rectangle.height -= this.lblTitle.getInsets().bottom + 7;
        return rectangle;
    }
}

