/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.FileSpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.beans.editor.BeanClassFinder;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.java.FieldNamesCalculator;
import org.netbeans.modules.spring.java.JavaUtils;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanIdCompletor
extends Completor {
    public BeanIdCompletor(int n) {
        super(n);
    }

    @Override
    protected int initAnchorOffset(CompletionContext completionContext) {
        return completionContext.getCurrentToken().getOffset() + 1;
    }

    @Override
    protected void compute(final CompletionContext completionContext) throws IOException {
        final FileObject fileObject = completionContext.getFileObject();
        JavaSource javaSource = JavaUtils.getJavaSource(fileObject);
        if (javaSource == null) {
            return;
        }
        final String string = completionContext.getTypedPrefix();
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws Exception {
                Map<String, String> map = SpringXMLConfigEditorUtils.getTagAttributes(completionContext.getTag());
                String string3 = new BeanClassFinder(map, fileObject).findImplementationClass();
                if (string3 == null) {
                    return;
                }
                TypeElement typeElement = JavaUtils.findClassElementByBinaryName(string3, compilationController);
                if (typeElement == null) {
                    return;
                }
                FieldNamesCalculator fieldNamesCalculator = new FieldNamesCalculator(typeElement.getSimpleName().toString(), BeanIdCompletor.this.getForbiddenNames(fileObject));
                List<String> list = fieldNamesCalculator.calculate();
                int n = 10;
                for (String string2 : list) {
                    if (!string2.startsWith(string)) continue;
                    SpringXMLConfigCompletionItem springXMLConfigCompletionItem = SpringXMLConfigCompletionItem.createBeanNameItem(BeanIdCompletor.this.getAnchorOffset(), string2, n);
                    BeanIdCompletor.this.addCacheItem(springXMLConfigCompletionItem);
                    n += 10;
                }
            }
        }, true);
    }

    private Set<String> getForbiddenNames(final FileObject fileObject) throws IOException {
        SpringConfigModel springConfigModel = SpringConfigModel.forFileObject(fileObject);
        if (springConfigModel == null) {
            return Collections.emptySet();
        }
        final HashSet hashSet = new HashSet();
        springConfigModel.runReadAction(new Action<SpringBeans>(){

            @Override
            public void run(SpringBeans springBeans) {
                FileSpringBeans fileSpringBeans = springBeans.getFileBeans(fileObject);
                if (fileSpringBeans == null) {
                    return;
                }
                for (SpringBean springBean : fileSpringBeans.getBeans()) {
                    hashSet.add(springBean.getId());
                    hashSet.addAll(springBean.getNames());
                }
            }
        });
        return Collections.unmodifiableSet(hashSet);
    }
}

