/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.jruby.nb.ast.ArgsNode;
import org.jruby.nb.ast.ArgumentNode;
import org.jruby.nb.ast.CallNode;
import org.jruby.nb.ast.ClassNode;
import org.jruby.nb.ast.FCallNode;
import org.jruby.nb.ast.IScopingNode;
import org.jruby.nb.ast.ListNode;
import org.jruby.nb.ast.LocalAsgnNode;
import org.jruby.nb.ast.MethodDefNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CodeCompletionContext;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.CodeCompletionResult;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.CompletionProposal;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.ElementKind;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.Modifier;
import org.netbeans.modules.gsf.api.NameKind;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParameterInfo;
import org.netbeans.modules.gsf.spi.DefaultCompletionProposal;
import org.netbeans.modules.gsf.spi.DefaultCompletionResult;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RDocFormatter;
import org.netbeans.modules.ruby.RubyDeclarationFinder;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyParser;
import org.netbeans.modules.ruby.RubyTypeAnalyzer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.AstElement;
import org.netbeans.modules.ruby.elements.AstFieldElement;
import org.netbeans.modules.ruby.elements.AstNameElement;
import org.netbeans.modules.ruby.elements.ClassElement;
import org.netbeans.modules.ruby.elements.CommentElement;
import org.netbeans.modules.ruby.elements.Element;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.IndexedField;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.elements.IndexedVariable;
import org.netbeans.modules.ruby.elements.KeywordElement;
import org.netbeans.modules.ruby.elements.RubyElement;
import org.netbeans.modules.ruby.lexer.Call;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyStringTokenId;
import org.netbeans.modules.ruby.lexer.RubyTokenId;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyCodeCompleter
implements CodeCompletionHandler {
    private static final String KEY_REQUIRE = "require";
    private static final String KEY_INSTANCEOF = "instanceof";
    private static final String ATTR_UNUSEDLOCAL = "unusedlocal";
    private static final String KEY_PIPE = "pipe";
    private static final String KEY_METHOD = "method";
    private static final String KEY_METHOD_FQN = "methodfqn";
    private static final String KEY_CLASS = "class";
    private static final String KEY_CLASS_FQN = "classfqn";
    private static final String KEY_SUPERCLASS = "superclass";
    private static final String KEY_FILE = "file";
    private static final String KEY_PATH = "path";
    private static final String ATTR_DEFAULTS = "defaults";
    private static final String[] RUBY_BUILTIN_VARS = new String[]{"__FILE__", "__LINE__", "STDIN", "STDOUT", "STDERR", "ENV", "ARGF", "ARGV", "DATA", "RUBY_VERSION", "RUBY_RELEASE_DATE", "RUBY_PLATFORM"};
    private static final String[] RUBY_REGEXP_WORDS = new String[]{"^", "Start of line", "$", "End of line", "\\A", "Beginning of string", "\\z", "End of string", "\\Z", "End of string (except \\n)", "\\w", "Letter or digit; same as [0-9A-Za-z]", "\\W", "Neither letter or digit", "\\s", "Space character; same as [ \\t\\n\\r\\f]", "\\S", "Non-space character", "\\d", "Digit character; same as [0-9]", "\\D", "Non-digit character", "\\b", "Backspace (0x08) (only if in a range specification)", "\\b", "Word boundary (if not in a range specification)", "\\B", "Non-word boundary", "*", "Zero or more repetitions of the preceding", "+", "One or more repetitions of the preceding", "{m,n}", "At least m and at most n repetitions of the preceding", "?", "At most one repetition of the preceding; same as {0,1}", "|", "Either preceding or next expression may match", "()", "Grouping", "[:alnum:]", "Alphanumeric character class", "[:alpha:]", "Uppercase or lowercase letter", "[:blank:]", "Blank and tab", "[:cntrl:]", "Control characters (at least 0x00-0x1f,0x7f)", "[:digit:]", "Digit", "[:graph:]", "Printable character excluding space", "[:lower:]", "Lowecase letter", "[:print:]", "Any printable letter (including space)", "[:punct:]", "Printable character excluding space and alphanumeric", "[:space:]", "Whitespace (same as \\s)", "[:upper:]", "Uppercase letter", "[:xdigit:]", "Hex digit (0-9, a-f, A-F)"};
    private static final String[] RUBY_PERCENT_WORDS = new String[]{"%q", "String (single-quoting rules)", "%Q", "String (double-quoting rules)", "%r", "Regular Expression", "%x", "Commands", "%W", "String Array (double quoting rules)", "%w", "String Array (single quoting rules)", "%s", "Symbol"};
    private static final String[] RUBY_STRING_PAIRS = new String[]{"(", "(delimiters)", "{", "{delimiters}", "[", "[delimiters]", "x", "<i>x</i>delimiters<i>x</i>"};
    private static final String[] RUBY_DOLLAR_VARIABLES = new String[]{"$!", "The exception information message set by 'raise'.", "$@", "Array of backtrace of the last exception thrown.", "$&", "The string matched by the last successful pattern match in this scope.", "$`", "The string to the left  of the last successful match.", "$'", "The string to the right of the last successful match.", "$+", "The last bracket matched by the last successful match.", "$n", "The Nth group of the last successful regexp match.", "$~", "The information about the last match in the current scope.", "$=", "The flag for case insensitive, nil by default.", "$/", "The input record separator, newline by default.", "$\\", "The output record separator for the print and IO#write. Default is nil.", "$,", "The output field separator for the print and Array#join.", "$;", "The default separator for String#split.", "$.", "The current input line number of the last file that was read.", "$<", "The virtual concatenation file of the files given on command line.", "$>", "The default output for print, printf. $stdout by default.", "$_", "The last input line of string by gets or readline.", "$0", "Contains the name of the script being executed. May be assignable.", "$*", "Command line arguments given for the script sans args.", "$$", "The process number of the Ruby running this script.", "$?", "The status of the last executed child process.", "$:", "Load path for scripts and binary modules by load or require.", "$\"", "The array contains the module names loaded by require.", "$DEBUG", "The status of the -d switch.", "$FILENAME", "Current input file from $&lt;. Same as $&lt;.filename.", "$LOAD_PATH", "The alias to the $:.", "$stderr", "The current standard error output.", "$stdin", "The current standard input.", "$stdout", "The current standard output.", "$VERBOSE", "The verbose flag, which is set by the -v switch.", "$-0", "The alias to $/.", "$-a", "True if option -a (\"autosplit\" mode) is set. Read-only variable.", "$-d", "The alias to $DEBUG.", "$-F", "The alias to $;.", "$-i", "If in-place-edit mode is set, this variable holds the extension, otherwise nil.", "$-I", "The alias to $:.", "$-l", "True if option -l is set (\"line-ending processing\" is on). Read-only variable.", "$-p", "True if option -p is set (\"loop\" mode is on). Read-only variable.", "$-v", "The alias to $VERBOSE.", "$-w", "True if option -w is set."};
    private static final String[] RUBY_QUOTED_STRING_ESCAPES = new String[]{"\\a", "Bell/alert (0x07)", "\\b", "Backspace (0x08)", "\\x", "\\x<i>nn</i>: Hex <i>nn</i>", "\\e", "Escape (0x1b)", "\\c", "Control-<i>x</i>", "\\C-", "Control-<i>x</i>", "\\f", "Formfeed (0x0c)", "\\n", "Newline (0x0a)", "\\M-", "\\M-<i>x</i>: Meta-<i>x</i>", "\\r", "Return (0x0d)", "\\M-\\C-", "Meta-control-<i>x</i>", "\\s", "Space (0x20)", "\\", "\\nnn Octal <i>nnn</i>", "\\t", "Tab (0x09)", "#{", "#{expr}: Value of expr", "\\v", "Vertical tab (0x0b)"};
    private static ImageIcon keywordIcon;
    private static ImageIcon symbolIcon;
    private static final Set<String> selectionTemplates;
    private boolean caseSensitive;
    private int anchor;
    private static int callLineStart;
    static IndexedMethod callMethod;
    private static final boolean FORCE_COMPLETION_SPACES;

    private boolean startsWith(String string, String string2) {
        if (string2.length() == 0) {
            return true;
        }
        return this.caseSensitive ? string.startsWith(string2) : string.toLowerCase().startsWith(string2.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPrefix(CompilationInfo compilationInfo, int n, boolean bl) {
        try {
            BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            if (baseDocument == null) {
                return null;
            }
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            baseDocument.readLock();
            try {
                int n2;
                int n3;
                String string;
                int n4;
                int n5;
                int n6;
                int n7;
                String string2;
                Token token;
                int n8 = LexUtilities.getRequireStringOffset(n, (TokenHierarchy<Document>)tokenHierarchy);
                if (n8 != -1) {
                    String string3 = baseDocument.getText(n8, n - n8);
                    return string3;
                }
                TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
                if (tokenSequence == null) {
                    String string4 = null;
                    return string4;
                }
                tokenSequence.move(n);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    String string5 = null;
                    return string5;
                }
                if (tokenSequence.offset() == n) {
                    tokenSequence.movePrevious();
                }
                if ((token = tokenSequence.token()) != null) {
                    TokenId tokenId = token.id();
                    if (tokenId == RubyTokenId.EMBEDDED_RUBY) {
                        tokenSequence = tokenSequence.embedded();
                        assert (tokenSequence != null);
                        tokenSequence.move(n);
                        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                            String string6 = null;
                            return string6;
                        }
                        token = tokenSequence.token();
                        tokenId = token.id();
                    }
                    string2 = ((Object)token.text()).toString();
                    if ((tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN || tokenId == RubyTokenId.ERROR && string2.equals("%")) && (n7 = tokenSequence.offset()) == n - 1 && string2.length() > 0 && string2.charAt(0) == '%') {
                        String string7 = "%";
                        return string7;
                    }
                }
                if ((n6 = LexUtilities.getDoubleQuotedStringOffset(n, (TokenHierarchy<Document>)tokenHierarchy)) != -1) {
                    if (n6 == n) {
                        string2 = "";
                        return string2;
                    }
                    if (n6 >= n) {
                        string2 = "";
                        return string2;
                    }
                    string2 = baseDocument.getText(n6, n - n6);
                    TokenHierarchy tokenHierarchy2 = TokenHierarchy.create((CharSequence)string2, RubyStringTokenId.languageDouble());
                    TokenSequence tokenSequence2 = tokenHierarchy2.tokenSequence();
                    tokenSequence2.move(n - n6);
                    if (!tokenSequence2.moveNext() && !tokenSequence2.movePrevious()) {
                        String string8 = "";
                        return string8;
                    }
                    TokenId tokenId = tokenSequence2.token().id();
                    String string9 = ((Object)tokenSequence2.token().text()).toString();
                    if (tokenId == RubyStringTokenId.STRING_ESCAPE || tokenId == RubyStringTokenId.STRING_INVALID) {
                        String string10 = string9;
                        return string10;
                    }
                    if (string9.startsWith("\\")) {
                        String string11 = string9;
                        return string11;
                    }
                    String string12 = "";
                    return string12;
                }
                int n9 = LexUtilities.getSingleQuotedStringOffset(n, (TokenHierarchy<Document>)tokenHierarchy);
                if (n9 != -1) {
                    if (n9 == n) {
                        String string13 = "";
                        return string13;
                    }
                    if (n9 >= n) {
                        String string14 = "";
                        return string14;
                    }
                    String string15 = baseDocument.getText(n9, n - n9);
                    TokenHierarchy tokenHierarchy3 = TokenHierarchy.create((CharSequence)string15, RubyStringTokenId.languageSingle());
                    TokenSequence tokenSequence3 = tokenHierarchy3.tokenSequence();
                    tokenSequence3.move(n - n9);
                    if (!tokenSequence3.moveNext() && !tokenSequence3.movePrevious()) {
                        String string16 = "";
                        return string16;
                    }
                    TokenId tokenId = tokenSequence3.token().id();
                    String string17 = ((Object)tokenSequence3.token().text()).toString();
                    if (tokenId == RubyStringTokenId.STRING_ESCAPE || tokenId == RubyStringTokenId.STRING_INVALID) {
                        String string18 = string17;
                        return string18;
                    }
                    if (string17.startsWith("\\")) {
                        String string19 = string17;
                        return string19;
                    }
                    String string20 = "";
                    return string20;
                }
                n7 = LexUtilities.getRegexpOffset(n, (TokenHierarchy<Document>)tokenHierarchy);
                if (n7 != -1 && n7 <= n) {
                    String string21 = ((Object)token.text()).toString();
                    int n10 = n - tokenSequence.offset();
                    if (n10 > 0 && n10 <= string21.length() && string21.charAt(n10 - 1) == '\\') {
                        String string22 = "\\";
                        return string22;
                    }
                    String string23 = "";
                    return string23;
                }
                int n11 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                if (n11 == -1) return null;
                int n12 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                String string24 = baseDocument.getText(n11, n12 - n11);
                int n13 = n5 = n - n11;
                if (n5 > 0) {
                    int n14 = n5 - 1;
                    while (n14 >= 0 && RubyUtils.isIdentifierChar((char)(n4 = (int)string24.charAt(n14)))) {
                        n13 = n14--;
                    }
                }
                if (bl) {
                    string = string24.substring(n13, n5);
                } else if (n5 == string24.length()) {
                    string = string24.substring(n13);
                } else {
                    char c;
                    n4 = string24.length();
                    n3 = n5;
                    for (n2 = n5; n2 < n4 && RubyUtils.isStrictIdentifierChar(c = string24.charAt(n2)); ++n2) {
                        n3 = n2 + 1;
                    }
                    string = string24.substring(n13, n3);
                }
                if (string.length() <= 0) return null;
                if (string.endsWith("::")) {
                    String string25 = "";
                    return string25;
                }
                if (string.endsWith(":") && string.length() > 1) {
                    String string26 = null;
                    return string26;
                }
                n4 = string.lastIndexOf("::");
                if (n4 != -1) {
                    string = string.substring(n4 + 2);
                }
                if (string.length() == 1) {
                    n3 = string.charAt(0);
                    if (!Character.isJavaIdentifierPart((char)n3) && n3 != 64 && n3 != 36 && n3 != 58) {
                        String string27 = null;
                        return string27;
                    }
                } else {
                    for (n3 = string.length() - 2; n3 >= 0; --n3) {
                        n2 = string.charAt(n3);
                        if (n3 == 0 && n2 == 58 || Character.isJavaIdentifierPart((char)n2) || n2 == 64 || n2 == 36) continue;
                        string = string.substring(n3 + 1);
                        break;
                    }
                }
                String string28 = string;
                return string28;
            }
            finally {
                baseDocument.readUnlock();
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return null;
    }

    private boolean completeKeywords(List<CompletionProposal> list, CompletionRequest completionRequest, boolean bl) {
        KeywordItem keywordItem;
        String string = completionRequest.prefix;
        if (string.equals("$")) {
            int n = RUBY_DOLLAR_VARIABLES.length;
            for (int i = 0; i < n; i += 2) {
                String string2 = RUBY_DOLLAR_VARIABLES[i];
                String string3 = RUBY_DOLLAR_VARIABLES[i + 1];
                keywordItem = new KeywordItem(string2, string3, this.anchor, completionRequest);
                if (bl) {
                    keywordItem.setSymbol(true);
                }
                list.add((CompletionProposal)keywordItem);
            }
        }
        for (String string3 : RUBY_BUILTIN_VARS) {
            if (!this.startsWith(string3, string)) continue;
            keywordItem = new KeywordItem(string3, null, this.anchor, completionRequest);
            if (bl) {
                keywordItem.setSymbol(true);
            }
            list.add((CompletionProposal)keywordItem);
        }
        for (String string3 : RubyUtils.RUBY_KEYWORDS) {
            if (!this.startsWith(string3, string)) continue;
            keywordItem = new KeywordItem(string3, null, this.anchor, completionRequest);
            if (bl) {
                keywordItem.setSymbol(true);
            }
            list.add((CompletionProposal)keywordItem);
        }
        return false;
    }

    private boolean completeRegexps(List<CompletionProposal> list, CompletionRequest completionRequest) {
        String string = completionRequest.prefix;
        int n = RUBY_REGEXP_WORDS.length;
        for (int i = 0; i < n; i += 2) {
            String string2 = RUBY_REGEXP_WORDS[i];
            String string3 = RUBY_REGEXP_WORDS[i + 1];
            if (!this.startsWith(string2, string)) continue;
            KeywordItem keywordItem = new KeywordItem(string2, string3, this.anchor, completionRequest);
            list.add((CompletionProposal)keywordItem);
        }
        return true;
    }

    private boolean completePercentWords(List<CompletionProposal> list, CompletionRequest completionRequest) {
        String string = completionRequest.prefix;
        int n = RUBY_PERCENT_WORDS.length;
        for (int i = 0; i < n; i += 2) {
            String string2 = RUBY_PERCENT_WORDS[i];
            String string3 = RUBY_PERCENT_WORDS[i + 1];
            if (!this.startsWith(string2, string)) continue;
            KeywordItem keywordItem = new KeywordItem(string2, string3, this.anchor, completionRequest);
            list.add((CompletionProposal)keywordItem);
        }
        return true;
    }

    private boolean completeStringBegins(List<CompletionProposal> list, CompletionRequest completionRequest) {
        int n = RUBY_STRING_PAIRS.length;
        for (int i = 0; i < n; i += 2) {
            String string = RUBY_STRING_PAIRS[i];
            String string2 = RUBY_STRING_PAIRS[i + 1];
            KeywordItem keywordItem = new KeywordItem(string, string2, this.anchor, completionRequest);
            list.add((CompletionProposal)keywordItem);
        }
        return true;
    }

    private boolean completeDefOrInclude(List<CompletionProposal> list, CompletionRequest completionRequest, String string) {
        RubyIndex rubyIndex = completionRequest.index;
        String string2 = completionRequest.prefix;
        int n = completionRequest.lexOffset;
        TokenHierarchy tokenHierarchy = completionRequest.th;
        NameKind nameKind = completionRequest.kind;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
        if (rubyIndex != null && tokenSequence != null) {
            Token token;
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return false;
            }
            if (tokenSequence.offset() == n) {
                tokenSequence.movePrevious();
            }
            if ((token = tokenSequence.token()) != null) {
                TokenId tokenId = token.id();
                if (tokenId == RubyTokenId.IDENTIFIER || tokenId == RubyTokenId.CONSTANT || tokenId.primaryCategory().equals("keyword")) {
                    if (!tokenSequence.movePrevious()) {
                        return false;
                    }
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
                if (tokenId != RubyTokenId.WHITESPACE) {
                    return false;
                }
                while (tokenSequence.movePrevious() && (token = tokenSequence.token()).id() == RubyTokenId.WHITESPACE) {
                }
                if (token.id() == RubyTokenId.DEF) {
                    Set<IndexedMethod> set = rubyIndex.getInheritedMethods(string, string2, nameKind);
                    for (IndexedMethod indexedMethod : set) {
                        if (string2.length() > 0 && !indexedMethod.getName().startsWith(string2) || string != null && string.equals(indexedMethod.getClz()) || indexedMethod.isNoDoc()) continue;
                        MethodItem methodItem = new MethodItem(indexedMethod, this.anchor, completionRequest);
                        methodItem.setSmart(indexedMethod.isSmart());
                        list.add((CompletionProposal)methodItem);
                    }
                    return true;
                }
                if (token.id() == RubyTokenId.IDENTIFIER && "include".equals(((Object)token.text()).toString())) {
                    Set<IndexedClass> set = rubyIndex.getClasses(string2, nameKind, false, true, false);
                    for (IndexedClass indexedClass : set) {
                        if (indexedClass.isNoDoc()) continue;
                        ClassItem classItem = new ClassItem(indexedClass, this.anchor, completionRequest);
                        classItem.setSmart(true);
                        list.add((CompletionProposal)classItem);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean completeObjectMethod(List<CompletionProposal> list, CompletionRequest completionRequest, String string, Call call) {
        RubyIndex rubyIndex = completionRequest.index;
        String string2 = completionRequest.prefix;
        int n = completionRequest.astOffset;
        int n2 = completionRequest.lexOffset;
        TokenHierarchy tokenHierarchy = completionRequest.th;
        BaseDocument baseDocument = completionRequest.doc;
        AstPath astPath = completionRequest.path;
        NameKind nameKind = completionRequest.kind;
        FileObject fileObject = completionRequest.fileObject;
        Node node = completionRequest.node;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n2);
        if (rubyIndex != null && tokenSequence != null) {
            Object object3;
            Object object2;
            boolean bl = true;
            if (call == Call.LOCAL || call == Call.NONE) {
                return false;
            }
            boolean bl2 = call.isMethodExpected();
            boolean bl3 = call.isStatic();
            Set<Object> set = Collections.emptySet();
            String string3 = call.getType();
            String string4 = call.getLhs();
            if (string3 == null && string4 != null && node != null && call.isSimpleIdentifier() && (object2 = AstUtilities.findLocalScope(node, astPath)) != null) {
                object3 = new RubyTypeAnalyzer(rubyIndex, (Node)object2, node, n, n2, baseDocument, fileObject);
                string3 = ((RubyTypeAnalyzer)object3).getType(string4);
            }
            if (string3 != null && string3.length() > 0) {
                if ("self".equals(string4)) {
                    string3 = string;
                    bl = true;
                } else if ("super".equals(string4)) {
                    bl = true;
                    object2 = rubyIndex.getSuperclass(string);
                    if (object2 != null) {
                        string3 = ((IndexedElement)object2).getFqn();
                    } else {
                        object3 = AstUtilities.findClass(astPath);
                        if (object3 != null) {
                            string3 = AstUtilities.getSuperclass((ClassNode)object3);
                        }
                    }
                    if (string3 == null) {
                        string3 = "Object";
                    }
                }
                if (string3 != null && string3.length() > 0) {
                    while (set.isEmpty()) {
                        set = rubyIndex.getInheritedMethods(string + "::" + string3, string2, nameKind);
                        int n3 = string.lastIndexOf("::");
                        if (n3 == -1) break;
                        string = string.substring(0, n3);
                    }
                    if (!(object2 = rubyIndex.getInheritedMethods(string3, string2, nameKind)).isEmpty()) {
                        set.addAll((Collection<Object>)object2);
                    }
                }
            }
            if (set.isEmpty()) {
                set = rubyIndex.getMethods(string2, null, nameKind);
            }
            for (Object object3 : set) {
                RubyCompletionItem rubyCompletionItem;
                if (bl && ((IndexedElement)object3).isPrivate() && !"new".equals(((IndexedMethod)object3).getName()) || bl3 && !((IndexedElement)object3).isStatic() && !((IndexedElement)object3).doesBelongToModule() || !bl3 && ((IndexedElement)object3).doesBelongToModule() || ((IndexedElement)object3).isNoDoc()) continue;
                if (((IndexedMethod)object3).getMethodType() == IndexedMethod.MethodType.DBCOLUMN) {
                    rubyCompletionItem = new DbItem(((IndexedMethod)object3).getName(), ((IndexedElement)object3).getIn(), this.anchor, completionRequest);
                    list.add((CompletionProposal)rubyCompletionItem);
                    continue;
                }
                rubyCompletionItem = new MethodItem((IndexedMethod)object3, this.anchor, completionRequest);
                rubyCompletionItem.setSmart(((IndexedMethod)object3).isSmart());
                list.add((CompletionProposal)rubyCompletionItem);
            }
            return bl2;
        }
        return false;
    }

    private void completeGlobals(List<CompletionProposal> list, CompletionRequest completionRequest, boolean bl) {
        RubyIndex rubyIndex = completionRequest.index;
        String string = completionRequest.prefix;
        NameKind nameKind = completionRequest.kind;
        Set<IndexedVariable> set = rubyIndex.getGlobals(string, nameKind);
        for (IndexedVariable indexedVariable : set) {
            RubyCompletionItem rubyCompletionItem = new RubyCompletionItem(indexedVariable, this.anchor, completionRequest);
            rubyCompletionItem.setSmart(true);
            if (bl) {
                rubyCompletionItem.setSymbol(true);
            }
            list.add((CompletionProposal)rubyCompletionItem);
        }
    }

    private boolean completeClasses(List<CompletionProposal> list, CompletionRequest completionRequest, boolean bl, Call call) {
        RubyIndex rubyIndex = completionRequest.index;
        String string = completionRequest.prefix;
        NameKind nameKind = completionRequest.kind;
        int n = this.anchor;
        int n2 = string.lastIndexOf("::");
        if (n2 != -1) {
            n += n2 + 2;
        }
        String string2 = string;
        if (call.isMethodExpected()) {
            return false;
        }
        String string3 = call.getType();
        String string4 = call.getLhs();
        if (string4 != null && string4.equals(string3)) {
            string2 = string3 + "::" + string;
        }
        AstPath astPath = completionRequest.path;
        String string5 = AstUtilities.getFqnName(astPath);
        HashSet<String> hashSet = new HashSet<String>();
        Set<IndexedClass> set = rubyIndex.getClasses(string2, nameKind, false, false, false, RubyIndex.ALL_SCOPE, hashSet);
        if (string5 != null && string5.length() > 0) {
            Set<IndexedClass> set2 = rubyIndex.getClasses(string5 + "::" + string2, nameKind, false, false, false, RubyIndex.ALL_SCOPE, hashSet);
            set.addAll((Collection<IndexedClass>)set2);
        }
        for (IndexedClass indexedClass : set) {
            if (indexedClass.isNoDoc()) continue;
            ClassItem classItem = new ClassItem(indexedClass, n, completionRequest);
            classItem.setSmart(true);
            if (bl) {
                classItem.setSymbol(true);
            }
            list.add((CompletionProposal)classItem);
        }
        return false;
    }

    private boolean completeStrings(List<CompletionProposal> list, CompletionRequest completionRequest) {
        RubyIndex rubyIndex = completionRequest.index;
        String string = completionRequest.prefix;
        int n = completionRequest.lexOffset;
        TokenHierarchy tokenHierarchy = completionRequest.th;
        TokenSequence tokenSequence = LexUtilities.getRubyTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
        if (rubyIndex != null && tokenSequence != null) {
            Token token;
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return false;
            }
            if (tokenSequence.offset() == n) {
                tokenSequence.movePrevious();
            }
            if ((token = tokenSequence.token()) != null) {
                int n2;
                TokenId tokenId = token.id();
                if (tokenId == RubyTokenId.LINE_COMMENT || tokenId == RubyTokenId.DOCUMENTATION) {
                    BaseDocument baseDocument;
                    OffsetRange offsetRange;
                    if (completionRequest.queryType == CodeCompletionHandler.QueryType.DOCUMENTATION && (offsetRange = LexUtilities.getCommentBlock(baseDocument = completionRequest.doc, n)) != OffsetRange.NONE) {
                        try {
                            String string2 = baseDocument.getText(offsetRange.getStart(), offsetRange.getLength());
                            if (string2.startsWith("=begin\n") && string2.endsWith("=end")) {
                                string2 = string2.substring("=begin\n".length(), string2.length() - "=end".length());
                            }
                            CommentElement commentElement = new CommentElement(string2);
                            ClassItem classItem = new ClassItem(commentElement, this.anchor, completionRequest);
                            list.add((CompletionProposal)classItem);
                            return true;
                        }
                        catch (BadLocationException badLocationException) {
                            Exceptions.printStackTrace((Throwable)badLocationException);
                        }
                    }
                    return true;
                }
                if (tokenId == RubyTokenId.EMBEDDED_RUBY) {
                    tokenSequence = tokenSequence.embedded();
                    assert (tokenSequence != null);
                    tokenSequence.move(n);
                    if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                        return false;
                    }
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                String string3 = ((Object)token.text()).toString();
                if ((tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN || tokenId == RubyTokenId.ERROR && string3.equals("%")) && (n2 = tokenSequence.offset()) == n - 1 && string3.length() > 0 && string3.charAt(0) == '%' && this.completePercentWords(list, completionRequest)) {
                    return true;
                }
                if ((tokenId == RubyTokenId.STRING_BEGIN || tokenId == RubyTokenId.QUOTED_STRING_BEGIN || tokenId == RubyTokenId.REGEXP_BEGIN) && token.length() == 3 && n == tokenSequence.offset() + 2 && Character.isLetter(string3.charAt(1))) {
                    this.completeStringBegins(list, completionRequest);
                    return true;
                }
                while (tokenId == RubyTokenId.ERROR || tokenId == RubyTokenId.STRING_LITERAL || tokenId == RubyTokenId.QUOTED_STRING_LITERAL || tokenId == RubyTokenId.REGEXP_LITERAL || tokenId == RubyTokenId.EMBEDDED_RUBY) {
                    if (tokenId == RubyTokenId.QUOTED_STRING_LITERAL) {
                        bl2 = true;
                    }
                    if (!tokenSequence.movePrevious()) {
                        return false;
                    }
                    token = tokenSequence.token();
                    tokenId = token.id();
                }
                if (tokenId == RubyTokenId.STRING_BEGIN) {
                    bl = true;
                } else if (tokenId == RubyTokenId.QUOTED_STRING_BEGIN) {
                    bl = true;
                    bl2 = true;
                } else if (tokenId == RubyTokenId.REGEXP_BEGIN) {
                    bl3 = true;
                }
                if (bl3) {
                    if (this.completeRegexps(list, completionRequest)) {
                        completionRequest.completionResult.setFilterable(false);
                        return true;
                    }
                } else if (bl) {
                    while (tokenSequence.movePrevious()) {
                        String string4;
                        token = tokenSequence.token();
                        if (token.id() == RubyTokenId.WHITESPACE || token.id() == RubyTokenId.LPAREN || token.id() == RubyTokenId.STRING_LITERAL || token.id() == RubyTokenId.QUOTED_STRING_LITERAL || token.id() == RubyTokenId.STRING_BEGIN || token.id() == RubyTokenId.QUOTED_STRING_BEGIN) continue;
                        if (token.id() != RubyTokenId.IDENTIFIER || !(string4 = ((Object)token.text()).toString()).equals(KEY_REQUIRE) && !string4.equals("load")) break;
                        Set<String[]> set = rubyIndex.getRequires(string, this.caseSensitive ? NameKind.PREFIX : NameKind.CASE_INSENSITIVE_PREFIX);
                        for (String[] stringArray : set) {
                            assert (stringArray.length == 2);
                            KeywordItem keywordItem = new KeywordItem(stringArray[0], stringArray[1], this.anchor, completionRequest);
                            list.add((CompletionProposal)keywordItem);
                        }
                        return true;
                    }
                    if (bl && bl2) {
                        int n3 = RUBY_QUOTED_STRING_ESCAPES.length;
                        for (int i = 0; i < n3; i += 2) {
                            String string5 = RUBY_QUOTED_STRING_ESCAPES[i];
                            String string6 = RUBY_QUOTED_STRING_ESCAPES[i + 1];
                            if (!string5.startsWith(string)) continue;
                            KeywordItem keywordItem = new KeywordItem(string5, string6, this.anchor, completionRequest);
                            list.add((CompletionProposal)keywordItem);
                        }
                        return true;
                    }
                    if (bl) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    static boolean computeMethodCall(CompilationInfo compilationInfo, int n, int n2, IndexedMethod[] indexedMethodArray, int[] nArray, int[] nArray2, Set<IndexedMethod>[] setArray, NameKind nameKind) {
        try {
            boolean bl;
            Node node;
            Node node2;
            Object object;
            RubyParseResult rubyParseResult;
            OffsetRange offsetRange;
            Node node3 = AstUtilities.getRoot(compilationInfo);
            if (node3 == null) {
                return false;
            }
            IndexedMethod indexedMethod = null;
            int n3 = -1;
            AstPath astPath = null;
            int n4 = n2;
            BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            if (baseDocument == null) {
                return false;
            }
            int n5 = LexUtilities.findSpaceBegin(baseDocument, n);
            if (n5 < n) {
                n2 -= n - n5;
            }
            if ((offsetRange = (rubyParseResult = AstUtilities.getParseResult(compilationInfo)).getSanitizedRange()) != OffsetRange.NONE && offsetRange.containsInclusive(n2) && n2 != offsetRange.getStart()) {
                n2 = offsetRange.getStart() - 1;
                if (n2 < 0) {
                    n2 = 0;
                }
                astPath = new AstPath(node3, n2);
            }
            if (astPath == null) {
                astPath = new AstPath(node3, n2);
            }
            int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            if (callLineStart != -1 && n6 == callLineStart) {
                indexedMethod = callMethod;
            }
            Node node4 = null;
            int n7 = -1;
            if (indexedMethod != null) {
                ListIterator<Node> listIterator = astPath.leafToRoot();
                object = indexedMethod.getName();
                while (listIterator.hasNext()) {
                    node2 = (Node)listIterator.next();
                    if (!AstUtilities.isCall(node2) || !((String)object).equals(AstUtilities.getCallName(node2))) continue;
                    if (node2.nodeId == NodeType.CALLNODE) {
                        node = ((CallNode)node2).getArgsNode();
                        if (node == null) break;
                        n3 = AstUtilities.findArgumentIndex(node, n2);
                        if (n3 == -1 && n2 < n4) {
                            n3 = AstUtilities.findArgumentIndex(node, n4);
                        }
                        if (n3 == -1) break;
                        node4 = node2;
                        n7 = node.getPosition().getStartOffset();
                        break;
                    }
                    if (node2.nodeId == NodeType.FCALLNODE) {
                        node = ((FCallNode)node2).getArgsNode();
                        if (node == null) break;
                        n3 = AstUtilities.findArgumentIndex(node, n2);
                        if (n3 == -1 && n2 < n4) {
                            n3 = AstUtilities.findArgumentIndex(node, n4);
                        }
                        if (n3 == -1) break;
                        node4 = node2;
                        n7 = node.getPosition().getStartOffset();
                        break;
                    }
                    if (node2.nodeId != NodeType.VCALLNODE) break;
                    node = AstUtilities.getCallRange(node2);
                    AstUtilities.getCallName(node2);
                    if (n4 <= node.getEnd()) break;
                    n3 = 0;
                    node4 = node2;
                    n7 = node.getEnd() + 1;
                    break;
                }
            }
            boolean bl2 = bl = rubyParseResult.getSanitized() == RubyParser.Sanitize.EDITED_DOT || rubyParseResult.getSanitized() == RubyParser.Sanitize.ERROR_DOT;
            if (bl && rubyParseResult.getSanitizedContents().indexOf(44) == -1) {
                bl = false;
            }
            if (node4 == null) {
                object = astPath.leafToRoot();
                block3: while (object.hasNext()) {
                    Node node5;
                    node2 = (Node)object.next();
                    if (nameKind == NameKind.EXACT_NAME && (node2.nodeId == NodeType.ITERNODE || node2.nodeId == NodeType.DEFNNODE || node2.nodeId == NodeType.DEFSNODE)) break;
                    if (node2.nodeId == NodeType.CALLNODE) {
                        Node node6;
                        node = AstUtilities.getCallRange(node2);
                        if (bl && n4 > node.getEnd() && object.hasNext()) {
                            for (int i = 0; i < 3; ++i) {
                                node5 = (Node)object.next();
                                if (!AstUtilities.isCall(node5) || Utilities.getRowStart((BaseDocument)baseDocument, (int)LexUtilities.getLexerOffset(compilationInfo, node5.getPosition().getStartOffset())) != Utilities.getRowStart((BaseDocument)baseDocument, (int)n)) continue;
                                object.previous();
                                continue block3;
                            }
                        }
                        if ((node6 = ((CallNode)node2).getArgsNode()) != null) {
                            n3 = AstUtilities.findArgumentIndex(node6, n2);
                            if (n3 == -1 && n2 < n4) {
                                n3 = AstUtilities.findArgumentIndex(node6, n4);
                            }
                            if (n3 == -1) continue;
                            node4 = node2;
                            n7 = node6.getPosition().getStartOffset();
                            break;
                        }
                        if (n4 <= node.getEnd()) continue;
                        n3 = 0;
                        node4 = node2;
                        n7 = node.getEnd() + 1;
                        break;
                    }
                    if (node2.nodeId == NodeType.FCALLNODE) {
                        Node node7;
                        node = AstUtilities.getCallRange(node2);
                        if (bl && n4 > node.getEnd() && object.hasNext()) {
                            for (int i = 0; i < 3; ++i) {
                                node5 = (Node)object.next();
                                if (!AstUtilities.isCall(node5) || Utilities.getRowStart((BaseDocument)baseDocument, (int)LexUtilities.getLexerOffset(compilationInfo, node5.getPosition().getStartOffset())) != Utilities.getRowStart((BaseDocument)baseDocument, (int)n)) continue;
                                object.previous();
                                continue block3;
                            }
                        }
                        if ((node7 = ((FCallNode)node2).getArgsNode()) == null) continue;
                        n3 = AstUtilities.findArgumentIndex(node7, n2);
                        if (n3 == -1 && n2 < n4) {
                            n3 = AstUtilities.findArgumentIndex(node7, n4);
                        }
                        if (n3 == -1) continue;
                        node4 = node2;
                        n7 = node7.getPosition().getStartOffset();
                        break;
                    }
                    if (node2.nodeId != NodeType.VCALLNODE) continue;
                    node = AstUtilities.getCallRange(node2);
                    if (bl && n4 > node.getEnd() && object.hasNext()) {
                        for (int i = 0; i < 3; ++i) {
                            node5 = (Node)object.next();
                            if (!AstUtilities.isCall(node5) || Utilities.getRowStart((BaseDocument)baseDocument, (int)LexUtilities.getLexerOffset(compilationInfo, node5.getPosition().getStartOffset())) != Utilities.getRowStart((BaseDocument)baseDocument, (int)n)) continue;
                            object.previous();
                            continue block3;
                        }
                    }
                    if (n4 <= node.getEnd()) continue;
                    n3 = 0;
                    node4 = node2;
                    n7 = node.getEnd() + 1;
                    break;
                }
            }
            if (n3 != -1 && bl && node4 != null) {
                object = null;
                if (node4.nodeId == NodeType.FCALLNODE) {
                    object = ((FCallNode)node4).getArgsNode();
                } else if (node4.nodeId == NodeType.CALLNODE) {
                    object = ((CallNode)node4).getArgsNode();
                }
                if (object != null && n3 < object.childNodes().size() && ((Node)object.childNodes().get((int)n3)).nodeId == NodeType.HASHNODE) {
                    --n3;
                }
                ++n3;
            }
            if (node4 == null || n3 == -1) {
                callLineStart = -1;
                callMethod = null;
                return false;
            }
            if (indexedMethod == null && (indexedMethod = new RubyDeclarationFinder().findMethodDeclaration(compilationInfo, node4, astPath, setArray)) == null) {
                return false;
            }
            callLineStart = n6;
            indexedMethodArray[0] = callMethod = indexedMethod;
            nArray[0] = n3;
            if (n7 == -1) {
                n7 = node4.getPosition().getStartOffset();
            }
            nArray2[0] = n7;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return false;
        }
        return true;
    }

    private boolean addParameters(List<CompletionProposal> list, CompletionRequest completionRequest) {
        Object object2;
        Collection<String> collection;
        int n;
        int n2;
        IndexedMethod[] indexedMethodArray = new IndexedMethod[1];
        Set[] setArray = new Set[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        CompilationInfo compilationInfo = completionRequest.info;
        if (!RubyCodeCompleter.computeMethodCall(compilationInfo, n2 = completionRequest.lexOffset, n = completionRequest.astOffset, indexedMethodArray, nArray, nArray2, setArray, completionRequest.kind)) {
            return false;
        }
        IndexedMethod indexedMethod = indexedMethodArray[0];
        int n3 = nArray[0];
        CallItem callItem = new CallItem(indexedMethod, n3, this.anchor, completionRequest);
        list.add((CompletionProposal)callItem);
        if (setArray[0] != null) {
            collection = new HashSet();
            collection.add(indexedMethod.getSignature().substring(indexedMethod.getSignature().indexOf(35) + 1));
            for (Object object2 : setArray[0]) {
                String string;
                if (object2 == indexedMethod || !((IndexedElement)object2).isDocumented() || ((IndexedElement)object2).isNoDoc() || collection.contains(string = ((IndexedMethod)object2).getSignature().substring(((IndexedMethod)object2).getSignature().indexOf(35) + 1))) continue;
                CallItem callItem2 = new CallItem((IndexedMethod)object2, n3, this.anchor, completionRequest);
                list.add((CompletionProposal)callItem2);
                collection.add(string);
            }
        }
        if ((collection = indexedMethod.getParameters()) == null || collection.isEmpty()) {
            return false;
        }
        if (collection.size() <= n3) {
            n3 = collection.size() - 1;
        }
        boolean bl = n3 < collection.size() - 1;
        object2 = indexedMethod.getEncodedAttributes();
        if (object2 != null && ((String)object2).length() > 0) {
            String string;
            String[] stringArray;
            int n4 = -1;
            for (int i = 0; i < 3 && (n4 = ((String)object2).indexOf(59, n4 + 1)) != -1; ++i) {
            }
            if (n4 == -1) {
                Node node = null;
                if (compilationInfo != null) {
                    node = AstUtilities.getRoot(compilationInfo);
                }
                if ((stringArray = this.findDocumentationEntry(node, indexedMethod)) == indexedMethod || !(stringArray instanceof IndexedMethod)) {
                    return false;
                }
                indexedMethod = (IndexedMethod)stringArray;
                object2 = indexedMethod.getEncodedAttributes();
                if (object2 != null && ((String)object2).length() > 0) {
                    n4 = -1;
                    for (int i = 0; i < 3 && (n4 = ((String)object2).indexOf(59, n4 + 1)) != -1; ++i) {
                    }
                }
            }
            if ((string = (String)collection.get(n3)).startsWith("*")) {
                string = string.substring(1);
            } else if (string.startsWith("&")) {
                string = string.substring(1);
            }
            if (n4 != -1) {
                if (((String)(object2 = ((String)object2).substring(n4 + 1))).length() == 0) {
                    return false;
                }
                for (String string2 : stringArray = ((String)object2).split(",")) {
                    int n5 = string2.indexOf(40);
                    assert (n5 != -1) : object2;
                    String string3 = string2.substring(0, n5);
                    if (!string.equals(string3)) continue;
                    int n6 = string2.indexOf(41, n5);
                    assert (n6 != -1);
                    String string4 = string2.substring(n5 + 1, n6);
                    if (string4.length() > 0 && string4.charAt(0) == '-') {
                        if ("-table".equals(string4)) {
                            this.completeDbTables(list, indexedMethod, completionRequest, bl);
                            continue;
                        }
                        if ("-column".equals(string4)) {
                            this.completeDbColumns(list, indexedMethod, completionRequest, bl);
                            continue;
                        }
                        if (!"-model".equals(string4)) continue;
                        this.completeModels(list, indexedMethod, completionRequest, bl);
                        continue;
                    }
                    if (string4.startsWith("=>")) {
                        this.completeHash(list, completionRequest, indexedMethod, string4, bl);
                        continue;
                    }
                    this.completeFixed(list, completionRequest, indexedMethod, string4, bl);
                }
            }
        }
        return true;
    }

    private boolean completeHash(List<CompletionProposal> list, CompletionRequest completionRequest, IndexedMethod indexedMethod, String string, boolean bl) {
        Object object;
        int n;
        Object object2;
        Object object3;
        assert (string.startsWith("=>"));
        string = string.substring(2);
        String string2 = completionRequest.prefix;
        boolean bl2 = false;
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(completionRequest.doc, this.anchor);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(this.anchor);
        String string3 = null;
        while (tokenSequence.movePrevious()) {
            object3 = tokenSequence.token();
            if (object3.id() == RubyTokenId.WHITESPACE) continue;
            if (object3.id() != RubyTokenId.NONUNARY_OP || !((Object)object3.text()).toString().equals("=>")) break;
            bl2 = true;
            try {
                object2 = completionRequest.doc;
                int n2 = Utilities.getRowStart((BaseDocument)object2, (int)tokenSequence.offset());
                string3 = object2.getText(n2, tokenSequence.offset() - n2).trim();
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                return false;
            }
        }
        object3 = new ArrayList();
        object2 = null;
        String[] stringArray = string.split("\\|");
        if (bl2) {
            for (String string4 : stringArray) {
                List<String> list2;
                n = string4.indexOf(58);
                if (n == -1 || !string3.endsWith((String)(object = string4.substring(0, n)))) continue;
                object2 = object;
                String string5 = string4.substring(n + 1);
                if ("nil".equals(string5)) {
                    object3.add("nil");
                    continue;
                }
                if ("bool".equals(string5)) {
                    object3.add("true");
                    object3.add("false");
                    continue;
                }
                if ("submitmethod".equals(string5)) {
                    object3.add("post");
                    object3.add("get");
                    continue;
                }
                if ("validationactive".equals(string5)) {
                    object3.add(":save");
                    object3.add(":create");
                    object3.add(":update");
                    continue;
                }
                if ("string".equals(string5)) {
                    object3.add("\"");
                    continue;
                }
                if ("hash".equals(string5)) {
                    object3.add("{");
                    continue;
                }
                if ("controller".equals(string5)) {
                    list2 = RubyUtils.getControllerNames(completionRequest.fileObject, true);
                    for (String string6 : list2) {
                        object3.add("'" + string6 + "'");
                    }
                    continue;
                }
                if (!"action".equals(string5)) continue;
                list2 = this.getActionNames(completionRequest);
                for (String string6 : list2) {
                    object3.add("'" + string6 + "'");
                }
            }
        } else {
            for (String string4 : stringArray) {
                n = string4.indexOf(58);
                if (n != -1) {
                    string4 = string4.substring(0, n);
                }
                string4 = ":" + string4 + " => ";
                object3.add(string4);
            }
        }
        String string7 = ":" + string2;
        Iterator iterator = object3.iterator();
        while (iterator.hasNext()) {
            String string4;
            String string8 = (String)iterator.next();
            if (!this.startsWith(string8, string2) && !this.startsWith(string8, string7)) continue;
            string4 = string8;
            String string9 = null;
            if (bl2) {
                if (!bl) {
                    string4 = string4 + ", ";
                }
                if (object2 != null) {
                    string9 = ":" + (String)object2 + " = " + string8;
                }
            }
            object = new ParameterItem(indexedMethod, string8, string9, string4, this.anchor, completionRequest);
            ((RubyCompletionItem)((Object)object)).setSymbol(true);
            object.setSmart(true);
            list.add((CompletionProposal)object);
        }
        return true;
    }

    private List<String> getActionNames(CompletionRequest completionRequest) {
        FileObject fileObject = completionRequest.fileObject;
        FileObject fileObject2 = null;
        fileObject2 = fileObject.getNameExt().endsWith("_controller.rb") ? fileObject : RubyUtils.getRailsControllerFor(fileObject);
        if (fileObject2 == null) {
            return Collections.emptyList();
        }
        String string = RubyUtils.getControllerClass(fileObject2);
        if (string != null) {
            String string2 = completionRequest.prefix;
            Set<IndexedMethod> set = completionRequest.index.getMethods(string2, string, completionRequest.kind);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (IndexedMethod indexedMethod : set) {
                if ((!indexedMethod.isPublic() || indexedMethod.getArgs() != null) && indexedMethod.getArgs().length != 0) continue;
                arrayList.add(indexedMethod.getName());
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    private void completeFixed(List<CompletionProposal> list, CompletionRequest completionRequest, IndexedMethod indexedMethod, String string, boolean bl) {
        String[] stringArray = string.split("\\|");
        String string2 = completionRequest.prefix;
        String string3 = ":" + string2;
        for (String string4 : stringArray) {
            if (!this.startsWith(string4, string2) && !this.startsWith(string4, string3)) continue;
            String string5 = bl ? string4 : string4 + ", ";
            ParameterItem parameterItem = new ParameterItem(indexedMethod, string4, null, string5, this.anchor, completionRequest);
            parameterItem.setSymbol(true);
            parameterItem.setSmart(true);
            list.add((CompletionProposal)parameterItem);
        }
    }

    private void completeDbTables(List<CompletionProposal> list, IndexedMethod indexedMethod, CompletionRequest completionRequest, boolean bl) {
        String string;
        String string2 = string = completionRequest.prefix;
        if (":".equals(string)) {
            string = "";
        } else {
            string2 = ":" + string;
        }
        Set<String> set = completionRequest.index.getDatabaseTables(string, completionRequest.kind);
        String string3 = completionRequest.prefix;
        for (String string4 : set) {
            String string5 = ":" + string4;
            if (!this.startsWith(string5, string3) && !this.startsWith(string5, string2)) continue;
            String string6 = bl ? string5 : string5 + ", ";
            ParameterItem parameterItem = new ParameterItem(indexedMethod, string5, null, string6, this.anchor, completionRequest);
            parameterItem.setSymbol(true);
            parameterItem.setSmart(true);
            list.add((CompletionProposal)parameterItem);
        }
    }

    private void completeModels(List<CompletionProposal> list, IndexedMethod indexedMethod, CompletionRequest completionRequest, boolean bl) {
        Set<IndexedClass> set = completionRequest.index.getSubClasses(completionRequest.prefix, "ActiveRecord::Base", completionRequest.kind, RubyIndex.SOURCE_SCOPE);
        String string = completionRequest.prefix;
        String string2 = ":" + string;
        for (IndexedClass indexedClass : set) {
            String string3 = indexedClass.getName();
            String string4 = ":" + RubyUtils.camelToUnderlinedName(string3);
            if (!this.startsWith(string4, string) && !this.startsWith(string4, string2)) continue;
            String string5 = bl ? string4 : string4 + ", ";
            ParameterItem parameterItem = new ParameterItem(indexedMethod, string4, string3, string5, this.anchor, completionRequest);
            parameterItem.setSymbol(true);
            parameterItem.setSmart(true);
            list.add((CompletionProposal)parameterItem);
        }
    }

    private void completeDbColumns(List<CompletionProposal> list, IndexedMethod indexedMethod, CompletionRequest completionRequest, boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodeCompletionResult complete(CodeCompletionContext codeCompletionContext) {
        CompilationInfo compilationInfo = codeCompletionContext.getInfo();
        int n = codeCompletionContext.getCaretOffset();
        String string = codeCompletionContext.getPrefix();
        NameKind nameKind = codeCompletionContext.getNameKind();
        CodeCompletionHandler.QueryType queryType = codeCompletionContext.getQueryType();
        this.caseSensitive = codeCompletionContext.isCaseSensitive();
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        if (n2 == -1) {
            return null;
        }
        if (string == null) {
            string = "";
        }
        List<CompletionProposal> list = new ArrayList<CompletionProposal>();
        DefaultCompletionResult defaultCompletionResult = new DefaultCompletionResult(list, false);
        this.anchor = n - string.length();
        RubyIndex rubyIndex = RubyIndex.get(compilationInfo.getIndex("text/x-ruby"), compilationInfo.getFileObject());
        Document document = compilationInfo.getDocument();
        if (document == null) {
            return CodeCompletionResult.NONE;
        }
        n = AstUtilities.boundCaretOffset(compilationInfo, n);
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        BaseDocument baseDocument = (BaseDocument)document;
        FileObject fileObject = compilationInfo.getFileObject();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        char c = '\u0000';
        baseDocument.readLock();
        try {
            Object object;
            String[] stringArray2;
            Object object22;
            Object object3;
            int n3;
            int n4;
            if (string.length() > 0) {
                c = string.charAt(0);
                int n5 = string.lastIndexOf("::");
                if (n5 != -1 && n5 < string.length() - 2) {
                    c = string.charAt(n5 + 2);
                }
                bl = Character.isLowerCase(c);
                bl2 = Character.isUpperCase(c);
                if (c == ':') {
                    bl3 = true;
                    if (string.length() > 1) {
                        char c2 = string.charAt(1);
                        string = string.substring(1);
                        bl = Character.isLowerCase(c2);
                        bl2 = Character.isUpperCase(c2);
                    }
                }
            }
            CompletionRequest completionRequest = new CompletionRequest();
            completionRequest.completionResult = defaultCompletionResult;
            completionRequest.lexOffset = n;
            completionRequest.astOffset = n2;
            completionRequest.index = rubyIndex;
            completionRequest.doc = baseDocument;
            completionRequest.info = compilationInfo;
            completionRequest.prefix = string;
            completionRequest.th = tokenHierarchy;
            completionRequest.kind = nameKind;
            completionRequest.queryType = queryType;
            completionRequest.fileObject = fileObject;
            if (this.completeStrings(list, completionRequest)) {
                defaultCompletionResult.setFilterable(false);
                DefaultCompletionResult defaultCompletionResult2 = defaultCompletionResult;
                return defaultCompletionResult2;
            }
            Call call = Call.getCallType(baseDocument, (TokenHierarchy<Document>)tokenHierarchy, n);
            Node node = AstUtilities.getRoot(compilationInfo);
            if (node == null) {
                this.completeKeywords(list, completionRequest, bl3);
                DefaultCompletionResult defaultCompletionResult3 = defaultCompletionResult;
                return defaultCompletionResult3;
            }
            try {
                n4 = AstUtilities.getAstOffset(compilationInfo, Utilities.getRowStart((BaseDocument)baseDocument, (int)n));
                n3 = AstUtilities.getAstOffset(compilationInfo, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n));
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
                CodeCompletionResult codeCompletionResult = CodeCompletionResult.NONE;
                baseDocument.readUnlock();
                return codeCompletionResult;
            }
            AstPath astPath = new AstPath(node, n2);
            completionRequest.path = astPath;
            HashMap<String, Node> hashMap = new HashMap<String, Node>();
            HashMap hashMap2 = new HashMap();
            HashMap hashMap3 = new HashMap();
            HashMap<String, Node> hashMap4 = new HashMap<String, Node>();
            Node node2 = astPath.leaf();
            completionRequest.node = node2;
            if (call.getLhs() == null) {
                Object object4;
                if (bl && node2 != null) {
                    object4 = AstUtilities.getApplicableBlocks(astPath, false);
                    object3 = object4.iterator();
                    while (object3.hasNext()) {
                        object22 = (Node)object3.next();
                        RubyCodeCompleter.addDynamic((Node)object22, hashMap);
                    }
                    object3 = AstUtilities.findLocalScope(node2, astPath);
                    object22 = object3.childNodes();
                    stringArray2 = object22.iterator();
                    while (stringArray2.hasNext()) {
                        object = (Node)stringArray2.next();
                        if (object.isInvisible()) continue;
                        RubyCodeCompleter.addLocals((Node)object, hashMap);
                    }
                }
                if (string.length() == 0 || c == '@' || bl3) {
                    object4 = AstUtilities.getFqnName(astPath);
                    if (object4 == null || ((String)object4).length() == 0) {
                        object4 = "Object";
                    }
                    if (RubyUtils.isRhtmlFile(fileObject) || RubyUtils.isMarkabyFile(fileObject)) {
                        object3 = new HashSet();
                        this.addActionViewFields((Set<IndexedField>)object3, fileObject, rubyIndex, string, nameKind);
                    } else {
                        object3 = rubyIndex.getInheritedFields((String)object4, string, nameKind, false);
                    }
                    for (String[] stringArray2 : object3) {
                        object = new FieldItem((Element)stringArray2, this.anchor, completionRequest);
                        object.setSmart(stringArray2.isSmart());
                        if (bl3) {
                            ((RubyCompletionItem)((Object)object)).setSymbol(true);
                        }
                        list.add((CompletionProposal)object);
                    }
                }
                if ((string.length() == 0 || c == '$' || bl3) && (string.startsWith("$") || bl3)) {
                    this.completeGlobals(list, completionRequest, bl3);
                    this.completeKeywords(list, completionRequest, bl3);
                    if (!bl3) {
                        object4 = defaultCompletionResult;
                        return object4;
                    }
                }
            }
            if (bl2 || bl3) {
                this.addConstants(node, hashMap4);
            }
            boolean bl4 = this.addParameters(list, completionRequest);
            if (rubyIndex != null) {
                if (bl || bl3) {
                    object3 = AstUtilities.getFqnName(astPath);
                    if (object3 == null || object3.length() == 0) {
                        object3 = "Object";
                    }
                    if (object3 != null && queryType == CodeCompletionHandler.QueryType.COMPLETION && this.completeDefOrInclude(list, completionRequest, (String)object3)) {
                        object22 = defaultCompletionResult;
                        return object22;
                    }
                    if (object3 != null && this.completeObjectMethod(list, completionRequest, (String)object3, call)) {
                        object22 = defaultCompletionResult;
                        return object22;
                    }
                    if (call.getLhs() == null) {
                        object22 = rubyIndex.getInheritedMethods((String)object3, string, nameKind);
                        if (RubyUtils.isRhtmlFile(fileObject) || RubyUtils.isMarkabyFile(fileObject)) {
                            this.addActionViewMethods((Set<IndexedMethod>)object22, fileObject, rubyIndex, string, nameKind);
                        } else if (fileObject.getName().endsWith("_spec")) {
                            stringArray2 = new String[]{"Spec::Matchers", "Spec::Expectations::ObjectExpectations", "Spec::DSL::BehaviourEval::InstanceMethods"};
                            for (String string2 : stringArray2) {
                                Set<IndexedMethod> set = rubyIndex.getInheritedMethods(string2, string, nameKind);
                                object22.addAll(set);
                            }
                        }
                        stringArray2 = object22.iterator();
                        while (stringArray2.hasNext()) {
                            object = (IndexedMethod)stringArray2.next();
                            if (string.length() > 0 && !((IndexedMethod)object).getName().startsWith(string) || ((IndexedElement)object).isNoDoc()) continue;
                            MethodItem methodItem = new MethodItem((IndexedMethod)object, this.anchor, completionRequest);
                            methodItem.setSmart(((IndexedMethod)object).isSmart());
                            if (bl3) {
                                methodItem.setSymbol(true);
                            }
                            list.add((CompletionProposal)methodItem);
                        }
                    }
                }
                if (bl2 && queryType == CodeCompletionHandler.QueryType.COMPLETION && this.completeDefOrInclude(list, completionRequest, "")) {
                    object3 = defaultCompletionResult;
                    return object3;
                }
                if (bl2 && (string != null && string.length() > 0 || !call.isMethodExpected() && call.getLhs() != null && call.getLhs().length() > 0) || bl3 && !bl4) {
                    this.completeClasses(list, completionRequest, bl3, call);
                }
            }
            assert (nameKind == NameKind.PREFIX || nameKind == NameKind.CASE_INSENSITIVE_PREFIX || nameKind == NameKind.EXACT_NAME);
            for (Object object22 : hashMap.keySet()) {
                if ((nameKind != NameKind.EXACT_NAME || !string.equals(object22)) && (nameKind == NameKind.EXACT_NAME || !this.startsWith((String)object22, string)) || this.overlapsLine((Node)(stringArray2 = (Node)hashMap.get(object22)), n4, n3)) continue;
                object = new AstNameElement(compilationInfo, (Node)stringArray2, (String)object22, ElementKind.VARIABLE);
                RubyCompletionItem rubyCompletionItem = new RubyCompletionItem((Element)object, this.anchor, completionRequest);
                rubyCompletionItem.setSmart(true);
                if (bl3) {
                    rubyCompletionItem.setSymbol(true);
                }
                list.add((CompletionProposal)rubyCompletionItem);
            }
            for (Object object22 : hashMap2.keySet()) {
                if ((nameKind != NameKind.EXACT_NAME || !string.equals(object22)) && (nameKind == NameKind.EXACT_NAME || !this.startsWith((String)object22, string)) || this.overlapsLine((Node)(stringArray2 = (Node)hashMap2.get(object22)), n4, n3)) continue;
                object = new AstFieldElement(compilationInfo, (Node)stringArray2);
                FieldItem fieldItem = new FieldItem((Element)object, this.anchor, completionRequest);
                fieldItem.setSmart(true);
                if (bl3) {
                    fieldItem.setSymbol(true);
                }
                list.add((CompletionProposal)fieldItem);
            }
            for (Object object22 : hashMap3.keySet()) {
                if (!this.startsWith((String)object22, string) && (!bl3 || !this.startsWith(((String)object22).substring(1), string)) || this.overlapsLine((Node)(stringArray2 = (Node)hashMap3.get(object22)), n4, n3)) continue;
                object = new AstNameElement(compilationInfo, (Node)stringArray2, (String)object22, ElementKind.VARIABLE);
                RubyCompletionItem rubyCompletionItem = new RubyCompletionItem((Element)object, this.anchor, completionRequest);
                rubyCompletionItem.setSmart(true);
                if (bl3) {
                    rubyCompletionItem.setSymbol(true);
                }
                list.add((CompletionProposal)rubyCompletionItem);
            }
            for (Object object22 : hashMap4.keySet()) {
                if ((nameKind != NameKind.EXACT_NAME || !string.equals(object22)) && (nameKind == NameKind.EXACT_NAME || !this.startsWith((String)object22, string)) || this.overlapsLine((Node)(stringArray2 = (String[])hashMap4.get(object22)), n4, n3)) continue;
                object = new AstNameElement(compilationInfo, (Node)stringArray2, (String)object22, ElementKind.VARIABLE);
                RubyCompletionItem rubyCompletionItem = new RubyCompletionItem((Element)object, this.anchor, completionRequest);
                rubyCompletionItem.setSmart(true);
                if (bl3) {
                    rubyCompletionItem.setSymbol(true);
                }
                list.add((CompletionProposal)rubyCompletionItem);
            }
            if (this.completeKeywords(list, completionRequest, bl3)) {
                object3 = defaultCompletionResult;
                return object3;
            }
            if (queryType == CodeCompletionHandler.QueryType.DOCUMENTATION) {
                list = this.filterDocumentation(list, node, baseDocument, compilationInfo, n2, n, string, astPath, rubyIndex);
            }
        }
        finally {
            baseDocument.readUnlock();
        }
        return defaultCompletionResult;
    }

    private void addActionViewMethods(Set<IndexedMethod> set, FileObject fileObject, RubyIndex rubyIndex, String string, NameKind nameKind) {
        FileObject fileObject2;
        boolean bl = RubyUtils.isMarkabyFile(fileObject);
        if (bl) {
            fileObject2 = rubyIndex.getInheritedMethods("ActionView::Base", string, nameKind);
            set.addAll((Collection<IndexedMethod>)fileObject2);
        }
        if (RubyUtils.isRhtmlFile(fileObject) || bl) {
            Object object;
            Object object2 = null;
            for (fileObject2 = fileObject.getParent(); fileObject2 != null && !fileObject2.getName().equals("views"); fileObject2 = fileObject2.getParent()) {
                object = RubyUtils.underlinedNameToCamel(fileObject2.getName());
                object2 = object2 == null ? object : (String)object + "::" + (String)object2;
            }
            object = rubyIndex.getInheritedMethods(object2 + "Helper", string, nameKind);
            set.addAll((Collection<IndexedMethod>)object);
        }
    }

    private void addActionViewFields(Set<IndexedField> set, FileObject fileObject, RubyIndex rubyIndex, String string, NameKind nameKind) {
        Object object;
        boolean bl = RubyUtils.isMarkabyFile(fileObject);
        if (bl) {
            object = rubyIndex.getInheritedFields("ActionView::Base", string, nameKind, true);
            set.addAll((Collection<IndexedField>)object);
        }
        if (RubyUtils.isRhtmlFile(fileObject) || bl) {
            String string2;
            String string3 = null;
            for (object = fileObject.getParent(); object != null && !object.getName().equals("views"); object = object.getParent()) {
                string2 = RubyUtils.underlinedNameToCamel(object.getName());
                string3 = string3 == null ? string2 : string2 + "::" + string3;
            }
            string2 = string3 + "Controller";
            Set<IndexedField> set2 = rubyIndex.getInheritedFields(string2, string, nameKind, true);
            for (IndexedField indexedField : set2) {
                if ("ActionController::Base".equals(indexedField.getIn())) continue;
                set.add(indexedField);
            }
        }
    }

    private List<CompletionProposal> filterDocumentation(List<CompletionProposal> list, Node node, BaseDocument baseDocument, CompilationInfo compilationInfo, int n, int n2, String string, AstPath astPath, RubyIndex rubyIndex) {
        IndexedElement indexedElement;
        RubyElement rubyElement;
        Object object2;
        ArrayList<CompletionProposal> arrayList = new ArrayList<CompletionProposal>();
        FileObject fileObject = compilationInfo.getFileObject();
        HashMap<IndexedElement, CompletionProposal> hashMap = new HashMap<IndexedElement, CompletionProposal>();
        HashSet<IndexedMethod> hashSet = new HashSet<IndexedMethod>();
        HashSet<IndexedClass> hashSet2 = new HashSet<IndexedClass>();
        for (Object object2 : list) {
            rubyElement = (RubyElement)object2.getElement();
            if (!(rubyElement instanceof IndexedElement)) continue;
            indexedElement = (IndexedElement)rubyElement;
            if (indexedElement instanceof IndexedClass) {
                hashSet2.add((IndexedClass)indexedElement);
                hashMap.put(indexedElement, (CompletionProposal)object2);
            } else if (indexedElement instanceof IndexedMethod) {
                hashSet.add((IndexedMethod)indexedElement);
                hashMap.put(indexedElement, (CompletionProposal)object2);
            }
            if (indexedElement.getFileObject() != fileObject) continue;
            arrayList.add((CompletionProposal)object2);
        }
        for (Object object2 : arrayList) {
            String string2;
            Node node2;
            rubyElement = (RubyElement)object2.getElement();
            if (!(rubyElement instanceof IndexedElement) || (node2 = AstUtilities.findBySignature(node, string2 = (indexedElement = (IndexedElement)rubyElement).getSignature())) == null) continue;
            ISourcePosition iSourcePosition = node2.getPosition();
            int n3 = LexUtilities.getLexerOffset(compilationInfo, iSourcePosition.getStartOffset());
            try {
                List<String> list2;
                int n4 = AstUtilities.getAstOffset(compilationInfo, Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n3));
                int n5 = AstUtilities.getAstOffset(compilationInfo, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3));
                if (n < n4 || n > n5 || (list2 = AstUtilities.gatherDocumentation(compilationInfo, baseDocument, node2)) == null || list2.isEmpty()) continue;
                return Collections.singletonList(object2);
            }
            catch (BadLocationException badLocationException) {
            }
        }
        RubyDeclarationFinder rubyDeclarationFinder = new RubyDeclarationFinder();
        object2 = null;
        if (!hashSet2.isEmpty()) {
            object2 = rubyDeclarationFinder.findBestClassMatch(hashSet2, astPath, astPath.leaf(), rubyIndex);
        } else if (!hashSet.isEmpty()) {
            object2 = rubyDeclarationFinder.findBestMethodMatch(string, hashSet, baseDocument, n, n2, astPath, astPath.leaf(), rubyIndex);
        }
        if (object2 != null && (rubyElement = (CompletionProposal)hashMap.get(object2)) != null) {
            return Collections.singletonList(rubyElement);
        }
        return list;
    }

    private boolean overlapsLine(Node node, int n, int n2) {
        ISourcePosition iSourcePosition = node.getPosition();
        return iSourcePosition.getStartOffset() >= n && iSourcePosition.getStartOffset() <= n2;
    }

    static void addLocals(Node node, Map<String, Node> map) {
        Node node2;
        Object object;
        Object object2;
        switch (node.nodeId) {
            case LOCALASGNNODE: {
                object2 = ((INameNode)node).getName();
                if (map.containsKey(object2)) break;
                map.put((String)object2, node);
                break;
            }
            case ARGSNODE: {
                object2 = (ArgsNode)node;
                if (object2.getRequiredArgsCount() > 0) {
                    object = object2.childNodes();
                    node2 = object.iterator();
                    while (node2.hasNext()) {
                        Node node3 = (Node)node2.next();
                        if (!(node3 instanceof ListNode)) continue;
                        List list = node3.childNodes();
                        for (Node node4 : list) {
                            if (node4 instanceof ArgumentNode) {
                                map.put(((ArgumentNode)node4).getName(), node4);
                                continue;
                            }
                            if (!(node4 instanceof LocalAsgnNode)) continue;
                            map.put(((INameNode)node4).getName(), node4);
                        }
                    }
                }
                if (object2.getRestArgNode() != null) {
                    object = object2.getRestArgNode().getName();
                    map.put((String)object, (Node)object2.getRestArgNode());
                }
                if (object2.getBlockArgNode() == null) break;
                object = object2.getBlockArgNode().getName();
                map.put((String)object, (Node)object2.getBlockArgNode());
                break;
            }
        }
        object2 = node.childNodes();
        object = object2.iterator();
        block9: while (object.hasNext()) {
            node2 = (Node)object.next();
            if (node2.isInvisible()) continue;
            switch (node2.nodeId) {
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: {
                    continue block9;
                }
            }
            RubyCodeCompleter.addLocals(node2, map);
        }
    }

    static void addDynamic(Node node, Map<String, Node> map) {
        Object object;
        if (node.nodeId == NodeType.DASGNNODE && !map.containsKey(object = ((INameNode)node).getName())) {
            map.put((String)object, node);
        }
        object = node.childNodes();
        Iterator iterator = object.iterator();
        block3: while (iterator.hasNext()) {
            Node node2 = (Node)iterator.next();
            if (node2.isInvisible()) continue;
            switch (node2.nodeId) {
                case DEFNNODE: 
                case DEFSNODE: 
                case CLASSNODE: 
                case SCLASSNODE: 
                case MODULENODE: 
                case ITERNODE: {
                    continue block3;
                }
            }
            RubyCodeCompleter.addDynamic(node2, map);
        }
    }

    private void addConstants(Node node, Map<String, Node> map) {
        if (node.nodeId == NodeType.CONSTDECLNODE) {
            map.put(((INameNode)node).getName(), node);
        }
        List list = node.childNodes();
        for (Node node2 : list) {
            if (node2.isInvisible()) continue;
            this.addConstants(node2, map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String loadResource(String string) {
        InputStream inputStream = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            inputStream = new BufferedInputStream(RubyCodeCompleter.class.getResourceAsStream("resources/" + string));
            while ((n = inputStream.read()) != -1) {
                stringBuilder.append((char)n);
            }
            if (stringBuilder.length() > 0) {
                String string2 = stringBuilder.toString();
                return string2;
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    private String getKeywordHelp(String string) {
        if (string.equals("if") || string.equals("elsif") || string.equals("else") || string.equals("then") || string.equals("unless")) {
            return this.loadResource("ifelse.html");
        }
        if (string.equals("case") || string.equals("when") || string.equals("else")) {
            return this.loadResource("case.html");
        }
        if (string.equals("rescue") || string.equals("ensure")) {
            return this.loadResource("rescue.html");
        }
        if (string.equals("yield")) {
            return this.loadResource("yield.html");
        }
        return null;
    }

    private IndexedElement findDocumentationEntry(Node node, IndexedElement indexedElement) {
        HashSet<? extends IndexedElement> hashSet;
        String string = indexedElement.getSignature();
        Set<? extends IndexedElement> set = indexedElement.getIndex().getDocumented(string);
        if (set == null || set.isEmpty()) {
            return null;
        }
        if (set.size() == 1) {
            return set.iterator().next();
        }
        if (node != null) {
            hashSet = new HashSet<IndexedElement>();
            Set<String> set2 = AstUtilities.getRequires(node);
            for (IndexedElement indexedElement2 : set) {
                String string2 = indexedElement2.getRequire();
                if (!set2.contains(string2)) continue;
                hashSet.add(indexedElement2);
            }
            if (hashSet.size() == 1) {
                return (IndexedElement)hashSet.iterator().next();
            }
            if (!hashSet.isEmpty()) {
                set = hashSet;
            }
        }
        hashSet = new HashSet();
        for (IndexedElement indexedElement3 : set) {
            String string3 = indexedElement3.getFileUrl();
            if (string3.indexOf("rubystubs") == -1) continue;
            hashSet.add(indexedElement3);
        }
        if (hashSet.size() == 1) {
            return (IndexedElement)hashSet.iterator().next();
        }
        if (!hashSet.isEmpty()) {
            set = hashSet;
        }
        return set.iterator().next();
    }

    private List<String> getComments(CompilationInfo compilationInfo, Element object) {
        List<String> list;
        Node node;
        Object object2;
        assert (compilationInfo != null || object instanceof IndexedElement);
        if (object == null) {
            return null;
        }
        Node node2 = null;
        if (object instanceof AstElement) {
            node2 = ((AstElement)object).getNode();
        } else if (object instanceof IndexedElement) {
            object2 = (IndexedElement)object;
            node = null;
            if (compilationInfo != null) {
                node = AstUtilities.getRoot(compilationInfo);
            }
            if ((list = this.findDocumentationEntry(node, (IndexedElement)object2)) != null) {
                object = object2 = list;
            }
            if ((node2 = AstUtilities.getForeignNode((IndexedElement)object2, (Node[])null)) == null) {
                return null;
            }
        } else {
            assert (false) : object;
            return null;
        }
        object2 = null;
        node = null;
        if (object instanceof IndexedElement) {
            object2 = ((IndexedElement)object).getDocument();
            compilationInfo = null;
        } else if (compilationInfo != null) {
            object2 = compilationInfo.getDocument();
        }
        if (!(object2 instanceof BaseDocument)) {
            return null;
        }
        node = (BaseDocument)object2;
        list = null;
        if (node2 instanceof ClassNode && !(object instanceof IndexedElement)) {
            ClassNode classNode;
            String string;
            String string2 = AstUtilities.getClassOrModuleName((IScopingNode)((ClassNode)node2));
            List<ClassNode> list2 = AstUtilities.getClasses(AstUtilities.getRoot(compilationInfo));
            for (int i = list2.size() - 1; i >= 0 && (!(string = AstUtilities.getClassOrModuleName((IScopingNode)(classNode = list2.get(i)))).equals(string2) || (list = AstUtilities.gatherDocumentation(compilationInfo, (BaseDocument)node, (Node)classNode)) == null || list.isEmpty()); --i) {
            }
        } else {
            list = AstUtilities.gatherDocumentation(compilationInfo, (BaseDocument)node, node2);
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public String document(CompilationInfo compilationInfo, ElementHandle elementHandle) {
        Object object;
        Object object2;
        List<String> list;
        RubyElement rubyElement = null;
        if (elementHandle instanceof ElementHandle.UrlHandle) {
            list = ((ElementHandle.UrlHandle)elementHandle).getUrl();
            object2 = new RubyDeclarationFinder().findLinkedMethod(compilationInfo, (String)((Object)list));
            if (object2 != DeclarationFinder.DeclarationLocation.NONE) {
                object = object2.getElement();
                if (elementHandle != null && (rubyElement = RubyParser.resolveHandle(compilationInfo, (ElementHandle)object)) == null) {
                    return null;
                }
            }
        } else {
            rubyElement = RubyParser.resolveHandle(compilationInfo, elementHandle);
        }
        if (rubyElement == null) {
            return null;
        }
        if (rubyElement instanceof KeywordElement) {
            return this.getKeywordHelp(((KeywordElement)rubyElement).getName());
        }
        if (rubyElement instanceof CommentElement) {
            list = rubyElement.getName();
            object2 = new RDocFormatter();
            object = ((String)((Object)list)).split("\n");
            for (String string : object) {
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c == '#') {
                        if (i <= 0) continue;
                        string = string.substring(i);
                        break;
                    }
                    if (!Character.isWhitespace(c)) break;
                }
                ((RDocFormatter)object2).appendLine(string);
            }
            return ((RDocFormatter)object2).toHtml();
        }
        list = this.getComments(compilationInfo, rubyElement);
        if (list == null) {
            if (rubyElement.getName().startsWith("find_by_") || rubyElement.getName().startsWith("find_all_by_")) {
                return new RDocFormatter().getSignature(rubyElement) + NbBundle.getMessage(RubyCodeCompleter.class, (String)"DynamicMethod");
            }
            object2 = new RDocFormatter().getSignature(rubyElement) + "\n<hr>\n<i>" + NbBundle.getMessage(RubyCodeCompleter.class, (String)"NoCommentFound") + "</i>";
            return object2;
        }
        object2 = new RDocFormatter();
        object = rubyElement.getName();
        if (object != null && ((String)object).length() > 0) {
            ((RDocFormatter)object2).setSeqName((String)object);
        }
        for (String string : list) {
            ((RDocFormatter)object2).appendLine(string);
        }
        Object object3 = ((RDocFormatter)object2).toHtml();
        if (!((RDocFormatter)object2).wroteSignature()) {
            object3 = ((RDocFormatter)object2).getSignature(rubyElement) + "\n<hr>\n" + (String)object3;
        }
        return object3;
    }

    public ElementHandle resolveLink(String string, ElementHandle elementHandle) {
        if (string.indexOf(35) != -1 && elementHandle.getMimeType().equals("text/x-ruby")) {
            RubyElement rubyElement;
            if (string.startsWith("#") && (rubyElement = RubyParser.resolveHandle(null, elementHandle)) != null && rubyElement.getKind() != ElementKind.KEYWORD) {
                String string2 = rubyElement.getName();
                ElementKind elementKind = rubyElement.getKind();
                if (elementKind != ElementKind.CLASS && elementKind != ElementKind.MODULE) {
                    int n;
                    String string3 = rubyElement.getIn();
                    if (string3 != null && string3.length() > 0) {
                        string2 = string3;
                    } else if (string2 != null && (n = string2.indexOf(35)) > 0) {
                        string2 = string2.substring(0, n);
                    }
                }
                if (string2 != null) {
                    string = string2 + string;
                }
            }
            return new ElementHandle.UrlHandle(string);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Set<String> getApplicableTemplates(CompilationInfo var1_1, int var2_2, int var3_3) {
        var4_4 = false;
        if (var3_3 != -1) {
            try {
                if (var2_2 == var3_3) {
                    return Collections.emptySet();
                }
                if (var3_3 < var2_2) {
                    var5_5 = var2_2;
                    var2_2 = var3_3;
                    var3_3 = var5_5;
                }
                if ((var5_6 = (BaseDocument)var1_1.getDocument()) == null) {
                    return Collections.emptySet();
                }
                var6_8 = Utilities.isRowEmpty((BaseDocument)var5_6, (int)var2_2);
                var7_9 = Utilities.isRowEmpty((BaseDocument)var5_6, (int)var3_3);
                if (!var6_8 && var2_2 > Utilities.getRowFirstNonWhite((BaseDocument)var5_6, (int)var2_2) || !var7_9 && var3_3 <= Utilities.getRowLastNonWhite((BaseDocument)var5_6, (int)var3_3)) ** GOTO lbl27
                var8_10 = var5_6.getText(var2_2, var3_3 - var2_2);
                for (var9_11 = 0; var9_11 < var8_10.length(); ++var9_11) {
                    if (Character.isWhitespace(var8_10.charAt(var9_11))) continue;
                    var10_12 = LexUtilities.getToken(var5_6, var2_2);
                    if (var10_12 == null || (var11_13 = var10_12.id()) == RubyTokenId.STRING_LITERAL || var11_13 == RubyTokenId.LINE_COMMENT || var11_13 == RubyTokenId.QUOTED_STRING_LITERAL || var11_13 == RubyTokenId.REGEXP_LITERAL || var11_13 == RubyTokenId.DOCUMENTATION) break;
                    var4_4 = true;
                }
            }
            catch (BadLocationException var5_7) {
                Exceptions.printStackTrace((Throwable)var5_7);
            }
        } else {
            var4_4 = true;
        }
lbl27:
        // 6 sources

        if (var4_4) {
            return RubyCodeCompleter.selectionTemplates;
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    private String suggestName(CompilationInfo compilationInfo, int n, String string, Map map) {
        n = AstUtilities.boundCaretOffset(compilationInfo, n);
        Node node = AstUtilities.getRoot(compilationInfo);
        if (node == null) {
            return null;
        }
        AstPath astPath = new AstPath(node, n);
        Node node2 = astPath.leaf();
        if (node2 == null) {
            return null;
        }
        if (string.startsWith("$")) {
            return null;
        }
        if (string.startsWith("@@")) {
            return null;
        }
        if (string.startsWith("@")) {
            return null;
        }
        if (node2 != null) {
            void var12_16;
            Object object;
            Node node3 = AstUtilities.findLocalScope(node2, astPath);
            HashMap<String, Node> hashMap = new HashMap<String, Node>();
            RubyCodeCompleter.addLocals(node3, hashMap);
            List<Node> list = AstUtilities.getApplicableBlocks(astPath, false);
            for (Node stringArray : list) {
                RubyCodeCompleter.addDynamic(stringArray, hashMap);
            }
            String string2 = (String)map.get(ATTR_DEFAULTS);
            if (string2 != null && string2.length() > 0) {
                String[] i = string2.split(",");
                for (String string3 : i) {
                    if (hashMap.containsKey(string3)) continue;
                    return string3;
                }
                object = i;
                int n2 = ((Object)object).length;
                for (int j = 0; j < n2; ++j) {
                    Object object2 = object[j];
                    for (int k = 2; k < 5; ++k) {
                        String string4 = (String)object2 + k;
                        if (string4.length() <= 0 || hashMap.containsKey(string4)) continue;
                        return string4;
                    }
                }
            }
            if (string.length() > 0 && !hashMap.containsKey(string)) {
                return string;
            }
            if (string.length() == 0) {
                string = "var";
            }
            boolean bl = true;
            while (var12_16 < 15) {
                Object object3 = object = var12_16 == true ? string : string + (int)var12_16;
                if (((String)object).length() > 0 && !hashMap.containsKey(object)) {
                    return object;
                }
                ++var12_16;
            }
        }
        return null;
    }

    public String resolveTemplateVariable(String string, CompilationInfo compilationInfo, int n, String string2, Map map) {
        if (string.equals(KEY_PIPE)) {
            return "||";
        }
        if (string.equals(ATTR_UNUSEDLOCAL)) {
            return this.suggestName(compilationInfo, n, string2, map);
        }
        if (map != null && map.containsKey(ATTR_UNUSEDLOCAL)) {
            return this.suggestName(compilationInfo, n, string2, map);
        }
        if (!(string.equals(KEY_METHOD) || string.equals(KEY_METHOD_FQN) || string.equals(KEY_CLASS) || string.equals(KEY_CLASS_FQN) || string.equals(KEY_SUPERCLASS) || string.equals(KEY_PATH) || string.equals(KEY_FILE))) {
            return null;
        }
        n = AstUtilities.boundCaretOffset(compilationInfo, n);
        Node node = AstUtilities.getRoot(compilationInfo);
        if (node == null) {
            return null;
        }
        AstPath astPath = new AstPath(node, n);
        if (string.equals(KEY_METHOD)) {
            MethodDefNode methodDefNode = AstUtilities.findMethod(astPath);
            if (methodDefNode != null) {
                return AstUtilities.getDefName((Node)methodDefNode);
            }
        } else if (string.equals(KEY_METHOD_FQN)) {
            MethodDefNode methodDefNode = AstUtilities.findMethod(astPath);
            if (methodDefNode != null) {
                String string3 = AstUtilities.getFqnName(astPath);
                String string4 = AstUtilities.getDefName((Node)methodDefNode);
                if (string3 != null && string3.length() > 0) {
                    return string3 + "#" + string4;
                }
                return string4;
            }
        } else if (string.equals(KEY_CLASS)) {
            ClassNode classNode = AstUtilities.findClass(astPath);
            if (classNode != null) {
                return classNode.getCPath().getName();
            }
        } else if (string.equals(KEY_SUPERCLASS)) {
            ClassNode classNode = AstUtilities.findClass(astPath);
            if (classNode != null) {
                Object object;
                IndexedClass indexedClass;
                Index index = compilationInfo.getIndex("text/x-ruby");
                if (index != null && (indexedClass = ((RubyIndex)(object = RubyIndex.get(index, compilationInfo.getFileObject()))).getSuperclass(AstUtilities.getFqnName(astPath))) != null) {
                    return indexedClass.getFqn();
                }
                object = AstUtilities.getSuperclass(classNode);
                if (object != null) {
                    return object;
                }
                return "Object";
            }
        } else {
            if (string.equals(KEY_CLASS_FQN)) {
                return AstUtilities.getFqnName(astPath);
            }
            if (string.equals(KEY_FILE)) {
                return FileUtil.toFile((FileObject)compilationInfo.getFileObject()).getName();
            }
            if (string.equals(KEY_PATH)) {
                return FileUtil.toFile((FileObject)compilationInfo.getFileObject()).getPath();
            }
        }
        return null;
    }

    public ParameterInfo parameters(CompilationInfo compilationInfo, int n, CompletionProposal completionProposal) {
        IndexedMethod[] indexedMethodArray = new IndexedMethod[1];
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n2 = AstUtilities.getAstOffset(compilationInfo, n);
        if (!RubyCodeCompleter.computeMethodCall(compilationInfo, n, n2, indexedMethodArray, nArray, nArray2, null, NameKind.PREFIX)) {
            return ParameterInfo.NONE;
        }
        IndexedMethod indexedMethod = indexedMethodArray[0];
        if (indexedMethod == null) {
            return ParameterInfo.NONE;
        }
        int n3 = nArray[0];
        int n4 = nArray2[0];
        int n5 = LexUtilities.getLexerOffset(compilationInfo, n4);
        List<String> list = indexedMethod.getParameters();
        if (list != null && !list.isEmpty()) {
            return new ParameterInfo(list, n3, n5);
        }
        return ParameterInfo.NONE;
    }

    private static boolean forceCompletionSpaces() {
        return FORCE_COMPLETION_SPACES;
    }

    public CodeCompletionHandler.QueryType getAutoQuery(JTextComponent jTextComponent, String string) {
        char c = string.charAt(0);
        if (c == '\n' || c == '(' || c == '[' || c == '{') {
            return CodeCompletionHandler.QueryType.STOP;
        }
        if (c != '.' && c != ':') {
            return CodeCompletionHandler.QueryType.NONE;
        }
        int n = jTextComponent.getCaretPosition();
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        if (".".equals(string)) {
            TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
            if (tokenSequence == null) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            tokenSequence.move(n);
            if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            if (tokenSequence.offset() == n && !tokenSequence.movePrevious()) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            Token token = tokenSequence.token();
            TokenId tokenId = token.id();
            if (tokenId == RubyTokenId.RANGE) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            if ("comment".equals(tokenId.primaryCategory()) || "string".equals(tokenId.primaryCategory()) || "regexp".equals(tokenId.primaryCategory())) {
                return CodeCompletionHandler.QueryType.NONE;
            }
            return CodeCompletionHandler.QueryType.COMPLETION;
        }
        if (":".equals(string)) {
            int n2 = jTextComponent.getSelectionStart();
            try {
                if (n2 > 1 && jTextComponent.getText(n2 - 2, 1).charAt(0) == ':' && RubyCodeCompleter.isRubyContext(baseDocument, n2 - 1)) {
                    return CodeCompletionHandler.QueryType.COMPLETION;
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return CodeCompletionHandler.QueryType.NONE;
    }

    public static boolean isRubyContext(BaseDocument baseDocument, int n) {
        TokenSequence<? extends RubyTokenId> tokenSequence = LexUtilities.getRubyTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return false;
        }
        tokenSequence.move(n);
        if (!tokenSequence.movePrevious() && !tokenSequence.moveNext()) {
            return true;
        }
        TokenId tokenId = tokenSequence.token().id();
        return !"comment".equals(tokenId.primaryCategory()) && !"string".equals(tokenId.primaryCategory()) && !"regexp".equals(tokenId.primaryCategory());
    }

    static {
        selectionTemplates = new HashSet<String>();
        selectionTemplates.add("begin");
        selectionTemplates.add("do");
        selectionTemplates.add("doc");
        selectionTemplates.add("if");
        selectionTemplates.add("ife");
        callLineStart = -1;
        FORCE_COMPLETION_SPACES = Boolean.getBoolean("ruby.complete.spaces");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DbItem
    extends RubyCompletionItem {
        private final String name;
        private final String type;

        DbItem(String string, String string2, int n, CompletionRequest completionRequest) {
            super(null, n, completionRequest);
            this.name = string;
            this.type = string2;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.emphasis(true);
            htmlFormatter.name(ElementKind.DB, true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(ElementKind.DB, false);
            htmlFormatter.emphasis(false);
            return htmlFormatter.getText();
        }

        @Override
        public String getInsertPrefix() {
            return this.name;
        }

        @Override
        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(this.type);
            return htmlFormatter.getText();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.DB;
        }

        @Override
        public ImageIcon getIcon() {
            return null;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isSmart() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallItem
    extends MethodItem {
        private final IndexedMethod method;
        private final int index;

        CallItem(IndexedMethod indexedMethod, int n, int n2, CompletionRequest completionRequest) {
            super(indexedMethod, n2, completionRequest);
            this.method = indexedMethod;
            this.index = n;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CALL;
        }

        @Override
        public String getInsertPrefix() {
            return "";
        }

        @Override
        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            ElementKind elementKind = this.getKind();
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.getName());
            List<String> list = this.method.getParameters();
            if (list != null && !list.isEmpty()) {
                htmlFormatter.appendHtml("(");
                if (this.index > 0 && this.index < list.size()) {
                    htmlFormatter.appendText("... , ");
                }
                htmlFormatter.active(true);
                htmlFormatter.appendText(list.get(Math.min(list.size() - 1, this.index)));
                htmlFormatter.active(false);
                if (this.index < list.size() - 1) {
                    htmlFormatter.appendText(", ...");
                }
                htmlFormatter.appendHtml(")");
            }
            if (this.method.hasBlock() && !this.method.isBlockOptional()) {
                htmlFormatter.appendText(" { }");
            }
            htmlFormatter.name(elementKind, false);
            return htmlFormatter.getText();
        }

        public boolean isSmart() {
            return true;
        }

        public List<String> getInsertParams() {
            return null;
        }

        @Override
        public String getCustomInsertTemplate() {
            return null;
        }
    }

    private class ParameterItem
    extends RubyCompletionItem {
        private static final String CONSTANT_ICON = "org/netbeans/modules/ruby/symbol.png";
        private final String name;
        private final String desc;
        private final String insert;

        ParameterItem(IndexedMethod indexedMethod, String string, String string2, String string3, int n, CompletionRequest completionRequest) {
            super(indexedMethod, n, completionRequest);
            this.name = string;
            this.desc = string2;
            this.insert = string3;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            if (this.desc != null) {
                htmlFormatter.appendText(this.desc);
                return htmlFormatter.getText();
            }
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.PARAMETER;
        }

        public ImageIcon getIcon() {
            if (symbolIcon == null) {
                symbolIcon = new ImageIcon(ImageUtilities.loadImage((String)CONSTANT_ICON));
            }
            return symbolIcon;
        }

        public String getName() {
            return this.name;
        }

        public String getInsertPrefix() {
            return this.insert;
        }
    }

    private class FieldItem
    extends RubyCompletionItem {
        FieldItem(Element element, int n, CompletionRequest completionRequest) {
            super(element, n, completionRequest);
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            if (this.element instanceof IndexedField) {
                boolean bl;
                IndexedField indexedField = (IndexedField)this.element;
                boolean bl2 = bl = !indexedField.isInherited();
                if (bl) {
                    htmlFormatter.emphasis(true);
                }
                htmlFormatter.name(ElementKind.FIELD, true);
                htmlFormatter.appendText(this.getName());
                htmlFormatter.name(ElementKind.FIELD, false);
                if (bl) {
                    htmlFormatter.emphasis(false);
                }
                return htmlFormatter.getText();
            }
            return super.getLhsHtml(htmlFormatter);
        }

        public String getInsertPrefix() {
            String string = this.element.getModifiers().contains(Modifier.STATIC) ? "@@" + this.getName() : "@" + this.getName();
            if (this.symbol) {
                string = ":" + string;
            }
            return string;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            IndexedField indexedField;
            String string;
            if (this.element instanceof IndexedField && (string = (indexedField = (IndexedField)this.element).getIn()) != null) {
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
            return null;
        }
    }

    private class ClassItem
    extends RubyCompletionItem {
        ClassItem(Element element, int n, CompletionRequest completionRequest) {
            super(element, n, completionRequest);
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            String string = ((ClassElement)this.element).getIn();
            if (string == null) {
                return null;
            }
            htmlFormatter.appendText(string);
            return htmlFormatter.getText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeywordItem
    extends RubyCompletionItem {
        private static final String RUBY_KEYWORD = "org/netbeans/modules/ruby/jruby.png";
        private final String keyword;
        private final String description;

        KeywordItem(String string, String string2, int n, CompletionRequest completionRequest) {
            super(null, n, completionRequest);
            this.keyword = string;
            this.description = string2;
        }

        @Override
        public String getName() {
            return this.keyword;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        @Override
        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            return null;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            ElementKind elementKind = this.getKind();
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.keyword);
            htmlFormatter.appendText(" ");
            htmlFormatter.name(elementKind, false);
            if (this.description != null) {
                htmlFormatter.appendHtml(this.description);
            }
            return htmlFormatter.getText();
        }

        @Override
        public ImageIcon getIcon() {
            if (keywordIcon == null) {
                keywordIcon = new ImageIcon(ImageUtilities.loadImage((String)RUBY_KEYWORD));
            }
            return keywordIcon;
        }

        @Override
        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        @Override
        public ElementHandle getElement() {
            return new KeywordElement(this.keyword);
        }
    }

    private class MethodItem
    extends RubyCompletionItem {
        private final IndexedMethod method;

        MethodItem(IndexedMethod indexedMethod, int n, CompletionRequest completionRequest) {
            super(indexedMethod, n, completionRequest);
            this.method = indexedMethod;
        }

        public String getLhsHtml(HtmlFormatter htmlFormatter) {
            List<String> list;
            boolean bl;
            ElementKind elementKind = this.getKind();
            boolean bl2 = bl = !this.method.isInherited();
            if (bl) {
                htmlFormatter.emphasis(true);
            }
            htmlFormatter.name(elementKind, true);
            htmlFormatter.appendText(this.getName());
            htmlFormatter.name(elementKind, false);
            if (bl) {
                htmlFormatter.emphasis(false);
            }
            if ((list = this.method.getParameters()) != null && !list.isEmpty()) {
                htmlFormatter.appendHtml("(");
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    htmlFormatter.parameters(true);
                    htmlFormatter.appendText((String)iterator.next());
                    htmlFormatter.parameters(false);
                    if (!iterator.hasNext()) continue;
                    htmlFormatter.appendText(", ");
                }
                htmlFormatter.appendHtml(")");
            }
            if (this.method.hasBlock() && !this.method.isBlockOptional()) {
                htmlFormatter.appendText(" { }");
            }
            return htmlFormatter.getText();
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            if (this.method.isTopLevel() && this.method.getRequire() != null) {
                htmlFormatter.appendText(this.method.getRequire());
                return htmlFormatter.getText();
            }
            String string = this.method.getIn();
            if (string != null) {
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
            return null;
        }

        public String getCustomInsertTemplate() {
            String string;
            Object object;
            String string2;
            String string3;
            boolean bl;
            int n;
            String string4 = this.getInsertPrefix();
            List<String> list = this.method.getParameters();
            boolean bl2 = false;
            int n2 = n = list.size();
            boolean bl3 = bl = this.method.getEncodedAttributes() != null && this.method.getEncodedAttributes().indexOf("=>") != -1;
            if (n > 0 && list.get(n - 1).startsWith("&")) {
                bl2 = true;
                --n2;
                string3 = "(";
                string2 = ")";
            } else if (this.method.hasBlock()) {
                bl2 = true;
                if (n > 0) {
                    string3 = "(";
                    string2 = ")";
                } else {
                    string3 = "";
                    string2 = "";
                }
            } else {
                object = this.getParamListDelimiters();
                assert (((String[])object).length == 2);
                string3 = object[0];
                string2 = object[1];
                if (n2 == 0) {
                    string3 = "";
                    string2 = "";
                }
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(string4);
            if (bl) {
                ((StringBuilder)object).append(" ");
                return ((StringBuilder)object).toString();
            }
            ((StringBuilder)object).append(string3);
            int n3 = 1;
            for (int i = 0; i < n2; ++i) {
                string = list.get(i);
                ((StringBuilder)object).append("${");
                ((StringBuilder)object).append("ruby-cc-");
                ((StringBuilder)object).append(Integer.toString(n3++));
                ((StringBuilder)object).append(" default=\"");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append("\"");
                ((StringBuilder)object).append("}");
                if (i >= n2 - 1) continue;
                ((StringBuilder)object).append(", ");
            }
            ((StringBuilder)object).append(string2);
            if (bl2) {
                int n4;
                String[] stringArray = null;
                string = this.method.getEncodedAttributes();
                int n5 = string.indexOf(59);
                if (n5 != -1 && (n4 = string.indexOf(59, n5 + 1)) != -1) {
                    stringArray = string.substring(n5 + 1, n4).split(",");
                }
                ((StringBuilder)object).append(" { |");
                if (stringArray != null && stringArray.length > 0) {
                    for (n4 = 0; n4 < stringArray.length; ++n4) {
                        if (n4 > 0) {
                            ((StringBuilder)object).append(",");
                        }
                        String string5 = stringArray[n4];
                        ((StringBuilder)object).append("${unusedlocal defaults=\"");
                        ((StringBuilder)object).append(string5);
                        ((StringBuilder)object).append("\"}");
                    }
                } else {
                    ((StringBuilder)object).append("${unusedlocal defaults=\"i,e\"}");
                }
                ((StringBuilder)object).append("| ${");
                ((StringBuilder)object).append("ruby-cc-");
                ((StringBuilder)object).append(Integer.toString(n3++));
                ((StringBuilder)object).append(" default=\"\"} }${cursor}");
            } else {
                ((StringBuilder)object).append("${cursor}");
            }
            try {
                callLineStart = Utilities.getRowStart((BaseDocument)this.request.doc, (int)this.anchorOffset);
                callMethod = this.method;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            return ((StringBuilder)object).toString();
        }

        public String[] getParamListDelimiters() {
            List list;
            String string = this.getName();
            String string2 = this.element.getIn();
            if ("Module".equals(string2)) {
                if (string.startsWith("attr_")) {
                    return new String[]{" :", " "};
                }
                if (string.equals("include") || string.equals("import")) {
                    return new String[]{" ", " "};
                }
                if (string.equals("include_package")) {
                    return new String[]{" '", "'"};
                }
            } else if ("Kernel".equals(string2)) {
                if (string.equals(RubyCodeCompleter.KEY_REQUIRE)) {
                    return new String[]{" '", "'"};
                }
                if (string.equals("p")) {
                    return new String[]{" ", " "};
                }
            } else if ("Object".equals(string2) && string.equals("include_class")) {
                return new String[]{" '", "'"};
            }
            if (RubyCodeCompleter.forceCompletionSpaces()) {
                boolean bl = false;
                AstPath astPath = this.request.path;
                if (astPath != null) {
                    ListIterator<Node> listIterator = astPath.leafToRoot();
                    while (listIterator.hasNext()) {
                        Node node = (Node)listIterator.next();
                        if (!AstUtilities.isCall(node) || node == this.request.node) continue;
                        bl = true;
                        break;
                    }
                }
                if (bl) {
                    return new String[]{"(", ")"};
                }
                return new String[]{" ", " "};
            }
            if (this.element instanceof IndexedElement && (list = RubyCodeCompleter.this.getComments(null, this.element)) != null && !list.isEmpty()) {
                String string3 = this.getName();
                boolean bl = false;
                boolean bl2 = false;
                for (String string4 : list) {
                    int n;
                    if (!string4.startsWith("#  ")) continue;
                    int n2 = 0;
                    int n3 = string4.length();
                    while ((n = string4.indexOf(string3, n2)) != -1) {
                        n2 = n += string3.length();
                        if (n >= n3) continue;
                        char c = string4.charAt(n);
                        if (c == ' ') {
                            bl = true;
                            continue;
                        }
                        if (c != '(') continue;
                        bl2 = true;
                    }
                }
                if (!bl2 && bl) {
                    return new String[]{" ", " "};
                }
            }
            return super.getParamListDelimiters();
        }

        public ElementKind getKind() {
            if (this.method.getMethodType() == IndexedMethod.MethodType.ATTRIBUTE) {
                return ElementKind.ATTRIBUTE;
            }
            return this.element.getKind();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RubyCompletionItem
    extends DefaultCompletionProposal {
        protected CompletionRequest request;
        protected Element element;
        protected boolean symbol;

        private RubyCompletionItem(Element element, int n, CompletionRequest completionRequest) {
            this.element = element;
            this.anchorOffset = n;
            this.request = completionRequest;
        }

        public String getName() {
            return this.element.getName();
        }

        public void setSymbol(boolean bl) {
            this.symbol = bl;
        }

        public String getInsertPrefix() {
            if (this.symbol) {
                return ":" + this.getName();
            }
            return this.getName();
        }

        public ElementHandle getElement() {
            return this.element;
        }

        public ElementKind getKind() {
            return this.element.getKind();
        }

        public ImageIcon getIcon() {
            return null;
        }

        public String getRhsHtml(HtmlFormatter htmlFormatter) {
            IndexedVariable indexedVariable;
            String string;
            if (this.element.getKind() == ElementKind.GLOBAL && this.element instanceof IndexedVariable && (string = (indexedVariable = (IndexedVariable)this.element).getIn()) != null) {
                htmlFormatter.appendText(string);
                return htmlFormatter.getText();
            }
            return null;
        }

        public Set<Modifier> getModifiers() {
            return this.element.getModifiers();
        }

        public String toString() {
            String string = ((Object)((Object)this)).getClass().getName();
            string = string.substring(string.lastIndexOf(46) + 1);
            return string + "(" + this.getKind() + "): " + this.getName();
        }

        public String[] getParamListDelimiters() {
            return new String[]{"(", ")"};
        }
    }

    private static class CompletionRequest {
        private DefaultCompletionResult completionResult;
        private TokenHierarchy<Document> th;
        private CompilationInfo info;
        private AstPath path;
        private Node node;
        private int lexOffset;
        private int astOffset;
        private BaseDocument doc;
        private String prefix;
        private RubyIndex index;
        private NameKind kind;
        private CodeCompletionHandler.QueryType queryType;
        private FileObject fileObject;

        private CompletionRequest() {
        }
    }
}

