/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.category;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.modules.xml.xam.ui.category.AbstractCategoryPane;
import org.netbeans.modules.xml.xam.ui.category.Category;
import org.netbeans.modules.xml.xam.ui.category.CategoryPane;
import org.netbeans.modules.xml.xam.ui.category.SearchComponent;
import org.netbeans.modules.xml.xam.ui.search.DefaultSearchControlPanel;

public class DefaultCategoryPane
extends AbstractCategoryPane {
    private JPanel visualComponent;
    private DefaultSearchControlPanel searchComponent;
    private JPanel categoryPanel;
    private List<ShowCategoryAction> categoryActions = new ArrayList<ShowCategoryAction>();
    private ButtonGroup buttonGroup;

    public DefaultCategoryPane() {
        this.initComponents();
    }

    public void addCategory(Category category) {
        this.categoryActions.add(new ShowCategoryAction(category, this));
    }

    public Component getComponent() {
        return this.visualComponent;
    }

    public SearchComponent getSearchComponent() {
        return this.searchComponent;
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.visualComponent = new JPanel(new GridBagLayout()){
            private static final long serialVersionUID = 1L;

            public void requestFocus() {
                super.requestFocus();
                Category category = DefaultCategoryPane.this.getCategory();
                if (category != null) {
                    category.getComponent().requestFocus();
                }
            }

            public boolean requestFocusInWindow() {
                boolean bl = super.requestFocusInWindow();
                Category category = DefaultCategoryPane.this.getCategory();
                if (category != null) {
                    return category.getComponent().requestFocusInWindow();
                }
                return bl;
            }
        };
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.categoryPanel = new JPanel(new BorderLayout());
        this.visualComponent.add((Component)this.categoryPanel, gridBagConstraints);
        this.searchComponent = new DefaultSearchControlPanel(this);
        this.searchComponent.hideComponent();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.visualComponent.add(this.searchComponent.getComponent(), gridBagConstraints);
    }

    public void populateToolbar(JToolBar jToolBar) {
        Category category = this.getCategory();
        Border border = UIManager.getBorder("nb.tabbutton.border");
        for (ShowCategoryAction showCategoryAction : this.categoryActions) {
            JToggleButton jToggleButton = new JToggleButton(showCategoryAction);
            jToggleButton.setText(null);
            jToggleButton.getAccessibleContext().setAccessibleName(showCategoryAction.getCategory().getTitle());
            jToggleButton.setRolloverEnabled(true);
            if (border != null) {
                jToggleButton.setBorder(border);
            }
            this.buttonGroup.add(jToggleButton);
            if (category == null) {
                if (this.buttonGroup.getButtonCount() == 1) {
                    jToggleButton.setSelected(true);
                    showCategoryAction.actionPerformed(null);
                }
            } else if (showCategoryAction.getCategory().equals(category)) {
                jToggleButton.setSelected(true);
            }
            jToolBar.add(jToggleButton);
        }
    }

    public void setCategory(Category category) {
        Component component;
        Category category2 = this.getCategory();
        super.setCategory(category);
        if (category2 != null) {
            component = category2.getComponent();
            this.categoryPanel.remove(component);
            category2.componentHidden();
        }
        component = category.getComponent();
        this.categoryPanel.add(component, "Center");
        category.componentShown();
        this.categoryPanel.validate();
        this.categoryPanel.repaint();
        this.searchComponent.updateSearchProviders();
    }

    public void close() {
        this.visualComponent.removeAll();
        this.categoryPanel.removeAll();
        this.categoryActions.clear();
        this.visualComponent = null;
        this.categoryPanel = null;
        this.categoryActions = null;
    }

    private static class ShowCategoryAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private transient Category category;
        private transient CategoryPane pane;

        public ShowCategoryAction(Category category, CategoryPane categoryPane) {
            this.category = category;
            this.pane = categoryPane;
            this.putValue("Name", category.getTitle());
            this.putValue("ShortDescription", category.getDescription());
            this.putValue("SmallIcon", category.getIcon());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.pane.setCategory(this.category);
        }

        public Category getCategory() {
            return this.category;
        }
    }
}

