/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.GridGraphLayout;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.cnd.callgraph.api.Call;
import org.netbeans.modules.cnd.callgraph.api.CallModel;
import org.netbeans.modules.cnd.callgraph.api.Function;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphScene;
import org.netbeans.modules.cnd.callgraph.impl.CallGraphState;
import org.netbeans.modules.cnd.callgraph.impl.CallNode;
import org.netbeans.modules.cnd.callgraph.impl.ExportAction;
import org.netbeans.modules.cnd.callgraph.impl.FunctionRootNode;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.ListView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class CallGraphPanel
extends JPanel
implements ExplorerManager.Provider,
HelpCtx.Provider {
    private ExplorerManager explorerManager = new ExplorerManager();
    private AbstractNode root;
    private Action[] actions;
    private CallModel model;
    private boolean showGraph;
    private boolean isCalls;
    public static final String IS_CALLS = "CallGraphIsCalls";
    private CallGraphScene scene;
    private static double dividerLocation = 0.5;
    private JToggleButton callers;
    private JToggleButton calls;
    private JPanel contextPanel;
    private JButton focusOn;
    private JScrollPane graphView;
    private JToolBar.Separator jSeparator1;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JToolBar jToolBar1;
    private JButton refresh;
    private JScrollPane treeView;

    public CallGraphPanel(boolean bl) {
        this.initComponents();
        this.isCalls = NbPreferences.forModule(CallGraphPanel.class).getBoolean(IS_CALLS, true);
        this.getTreeView().setRootVisible(false);
        Children.SortedArray sortedArray = new Children.SortedArray();
        this.showGraph = bl;
        if (bl) {
            this.scene = new CallGraphScene();
            this.actions = new Action[]{new RefreshAction(), new FocusOnAction(), null, new WhoIsCalledAction(), new WhoCallsAction(), null, new ExportAction((Scene)this.scene, this)};
            this.scene.setExportAction(this.actions[this.actions.length - 1]);
        } else {
            this.actions = new Action[]{new RefreshAction(), new FocusOnAction(), null, new WhoIsCalledAction(), new WhoCallsAction()};
        }
        this.root = new AbstractNode((Children)sortedArray){

            public Action[] getActions(boolean bl) {
                return CallGraphPanel.this.actions;
            }
        };
        this.getExplorerManager().setRootContext((Node)this.root);
        if (bl) {
            this.addComponentListener(new ComponentListener(){

                public void componentResized(ComponentEvent componentEvent) {
                    CallGraphPanel.this.jSplitPane1.setDividerLocation(dividerLocation);
                }

                public void componentMoved(ComponentEvent componentEvent) {
                }

                public void componentShown(ComponentEvent componentEvent) {
                }

                public void componentHidden(ComponentEvent componentEvent) {
                }
            });
            this.jSplitPane1.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("dividerLocation".equals(propertyChangeEvent.getPropertyName())) {
                        dividerLocation = (double)CallGraphPanel.this.jSplitPane1.getDividerLocation() / (double)(CallGraphPanel.this.jSplitPane1.getWidth() - CallGraphPanel.this.jSplitPane1.getDividerSize());
                    }
                }
            });
            this.initGraph();
        } else {
            Component component = this.jSplitPane1.getLeftComponent();
            this.remove(this.jSplitPane1);
            this.jSplitPane1.remove(component);
            this.add(component, "Center");
        }
        this.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Node[] nodeArray = CallGraphPanel.this.getExplorerManager().getSelectedNodes();
                if (nodeArray.length == 1) {
                    Node node = nodeArray[0];
                    if (node instanceof CallNode) {
                        CallGraphPanel.this.getContextPanel().setRootContent((CallNode)node);
                    } else {
                        CallGraphPanel.this.getContextPanel().setRootContent(null);
                    }
                }
            }
        });
    }

    private void initGraph() {
        JComponent jComponent = this.scene.createView();
        this.graphView.setViewportView(jComponent);
        jComponent.setFocusable(this.isCalls);
        GridGraphLayout gridGraphLayout = new GridGraphLayout();
        SceneLayout sceneLayout = LayoutFactory.createSceneGraphLayout((GraphScene)this.scene, (GraphLayout)gridGraphLayout);
        this.scene.setLayout(sceneLayout);
        sceneLayout.invokeLayout();
        this.graphView.setFocusable(false);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.refresh = new JButton();
        this.focusOn = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.calls = new JToggleButton();
        this.callers = new JToggleButton();
        this.jSplitPane1 = new JSplitPane();
        this.graphView = new JScrollPane();
        this.jSplitPane2 = new JSplitPane();
        this.treeView = new BeanTreeView();
        this.contextPanel = new ContextPanel();
        this.setLayout(new BorderLayout());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setOrientation(1);
        this.jToolBar1.setRollover(true);
        this.refresh.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/refresh.png")));
        this.refresh.setToolTipText(NbBundle.getMessage(CallGraphPanel.class, (String)"RefreshActionTooltip"));
        this.refresh.setFocusable(false);
        this.refresh.setHorizontalTextPosition(0);
        this.refresh.setVerticalTextPosition(3);
        this.refresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphPanel.this.refreshActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.refresh);
        this.focusOn.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/focus.png")));
        this.focusOn.setToolTipText(NbBundle.getMessage(CallGraphPanel.class, (String)"FocusOnActionTooltip"));
        this.focusOn.setFocusable(false);
        this.focusOn.setHorizontalTextPosition(0);
        this.focusOn.setMaximumSize(new Dimension(28, 28));
        this.focusOn.setMinimumSize(new Dimension(28, 28));
        this.focusOn.setPreferredSize(new Dimension(28, 28));
        this.focusOn.setVerticalTextPosition(3);
        this.focusOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphPanel.this.focusOnActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.focusOn);
        this.jToolBar1.add(this.jSeparator1);
        this.calls.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/who_is_called.png")));
        this.calls.setToolTipText(NbBundle.getMessage(CallGraphPanel.class, (String)"CallsActionTooltip"));
        this.calls.setFocusable(false);
        this.calls.setHorizontalTextPosition(0);
        this.calls.setVerticalTextPosition(3);
        this.calls.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphPanel.this.callsActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.calls);
        this.callers.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/cnd/callgraph/resources/who_calls.png")));
        this.callers.setToolTipText(NbBundle.getMessage(CallGraphPanel.class, (String)"CallersActionTooltip"));
        this.callers.setFocusable(false);
        this.callers.setHorizontalTextPosition(0);
        this.callers.setVerticalTextPosition(3);
        this.callers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CallGraphPanel.this.callersActionPerformed(actionEvent);
            }
        });
        this.jToolBar1.add(this.callers);
        this.add((Component)this.jToolBar1, "Before");
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jSplitPane1.setFocusable(false);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.graphView.setFocusable(false);
        this.jSplitPane1.setRightComponent(this.graphView);
        this.jSplitPane2.setOrientation(0);
        this.jSplitPane2.setResizeWeight(1.0);
        this.jSplitPane2.setFocusable(false);
        this.treeView.setFocusable(false);
        this.jSplitPane2.setLeftComponent(this.treeView);
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_TreeView_AN"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_TreeView_AD"));
        this.contextPanel.setFocusable(false);
        this.jSplitPane2.setRightComponent(this.contextPanel);
        this.contextPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_ListView_AM"));
        this.contextPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_ListView_AD"));
        this.jSplitPane1.setLeftComponent(this.jSplitPane2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void refreshActionPerformed(ActionEvent actionEvent) {
        this.update();
    }

    private void callsActionPerformed(ActionEvent actionEvent) {
        if (this.isCalls == this.calls.isSelected()) {
            return;
        }
        this.setDirection(true);
    }

    private void callersActionPerformed(ActionEvent actionEvent) {
        if (this.isCalls != this.callers.isSelected()) {
            return;
        }
        this.setDirection(false);
    }

    private void focusOnActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.getExplorerManager().getSelectedNodes();
        if (nodeArray == null || nodeArray.length != 1) {
            return;
        }
        Node node = nodeArray[0];
        if (node instanceof FunctionRootNode) {
            this.update();
        } else if (node instanceof CallNode) {
            Call call = ((CallNode)node).getCall();
            if (this.isCalls) {
                this.model.setRoot(call.getCallee());
            } else {
                this.model.setRoot(call.getCaller());
            }
            this.setName(this.model.getName());
            this.setToolTipText(this.getName() + " - " + NbBundle.getMessage(this.getClass(), (String)"CTL_CallGraphTopComponent"));
            Container container = this.getParent();
            while (container != null) {
                if (container instanceof JTabbedPane) {
                    int n = ((JTabbedPane)container).getSelectedIndex();
                    if (n < 0) break;
                    ((JTabbedPane)container).setTitleAt(n, this.getName() + "  ");
                    break;
                }
                if (!(container instanceof TopComponent)) continue;
                ((TopComponent)container).setName(this.getToolTipText());
                break;
            }
            this.update();
        }
    }

    private void setDirection(boolean bl) {
        this.isCalls = bl;
        NbPreferences.forModule(CallGraphPanel.class).putBoolean(IS_CALLS, this.isCalls);
        this.updateButtons();
        this.update();
    }

    private void updateButtons() {
        this.calls.setSelected(this.isCalls);
        this.callers.setSelected(!this.isCalls);
    }

    public void setModel(CallModel callModel) {
        this.model = callModel;
        if (this.showGraph) {
            this.scene.setModel(callModel);
        }
        this.updateButtons();
        this.update();
    }

    private synchronized void update() {
        Function function;
        if (this.showGraph) {
            this.scene.clean();
        }
        if ((function = this.model.getRoot()) != null) {
            final Children children = this.root.getChildren();
            if (!Children.MUTEX.isReadAccess()) {
                Children.MUTEX.writeAccess(new Runnable(){

                    public void run() {
                        children.remove(children.getNodes());
                        CallGraphState callGraphState = new CallGraphState(CallGraphPanel.this.model, CallGraphPanel.this.scene, CallGraphPanel.this.actions);
                        FunctionRootNode functionRootNode = new FunctionRootNode(function, callGraphState, CallGraphPanel.this.isCalls);
                        children.add(new Node[]{functionRootNode});
                        try {
                            CallGraphPanel.this.getExplorerManager().setSelectedNodes(new Node[]{functionRootNode});
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable((Node)functionRootNode){
                            final /* synthetic */ Node val$node;
                            {
                                this.val$node = node;
                            }

                            public void run() {
                                CallGraphPanel.this.getTreeView().expandNode(this.val$node);
                            }
                        });
                    }
                });
            }
        } else {
            final Children children = this.root.getChildren();
            if (!Children.MUTEX.isReadAccess()) {
                Children.MUTEX.writeAccess(new Runnable(){

                    public void run() {
                        children.remove(children.getNodes());
                    }
                });
            }
        }
    }

    public void requestFocus() {
        super.requestFocus();
        this.treeView.requestFocus();
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.treeView.requestFocusInWindow();
    }

    public BeanTreeView getTreeView() {
        return (BeanTreeView)this.treeView;
    }

    private ContextPanel getContextPanel() {
        return (ContextPanel)this.contextPanel;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("CallGraphView");
    }

    private static final class ContextPanel
    extends JPanel
    implements ExplorerManager.Provider {
        private ExplorerManager managerCtx = new ExplorerManager();
        private ListView listView = new ListView();

        private ContextPanel() {
            this.listView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_ListView_AM"));
            this.listView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CallGraphPanel.class, (String)"CGP_ListView_AD"));
            this.setLayout(new BorderLayout());
            this.add((Component)this.listView, "Center");
            this.listView.setFocusable(false);
        }

        public ExplorerManager getExplorerManager() {
            return this.managerCtx;
        }

        public boolean requestFocusInWindow() {
            super.requestFocusInWindow();
            return this.listView.requestFocusInWindow();
        }

        private void setRootContent(CallNode callNode) {
            Object object;
            List list;
            if (callNode == null) {
                list = Collections.emptyList();
            } else {
                list = new ArrayList(1);
                object = callNode.getCall();
                list.add(new CallContext((Call)object));
            }
            object = new CallContextRoot(new ContextList(list));
            this.getExplorerManager().setRootContext((Node)object);
        }

        public static class CallContext
        extends AbstractNode {
            private Call call;

            public CallContext(Call call) {
                super(Children.LEAF);
                this.call = call;
            }

            public String getHtmlDisplayName() {
                if (this.call != null) {
                    return this.call.getHtmlDisplayName();
                }
                return super.getHtmlDisplayName();
            }

            public Action getPreferredAction() {
                return null;
            }

            public Action[] getActions(boolean bl) {
                return new Action[0];
            }
        }

        private static final class CallContextRoot
        extends AbstractNode {
            public CallContextRoot(Children.Array array) {
                super((Children)array);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static final class ContextList
        extends Children.Array {
            private ContextList(Collection<Node> collection) {
                super(collection);
            }
        }
    }

    private final class FocusOnAction
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;

        public FocusOnAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphPanel.class, (String)"FocusOnAction"));
            this.putValue("SmallIcon", CallGraphPanel.this.focusOn.getIcon());
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CallGraphPanel.this.focusOnActionPerformed(actionEvent);
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }

    private final class WhoIsCalledAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public WhoIsCalledAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphPanel.class, (String)"CallsAction"));
            this.putValue("SmallIcon", CallGraphPanel.this.calls.getIcon());
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CallGraphPanel.this.setDirection(true);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(CallGraphPanel.this.isCalls);
            return this.menuItem;
        }
    }

    private final class WhoCallsAction
    extends AbstractAction
    implements Presenter.Popup {
        private JRadioButtonMenuItem menuItem;

        public WhoCallsAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphPanel.class, (String)"CallersAction"));
            this.putValue("SmallIcon", CallGraphPanel.this.callers.getIcon());
            this.menuItem = new JRadioButtonMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CallGraphPanel.this.setDirection(false);
        }

        public final JMenuItem getPopupPresenter() {
            this.menuItem.setSelected(!CallGraphPanel.this.isCalls);
            return this.menuItem;
        }
    }

    private final class RefreshAction
    extends AbstractAction
    implements Presenter.Popup {
        private JMenuItem menuItem;

        public RefreshAction() {
            this.putValue("Name", NbBundle.getMessage(CallGraphPanel.class, (String)"RefreshAction"));
            this.putValue("SmallIcon", CallGraphPanel.this.refresh.getIcon());
            this.menuItem = new JMenuItem(this);
            Mnemonics.setLocalizedText((AbstractButton)this.menuItem, (String)((String)this.getValue("Name")));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CallGraphPanel.this.refreshActionPerformed(actionEvent);
        }

        public final JMenuItem getPopupPresenter() {
            return this.menuItem;
        }
    }
}

