/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.project.ui.BrowseFolders;
import org.netbeans.modules.project.ui.PhysicalView;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class SimpleTargetChooserPanelGUI
extends JPanel
implements ActionListener,
DocumentListener {
    private static final Dimension PREF_DIM = new Dimension(500, 340);
    private static final String NEW_FILE_PREFIX = NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_SimpleTargetChooserPanelGUI_NewFilePrefix");
    private final ListCellRenderer CELL_RENDERER = new GroupCellRenderer();
    private Project project;
    private String expectedExtension;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private SourceGroup[] folders;
    private boolean isFolder;
    private JPanel bottomPanelContainer;
    private JButton browseButton;
    private JTextField documentNameTextField;
    private JTextField fileTextField;
    private JTextField folderTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JComboBox locationComboBox;
    private JLabel locationLabel;
    private JTextField projectTextField;
    private JSeparator targetSeparator;

    public SimpleTargetChooserPanelGUI(Project project, SourceGroup[] sourceGroupArray, Component component, boolean bl) {
        this.project = project;
        this.folders = sourceGroupArray;
        this.isFolder = bl;
        this.initComponents();
        this.locationComboBox.setRenderer(this.CELL_RENDERER);
        if (component != null) {
            this.bottomPanelContainer.add(component, "Center");
        }
        this.initValues(null, null, null);
        this.setPreferredSize(PREF_DIM);
        this.browseButton.addActionListener(this);
        this.locationComboBox.addActionListener(this);
        this.documentNameTextField.getDocument().addDocumentListener(this);
        this.folderTextField.getDocument().addDocumentListener(this);
        this.setName(NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_SimpleTargetChooserPanel_Name"));
    }

    public void initValues(FileObject fileObject, FileObject fileObject2, String string) {
        Object object;
        assert (this.project != null);
        this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
        Sources sources = ProjectUtils.getSources((Project)this.project);
        if (this.folders == null) {
            this.folders = sources.getSourceGroups("generic");
        }
        if (this.folders.length < 2) {
            this.locationLabel.setVisible(false);
            this.locationComboBox.setVisible(false);
        } else {
            this.locationLabel.setVisible(true);
            this.locationComboBox.setVisible(true);
        }
        this.locationComboBox.setModel(new DefaultComboBoxModel<SourceGroup>(this.folders));
        SourceGroup sourceGroup = this.getPreselectedGroup(this.folders, fileObject2);
        this.locationComboBox.setSelectedItem(sourceGroup);
        if (sourceGroup != null) {
            this.folderTextField.setText(this.getRelativeNativeName(sourceGroup.getRootFolder(), fileObject2));
        }
        String string2 = fileObject == null ? "" : fileObject.getExt();
        this.expectedExtension = string2.length() == 0 ? "" : "." + string2;
        String string3 = null;
        try {
            if (fileObject != null) {
                object = DataObject.find((FileObject)fileObject);
                string3 = object.getNodeDelegate().getDisplayName();
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            string3 = fileObject.getName();
        }
        this.putClientProperty("NewFileWizard_Title", string3);
        if (fileObject != null) {
            object = NEW_FILE_PREFIX + fileObject.getName();
            if (string == null) {
                string = object;
            }
            if (fileObject2 != null) {
                FileObject fileObject3;
                int n = 0;
                while ((fileObject3 = fileObject2.getFileObject(string, fileObject.getExt())) != null) {
                    string = (String)object + ++n;
                }
            }
            this.documentNameTextField.setText(string);
            this.documentNameTextField.selectAll();
        }
        if (this.isFolder) {
            Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_FolderName_Label"));
            Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_ParentFolder_Label"));
            Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_CreatedFolder_Label"));
        } else {
            Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_FileName_Label"));
            Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
            Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_CreatedFile_Label"));
        }
    }

    public SourceGroup getTargetGroup() {
        return (SourceGroup)this.locationComboBox.getSelectedItem();
    }

    public String getTargetFolder() {
        String string = this.folderTextField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string.replace(File.separatorChar, '/');
    }

    public String getTargetName() {
        String string = this.documentNameTextField.getText().trim();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel3 = new JLabel();
        this.documentNameTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.jLabel4 = new JLabel();
        this.fileTextField = new JTextField();
        this.targetSeparator = new JSeparator();
        this.bottomPanelContainer = new JPanel();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.documentNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_FileName_Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        this.jPanel1.add((Component)this.documentNameTextField, gridBagConstraints);
        this.documentNameTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_documentNameTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 24, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jLabel1.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Project_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.projectTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 0);
        this.add((Component)this.projectTextField, gridBagConstraints);
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_projectTextField"));
        this.locationLabel.setLabelFor(this.locationComboBox);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Location_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)this.locationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 6, 5, 0);
        this.add((Component)this.locationComboBox, gridBagConstraints);
        this.locationComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_locationComboBox"));
        this.jLabel2.setLabelFor(this.folderTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Folder_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.folderTextField, gridBagConstraints);
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_folderTextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_Browse_Button"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_browseButton"));
        this.jLabel4.setLabelFor(this.fileTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SimpleTargetChooserPanelGUI.class, (String)"LBL_TargetChooser_CreatedFile_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.fileTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 12, 0);
        this.add((Component)this.fileTextField, gridBagConstraints);
        this.fileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_fileTextField"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 12, 0);
        this.add((Component)this.targetSeparator, gridBagConstraints);
        this.bottomPanelContainer.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.bottomPanelContainer, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SimpleTargetChooserPanelGUI.class).getString("AD_SimpleTargetChooserPanelGUI"));
    }

    private SourceGroup getPreselectedGroup(SourceGroup[] sourceGroupArray, FileObject fileObject) {
        for (int i = 0; fileObject != null && i < sourceGroupArray.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)sourceGroupArray[i].getRootFolder(), (FileObject)fileObject) && !sourceGroupArray[i].getRootFolder().equals(fileObject)) continue;
            return sourceGroupArray[i];
        }
        if (sourceGroupArray.length > 0) {
            return sourceGroupArray[0];
        }
        return null;
    }

    private String getRelativeNativeName(FileObject fileObject, FileObject fileObject2) {
        if (fileObject == null) {
            throw new NullPointerException("null root passed to getRelativeNativeName");
        }
        String string = fileObject2 == null ? "" : FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
        return string == null ? "" : string.replace('/', File.separatorChar);
    }

    private void updateCreatedFolder() {
        FileObject fileObject = ((SourceGroup)this.locationComboBox.getSelectedItem()).getRootFolder();
        String string = this.folderTextField.getText().trim();
        String string2 = this.documentNameTextField.getText().trim();
        String string3 = FileUtil.getFileDisplayName((FileObject)fileObject) + (string.startsWith("/") || string.startsWith(File.separator) ? "" : "/") + string + (string.endsWith("/") || string.endsWith(File.separator) || string.length() == 0 ? "" : "/") + string2 + this.expectedExtension;
        this.fileTextField.setText(string3.replace('/', File.separatorChar));
        this.changeSupport.fireChange();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.browseButton == actionEvent.getSource()) {
            FileObject fileObject = null;
            SourceGroup sourceGroup = (SourceGroup)this.locationComboBox.getSelectedItem();
            fileObject = BrowseFolders.showDialog(new SourceGroup[]{sourceGroup}, this.project, this.folderTextField.getText().replace(File.separatorChar, '/'));
            if (fileObject != null && fileObject.isFolder()) {
                String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
                this.folderTextField.setText(string.replace('/', File.separatorChar));
            }
        } else if (this.locationComboBox == actionEvent.getSource()) {
            this.updateCreatedFolder();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateCreatedFolder();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateCreatedFolder();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateCreatedFolder();
    }

    private class GroupCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public GroupCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof SourceGroup) {
                String string;
                SourceGroup sourceGroup = (SourceGroup)object;
                String string2 = ProjectUtils.getInformation((Project)SimpleTargetChooserPanelGUI.this.project).getDisplayName();
                if (string2.equals(string = sourceGroup.getDisplayName())) {
                    this.setText(string);
                } else {
                    this.setText(MessageFormat.format(PhysicalView.GroupNode.GROUP_NAME_PATTERN, string, string2, sourceGroup.getRootFolder().getName()));
                }
                this.setIcon(sourceGroup.getIcon(false));
            } else {
                this.setText(object.toString());
                this.setIcon(null);
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

