/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatRefValues;
import com.sun.perseus.model.FloatSegment;
import com.sun.perseus.model.RefValues;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.model.TraitAnimationNode;
import org.w3c.dom.DOMException;

class FloatTraitAnim
extends TraitAnim {
    public FloatTraitAnim(ElementNode targetElement, String traitName, String traitType) {
        super(targetElement, "#!null/ns@!", traitName, traitType);
    }

    public Object[] getBaseValue() {
        return this.targetElement.validateFloatArrayTrait(this.traitName, this.getSpecifiedTraitNS(), this.targetElement.getNamespaceURI(), this.targetElement.getLocalName(), this.traitNamespace, this.traitName);
    }

    void apply() {
        float[][] v = (float[][])this.rootAnim.compute();
        this.targetElement.setFloatArrayTrait(this.traitName, v);
    }

    protected String getTraitImpl() {
        float[][] v = this.targetElement.validateFloatArrayTrait(this.traitName, this.specifiedTraitValue, this.targetElement.getNamespaceURI(), this.targetElement.getLocalName(), this.traitNamespace, this.traitName);
        return this.targetElement.toStringTrait(this.traitName, v);
    }

    void setTraitImpl(String value) throws DOMException {
        this.targetElement.validateFloatArrayTrait(this.traitName, value, this.targetElement.getNamespaceURI(), this.targetElement.getLocalName(), this.traitNamespace, this.traitName);
        this.specifiedTraitValue = value;
    }

    RefValues toRefValues(TraitAnimationNode anim, String[] values, String reqTraitNamespace, String reqTraitName) throws DOMException {
        FloatRefValues refValues = new FloatRefValues();
        if (values.length < 1) {
            throw new IllegalArgumentException();
        }
        if (values.length == 1) {
            String[] tmpValues = new String[]{values[0], values[0]};
            values = tmpValues;
        }
        int nSegments = values.length - 1;
        refValues.segments = new FloatSegment[nSegments];
        refValues.segments[0] = new FloatSegment();
        refValues.segments[0].start = this.targetElement.validateFloatArrayTrait(anim.traitName, values[0], anim.getNamespaceURI(), anim.getLocalName(), reqTraitNamespace, reqTraitName);
        refValues.segments[0].end = this.targetElement.validateFloatArrayTrait(anim.traitName, values[1], anim.getNamespaceURI(), anim.getLocalName(), reqTraitNamespace, reqTraitName);
        FloatSegment prevSegment = refValues.segments[0];
        for (int i = 1; i < nSegments; ++i) {
            refValues.segments[i] = new FloatSegment();
            refValues.segments[i].start = prevSegment.end;
            refValues.segments[i].end = this.targetElement.validateFloatArrayTrait(anim.traitName, values[i + 1], anim.getNamespaceURI(), anim.getLocalName(), reqTraitNamespace, reqTraitName);
            prevSegment = refValues.segments[i];
        }
        return refValues;
    }

    public Object[] sum(Object[] valueA, Object[] valueB) {
        if (valueA == null) {
            return valueB;
        }
        float[][] fva = (float[][])valueA;
        float[][] fvb = (float[][])valueB;
        for (int ci = 0; ci < fva.length; ++ci) {
            for (int di = 0; di < fva[ci].length; ++di) {
                float[] fArray = fvb[ci];
                int n = di;
                fArray[n] = fArray[n] + fva[ci][di];
            }
        }
        return valueB;
    }

    public Object[] multiply(Object[] value, int iter) {
        float[][] fv = (float[][])value;
        float[][] r = new float[fv.length][];
        for (int ci = 0; ci < fv.length; ++ci) {
            r[ci] = new float[fv[ci].length];
            for (int di = 0; di < fv[ci].length; ++di) {
                r[ci][di] = fv[ci][di] * (float)iter;
            }
        }
        return r;
    }

    boolean supportsInterpolation() {
        return true;
    }
}

