/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.hqleditor;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.SAXReader;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.hqleditor.HQLExecutor;
import org.netbeans.modules.hibernate.hqleditor.HQLResult;
import org.netbeans.modules.hibernate.hqleditor.ui.HQLEditorTopComponent;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.netbeans.modules.hibernate.util.HibernateUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HQLEditorController {
    private Logger logger = Logger.getLogger(HQLEditorController.class.getName());
    private HQLEditorTopComponent editorTopComponent = null;

    public void executeHQLQuery(final String string, final FileObject fileObject, final int n, final ProgressHandle progressHandle) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        try {
            progressHandle.progress(10);
            progressHandle.setDisplayName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionPrepare"));
            final Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
            HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
            arrayList.addAll(hibernateEnvironment.getProjectClassPath(fileObject));
            for (FileObject object2 : hibernateEnvironment.getAllHibernateMappingFileObjects()) {
                arrayList.add(object2.getURL());
            }
            final ClassLoader classLoader = hibernateEnvironment.getProjectClassLoader(arrayList.toArray(new URL[0]));
            Thread thread = new Thread(){

                public void run() {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    HQLExecutor hQLExecutor = new HQLExecutor();
                    HQLResult hQLResult = new HQLResult();
                    try {
                        SessionFactory sessionFactory = HQLEditorController.this.processAndConstructSessionFactory(string, fileObject, classLoader, project);
                        progressHandle.progress(50);
                        progressHandle.setDisplayName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionPassControlToHibernate"));
                        hQLResult = hQLExecutor.execute(string, sessionFactory, n, progressHandle);
                        progressHandle.progress(80);
                        progressHandle.setDisplayName(NbBundle.getMessage(HQLEditorTopComponent.class, (String)"queryExecutionProcessResults"));
                    }
                    catch (Exception exception) {
                        HQLEditorController.this.logger.log(Level.INFO, "Problem in executing HQL", exception);
                        hQLResult.getExceptions().add(exception);
                    }
                    HQLEditorController.this.editorTopComponent.setResult(hQLResult, classLoader);
                }
            };
            thread.setContextClassLoader(classLoader);
            thread.start();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    public void init(Node[] nodeArray) {
        this.editorTopComponent = new HQLEditorTopComponent(this);
        this.editorTopComponent.open();
        this.editorTopComponent.requestActive();
        this.editorTopComponent.setFocusToEditor();
        this.editorTopComponent.fillHibernateConfigurations(nodeArray);
    }

    public SessionFactory getHibernateSessionFactoryForThisContext(FileObject fileObject, List<FileObject> list, List<Class> list2, ClassLoader classLoader) throws Exception {
        SAXReader sAXReader;
        AnnotationConfiguration annotationConfiguration = null;
        try {
            sAXReader = classLoader.loadClass("org.hibernate.cfg.AnnotationConfiguration");
            annotationConfiguration = (AnnotationConfiguration)sAXReader.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Exceptions.printStackTrace((Throwable)classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Exceptions.printStackTrace((Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Exceptions.printStackTrace((Throwable)illegalAccessException);
        }
        try {
            Object object;
            Object object2;
            sAXReader = new SAXReader();
            Document document = sAXReader.read(fileObject.getInputStream());
            Element element = document.getRootElement().element("session-factory");
            Iterator iterator = element.elementIterator("mapping");
            while (iterator.hasNext()) {
                object2 = (Element)iterator.next();
                this.logger.fine("Removing mapping element ..  " + object2);
                object2.getParent().remove((Element)object2);
            }
            object2 = element.attributeValue("name");
            if (object2 != null && !((String)object2).trim().equals("")) {
                Iterator<Class> iterator2 = new Properties();
                Iterator object3 = element.elementIterator("property");
                while (object3.hasNext()) {
                    object = (Element)object3.next();
                    if ("hibernate.jndi.class".equals(object.attributeValue("name"))) {
                        ((Properties)((Object)iterator2)).setProperty("java.naming.factory.initial", object.getTextTrim());
                    }
                    if (!"hibernate.jndi.url".equals(object.attributeValue("name"))) continue;
                    ((Properties)((Object)iterator2)).setProperty("java.naming.provider.url", object.getTextTrim());
                }
                try {
                    object = new InitialContext((Hashtable<?, ?>)((Object)iterator2));
                    ((InitialContext)object).bind("dummy", new Object());
                    ((InitialContext)object).unbind("dummy");
                }
                catch (NamingException namingException) {
                    this.logger.log(Level.INFO, "Incorrect JNDI properties", namingException);
                    throw namingException;
                }
            }
            for (FileObject fileObject2 : list) {
                this.logger.info("Adding mapping to custom configuration " + fileObject2.getName());
                object = element.addElement("mapping");
                File file = FileUtil.toFile((FileObject)fileObject2);
                object.addAttribute("file", file.getAbsolutePath());
            }
            for (Class clazz : list2) {
                this.logger.info("Adding annotated class to custom configuration " + clazz.getName());
                annotationConfiguration.addAnnotatedClass(clazz);
            }
            this.logger.info("configuring custom configuration..");
            annotationConfiguration.configure(this.getW3CDocument(document));
            return annotationConfiguration.buildSessionFactory();
        }
        catch (Exception exception) {
            this.logger.log(Level.INFO, "Problem in constructing custom configuration", exception);
            throw exception;
        }
    }

    private org.w3c.dom.Document getW3CDocument(Document document) {
        try {
            return new DOMWriter().write(document);
        }
        catch (DocumentException documentException) {
            Exceptions.printStackTrace((Throwable)documentException);
            return null;
        }
    }

    public SessionFactory processAndConstructSessionFactory(String string, FileObject fileObject, ClassLoader classLoader, Project project) throws Exception {
        Object object;
        Iterator iterator;
        Object object2;
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n\r\f\t(),");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
        ArrayList<FileObject> arrayList3 = new ArrayList<FileObject>();
        Map<FileObject, List<String>> map = hibernateEnvironment.getAllPOJONamesFromConfiguration(fileObject);
        for (FileObject object32 : map.keySet()) {
            Object object3;
            object2 = map.get(object32);
            this.logger.info("pojoNameList from configution : ");
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                this.logger.info("pojo-name " + (String)object3);
            }
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object3 = (String)iterator.next();
                for (String string2 : arrayList) {
                    if (!this.foundClassNameMatch(string2, (String)object3)) continue;
                    object = this.processMatchingClass((String)object3, classLoader, project);
                    this.logger.info("matching classname = " + (String)object3);
                    this.logger.info("Got clazz " + object);
                    if (object == null) continue;
                    arrayList2.add(object32);
                    arrayList3.add(object32);
                    this.getRelatedMappings(object32, arrayList2, map);
                    for (FileObject fileObject2 : arrayList2) {
                        List<String> list = map.get(fileObject2);
                        if (list == null) continue;
                        this.logger.info("Processing relationships from " + fileObject2 + " mapping file.");
                        this.logger.info("Related POJOs " + list);
                        for (String string3 : list) {
                            Class clazz = this.processMatchingClass(string3, classLoader, project);
                            this.logger.info("Got related POJO clazz " + clazz);
                            if (clazz == null) continue;
                            arrayList3.add(fileObject2);
                        }
                    }
                }
            }
        }
        List<String> list = hibernateEnvironment.getAnnotatedPOJOClassNames(fileObject);
        ArrayList<Class> arrayList4 = new ArrayList<Class>();
        if (list.size() != 0) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                iterator = (String)object2.next();
                for (String string4 : arrayList) {
                    if (!this.foundClassNameMatch(string4, (String)((Object)iterator))) continue;
                    Class clazz = this.processMatchingClass((String)((Object)iterator), classLoader, project);
                    this.logger.info("matching classname = " + iterator);
                    this.logger.info("Got clazz " + clazz);
                    if (clazz == null) continue;
                    arrayList4.add(clazz);
                    object = this.getRelatedPOJOClasses(clazz, list, classLoader, project);
                    this.logger.info("Related POJO Class list " + object);
                    arrayList4.addAll((Collection<Class>)object);
                }
            }
        }
        return this.getHibernateSessionFactoryForThisContext(fileObject, arrayList2, arrayList4, classLoader);
    }

    private List<Class> getRelatedPOJOClasses(Class clazz, List<String> list, ClassLoader classLoader, Project project) {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        this.getRelatedPOJOClassesByType(clazz, list, arrayList, classLoader, project);
        return arrayList;
    }

    private void getRelatedPOJOClassesByType(Class clazz, List<String> list, List<Class> list2, ClassLoader classLoader, Project project) {
        AnnotationAccessType annotationAccessType = this.findAnnotationAccessType(clazz);
        if (annotationAccessType == AnnotationAccessType.METHOD_TYPE) {
            this.logger.info("Annotation Access type for " + clazz.getName() + " is : METHOD_TYPE");
            this.getRelatedPOJOClassesByMethodType(clazz, list, list2, classLoader, project);
        } else {
            this.logger.info("Annotation Access type for " + clazz.getName() + " is : FIELD_TYPE");
            this.getRelatedPOJOClassesByFieldType(clazz, list, list2, classLoader, project);
        }
    }

    private AnnotationAccessType findAnnotationAccessType(Class clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Id.class) && !field.isAnnotationPresent(EmbeddedId.class)) continue;
            return AnnotationAccessType.FIELD_TYPE;
        }
        return AnnotationAccessType.METHOD_TYPE;
    }

    private void getRelatedPOJOClassesByMethodType(Class clazz, List<String> list, List<Class> list2, ClassLoader classLoader, Project project) {
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(ManyToOne.class) && !method.isAnnotationPresent(OneToOne.class) && !method.isAnnotationPresent(OneToMany.class)) continue;
            this.logger.info("Found relationship in " + method.getName() + " method of " + clazz.getName() + " related POJO.");
            try {
                Class clazz2;
                Class clazz3;
                Class clazz4;
                Class clazz5;
                Class clazz6 = method.getReturnType();
                if (Collection.class.isAssignableFrom(clazz6)) {
                    try {
                        clazz5 = (Class)((ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()[0];
                        this.logger.info("Method return type is java.util.Collection");
                        if (!clazz5.equals(Object.class)) {
                            this.logger.info("Re-assigning related class to " + clazz5);
                            clazz6 = clazz5;
                        }
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                } else if (Map.class.isAssignableFrom(clazz6)) {
                    this.logger.info("Accessor method return type is java.util.Map");
                }
                if (list.contains(clazz6.getName())) {
                    this.logger.info("Related POJO Class " + clazz6.getName());
                    if (list2.contains(clazz6)) {
                        this.logger.info("Already processed " + clazz6 + ". Skipping.");
                        continue;
                    }
                    this.logger.info("adding to related POJO class list " + clazz6);
                    list2.add(clazz6);
                    this.getRelatedPOJOClassesByType(clazz6, list, list2, classLoader, project);
                }
                if ((clazz5 = method.getAnnotation(OneToMany.class)) != null && (clazz4 = clazz5.targetEntity()) != null && !clazz4.getName().equals("void")) {
                    if (list2.contains(clazz4)) {
                        this.logger.info("Already processed " + clazz4 + ". Skipping.");
                        continue;
                    }
                    if ((clazz4 = this.processMatchingClass(clazz4.getName(), classLoader, project)) != null) {
                        this.logger.info("adding to related POJO class list from targetEntity : " + clazz4);
                        list2.add(clazz4);
                        this.getRelatedPOJOClassesByType(clazz4, list, list2, classLoader, project);
                    }
                }
                if ((clazz4 = method.getAnnotation(ManyToOne.class)) != null && (clazz3 = clazz4.targetEntity()) != null && !clazz3.getName().equals("void")) {
                    if (list2.contains(clazz3)) {
                        this.logger.info("Already processed " + clazz3 + ". Skipping.");
                        continue;
                    }
                    if ((clazz3 = this.processMatchingClass(clazz3.getName(), classLoader, project)) != null) {
                        this.logger.info("adding to related POJO class list from targetEntity : " + clazz3);
                        list2.add(clazz3);
                        this.getRelatedPOJOClassesByType(clazz3, list, list2, classLoader, project);
                    }
                }
                if ((clazz3 = method.getAnnotation(OneToOne.class)) == null || (clazz2 = clazz3.targetEntity()) == null || clazz2.getName().equals("void")) continue;
                if (list2.contains(clazz2)) {
                    this.logger.info("Already processed " + clazz2 + ". Skipping.");
                    continue;
                }
                if ((clazz2 = this.processMatchingClass(clazz2.getName(), classLoader, project)) == null) continue;
                this.logger.info("adding to related POJO class list from targetEntity : " + clazz2);
                list2.add(clazz2);
                this.getRelatedPOJOClassesByType(clazz2, list, list2, classLoader, project);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.log(Level.INFO, "Accessor method is not annotated", illegalArgumentException);
            }
        }
    }

    private void getRelatedPOJOClassesByFieldType(Class clazz, List<String> list, List<Class> list2, ClassLoader classLoader, Project project) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ManyToOne.class) && !field.isAnnotationPresent(OneToOne.class) && !field.isAnnotationPresent(OneToMany.class)) continue;
            this.logger.info("Found relationship in " + field.getName() + " field of " + clazz.getName() + " related POJO.");
            try {
                Class clazz2;
                Class clazz3;
                Class clazz4;
                Class clazz5;
                Class clazz6 = field.getType();
                if (Collection.class.isAssignableFrom(clazz6)) {
                    try {
                        clazz5 = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
                        this.logger.info("Field type is java.util.Collection");
                        if (!clazz5.equals(Object.class)) {
                            this.logger.info("Re-assigning related class to " + clazz5);
                            clazz6 = clazz5;
                        }
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                } else if (Map.class.isAssignableFrom(clazz6)) {
                    this.logger.info("Field type is java.util.Map");
                }
                if (list.contains(clazz6.getName())) {
                    this.logger.info("Related POJO Class " + clazz6.getName());
                    if (list2.contains(clazz6)) {
                        this.logger.info("Already processed " + clazz6 + ". Skipping.");
                        continue;
                    }
                    this.logger.info("adding to related POJO class list " + clazz6);
                    list2.add(clazz6);
                    this.getRelatedPOJOClassesByType(clazz6, list, list2, classLoader, project);
                }
                if ((clazz5 = field.getAnnotation(OneToMany.class)) != null && (clazz4 = clazz5.targetEntity()) != null && !clazz4.getName().equals("void")) {
                    if (list2.contains(clazz4)) {
                        this.logger.info("Already processed " + clazz4 + ". Skipping.");
                        continue;
                    }
                    if ((clazz4 = this.processMatchingClass(clazz4.getName(), classLoader, project)) != null) {
                        this.logger.info("adding to related POJO class list from targetEntity : " + clazz4);
                        list2.add(clazz4);
                        this.getRelatedPOJOClassesByType(clazz4, list, list2, classLoader, project);
                    }
                }
                if ((clazz4 = field.getAnnotation(ManyToOne.class)) != null && (clazz3 = clazz4.targetEntity()) != null && !clazz3.getName().equals("void")) {
                    if (!list2.contains(clazz3)) {
                        if ((clazz3 = this.processMatchingClass(clazz3.getName(), classLoader, project)) != null) {
                            this.logger.info("adding to related POJO class list from targetEntity : " + clazz3);
                            list2.add(clazz3);
                            this.getRelatedPOJOClassesByType(clazz3, list, list2, classLoader, project);
                        }
                    } else {
                        this.logger.info("Already processed " + clazz3 + ". Skipping.");
                        continue;
                    }
                }
                if ((clazz3 = field.getAnnotation(OneToOne.class)) == null || (clazz2 = clazz3.targetEntity()) == null || clazz2.getName().equals("void")) continue;
                if (list2.contains(clazz2)) {
                    this.logger.info("Already processed " + clazz2 + ". Skipping.");
                    continue;
                }
                if ((clazz2 = this.processMatchingClass(clazz2.getName(), classLoader, project)) == null) continue;
                this.logger.info("adding to related POJO class list from targetEntity : " + clazz2);
                list2.add(clazz2);
                this.getRelatedPOJOClassesByType(clazz2, list, list2, classLoader, project);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.logger.log(Level.INFO, "Field is not annotated", illegalArgumentException);
            }
        }
    }

    private List<FileObject> getRelatedMappings(FileObject fileObject, List<FileObject> list, Map<FileObject, List<String>> map) {
        try {
            SAXReader sAXReader = new SAXReader();
            Document document = sAXReader.read(FileUtil.toFile((FileObject)fileObject));
            Iterator iterator = document.getRootElement().elementIterator("class");
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                this.logger.info("Processing many-to-one");
                this.processMappingRelationships(element.elementIterator("many-to-one"), list, map);
                this.logger.info("Processing one-to-one");
                this.processMappingRelationships(element.elementIterator("one-to-one"), list, map);
                this.logger.info("Processing set");
                this.processMappingRelationships(element.elementIterator("set"), list, map);
                this.logger.info("Processing idbag");
                this.processMappingRelationships(element.elementIterator("idbag"), list, map);
                this.logger.info("Processing map");
                this.processMappingRelationships(element.elementIterator("map"), list, map);
                this.logger.info("Processing bag");
                this.processMappingRelationships(element.elementIterator("bag"), list, map);
                this.logger.info("Processing list");
                this.processMappingRelationships(element.elementIterator("list"), list, map);
                this.logger.info("Processing array");
                this.processMappingRelationships(element.elementIterator("array"), list, map);
            }
        }
        catch (Exception exception) {
            this.logger.log(Level.INFO, "Problem in parsing mapping file for relation", exception);
        }
        return list;
    }

    private List<FileObject> processMappingRelationships(Iterator iterator, List<FileObject> list, Map<FileObject, List<String>> map) {
        while (iterator.hasNext()) {
            Element element;
            Element element2 = (Element)iterator.next();
            String string = element2.attributeValue("class");
            if (string == null) {
                element = element2.element("one-to-many");
                if (element == null) {
                    element = element2.element("composite-element");
                }
                if (element == null) {
                    element = element2.element("one-to-many");
                }
                if (element == null) {
                    element = element2.element("many-to-many");
                }
                if (element != null) {
                    string = element.attributeValue("class");
                }
            }
            if ((element = this.findRelatedMappingFO(string, map)) == null || list.contains(element)) continue;
            list.add((FileObject)element);
            this.getRelatedMappings((FileObject)element, list, map);
        }
        this.logger.info("Related mapping files : " + list);
        return list;
    }

    private FileObject findRelatedMappingFO(String string, Map<FileObject, List<String>> map) {
        for (FileObject fileObject : map.keySet()) {
            List<String> list = map.get(fileObject);
            if (!list.contains(string)) continue;
            this.logger.info("Related POJO : " + string);
            return fileObject;
        }
        return null;
    }

    private boolean foundClassNameMatch(String string, String string2) {
        boolean bl = false;
        if (string.indexOf(".") != -1) {
            if (string2.endsWith(string)) {
                bl = true;
            }
        } else if (string2.indexOf(".") == -1) {
            if (string2.equals(string)) {
                bl = true;
            }
        } else {
            String string3 = string2.substring(string2.lastIndexOf(".") + 1);
            if (string3.equals(string)) {
                bl = true;
            }
        }
        return bl;
    }

    private Class processMatchingClass(String string, ClassLoader classLoader, Project project) {
        FileObject fileObject = HibernateUtil.findJavaFileObjectInProject(string, project);
        FileObject fileObject2 = HibernateUtil.getBuildFO(project);
        if (fileObject2 == null) {
            return null;
        }
        return this.checkAndCompile(string, fileObject, fileObject2, classLoader, project);
    }

    private Class checkAndCompile(String string, FileObject fileObject, FileObject fileObject2, ClassLoader classLoader, Project project) {
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(string);
            if (clazz != null) {
                this.logger.info("Found pre-existing class. Returning.." + clazz.getName());
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.logger.info("CNF. Processing .. " + string);
            try {
                JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
                StandardJavaFileManager standardJavaFileManager = javaCompiler.getStandardFileManager(null, null, null);
                string = string.replace(".", File.separator);
                File file = FileUtil.toFile((FileObject)fileObject);
                Iterable<? extends JavaFileObject> iterable = standardJavaFileManager.getJavaFileObjectsFromFiles(Arrays.asList(file));
                ArrayList<File> arrayList = new ArrayList<File>();
                arrayList.add(FileUtil.toFile((FileObject)fileObject2));
                ArrayList<File> arrayList2 = new ArrayList<File>();
                for (SourceGroup sourceGroup : HibernateUtil.getSourceGroups(project)) {
                    arrayList2.add(FileUtil.toFile((FileObject)sourceGroup.getRootFolder()));
                }
                standardJavaFileManager.setLocation(StandardLocation.CLASS_OUTPUT, arrayList);
                standardJavaFileManager.setLocation(StandardLocation.CLASS_PATH, this.getProjectClasspath(project, fileObject));
                standardJavaFileManager.setLocation(StandardLocation.SOURCE_PATH, arrayList2);
                ArrayList arrayList3 = new ArrayList();
                arrayList3.add("-target");
                String string2 = System.getProperty("java.specification.version");
                if (string2 == null || string2.equals("")) {
                    string2 = "1.5";
                }
                arrayList3.add(string2);
                Boolean bl = javaCompiler.getTask(null, standardJavaFileManager, null, arrayList3, null, iterable).call();
                this.logger.info("b = " + bl);
                if (!bl.booleanValue()) {
                    SourceGroup sourceGroup;
                    sourceGroup = fileObject2.getFileObject(string + ".class");
                    if (sourceGroup != null && sourceGroup.isValid()) {
                        sourceGroup.delete();
                    }
                    return clazz;
                }
                try {
                    string = string.replace(File.separator, ".");
                    clazz = classLoader.loadClass(string);
                    if (clazz != null) {
                        this.logger.info("Found class after processing. Returning.." + clazz.getName());
                        return clazz;
                    }
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    this.logger.info("CNF after processing.. " + string);
                    Exceptions.printStackTrace((Throwable)classNotFoundException2);
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
        return clazz;
    }

    private List<File> getProjectClasspath(Project project, FileObject fileObject) {
        ArrayList<File> arrayList = new ArrayList<File>();
        HibernateEnvironment hibernateEnvironment = (HibernateEnvironment)project.getLookup().lookup(HibernateEnvironment.class);
        for (URL uRL : hibernateEnvironment.getProjectClassPath(fileObject)) {
            String string = uRL.getPath();
            string = string.replace("file:", "");
            string = string.replace("!/", "");
            File file = new File(string);
            arrayList.add(file);
        }
        this.logger.info("Adding classpath " + arrayList);
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AnnotationAccessType {
        FIELD_TYPE,
        METHOD_TYPE;

    }
}

