/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.lexer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.modules.gsf.api.TranslatedSource;
import org.netbeans.modules.gsf.api.annotations.CheckForNull;
import org.netbeans.modules.gsf.spi.GsfUtilities;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexUtilities {
    private static final Set<TokenId> INDENT_WORDS = new HashSet<TokenId>();

    @CheckForNull
    public static BaseDocument getDocument(CompilationInfo compilationInfo, boolean bl) {
        try {
            if (compilationInfo == null) {
                return null;
            }
            BaseDocument baseDocument = (BaseDocument)compilationInfo.getDocument();
            if (baseDocument == null && bl) {
                baseDocument = GsfUtilities.getDocument((FileObject)compilationInfo.getFileObject(), (boolean)true);
            }
            return baseDocument;
        }
        catch (ClassCastException classCastException) {
            return GsfUtilities.getDocument((FileObject)compilationInfo.getFileObject(), (boolean)true);
        }
    }

    private LexUtilities() {
    }

    public static TokenSequence<? extends JsCommentTokenId> getCommentFor(BaseDocument baseDocument, int n) {
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return null;
        }
        tokenSequence.move(n);
        while (tokenSequence.movePrevious()) {
            TokenId tokenId = tokenSequence.token().id();
            if (tokenId == JsTokenId.BLOCK_COMMENT) {
                return tokenSequence.embedded(JsCommentTokenId.language());
            }
            if (tokenId == JsTokenId.WHITESPACE || tokenId == JsTokenId.EOL) continue;
            return null;
        }
        return null;
    }

    public static int getLexerOffset(CompilationInfo compilationInfo, int n) {
        TranslatedSource translatedSource;
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/javascript", 0);
        if (parserResult == null) {
            parserResult = compilationInfo.getEmbeddedResult("text/x-json", 0);
        }
        if (parserResult != null && (translatedSource = parserResult.getTranslatedSource()) != null) {
            return translatedSource.getLexicalOffset(n);
        }
        return n;
    }

    public static OffsetRange getLexerOffsets(CompilationInfo compilationInfo, OffsetRange offsetRange) {
        TranslatedSource translatedSource;
        ParserResult parserResult = compilationInfo.getEmbeddedResult("text/javascript", 0);
        if (parserResult == null) {
            parserResult = compilationInfo.getEmbeddedResult("text/x-json", 0);
        }
        if (parserResult != null && (translatedSource = parserResult.getTranslatedSource()) != null) {
            int n = offsetRange.getStart();
            int n2 = translatedSource.getLexicalOffset(n);
            if (n2 == n) {
                return offsetRange;
            }
            if (n2 == -1) {
                return OffsetRange.NONE;
            }
            return new OffsetRange(n2, n2 + offsetRange.getLength());
        }
        return offsetRange;
    }

    public static TokenSequence<? extends JsTokenId> getNextJsTokenSequence(BaseDocument baseDocument, int n, int n2) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(n);
        return LexUtilities.findNextJsTokenSequence(tokenSequence, n, n2);
    }

    private static TokenSequence<? extends JsTokenId> findNextJsTokenSequence(TokenSequence<?> tokenSequence, int n, int n2) {
        if (tokenSequence.language() == JsTokenId.language()) {
            if (!tokenSequence.moveNext()) {
                return null;
            }
            return tokenSequence;
        }
        while (tokenSequence.moveNext() && tokenSequence.offset() <= n2) {
            int n3 = tokenSequence.offset();
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 == null) continue;
            tokenSequence2.move(n3);
            TokenSequence<? extends JsTokenId> tokenSequence3 = LexUtilities.findNextJsTokenSequence(tokenSequence2, n, n2);
            if (tokenSequence3 == null) continue;
            return tokenSequence3;
        }
        return null;
    }

    public static TokenSequence<? extends JsTokenId> getJsTokenSequence(BaseDocument baseDocument, int n) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
        return LexUtilities.getJsTokenSequence((TokenHierarchy<Document>)tokenHierarchy, n);
    }

    public static TokenSequence<? extends JsTokenId> getJsTokenSequence(TokenHierarchy<Document> tokenHierarchy, int n) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(JsTokenId.language());
        if (tokenSequence == null) {
            List list = tokenHierarchy.embeddedTokenSequences(n, true);
            for (TokenSequence tokenSequence2 : list) {
                if (tokenSequence2.language() != JsTokenId.language()) continue;
                tokenSequence = tokenSequence2;
                break;
            }
            if (tokenSequence == null) {
                list = tokenHierarchy.embeddedTokenSequences(n, false);
                for (TokenSequence tokenSequence2 : list) {
                    if (tokenSequence2.language() != JsTokenId.language()) continue;
                    tokenSequence = tokenSequence2;
                    break;
                }
            }
        }
        return tokenSequence;
    }

    public static TokenSequence<? extends JsTokenId> getPositionedSequence(BaseDocument baseDocument, int n) {
        return LexUtilities.getPositionedSequence(baseDocument, n, true);
    }

    public static TokenSequence<? extends JsTokenId> getPositionedSequence(BaseDocument baseDocument, int n, boolean bl) {
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n);
        if (tokenSequence != null) {
            try {
                tokenSequence.move(n);
            }
            catch (AssertionError assertionError) {
                DataObject dataObject = (DataObject)baseDocument.getProperty((Object)"stream");
                if (dataObject != null) {
                    Exceptions.attachMessage((Throwable)((Object)assertionError), (String)FileUtil.getFileDisplayName((FileObject)dataObject.getPrimaryFile()));
                }
                throw assertionError;
            }
            if (!bl && !tokenSequence.moveNext()) {
                return null;
            }
            if (bl && !tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                return null;
            }
            return tokenSequence;
        }
        return null;
    }

    public static Token<? extends JsTokenId> getToken(BaseDocument baseDocument, int n) {
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence(baseDocument, n);
        if (tokenSequence != null) {
            return tokenSequence.token();
        }
        return null;
    }

    public static char getTokenChar(BaseDocument baseDocument, int n) {
        String string;
        Token<? extends JsTokenId> token = LexUtilities.getToken(baseDocument, n);
        if (token != null && (string = ((Object)token.text()).toString()).length() > 0) {
            return string.charAt(0);
        }
        return '\u0000';
    }

    public static Token<? extends JsTokenId> findNextNonWsNonComment(TokenSequence<? extends JsTokenId> tokenSequence) {
        return LexUtilities.findNext(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT));
    }

    public static Token<? extends JsTokenId> findPreviousNonWsNonComment(TokenSequence<? extends JsTokenId> tokenSequence) {
        return LexUtilities.findPrevious(tokenSequence, Arrays.asList(JsTokenId.WHITESPACE, JsTokenId.EOL, JsTokenId.LINE_COMMENT, JsTokenId.BLOCK_COMMENT));
    }

    public static Token<? extends JsTokenId> findNext(TokenSequence<? extends JsTokenId> tokenSequence, List<JsTokenId> list) {
        if (list.contains(tokenSequence.token().id())) {
            while (tokenSequence.moveNext() && list.contains(tokenSequence.token().id())) {
            }
        }
        return tokenSequence.token();
    }

    public static Token<? extends JsTokenId> findNextIncluding(TokenSequence<? extends JsTokenId> tokenSequence, List<JsTokenId> list) {
        while (tokenSequence.moveNext() && !list.contains(tokenSequence.token().id())) {
        }
        return tokenSequence.token();
    }

    public static Token<? extends JsTokenId> findPreviousIncluding(TokenSequence<? extends JsTokenId> tokenSequence, List<JsTokenId> list) {
        while (tokenSequence.movePrevious() && !list.contains(tokenSequence.token().id())) {
        }
        return tokenSequence.token();
    }

    public static Token<? extends JsTokenId> findPrevious(TokenSequence<? extends JsTokenId> tokenSequence, List<JsTokenId> list) {
        if (list.contains(tokenSequence.token().id())) {
            while (tokenSequence.movePrevious() && list.contains(tokenSequence.token().id())) {
            }
        }
        return tokenSequence.token();
    }

    static boolean skipParenthesis(TokenSequence<? extends JsTokenId> tokenSequence) {
        return LexUtilities.skipParenthesis(tokenSequence, false);
    }

    public static boolean skipParenthesis(TokenSequence<? extends JsTokenId> tokenSequence, boolean bl) {
        int n = 0;
        Token token = tokenSequence.token();
        if (token == null) {
            return false;
        }
        TokenId tokenId = token.id();
        if (tokenId == JsTokenId.WHITESPACE || tokenId == JsTokenId.EOL) {
            while ((bl ? tokenSequence.movePrevious() : tokenSequence.moveNext()) && (tokenSequence.token().id() == JsTokenId.WHITESPACE || tokenSequence.token().id() == JsTokenId.EOL)) {
            }
        }
        if (tokenSequence.token().id() != (bl ? JsTokenId.RPAREN : JsTokenId.LPAREN)) {
            return false;
        }
        do {
            if ((tokenId = (token = tokenSequence.token()).id()) == (bl ? JsTokenId.RPAREN : JsTokenId.LPAREN)) {
                ++n;
                continue;
            }
            if (tokenId != (bl ? JsTokenId.LPAREN : JsTokenId.RPAREN)) continue;
            if (n == 0) {
                return false;
            }
            if (n == 1) {
                if (bl) {
                    tokenSequence.movePrevious();
                } else {
                    tokenSequence.moveNext();
                }
                return true;
            }
            --n;
        } while (!bl ? tokenSequence.moveNext() : tokenSequence.movePrevious());
        return false;
    }

    public static OffsetRange findFwd(BaseDocument baseDocument, TokenSequence<? extends JsTokenId> tokenSequence, TokenId tokenId, TokenId tokenId2) {
        int n = 0;
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            TokenId tokenId3 = token.id();
            if (tokenId3 == tokenId) {
                ++n;
                continue;
            }
            if (tokenId3 != tokenId2) continue;
            if (n == 0) {
                return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
            }
            --n;
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange findBwd(BaseDocument baseDocument, TokenSequence<? extends JsTokenId> tokenSequence, TokenId tokenId, TokenId tokenId2) {
        int n = 0;
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            TokenId tokenId3 = token.id();
            if (tokenId3 == tokenId) {
                if (n == 0) {
                    return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
                }
                ++n;
                continue;
            }
            if (tokenId3 != tokenId2) continue;
            --n;
        }
        return OffsetRange.NONE;
    }

    private static OffsetRange findMultilineRange(TokenSequence<? extends JsTokenId> tokenSequence) {
        int n = tokenSequence.offset();
        JsTokenId jsTokenId = (JsTokenId)tokenSequence.token().id();
        switch (jsTokenId) {
            case ELSE: {
                tokenSequence.moveNext();
                jsTokenId = (JsTokenId)tokenSequence.token().id();
                break;
            }
            case IF: 
            case FOR: 
            case WHILE: {
                tokenSequence.moveNext();
                if (!LexUtilities.skipParenthesis(tokenSequence, false)) {
                    return OffsetRange.NONE;
                }
                jsTokenId = (JsTokenId)tokenSequence.token().id();
                break;
            }
            default: {
                return OffsetRange.NONE;
            }
        }
        boolean bl = false;
        int n2 = tokenSequence.offset();
        if (jsTokenId == JsTokenId.WHITESPACE || jsTokenId == JsTokenId.LINE_COMMENT || jsTokenId == JsTokenId.BLOCK_COMMENT || jsTokenId == JsTokenId.EOL) {
            if (tokenSequence.token().id() == JsTokenId.EOL) {
                n2 = tokenSequence.offset();
                bl = true;
            }
            while (tokenSequence.moveNext() && (tokenSequence.token().id() == JsTokenId.WHITESPACE || tokenSequence.token().id() == JsTokenId.LINE_COMMENT || tokenSequence.token().id() == JsTokenId.EOL || tokenSequence.token().id() == JsTokenId.BLOCK_COMMENT)) {
                if (tokenSequence.token().id() != JsTokenId.EOL) continue;
                n2 = tokenSequence.offset();
                bl = true;
            }
        }
        if (tokenSequence.token() == null || tokenSequence.token().id() != JsTokenId.LBRACE && bl) {
            return new OffsetRange(n, n2);
        }
        return OffsetRange.NONE;
    }

    public static OffsetRange getMultilineRange(BaseDocument baseDocument, TokenSequence<? extends JsTokenId> tokenSequence) {
        int n = tokenSequence.index();
        OffsetRange offsetRange = LexUtilities.findMultilineRange(tokenSequence);
        tokenSequence.moveIndex(n);
        tokenSequence.moveNext();
        return offsetRange;
    }

    public static boolean isIndentToken(TokenId tokenId) {
        return INDENT_WORDS.contains(tokenId);
    }

    public static int getLineBalance(BaseDocument baseDocument, int n, TokenId tokenId, TokenId tokenId2) {
        try {
            int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
            TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n2);
            if (tokenSequence == null) {
                return 0;
            }
            tokenSequence.move(n2);
            if (!tokenSequence.moveNext()) {
                return 0;
            }
            int n4 = 0;
            do {
                Token token;
                TokenId tokenId3;
                if ((tokenId3 = (token = tokenSequence.token()).id()) == tokenId) {
                    ++n4;
                    continue;
                }
                if (tokenId3 != tokenId2) continue;
                --n4;
            } while (tokenSequence.moveNext() && tokenSequence.offset() <= n3);
            return n4;
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return 0;
        }
    }

    public static int getTokenBalance(BaseDocument baseDocument, TokenId tokenId, TokenId tokenId2, int n) throws BadLocationException {
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, 0);
        if (tokenSequence == null) {
            return 0;
        }
        tokenSequence.moveIndex(0);
        if (!tokenSequence.moveNext()) {
            return 0;
        }
        int n2 = 0;
        do {
            Token token;
            if ((token = tokenSequence.token()).id() == tokenId) {
                ++n2;
                continue;
            }
            if (token.id() != tokenId2) continue;
            --n2;
        } while (tokenSequence.moveNext());
        return n2;
    }

    public static boolean isCommentOnlyLine(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 == -1) {
            return false;
        }
        Token<? extends JsTokenId> token = LexUtilities.getToken(baseDocument, n2);
        if (token != null) {
            return token.id() == JsTokenId.LINE_COMMENT;
        }
        return false;
    }

    public static OffsetRange getCommentBlock(BaseDocument baseDocument, int n, boolean bl) {
        block13: {
            try {
                TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n);
                if (tokenSequence == null) {
                    return OffsetRange.NONE;
                }
                tokenSequence.move(n);
                if (bl) {
                    while (tokenSequence.movePrevious()) {
                        TokenId tokenId = tokenSequence.token().id();
                        if (tokenId == JsTokenId.BLOCK_COMMENT || tokenId == JsTokenId.LINE_COMMENT) {
                            return LexUtilities.getCommentBlock(baseDocument, tokenSequence.offset(), false);
                        }
                        if (tokenId == JsTokenId.WHITESPACE || tokenId == JsTokenId.EOL) continue;
                        return OffsetRange.NONE;
                    }
                    return OffsetRange.NONE;
                }
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    return null;
                }
                Token token = tokenSequence.token();
                if (token != null && token.id() == JsTokenId.BLOCK_COMMENT) {
                    return new OffsetRange(tokenSequence.offset(), tokenSequence.offset() + token.length());
                }
                if (token == null || token.id() != JsTokenId.LINE_COMMENT) break block13;
                int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                int n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                if (LexUtilities.isCommentOnlyLine(baseDocument, n)) {
                    int n4;
                    while (n2 > 0) {
                        n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)(n2 - 1));
                        if (n4 < 0 || !LexUtilities.isCommentOnlyLine(baseDocument, n4)) {
                            n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                            break;
                        }
                        n2 = n4;
                    }
                    n4 = baseDocument.getLength();
                    while (true) {
                        int n5;
                        if ((n5 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)(n3 + 1))) >= n4 || !LexUtilities.isCommentOnlyLine(baseDocument, n5)) break;
                        n3 = n5;
                    }
                    n3 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n3) + 1;
                    if (n2 < n3) {
                        return new OffsetRange(n2, n3);
                    }
                    break block13;
                }
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
                int n6 = token.offset(tokenHierarchy);
                return new OffsetRange(n6, n6 + token.length());
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return OffsetRange.NONE;
    }

    public static int findSpaceBegin(BaseDocument baseDocument, int n) {
        int n2;
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence(baseDocument, n);
        if (tokenSequence == null) {
            return n;
        }
        boolean bl = false;
        try {
            int n3;
            n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)Math.min(n, baseDocument.getLength()));
            int n4 = n2 - 1;
            if (n2 > 0 && (n4 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)(n2 - 1))) != -1 && (n3 = (int)baseDocument.getText(n4, 1).charAt(0)) == 44) {
                bl = true;
            }
            if (!bl) {
                n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                if (n <= n3 || n3 == -1) {
                    return n;
                }
            } else {
                n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n2);
                if (n4 >= 0 && (n <= n3 || n3 == -1)) {
                    return n4 + 1;
                }
                n2 = 0;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return n;
        }
        tokenSequence.move(n);
        if (tokenSequence.moveNext()) {
            if (n > tokenSequence.offset()) {
                return Math.max(tokenSequence.token().id() == JsTokenId.WHITESPACE ? tokenSequence.offset() : n, n2);
            }
            while (tokenSequence.movePrevious()) {
                Token token = tokenSequence.token();
                if (token.id() == JsTokenId.WHITESPACE) continue;
                return Math.max(tokenSequence.offset() + token.length(), n2);
            }
        }
        return n;
    }

    public static List<String> gatherDocumentation(CompilationInfo compilationInfo, BaseDocument baseDocument, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = n;
        if (compilationInfo != null && compilationInfo.getDocument() == baseDocument && (n2 = LexUtilities.getLexerOffset(compilationInfo, n2)) == -1) {
            return null;
        }
        try {
            int n3;
            int n4;
            String string;
            if (n2 >= baseDocument.getLength()) {
                return null;
            }
            int n5 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2);
            --n5;
            while (n5 >= 0 && (Utilities.isRowEmpty((BaseDocument)baseDocument, (int)(n5 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n5))) || Utilities.isRowWhite((BaseDocument)baseDocument, (int)n5))) {
                --n5;
            }
            if (n5 < 0) {
                return null;
            }
            while (n5 >= 0 && !Utilities.isRowEmpty((BaseDocument)baseDocument, (int)(n5 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n5))) && !Utilities.isRowWhite((BaseDocument)baseDocument, (int)n5) && (string = baseDocument.getText(n4 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n5), (n3 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n5) + 1) - n4)).startsWith("*")) {
                if (string.length() == 1 || string.length() > 1 && string.charAt(1) != '/') {
                    linkedList.addFirst(string.substring(1).trim());
                }
                --n5;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return linkedList;
    }

    static {
        INDENT_WORDS.add(JsTokenId.FOR);
        INDENT_WORDS.add(JsTokenId.IF);
        INDENT_WORDS.add(JsTokenId.ELSE);
        INDENT_WORDS.add(JsTokenId.WHILE);
    }
}

