/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.spi.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.selector.spi.nodes.ContainerNode;
import org.netbeans.modules.profiler.selector.spi.nodes.PackageNode;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorChildren;
import org.netbeans.modules.profiler.selector.spi.nodes.SelectorNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectPackages
extends SelectorChildren<ContainerNode> {
    private final PackageType packageType;
    private final Set<ClassIndex.SearchScope> scope = new HashSet<ClassIndex.SearchScope>();
    private final boolean subprojects;

    public ProjectPackages(PackageType packageType, boolean bl) {
        this.packageType = packageType;
        switch (packageType) {
            case Source: {
                this.scope.add(ClassIndex.SearchScope.SOURCE);
                break;
            }
            case Libraries: {
                this.scope.add(ClassIndex.SearchScope.DEPENDENCIES);
            }
        }
        this.subprojects = bl;
    }

    @Override
    protected List<SelectorNode> prepareChildren(ContainerNode containerNode) {
        ArrayList<SelectorNode> arrayList = new ArrayList<SelectorNode>();
        Project project = containerNode.getProject();
        ClasspathInfo classpathInfo = ProjectUtilities.getClasspathInfo((Project)project, (boolean)this.subprojects, (boolean)this.scope.contains(ClassIndex.SearchScope.SOURCE), (boolean)this.scope.contains(ClassIndex.SearchScope.DEPENDENCIES));
        ClassIndex classIndex = classpathInfo.getClassIndex();
        for (String string : classIndex.getPackageNames("", true, this.scope)) {
            arrayList.add(new PackageNode(classpathInfo, string, containerNode, this.scope));
        }
        Collections.sort(arrayList, PackageNode.COMPARATOR);
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PackageType {
        Libraries,
        Source;

    }
}

