/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.toplink.essentials.internal.databaseaccess.Accessor;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.essentials.internal.parsing.ejbql.EJBQLCallQueryMechanism;
import oracle.toplink.essentials.internal.parsing.ejbql.EJBQLParserFactory;
import oracle.toplink.essentials.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;

public class EJBQLCall
implements Serializable,
Call {
    protected DatabaseQuery query;
    protected String ejbqlString;
    protected boolean isParsed;

    public EJBQLCall() {
    }

    public EJBQLCall(String ejbqlString) {
        this();
        this.ejbqlString = ejbqlString;
    }

    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery query) {
        return new EJBQLCallQueryMechanism(query, this);
    }

    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery query, DatabaseQueryMechanism mechanism) {
        return this.buildNewQueryMechanism(query);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public String getCallString() {
        return this.getEjbqlString();
    }

    public String getEjbqlString() {
        return this.ejbqlString;
    }

    private boolean getIsParsed() {
        return this.isParsed;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public String getLogString(Accessor accessor) {
        return this.getSQLString();
    }

    public String getSQLString() {
        return null;
    }

    public boolean isEJBQLCall() {
        return true;
    }

    public boolean isFinished() {
        return true;
    }

    public boolean isParsed() {
        return this.getIsParsed();
    }

    public void populateQuery(AbstractSession session) {
        if (!this.isParsed()) {
            new EJBQLParserFactory().populateQuery(this.getEjbqlString(), (ObjectLevelReadQuery)this.getQuery(), session);
            this.setIsParsed(true);
        }
    }

    public PreparedStatement prepareStatement(DatabaseAccessor accessor, AbstractRecord translationRow, AbstractSession session) throws SQLException {
        return null;
    }

    public void setEjbqlString(String newEjbqlString) {
        this.ejbqlString = newEjbqlString;
    }

    public void setIsParsed(boolean newIsParsed) {
        this.isParsed = newIsParsed;
    }

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
    }
}

