/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoBrush;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoRectangle;
import com.nwoods.jgo.JGoView;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class JGo3DNoteRect
extends JGoRectangle {
    public static final int ChangedShadowSize = 401;
    public static final int ChangedFlapSize = 402;
    private int myShadowSize = 4;
    private int myFlapSize = 8;

    public JGo3DNoteRect() {
    }

    public JGo3DNoteRect(Rectangle rect) {
        super(rect);
    }

    public JGo3DNoteRect(Point location, Dimension size) {
        super(location, size);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGo3DNoteRect newobj = (JGo3DNoteRect)super.copyObject(env);
        if (newobj != null) {
            newobj.myShadowSize = this.myShadowSize;
            newobj.myFlapSize = this.myFlapSize;
        }
        return newobj;
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGo3DNoteRect = svgDoc.createJGoClassElement("com.nwoods.jgo.JGo3DNoteRect", jGoElementGroup);
            jGo3DNoteRect.setAttribute("flapsize", Integer.toString(this.myFlapSize));
            jGo3DNoteRect.setAttribute("shadow", Integer.toString(this.myShadowSize));
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            this.setFlapSize(Integer.parseInt(jGoChildElement.getAttribute("flapsize")));
            this.setShadowSize(Integer.parseInt(jGoChildElement.getAttribute("shadow")));
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
        }
        return svgElement.getNextSibling();
    }

    public void paint(Graphics2D g, JGoView view) {
        Rectangle rect = this.getBoundingRect();
        int pad = this.getShadowSize();
        int r2x = rect.x;
        int r2y = rect.y;
        int r2width = rect.width - pad;
        int r2height = rect.height - pad;
        this.drawRect(g, r2x, r2y, r2width, r2height);
        int[] shadowx = view.getTempXs(6);
        int[] shadowy = view.getTempYs(6);
        shadowx[0] = r2x + r2width;
        shadowy[0] = r2y;
        shadowx[1] = rect.x + rect.width;
        shadowy[1] = rect.y + pad;
        shadowx[2] = rect.x + rect.width;
        shadowy[2] = rect.y + rect.height;
        shadowx[3] = rect.x + pad;
        shadowy[3] = rect.y + rect.height;
        shadowx[4] = r2x;
        shadowy[4] = r2y + r2height;
        shadowx[5] = r2x + r2width;
        shadowy[5] = r2y + r2height;
        JGo3DNoteRect.drawPolygon(g, null, JGoBrush.lightGray, shadowx, shadowy, 6);
        int flapsize = this.getFlapSize();
        shadowx[0] = r2x + r2width - flapsize;
        shadowy[0] = r2y + r2height;
        shadowx[1] = r2x + r2width - flapsize * 7 / 8;
        shadowy[1] = r2y + r2height - flapsize * 7 / 8;
        shadowx[2] = r2x + r2width;
        shadowy[2] = r2y + r2height - flapsize;
        JGo3DNoteRect.drawPolygon(g, null, JGoBrush.gray, shadowx, shadowy, 3);
    }

    public int getShadowSize() {
        return this.myShadowSize;
    }

    public void setShadowSize(int s) {
        int oldShadowSize = this.myShadowSize;
        if (oldShadowSize != s) {
            this.myShadowSize = Math.max(s, 0);
            this.update(401, oldShadowSize, null);
        }
    }

    public int getFlapSize() {
        return this.myFlapSize;
    }

    public void setFlapSize(int s) {
        int oldFlapSize = this.myFlapSize;
        if (oldFlapSize != s) {
            this.myFlapSize = Math.max(s, 0);
            this.update(402, oldFlapSize, null);
        }
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 401: {
                e.setNewValueInt(this.getShadowSize());
                return;
            }
            case 402: {
                e.setNewValueInt(this.getFlapSize());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 401: {
                this.setShadowSize(e.getValueInt(undo));
                return;
            }
            case 402: {
                this.setFlapSize(e.getValueInt(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }
}

