/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.impl.references;

import java.util.Collection;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.PartnerLinkReference;
import org.netbeans.modules.bpel.model.api.PortTypeReference;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.model.impl.references.AbstractNamedComponentReference;
import org.netbeans.modules.bpel.model.impl.references.AbstractNamedReferenceFactory;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OperationResolver
extends AbstractNamedReferenceFactory {
    OperationResolver() {
    }

    @Override
    public <T extends ReferenceableWSDLComponent> boolean isApplicable(Class<T> clazz) {
        return Operation.class.isAssignableFrom(clazz);
    }

    @Override
    public <T extends ReferenceableWSDLComponent> T resolve(AbstractNamedComponentReference<T> abstractNamedComponentReference) {
        String string = abstractNamedComponentReference.getRefString();
        Class clazz = abstractNamedComponentReference.getType();
        AbstractDocumentComponent abstractDocumentComponent = abstractNamedComponentReference.getParent();
        Collection<Operation> collection = null;
        if (abstractDocumentComponent instanceof PortTypeReference) {
            collection = this.resolveByPortType(abstractDocumentComponent);
        }
        if (collection == null || collection.size() == 0) {
            collection = this.resolveByPartnerLink(abstractDocumentComponent);
        }
        if (collection == null) {
            return null;
        }
        for (Operation operation : collection) {
            if (!string.equals(operation.getName())) continue;
            return (T)((ReferenceableWSDLComponent)clazz.cast(operation));
        }
        return null;
    }

    private Collection<Operation> resolveByPartnerLink(AbstractDocumentComponent abstractDocumentComponent) {
        if (!(abstractDocumentComponent instanceof PartnerLinkReference)) {
            return null;
        }
        BpelReference<PartnerLink> bpelReference = ((PartnerLinkReference)abstractDocumentComponent).getPartnerLink();
        NamedComponentReference<PortType> namedComponentReference = Utils.getPortTypeRef(bpelReference, (Component)abstractDocumentComponent);
        if (namedComponentReference == null) {
            return null;
        }
        PortType portType = (PortType)namedComponentReference.get();
        if (portType == null) {
            return null;
        }
        Collection collection = portType.getOperations();
        return collection;
    }

    private Collection<Operation> resolveByPortType(AbstractDocumentComponent abstractDocumentComponent) {
        WSDLReference<PortType> wSDLReference = ((PortTypeReference)abstractDocumentComponent).getPortType();
        if (wSDLReference == null) {
            return null;
        }
        PortType portType = (PortType)wSDLReference.get();
        if (portType == null) {
            return null;
        }
        Collection collection = portType.getOperations();
        return collection;
    }
}

