/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.model.api.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.bpel.model.api.support.FindVaribleVisitor;
import org.netbeans.modules.bpel.model.api.support.RefactoringReferenceFactory;
import org.netbeans.modules.bpel.model.api.support.VariableReferenceFactory;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xpath.ext.XPathException;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathModelHelper;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExpressionUpdater {
    private static ExpressionUpdater INSTANCE = new ExpressionUpdater();
    private Set<RefactoringReferenceFactory> myFactories = new HashSet<RefactoringReferenceFactory>();

    private ExpressionUpdater() {
        this.myFactories.add(new VariableReferenceFactory());
    }

    public static ExpressionUpdater getInstance() {
        return INSTANCE;
    }

    public boolean isPresent(String string, Named named) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (RefactoringReferenceFactory refactoringReferenceFactory : this.myFactories) {
            if (!refactoringReferenceFactory.isApplicable(named)) continue;
            return refactoringReferenceFactory.isPresent(string, named);
        }
        return false;
    }

    public String update(String string, Named named, String string2) {
        if (string == null || string.length() == 0) {
            return null;
        }
        for (RefactoringReferenceFactory refactoringReferenceFactory : this.myFactories) {
            if (!refactoringReferenceFactory.isApplicable(named)) continue;
            return refactoringReferenceFactory.update(string, named, string2);
        }
        return null;
    }

    public Collection<String> getUsedVariables(String string) {
        if (string == null || string.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        try {
            XPathModel xPathModel = XPathModelHelper.getInstance().newXPathModel();
            XPathExpression xPathExpression = xPathModel.parseExpression(string);
            FindVaribleVisitor findVaribleVisitor = new FindVaribleVisitor();
            xPathExpression.accept((XPathVisitor)findVaribleVisitor);
            return findVaribleVisitor.getVariables();
        }
        catch (XPathException xPathException) {
            return Collections.EMPTY_LIST;
        }
    }

    public static class InvalidExpressionException
    extends ExpressionException {
        private static final long serialVersionUID = -461547631006192178L;

        public InvalidExpressionException() {
        }

        public InvalidExpressionException(String string) {
            super(string);
        }

        public InvalidExpressionException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public InvalidExpressionException(Throwable throwable) {
            super(throwable);
        }
    }

    public static class ExpressionException
    extends Exception {
        private static final long serialVersionUID = -6309073089869606561L;

        public ExpressionException() {
        }

        public ExpressionException(String string) {
            super(string);
        }

        public ExpressionException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public ExpressionException(Throwable throwable) {
            super(throwable);
        }
    }
}

