/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common.project.ui;

import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.common.project.classpath.ClassPathSupport;
import org.netbeans.modules.j2ee.common.project.ui.ProjectProperties;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class ClassPathListCellRenderer
extends DefaultListCellRenderer {
    private static ImageIcon ICON_FOLDER = null;
    private static ImageIcon ICON_BROKEN_JAR;
    private static ImageIcon ICON_BROKEN_LIBRARY;
    private static ImageIcon ICON_BROKEN_ARTIFACT;
    private PropertyEvaluator evaluator;
    private FileObject projectFolder;
    private static final Map<String, String> WELL_KNOWN_PATHS_NAMES;

    public ClassPathListCellRenderer(PropertyEvaluator propertyEvaluator, FileObject fileObject) {
        this.evaluator = propertyEvaluator;
        this.projectFolder = fileObject;
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        if (object != null) assert (object instanceof ClassPathSupport.Item) : object.getClass().toString();
        ClassPathSupport.Item item = (ClassPathSupport.Item)object;
        super.getListCellRendererComponent((JList<?>)jList, this.getDisplayName(item), n, bl, bl2);
        this.setIcon(ClassPathListCellRenderer.getIcon(item));
        this.setToolTipText(this.getToolTipText(item));
        return this;
    }

    private String getDisplayName(ClassPathSupport.Item item) {
        switch (item.getType()) {
            case 1: {
                if (item.isBroken()) {
                    return NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_MISSING_LIBRARY", (Object)this.getLibraryName(item));
                }
                return item.getLibrary().getDisplayName();
            }
            case 3: {
                String string = WELL_KNOWN_PATHS_NAMES.get(CommonProjectUtils.getAntPropertyName((String)item.getReference()));
                return string == null ? item.getReference() : string;
            }
            case 2: {
                if (item.isBroken()) {
                    return NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_MISSING_PROJECT", (Object)this.getProjectName(item));
                }
                Project project = item.getArtifact().getProject();
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                String string = projectInformation.getDisplayName();
                return MessageFormat.format(NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"MSG_ProjectArtifactFormat"), string, item.getArtifactURI().toString());
            }
            case 0: {
                if (item.isBroken()) {
                    return NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_MISSING_FILE", (Object)this.getFileRefName(item));
                }
                if (item.getVariableBasedProperty() != null) {
                    String string = item.getVariableBasedProperty();
                    return string.substring(6, string.indexOf("}")) + string.substring(string.indexOf("}") + 1);
                }
                return item.getFilePath();
            }
        }
        return item.getReference();
    }

    static Icon getIcon(ClassPathSupport.Item item) {
        switch (item.getType()) {
            case 1: {
                if (item.isBroken()) {
                    if (ICON_BROKEN_LIBRARY == null) {
                        ICON_BROKEN_LIBRARY = new ImageIcon(ImageUtilities.mergeImages((Image)ProjectProperties.ICON_LIBRARY.getImage(), (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                    }
                    return ICON_BROKEN_LIBRARY;
                }
                return ProjectProperties.ICON_LIBRARY;
            }
            case 2: {
                if (item.isBroken()) {
                    if (ICON_BROKEN_ARTIFACT == null) {
                        ICON_BROKEN_ARTIFACT = new ImageIcon(ImageUtilities.mergeImages((Image)ProjectProperties.ICON_ARTIFACT.getImage(), (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                    }
                    return ICON_BROKEN_ARTIFACT;
                }
                Project project = item.getArtifact().getProject();
                if (project != null) {
                    ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                    return projectInformation.getIcon();
                }
                return ProjectProperties.ICON_ARTIFACT;
            }
            case 0: {
                ImageIcon imageIcon;
                if (item.isBroken()) {
                    if (ICON_BROKEN_JAR == null) {
                        ICON_BROKEN_JAR = new ImageIcon(ImageUtilities.mergeImages((Image)ProjectProperties.ICON_JAR.getImage(), (Image)ProjectProperties.ICON_BROKEN_BADGE.getImage(), (int)7, (int)7));
                    }
                    return ICON_BROKEN_JAR;
                }
                File file = item.getResolvedFile();
                ImageIcon imageIcon2 = imageIcon = file.isDirectory() ? ClassPathListCellRenderer.getFolderIcon() : ProjectProperties.ICON_JAR;
                if (item.getSourceFilePath() != null) {
                    imageIcon = new ImageIcon(ImageUtilities.mergeImages((Image)imageIcon.getImage(), (Image)ProjectProperties.ICON_SOURCE_BADGE.getImage(), (int)8, (int)8));
                }
                if (item.getJavadocFilePath() != null) {
                    imageIcon = new ImageIcon(ImageUtilities.mergeImages((Image)imageIcon.getImage(), (Image)ProjectProperties.ICON_JAVADOC_BADGE.getImage(), (int)8, (int)0));
                }
                return imageIcon;
            }
            case 3: {
                return ProjectProperties.ICON_CLASSPATH;
            }
        }
        return null;
    }

    private String getToolTipText(ClassPathSupport.Item item) {
        if (item.isBroken() && (item.getType() == 0 || item.getType() == 2)) {
            return this.evaluator.evaluate(item.getReference());
        }
        switch (item.getType()) {
            case 0: {
                File file = item.getResolvedFile();
                if (file.getPath().equals(item.getFilePath()) && item.getVariableBasedProperty() == null) break;
                return file.getPath();
            }
        }
        return null;
    }

    private static ImageIcon getFolderIcon() {
        if (ICON_FOLDER == null) {
            FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot();
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            ICON_FOLDER = new ImageIcon(dataFolder.getNodeDelegate().getIcon(1));
        }
        return ICON_FOLDER;
    }

    private String getProjectName(ClassPathSupport.Item item) {
        String string = item.getReference();
        return string.substring(12, string.indexOf(46, 12));
    }

    private String getLibraryName(ClassPathSupport.Item item) {
        String string = item.getReference();
        if (string == null) {
            if (item.getLibrary() != null) {
                return item.getLibrary().getName();
            }
            return "XXX";
        }
        return string.substring(7, string.indexOf(".classpath"));
    }

    private String getFileRefName(ClassPathSupport.Item item) {
        String string = item.getReference();
        if (string.startsWith("${file.reference.")) {
            return string.substring(17, string.length() - 1);
        }
        return string;
    }

    static {
        WELL_KNOWN_PATHS_NAMES = new HashMap<String, String>();
        WELL_KNOWN_PATHS_NAMES.put("javac.classpath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_JavacClasspath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("javac.test.classpath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_JavacTestClasspath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("run.classpath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_RunClasspath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("run.test.classpath", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_RunTestClasspath_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("build.classes.dir", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_BuildClassesDir_DisplayName"));
        WELL_KNOWN_PATHS_NAMES.put("build.test.classes.dir", NbBundle.getMessage(ClassPathListCellRenderer.class, (String)"LBL_BuildTestClassesDir_DisplayName"));
    }

    static class ClassPathTableCellRenderer
    extends DefaultTableCellRenderer {
        private ClassPathListCellRenderer renderer;

        public ClassPathTableCellRenderer(PropertyEvaluator propertyEvaluator, FileObject fileObject) {
            this.renderer = new ClassPathListCellRenderer(propertyEvaluator, fileObject);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                assert (object instanceof ClassPathSupport.Item) : object.getClass().toString();
                ClassPathSupport.Item item = (ClassPathSupport.Item)object;
                this.setIcon(ClassPathListCellRenderer.getIcon(item));
                this.setToolTipText(this.renderer.getToolTipText(item));
                return super.getTableCellRendererComponent(jTable, this.renderer.getDisplayName(item), bl, false, n, n2);
            }
            this.setIcon(null);
            return super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        }
    }
}

