/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DatasourceCustomizer
extends JPanel {
    private Dialog dialog = null;
    private DialogDescriptor descriptor = null;
    private boolean dialogOK = false;
    private HashMap<String, Datasource> datasources;
    private String jndiName;
    private String url;
    private String username;
    private String password;
    private String driverClassName;
    private MsgHelper msgHelper;
    private JComboBox connCombo;
    private JLabel errorLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField jndiNameField;

    public DatasourceCustomizer(List<Datasource> list) {
        if (list != null) {
            this.datasources = new HashMap();
            for (Datasource datasource : list) {
                if (datasource.getJndiName() == null) continue;
                this.datasources.put(datasource.getJndiName(), datasource);
            }
        }
        this.initComponents();
        this.msgHelper = new MsgHelper(this.errorLabel, DatasourceCustomizer.class);
        DatabaseExplorerUIs.connect((JComboBox)this.connCombo, (ConnectionManager)ConnectionManager.getDefault());
        this.connCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DatasourceCustomizer.this.verify();
            }
        });
        this.jndiNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                DatasourceCustomizer.this.verify();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                DatasourceCustomizer.this.verify();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                DatasourceCustomizer.this.verify();
            }
        });
    }

    public boolean showDialog() {
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(DatasourceCustomizer.class, (String)"LBL_DatasourceCustomizer"), true, 2, DialogDescriptor.OK_OPTION, 0, new HelpCtx(DatasourceCustomizer.class), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                if (DatasourceCustomizer.this.descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                    boolean bl2;
                    bl = bl2 = DatasourceCustomizer.this.handleConfirmation();
                    DatasourceCustomizer.this.dialogOK = bl2;
                }
                if (bl) {
                    DatasourceCustomizer.this.dialog.dispose();
                }
            }
        });
        this.descriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        this.verify();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.dialog.setVisible(true);
        this.repaint();
        return this.dialogOK;
    }

    private boolean handleConfirmation() {
        this.jndiName = this.jndiNameField.getText().trim();
        DatabaseConnection databaseConnection = (DatabaseConnection)this.connCombo.getSelectedItem();
        if (databaseConnection.getPassword() == null) {
            ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
        }
        if (databaseConnection.getPassword() == null) {
            this.msgHelper.setErrorMsg("ERR_NoPassword");
            return false;
        }
        this.url = databaseConnection.getDatabaseURL();
        this.username = databaseConnection.getUser();
        this.password = databaseConnection.getPassword();
        this.driverClassName = databaseConnection.getDriverClass();
        return true;
    }

    private boolean verify() {
        boolean bl = this.verifyJndiName();
        if (bl) {
            bl = this.verifyConnection();
        }
        return bl;
    }

    private boolean verifyJndiName() {
        boolean bl = true;
        String string = this.jndiNameField.getText().trim();
        if (string.length() == 0) {
            this.msgHelper.setInfoMsg("ERR_JNDI_NAME_EMPTY");
            bl = false;
        } else if (this.datasourceAlreadyExists(string)) {
            this.msgHelper.setErrorMsg("ERR_DS_EXISTS");
            bl = false;
        } else {
            this.msgHelper.setErrorMsg(null);
        }
        this.descriptor.setValid(bl);
        return bl;
    }

    private boolean verifyConnection() {
        boolean bl = true;
        if (!(this.connCombo.getSelectedItem() instanceof DatabaseConnection)) {
            this.msgHelper.setInfoMsg("ERR_NO_CONN_SELECTED");
            bl = false;
        } else {
            this.msgHelper.setErrorMsg(null);
        }
        this.descriptor.setValid(bl);
        return bl;
    }

    private boolean datasourceAlreadyExists(String string) {
        return this.datasources.containsKey(string);
    }

    String getJndiName() {
        return this.jndiName;
    }

    String getUrl() {
        return this.url;
    }

    String getUsername() {
        return this.username;
    }

    String getPassword() {
        return this.password;
    }

    String getDriverClassName() {
        return this.driverClassName;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jndiNameField = new JTextField();
        this.errorLabel = new JLabel();
        this.connCombo = new JComboBox();
        this.setForeground(new Color(255, 0, 0));
        this.jLabel1.setLabelFor(this.jndiNameField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(DatasourceCustomizer.class, (String)"LBL_DSC_JndiName"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(DatasourceCustomizer.class, (String)"LBL_DSC_DbConn"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jndiNameField, -1, 327, Short.MAX_VALUE).add((Component)this.connCombo, 0, 327, Short.MAX_VALUE))).add((Component)this.errorLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jndiNameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0, 39, Short.MAX_VALUE).add((Component)this.errorLabel)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.connCombo, -2, -1, -2).addContainerGap()))));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MsgHelper {
        private JLabel label;
        private Class<?> clazz;
        private Color nbErrorForeground;
        private Color nbWarningForeground;
        private Color nbInfoForeground;
        private ImageIcon errorIcon;
        private ImageIcon warningIcon;
        private ImageIcon infoIcon;

        MsgHelper(JLabel jLabel, Class<?> clazz) {
            this.label = jLabel;
            this.clazz = clazz;
            this.nbErrorForeground = UIManager.getColor("nb.errorForeground");
            if (this.nbErrorForeground == null) {
                this.nbErrorForeground = new Color(255, 0, 0);
            }
            this.nbWarningForeground = UIManager.getColor("nb.warningForeground");
            if (this.nbWarningForeground == null) {
                this.nbWarningForeground = new Color(0, 0, 0);
            }
            this.nbInfoForeground = this.nbWarningForeground;
            this.errorIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/common/resources/errorIcon.png"));
            this.warningIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/common/resources/warningIcon.png"));
            this.infoIcon = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/common/resources/infoIcon.png"));
        }

        void setErrorMsg(String string) {
            this.label.setForeground(this.nbErrorForeground);
            if (string != null) {
                this.label.setText(NbBundle.getMessage(this.clazz, (String)string));
                this.label.setIcon(this.errorIcon);
            } else {
                this.label.setText("");
                this.label.setIcon(null);
            }
        }

        void setWarningMsg(String string) {
            this.label.setForeground(this.nbWarningForeground);
            if (string != null) {
                this.label.setText(NbBundle.getMessage(this.clazz, (String)string));
                this.label.setIcon(this.warningIcon);
            } else {
                this.label.setText("");
                this.label.setIcon(null);
            }
        }

        void setInfoMsg(String string) {
            this.label.setForeground(this.nbInfoForeground);
            if (string != null) {
                this.label.setText(NbBundle.getMessage(this.clazz, (String)string));
                this.label.setIcon(this.infoIcon);
            } else {
                this.label.setText("");
                this.label.setIcon(null);
            }
        }
    }
}

