/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.common.palette;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.soa.mapper.common.palette.PaletteCategoryNode;
import org.netbeans.modules.soa.mapper.common.palette.PaletteItemNode;
import org.netbeans.modules.soa.mapper.common.palette.PaletteList;
import org.netbeans.modules.soa.mapper.common.palette.PaletteManager;
import org.openide.nodes.Node;

public class PalettePanel
extends JPanel {
    protected PaletteManager mManager = null;
    protected Node mPaletteNode;
    protected JTabbedPane mTabbedPane;
    protected ArrayList mAlignedLists = new ArrayList();
    private Listener mListener;
    private Set mCategories = new HashSet();
    protected Node[] mCategoryNodes = null;
    protected boolean[] mCategoryStatus = null;
    private static final String SHOW_NAMES = "SHOW_NAMES";
    private boolean mTabbedDone = false;
    private boolean mInitTabbed = false;
    private PaletteListRenderer listRenderer;
    private static Logger mLogger = Logger.getLogger(PalettePanel.class.getName());
    private static final boolean TRACE = true;

    public PalettePanel(PaletteManager paletteManager) {
        this.mManager = paletteManager;
        this.mPaletteNode = this.mManager.getRootNode();
        this.mTabbedPane = new JTabbedPane();
        this.mTabbedPane.setPreferredSize(new Dimension(410, 50));
        this.fillTabbedPane();
        this.updateTabbedPane();
        this.add(this.mTabbedPane);
        this.setLayout(new PaletteLayout(this.mTabbedPane));
    }

    public boolean isInitialized() {
        return this.mTabbedDone;
    }

    public PaletteCategoryNode getSelectedCategory() {
        int n = this.mTabbedPane.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        String string = this.mTabbedPane.getTitleAt(n);
        PaletteCategoryNode paletteCategoryNode2 = null;
        for (PaletteCategoryNode paletteCategoryNode2 : this.mCategories) {
            if (!string.equals(paletteCategoryNode2.getDisplayName())) continue;
            return paletteCategoryNode2;
        }
        return null;
    }

    public void setSelectedCategory(String string) {
        int n = this.mTabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.mTabbedPane.getTitleAt(i))) continue;
            this.mTabbedPane.setSelectedIndex(i);
            break;
        }
    }

    public int[] getCategorySelectedItemIndices(String string) {
        int n = -1;
        int n2 = this.mTabbedPane.getTabCount();
        for (int i = 0; i < n2; ++i) {
            if (!string.equals(this.mTabbedPane.getTitleAt(i))) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return null;
        }
        JList jList = (JList)this.mAlignedLists.get(n);
        return jList.getSelectedIndices();
    }

    public int getCategoryIndex(String string) {
        int n = -1;
        int n2 = this.mTabbedPane.getTabCount();
        for (int i = 0; i < n2; ++i) {
            if (!string.equals(this.mTabbedPane.getTitleAt(i))) continue;
            n = i;
            break;
        }
        return n;
    }

    public void selectAll(String string) {
        int n = this.mTabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.mTabbedPane.getTitleAt(i))) continue;
            PaletteList paletteList = (PaletteList)this.mAlignedLists.get(i);
            paletteList.addSelectionInterval(0, paletteList.getModel().getSize() - 1);
            return;
        }
    }

    public void clearAll(String string) {
        int n = this.mTabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.mTabbedPane.getTitleAt(i))) continue;
            ((PaletteList)this.mAlignedLists.get(i)).clearSelection();
            return;
        }
    }

    public void selectItem(String string, PaletteItemNode paletteItemNode) {
        int n = this.mTabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.mTabbedPane.getTitleAt(i))) continue;
            PaletteList paletteList = (PaletteList)this.mAlignedLists.get(i);
            ListModel listModel = paletteList.getModel();
            int n2 = listModel.getSize();
            for (int j = 0; j < n2; ++j) {
                if (paletteItemNode != (PaletteItemNode)listModel.getElementAt(j)) continue;
                paletteList.addSelectionInterval(j, j);
                return;
            }
        }
    }

    public void clearItem(String string, PaletteItemNode paletteItemNode) {
        int n = this.mTabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            if (!string.equals(this.mTabbedPane.getTitleAt(i))) continue;
            PaletteList paletteList = (PaletteList)this.mAlignedLists.get(i);
            ListModel listModel = paletteList.getModel();
            int n2 = listModel.getSize();
            for (int j = 0; j < n2; ++j) {
                if (paletteItemNode != (PaletteItemNode)listModel.getElementAt(j)) continue;
                paletteList.removeSelectionInterval(j, j);
                return;
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.mListener == null) {
            this.mListener = new Listener();
            this.mManager.addPropertyChangeListener(this.mListener);
            this.mTabbedPane.addChangeListener(this.mListener);
            this.mTabbedPane.addMouseListener(this.mListener);
        }
        this.mTabbedPane.setSelectedIndex(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillTabbedPane() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.mInitTabbed) {
                return;
            }
            this.mCategoryNodes = this.mManager.getCategoryNodes();
            if (this.mCategoryNodes == null) {
                return;
            }
            if (this.mCategoryNodes.length < 1) {
                return;
            }
            this.mCategoryStatus = new boolean[this.mCategoryNodes.length];
            this.mTabbedPane.removeAll();
            this.mAlignedLists.clear();
            this.mCategories.clear();
            for (int i = 0; i < this.mCategoryNodes.length; ++i) {
                Node node = this.mCategoryNodes[i];
                this.mCategories.add(node);
                JPanel jPanel = new JPanel();
                this.mTabbedPane.addTab(node.getDisplayName(), null, jPanel);
                this.mCategoryStatus[i] = false;
            }
        }
        this.mTabbedPane.revalidate();
        this.mTabbedPane.repaint();
        this.mInitTabbed = true;
        this.updateShowNames(this.mManager.getShowComponentsNames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTabbedPane() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (!this.mInitTabbed) {
                this.fillTabbedPane();
            }
            int n = this.mCategoryNodes.length;
            for (int i = 0; i < this.mCategoryNodes.length; ++i) {
                Node node = this.mCategoryNodes[i];
                this.mCategories.add(node);
                Component component = this.createPaletteTab(i, node);
                this.mTabbedPane.setComponentAt(i, component);
            }
        }
        this.mTabbedPane.revalidate();
        this.mTabbedPane.repaint();
        this.mTabbedDone = true;
        this.mManager.setInitialized(this.mTabbedDone);
    }

    private Component createPaletteTab(int n, Node node) {
        PaletteList paletteList = this.createCategoryList(node);
        this.mAlignedLists.add(n, paletteList);
        JScrollPane jScrollPane = new JScrollPane(){

            public void setBorder(Border border) {
            }
        };
        jScrollPane.setViewportView(paletteList);
        ListModel listModel = paletteList.getModel();
        int n2 = listModel.getSize();
        for (int i = 0; i < n2; ++i) {
            PaletteItemNode paletteItemNode = (PaletteItemNode)listModel.getElementAt(i);
            Boolean bl = (Boolean)paletteItemNode.getItemAttribute("Checked");
            if (bl == null || !bl.booleanValue()) continue;
            paletteList.addSelectionInterval(i, i);
        }
        return jScrollPane;
    }

    private PaletteList createCategoryList(Node node) {
        PaletteList paletteList = new PaletteList(this.mManager);
        paletteList.setListData(this.mManager.getItemNodes(node));
        paletteList.setOpaque(false);
        paletteList.setAlignStyle(0);
        paletteList.setVisibleRowCount(2);
        paletteList.addListSelectionListener(this.mListener);
        paletteList.addMouseListener(this.mListener);
        if (this.listRenderer == null) {
            this.listRenderer = new PaletteListRenderer();
            this.listRenderer.setShowNames(this.mManager.getShowComponentsNames());
        }
        paletteList.setCellRenderer(this.listRenderer);
        ToolTipManager.sharedInstance().registerComponent(paletteList);
        paletteList.getAccessibleContext().setAccessibleName(MessageFormat.format(PaletteManager.getBundle().getString("ACS_PaletteBeansList"), node.getDisplayName()));
        paletteList.getAccessibleContext().setAccessibleDescription(PaletteManager.getBundle().getString("ACSD_PaletteBeansList"));
        return paletteList;
    }

    private void clearSelection() {
        for (int i = 0; i < this.mAlignedLists.size(); ++i) {
            ((PaletteList)this.mAlignedLists.get(i)).clearSelection();
        }
    }

    private void revalidateLists() {
        for (int i = 0; i < this.mAlignedLists.size(); ++i) {
            PaletteList paletteList = (PaletteList)this.mAlignedLists.get(i);
            paletteList.setSize(0, 0);
            if (i != this.mTabbedPane.getSelectedIndex()) continue;
            paletteList.revalidate();
            paletteList.repaint();
        }
    }

    public void updateShowNames(boolean bl) {
        if (this.listRenderer != null) {
            this.listRenderer.setShowNames(bl);
            this.revalidateLists();
        }
    }

    private static void t(String string) {
        if (string != null) {
            mLogger.fine("-----=====> PalettePanel: [" + Thread.currentThread().getName() + "] " + string);
        } else {
            mLogger.fine("");
        }
    }

    private static class PaletteLayout
    implements LayoutManager {
        private Component buttons = null;
        private Component tabs;

        public PaletteLayout(Component component) {
            this.tabs = component;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Insets insets = container.getInsets();
                int n = insets.top;
                int n2 = container.getHeight() - insets.bottom;
                int n3 = insets.left;
                int n4 = container.getWidth() - insets.right;
                int n5 = n2 - n;
                int n6 = n4 - n3;
                if (this.buttons != null) {
                    Dimension dimension = this.buttons.getPreferredSize();
                    if (dimension.width * n5 >= dimension.height * n6) {
                        this.buttons.setBounds(n3, n, n6, dimension.height);
                        n += dimension.height;
                        n5 -= dimension.height;
                    } else {
                        this.buttons.setBounds(n3, n + 5, dimension.width, n5 - 5);
                        n3 += dimension.width;
                        n6 -= dimension.width;
                    }
                }
                if (this.tabs != null) {
                    this.tabs.setBounds(n3, n, n6, n5);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Cloneable cloneable;
                Dimension dimension = new Dimension();
                if (this.buttons != null) {
                    cloneable = this.buttons.getPreferredSize();
                    dimension.width += cloneable.width;
                }
                if (this.tabs != null) {
                    cloneable = this.tabs.getPreferredSize();
                    dimension.width += cloneable.width;
                    dimension.height = cloneable.height;
                }
                cloneable = container.getInsets();
                dimension.width += ((Insets)cloneable).left + ((Insets)cloneable).right;
                dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
                return dimension;
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    PropertyChangeListener,
    ChangeListener,
    ListSelectionListener {
        private Listener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            if (actionEvent.getActionCommand().equals(PalettePanel.SHOW_NAMES)) {
                PalettePanel.this.listRenderer.setShowNames(jCheckBoxMenuItem.isSelected());
                PalettePanel.this.mManager.setShowComponentsNames(jCheckBoxMenuItem.isSelected());
            }
            PalettePanel.this.revalidateLists();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            PaletteList paletteList;
            int n = PalettePanel.this.mTabbedPane.getSelectedIndex();
            if (n >= 0 && n < PalettePanel.this.mAlignedLists.size() && (paletteList = (PaletteList)PalettePanel.this.mAlignedLists.get(n)) != null) {
                int n2 = paletteList.getCurSelectedIndex();
                PalettePanel.this.mManager.setSelectedItem(n2 < 0 ? null : (PaletteItemNode)paletteList.getModel().getElementAt(n2));
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("Palette_selectedItem".equals(propertyChangeEvent.getPropertyName())) {
                // empty if block
            }
        }
    }

    private static class PaletteListRenderer
    implements ListCellRenderer {
        private DoCheckBox button = new DoCheckBox();
        private Border buttonBorder;
        private Border emptyBorder;
        private int iconSize;
        private boolean showNames = true;
        private Color defaultColor;

        public PaletteListRenderer() {
            this.button.setMargin(new Insets(1, 1, 1, 1));
            this.buttonBorder = this.button.getBorder();
            this.defaultColor = this.button.getBackground();
            if (this.buttonBorder != null) {
                this.emptyBorder = new EmptyBorder(this.buttonBorder.getBorderInsets(this.button));
            }
            this.setIconSize(1);
            this.setShowNames(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Node node = (Node)object;
            if (this.showNames) {
                this.button.setText(node.getDisplayName());
            }
            this.button.setIcon(new ImageIcon(node.getIcon(this.iconSize)));
            this.button.setSelected(bl);
            this.button.setBackground(n == ((PaletteList)jList).getCurSelectedIndex() ? Color.YELLOW : this.defaultColor);
            this.button.setToolTipText(node.getShortDescription().replace('-', '.'));
            return this.button;
        }

        public void setIconSize(int n) {
            this.iconSize = n;
        }

        public int getIconSize() {
            return this.iconSize;
        }

        public void setShowNames(boolean bl) {
            if (!bl) {
                this.button.setText("     ");
            }
            this.showNames = bl;
            this.setIconSize(this.getIconSize());
        }

        public boolean isShowNames() {
            return this.showNames;
        }
    }

    private static class DoCheckBox
    extends JPanel {
        private JCheckBox jc;
        private JLabel jb;
        private ItemListener iListener;

        public DoCheckBox() {
            this.setLayout(new BorderLayout(0, 1));
            this.jc = new JCheckBox();
            this.jb = new JLabel();
            this.jb.setHorizontalAlignment(2);
            this.add((Component)this.jc, "West");
            this.add((Component)this.jb, "Center");
            this.add((Component)new JLabel("   "), "East");
        }

        public void setMargin(Insets insets) {
        }

        public void setIcon(Icon icon) {
            this.jb.setIcon(icon);
        }

        public void setText(String string) {
            this.jb.setText(string);
        }

        public void setSelected(boolean bl) {
            this.jc.setSelected(bl);
        }
    }
}

