/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.mapper.basicmapper.dnd;

import java.awt.Component;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import org.netbeans.modules.soa.mapper.common.basicmapper.dnd.IDnDHandler;

public final class ComponentDnDHandler
implements DragGestureListener,
DropTargetListener,
DragSourceListener {
    private Component mComp;
    private DropTarget mDropTarget;
    private DragGestureRecognizer mRecognizer;
    private IDnDHandler mHandler;

    public void setHandler(IDnDHandler iDnDHandler) {
        this.mHandler = iDnDHandler;
    }

    public IDnDHandler getHandler() {
        return this.mHandler;
    }

    public void setComponent(Component component) {
        if (this.mComp != null) {
            this.mRecognizer.removeDragGestureListener(this);
            this.mDropTarget.removeDropTargetListener(this);
            DragSource.getDefaultDragSource().removeDragSourceListener(this);
            this.mComp.setDropTarget(null);
            this.mRecognizer = null;
            this.mDropTarget = null;
        }
        this.mComp = component;
        if (this.mComp != null) {
            this.mRecognizer = DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.mComp, 3, this);
            DragSource.getDefaultDragSource().addDragSourceListener(this);
            this.mDropTarget = new DropTarget(this.mComp, this);
            this.mComp.setDropTarget(this.mDropTarget);
        }
    }

    public DropTarget getDropTarget() {
        return this.mDropTarget;
    }

    public DragGestureRecognizer getDragGestureRecognizer() {
        return this.mRecognizer;
    }

    public DragSource getDragSource() {
        if (this.mComp == null) {
            return null;
        }
        return DragSource.getDefaultDragSource();
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.mHandler != null && this.mHandler.getDropTargetListener() != null) {
            this.mHandler.getDropTargetListener().dragEnter(dropTargetDragEvent);
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.mHandler != null && this.mHandler.getDropTargetListener() != null) {
            this.mHandler.getDropTargetListener().dragExit(dropTargetEvent);
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        if (this.mHandler != null && this.mHandler.getDragGestureListener() != null) {
            this.mHandler.getDragGestureListener().dragGestureRecognized(dragGestureEvent);
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.mHandler != null && this.mHandler.getDropTargetListener() != null) {
            this.mHandler.getDropTargetListener().dragOver(dropTargetDragEvent);
        }
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.mHandler != null && this.mHandler.getDropTargetListener() != null) {
            this.mHandler.getDropTargetListener().drop(dropTargetDropEvent);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.mHandler != null && this.mHandler.getDropTargetListener() != null) {
            this.mHandler.getDropTargetListener().dropActionChanged(dropTargetDragEvent);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
        if (this.mHandler != null && this.mHandler.getDragSourceListener() != null) {
            this.mHandler.getDragSourceListener().dragDropEnd(dragSourceDropEvent);
        }
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        if (this.mHandler != null && this.mHandler.getDragSourceListener() != null) {
            this.mHandler.getDragSourceListener().dragEnter(dragSourceDragEvent);
        }
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
        if (this.mHandler != null && this.mHandler.getDragSourceListener() != null) {
            this.mHandler.getDragSourceListener().dragExit(dragSourceEvent);
        }
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        if (this.mHandler != null && this.mHandler.getDragSourceListener() != null) {
            this.mHandler.getDragSourceListener().dragOver(dragSourceDragEvent);
        }
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        if (this.mHandler != null && this.mHandler.getDragSourceListener() != null) {
            this.mHandler.getDragSourceListener().dropActionChanged(dragSourceDragEvent);
        }
    }
}

