/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.Stack;
import proguard.evaluation.Variables;
import proguard.evaluation.value.Value;
import proguard.optimize.info.ParameterUsageMarker;

public class UnusedParameterInvocationUnit
extends SimplifiedVisitor
implements InvocationUnit,
ConstantVisitor,
MemberVisitor {
    private static final boolean DEBUG = false;
    private final InvocationUnit invocationUnit;
    private Stack stack;

    public UnusedParameterInvocationUnit(InvocationUnit invocationUnit) {
        this.invocationUnit = invocationUnit;
    }

    public void enterMethod(Clazz clazz, Method method, Variables variables) {
        this.invocationUnit.enterMethod(clazz, method, variables);
    }

    public void exitMethod(Clazz clazz, Method method, Value value) {
        this.invocationUnit.exitMethod(clazz, method, value);
    }

    public void invokeMember(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction, Stack stack) {
        this.stack = stack;
        clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        this.invocationUnit.invokeMember(clazz, method, codeAttribute, n, constantInstruction, stack);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        refConstant.referencedMemberAccept(this);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int n = ParameterUsageMarker.getParameterSize(programMethod);
        for (int i = 0; i < n; ++i) {
            if (ParameterUsageMarker.isParameterUsed(programMethod, i)) continue;
            this.stack.removeTop(n - i - 1);
        }
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
    }
}

