/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;

public class MethodBreakpoint
extends JPDABreakpoint {
    public static final String PROP_METHOD_NAME = "methodName";
    public static final String PROP_METHOD_SIGNATURE = "signature";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointtType";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_CLASS_FILTERS = "classFilters";
    public static final String PROP_CLASS_EXCLUSION_FILTERS = "classExclusionFilters";
    public static final String PROP_INSTANCE_FILTERS = "instanceFilters";
    public static final String PROP_THREAD_FILTERS = "threadFilters";
    public static final int TYPE_METHOD_ENTRY = 1;
    public static final int TYPE_METHOD_EXIT = 2;
    private String[] classFilters = new String[0];
    private String[] classExclusionFilters = new String[0];
    private String methodName = "";
    private String methodSignature;
    private int breakpointType = 1;
    private String condition = "";
    private Map<JPDADebugger, ObjectVariable[]> instanceFilters;
    private Map<JPDADebugger, JPDAThread[]> threadFilters;

    private MethodBreakpoint() {
    }

    public static MethodBreakpoint create(String string, String string2) {
        MethodBreakpointImpl methodBreakpointImpl = new MethodBreakpointImpl();
        methodBreakpointImpl.setClassFilters(new String[]{string});
        methodBreakpointImpl.setMethodName(string2);
        return methodBreakpointImpl;
    }

    public static MethodBreakpoint create() {
        MethodBreakpointImpl methodBreakpointImpl = new MethodBreakpointImpl();
        return methodBreakpointImpl;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string == this.methodName || string != null && this.methodName != null && this.methodName.equals(string)) {
            return;
        }
        String string2 = this.methodName;
        this.methodName = string;
        this.firePropertyChange(PROP_METHOD_NAME, string2, string);
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public void setMethodSignature(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string == this.methodSignature || string != null && string.equals(this.methodSignature)) {
            return;
        }
        String string2 = this.methodSignature;
        this.methodSignature = string;
        this.firePropertyChange(PROP_METHOD_SIGNATURE, string2, string);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String string) {
        if (string != null) {
            string = string.trim();
        }
        String string2 = this.condition;
        this.condition = string;
        this.firePropertyChange(PROP_CONDITION, string2, string);
    }

    public int getBreakpointType() {
        return this.breakpointType;
    }

    public void setBreakpointType(int n) {
        if (n == this.breakpointType) {
            return;
        }
        if ((n & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.breakpointType;
        this.breakpointType = n;
        this.firePropertyChange(PROP_BREAKPOINT_TYPE, new Integer(n2), new Integer(n));
    }

    public String[] getClassFilters() {
        return this.classFilters;
    }

    public void setClassFilters(String[] stringArray) {
        if (stringArray == this.classFilters) {
            return;
        }
        String[] stringArray2 = this.classFilters;
        this.classFilters = stringArray;
        this.firePropertyChange(PROP_CLASS_FILTERS, stringArray2, stringArray);
    }

    public String[] getClassExclusionFilters() {
        return this.classExclusionFilters;
    }

    public void setClassExclusionFilters(String[] stringArray) {
        if (stringArray == this.classExclusionFilters) {
            return;
        }
        String[] stringArray2 = this.classExclusionFilters;
        this.classExclusionFilters = stringArray;
        this.firePropertyChange(PROP_CLASS_EXCLUSION_FILTERS, stringArray2, stringArray);
    }

    public ObjectVariable[] getInstanceFilters(JPDADebugger jPDADebugger) {
        if (this.instanceFilters != null) {
            return this.instanceFilters.get(jPDADebugger);
        }
        return null;
    }

    public void setInstanceFilters(JPDADebugger jPDADebugger, ObjectVariable[] objectVariableArray) {
        Object[] objectArray;
        if (this.instanceFilters == null) {
            this.instanceFilters = new WeakHashMap<JPDADebugger, ObjectVariable[]>();
        }
        if (objectVariableArray != null) {
            this.instanceFilters.put(jPDADebugger, objectVariableArray);
        } else {
            this.instanceFilters.remove(jPDADebugger);
        }
        if (objectVariableArray != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = jPDADebugger;
            objectArray = objectArray2;
            objectArray2[1] = objectVariableArray;
        } else {
            objectArray = null;
        }
        this.firePropertyChange(PROP_INSTANCE_FILTERS, null, objectArray);
    }

    public JPDAThread[] getThreadFilters(JPDADebugger jPDADebugger) {
        if (this.threadFilters != null) {
            return this.threadFilters.get(jPDADebugger);
        }
        return null;
    }

    public void setThreadFilters(JPDADebugger jPDADebugger, JPDAThread[] jPDAThreadArray) {
        Object[] objectArray;
        if (this.threadFilters == null) {
            this.threadFilters = new WeakHashMap<JPDADebugger, JPDAThread[]>();
        }
        if (jPDAThreadArray != null) {
            this.threadFilters.put(jPDADebugger, jPDAThreadArray);
        } else {
            this.threadFilters.remove(jPDADebugger);
        }
        if (jPDAThreadArray != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = jPDADebugger;
            objectArray = objectArray2;
            objectArray2[1] = jPDAThreadArray;
        } else {
            objectArray = null;
        }
        this.firePropertyChange(PROP_THREAD_FILTERS, null, objectArray);
    }

    public String toString() {
        return "MethodBreakpoint " + Arrays.asList(this.classFilters).toString() + "." + this.methodName + (this.methodSignature != null ? " '" + this.methodSignature + "'" : "");
    }

    private static final class MethodBreakpointImpl
    extends MethodBreakpoint
    implements ChangeListener {
        private MethodBreakpointImpl() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (!(object instanceof Breakpoint.VALIDITY)) {
                throw new UnsupportedOperationException(changeEvent.toString());
            }
            this.setValidity((Breakpoint.VALIDITY)object, changeEvent.toString());
        }
    }
}

