/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jbi.ui.common;

import com.sun.jbi.ui.common.DOMUtil;
import com.sun.jbi.ui.common.I18NBundle;
import com.sun.jbi.ui.common.JBIManagementMessage;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

public class JBIResultXmlBuilder {
    public static final boolean SUCCESS_RESULT = true;
    public static final boolean FAILED_RESULT = false;
    public static final String INFO_MSG_TYPE = "INFO";
    public static final String WARNING_MSG_TYPE = "WARNING";
    public static final String ERROR_MSG_TYPE = "ERROR";
    public static final String DEFAULT_TASK_ID = "UI_COMMON_TASK";
    public static final String DEFAULT_MSG_CODE = "UICMN0000";
    private static final String JBI_MGMT_XML_BEGIN = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><jbi-task version=\"1.0\" xmlns=\"http://java.sun.com/xml/ns/jbi/management-message\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" > <jbi-task-result><frmwk-task-result><frmwk-task-result-details><task-result-details>";
    private static final String JBI_MGMT_XML_END = "</task-result-details><locale></locale></frmwk-task-result-details><is-cause-framework>YES</is-cause-framework></frmwk-task-result></jbi-task-result></jbi-task>";
    private static JBIResultXmlBuilder sJbiResultXmlBuilder = null;

    protected JBIResultXmlBuilder() {
    }

    public static JBIResultXmlBuilder getInstance() {
        if (sJbiResultXmlBuilder == null) {
            sJbiResultXmlBuilder = new JBIResultXmlBuilder();
        }
        return sJbiResultXmlBuilder;
    }

    protected List flatExceptionChain(Throwable ex) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        list.add(ex);
        for (Throwable cause = ex.getCause(); cause != null; cause = cause.getCause()) {
            list.add(cause);
        }
        return list;
    }

    protected String getTaskInfoXml(String taskId, boolean successResult, String msgType) {
        String taskResult = successResult ? "SUCCESS" : "FAILED";
        return "<task-id>" + taskId + "</task-id>" + "<task-result>" + taskResult + "</task-result>" + "<message-type>" + msgType + "</message-type>";
    }

    protected String getMsgLocInfoXml(String msgCode, String msg, Object[] args) {
        StringBuffer buff = new StringBuffer();
        buff.append("<msg-loc-info><loc-token>" + msgCode + "</loc-token>" + "<loc-message>" + DOMUtil.replaceXmlEscapeCharsToEntityRefereces(msg) + "</loc-message>");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                buff.append("<loc-param>" + args[i] + "</loc-param>");
            }
        }
        buff.append("</msg-loc-info>");
        return buff.toString();
    }

    protected String getTaskStatusMsgXml(String msgCode, String msg, Object[] args) {
        return "<task-status-msg>" + this.getMsgLocInfoXml(msgCode, msg, args) + "</task-status-msg>";
    }

    protected String getExceptionStackTrace(Throwable ex) {
        StringWriter buff = new StringWriter();
        PrintWriter out = new PrintWriter(buff);
        String stackTrace = "";
        StackTraceElement[] stEl = ex.getStackTrace();
        if (stEl == null || stEl.length == 0) {
            return stackTrace;
        }
        for (int i = 0; i < stEl.length; ++i) {
            out.println(stEl[i].toString());
        }
        out.close();
        stackTrace = buff.getBuffer().toString();
        return stackTrace;
    }

    protected String getExceptionInfoXml(String msgCode, int nestingLevel, Throwable ex) {
        String stackTrace = this.getExceptionStackTrace(ex);
        return "<exception-info><nesting-level>" + nestingLevel + "</nesting-level>" + this.getMsgLocInfoXml(msgCode, ex.getMessage(), null) + "<stack-trace>" + DOMUtil.replaceXmlEscapeCharsToEntityRefereces(stackTrace) + "</stack-trace>" + "</exception-info>";
    }

    protected String getExceptionInfoXml(String msgCode, String locMsg, int nestingLevel, String stackTrace) {
        return "<exception-info><nesting-level>" + nestingLevel + "</nesting-level>" + this.getMsgLocInfoXml(msgCode, locMsg, null) + "<stack-trace>" + stackTrace + "</stack-trace>" + "</exception-info>";
    }

    protected String getChainedExceptionInfoXml(String msgCode, Throwable ex) {
        StringBuffer buff = new StringBuffer();
        if (msgCode == null) {
            msgCode = DEFAULT_MSG_CODE;
        }
        List list = this.flatExceptionChain(ex);
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            buff.append(this.getExceptionInfoXml(msgCode, i + 1, (Throwable)list.get(i)));
        }
        return buff.toString();
    }

    public String createJbiResultXml(String taskId, boolean successResult, String msgType, String msgCode, String msg, Object[] args, Throwable ex) {
        StringBuffer buff = new StringBuffer();
        buff.append(JBI_MGMT_XML_BEGIN);
        buff.append(this.getTaskInfoXml(taskId, successResult, msgType));
        buff.append(this.getTaskStatusMsgXml(msgCode, msg, args));
        if (ex != null) {
            String expMsgCode = DEFAULT_MSG_CODE;
            if (msg == null) {
                expMsgCode = msgCode;
            }
            buff.append(this.getChainedExceptionInfoXml(expMsgCode, ex));
        }
        buff.append(JBI_MGMT_XML_END);
        return buff.toString();
    }

    public String createJbiResultXml(String taskId, boolean successResult, String msgType, String msgCode, String msg, Object[] args) {
        return this.createJbiResultXml(taskId, successResult, msgType, msgCode, msg, args, null);
    }

    public String createJbiResultXml(String taskId, String msgCode, Throwable ex) {
        return this.createJbiResultXml(taskId, false, ERROR_MSG_TYPE, msgCode, null, null, ex);
    }

    public static String createJbiResultXml(I18NBundle i18nBundle, String i18nKey, Object[] args, String taskId, boolean successResult, String msgType, Throwable ex) {
        String msgCode = i18nBundle.getMessage(i18nKey + ".ID");
        String msg = i18nBundle.getMessage(i18nKey, args);
        String jbiResultXml = JBIResultXmlBuilder.getInstance().createJbiResultXml(taskId, successResult, msgType, msgCode, msg, args, ex);
        if (jbiResultXml == null) {
            return msg;
        }
        return jbiResultXml;
    }

    public static String createJbiResultXml(I18NBundle i18nBundle, String i18nKey, Object[] args, Throwable ex) {
        return JBIResultXmlBuilder.createJbiResultXml(i18nBundle, i18nKey, args, "JBI_UI_COMMON_TASKS", false, ERROR_MSG_TYPE, ex);
    }

    public String createJbiResultXml(JBIManagementMessage msg) {
        String resultXml = null;
        if (msg != null) {
            JBIManagementMessage.FrameworkTaskResult fwkRslt = msg.getFrameworkTaskResult();
            JBIManagementMessage.TaskResultInfo tskRsltInfo = fwkRslt.getTaskResultInfo();
            StringBuffer jbiXmlBuf = new StringBuffer(JBI_MGMT_XML_BEGIN);
            jbiXmlBuf.append(this.getTaskInfoXml(tskRsltInfo.getTaskId(), msg.isSuccessMsg(), tskRsltInfo.getMessageType()));
            List msgInfos = tskRsltInfo.getStatusMessageInfoList();
            for (JBIManagementMessage.MessageInfo msgInfo : msgInfos) {
                Object[] params = new Object[msgInfo.getl10nMsgParams().size()];
                params = msgInfo.getl10nMsgParams().toArray(params);
                jbiXmlBuf.append(this.getTaskStatusMsgXml(msgInfo.getI18nId(), msgInfo.getLocalizedMsg(), params));
            }
            List exInfos = tskRsltInfo.getExceptionInfoList();
            for (JBIManagementMessage.ExceptionInfo exInfo : exInfos) {
                jbiXmlBuf.append(this.getExceptionInfoXml(exInfo.getMessageInfo().getI18nId(), exInfo.getMessageInfo().getLocalizedMsg(), exInfo.getLevel(), exInfo.getFormattedStackTrace()));
            }
            jbiXmlBuf.append(JBI_MGMT_XML_END);
            resultXml = jbiXmlBuf.toString();
        }
        return resultXml;
    }

    public static String createFailedJbiResultXml(I18NBundle i18nBundle, String i18nKey, Object[] args) {
        return JBIResultXmlBuilder.createJbiResultXml(i18nBundle, i18nKey, args, "JBI_UI_COMMON_TASKS", false, ERROR_MSG_TYPE, null);
    }
}

