/*
 * Decompiled with CFR 0.152.
 */
package com.sun.esb.management.common.data.helper;

import com.sun.esb.management.common.data.ApplicationVerificationReport;
import com.sun.esb.management.common.data.EndpointInformation;
import com.sun.esb.management.common.data.JavaEEVerifierReport;
import com.sun.esb.management.common.data.helper.ApplicationVerificationReportReader;
import com.sun.esb.management.common.data.helper.ApplicationVerificationReportXMLConstants;
import com.sun.esb.management.common.data.helper.PerformanceDataMapWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ApplicationVerificationReportWriter
implements ApplicationVerificationReportXMLConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    static final String FILE_NAME_KEY = "ApplicationVerificationReport.xml";

    public static void writeToFile(Document document, String directoryPath) throws TransformerConfigurationException, TransformerException, Exception {
        File file = new File(directoryPath);
        if (!file.isDirectory() || !file.exists()) {
            throw new Exception("Directory Path: " + directoryPath + " is invalid.");
        }
        String fileLocation = file.getAbsolutePath() + File.separator + FILE_NAME_KEY;
        System.out.println("Writing out to file: " + fileLocation);
        File outputFile = new File(fileLocation);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(outputFile);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(File aFile, String aContents) throws FileNotFoundException, IOException {
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            aFile.createNewFile();
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + aFile);
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + aFile);
        }
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(aFile));
            output.write(aContents);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static String serialize(ApplicationVerificationReport report) throws ParserConfigurationException, TransformerException {
        Document document = null;
        PerformanceDataMapWriter writer = new PerformanceDataMapWriter();
        if (report != null) {
            Element javaEEVerifierReportsElementChild;
            Element endpointInformationListElementChild;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("ApplicationVerificationReport");
            root.setAttribute("xmlns", "http://java.sun.com/xml/ns/esb/management/ApplicationVerificationReport");
            root.setAttribute("version", "1.0");
            Element serviceAssemblyNameElementChild = document.createElement("ServiceAssemblyName");
            if (serviceAssemblyNameElementChild != null) {
                serviceAssemblyNameElementChild.setTextContent(report.getServiceAssemblyName());
            }
            root.appendChild(serviceAssemblyNameElementChild);
            Element serviceAssemblyDescriptionElementChild = document.createElement("ServiceAssemblyDescription");
            if (serviceAssemblyDescriptionElementChild != null) {
                serviceAssemblyDescriptionElementChild.setTextContent(report.getServiceAssemblyDescription());
            }
            root.appendChild(serviceAssemblyDescriptionElementChild);
            Element numberOfServiceUnitsElementChild = document.createElement("NumberOfServiceUnits");
            if (numberOfServiceUnitsElementChild != null) {
                numberOfServiceUnitsElementChild.setTextContent(report.getNumberOfServiceUnits() + "");
            }
            root.appendChild(numberOfServiceUnitsElementChild);
            Element allComponentsInstalledElementChild = document.createElement("AllComponentsInstalled");
            if (allComponentsInstalledElementChild != null) {
                allComponentsInstalledElementChild.setTextContent(report.areAllComponentsInstalled() + "");
            }
            root.appendChild(allComponentsInstalledElementChild);
            Element templateZipIdElementChild = document.createElement("TemplateZIPID");
            if (templateZipIdElementChild != null) {
                templateZipIdElementChild.setTextContent(report.getTemplateDirectory());
            }
            root.appendChild(templateZipIdElementChild);
            Element missingComponentsElementChild = ApplicationVerificationReportWriter.createMissingComponentsList(document, report);
            if (missingComponentsElementChild != null) {
                root.appendChild(missingComponentsElementChild);
            }
            if ((endpointInformationListElementChild = ApplicationVerificationReportWriter.createEndpointInformationList(document, report)) != null) {
                root.appendChild(endpointInformationListElementChild);
            }
            if (report.getJavaEEVerifierReports().size() > 0 && (javaEEVerifierReportsElementChild = ApplicationVerificationReportWriter.createJavaEEVerifierReports(document, report)) != null) {
                root.appendChild(javaEEVerifierReportsElementChild);
            }
            document.appendChild(root);
        }
        return writer.writeToString(document);
    }

    protected static Element createMissingComponentsList(Document document, ApplicationVerificationReport data) {
        Element missingComponentsListElement = null;
        if (document != null && data != null) {
            missingComponentsListElement = document.createElement("MissingComponentsList");
            for (String missingComponentName : data.getMissingComponentsList()) {
                Element missingComponentNameElementChild = document.createElement("MissingComponentName");
                if (missingComponentNameElementChild != null) {
                    missingComponentNameElementChild.setTextContent(missingComponentName);
                }
                missingComponentsListElement.appendChild(missingComponentNameElementChild);
            }
        }
        return missingComponentsListElement;
    }

    protected static Element createEndpointInformationList(Document document, ApplicationVerificationReport data) {
        Element endpointInformationListElement = null;
        if (document != null && data != null) {
            endpointInformationListElement = document.createElement("EndpointInformationList");
            for (EndpointInformation endpointInformation : data.getEndpointInformationList()) {
                Element endpointElementChild = ApplicationVerificationReportWriter.createEndpointInformation(document, endpointInformation);
                if (endpointElementChild == null) continue;
                endpointInformationListElement.appendChild(endpointElementChild);
            }
        }
        return endpointInformationListElement;
    }

    protected static Element createEndpointInformation(Document document, EndpointInformation data) {
        Element endpointInformationElement = null;
        if (document != null && data != null) {
            endpointInformationElement = document.createElement("Endpoint");
            Element endpointNameElementChild = document.createElement("EndpointName");
            if (endpointNameElementChild != null) {
                endpointNameElementChild.setTextContent(data.getEndpointName());
            }
            endpointInformationElement.appendChild(endpointNameElementChild);
            Element serviceUnitNameElementChild = document.createElement("ServiceUnitName");
            if (serviceUnitNameElementChild != null) {
                serviceUnitNameElementChild.setTextContent(data.getServiceUnitName());
            }
            endpointInformationElement.appendChild(serviceUnitNameElementChild);
            Element componentNameElementChild = document.createElement("ComponentName");
            if (componentNameElementChild != null) {
                componentNameElementChild.setTextContent(data.getComponentName());
            }
            endpointInformationElement.appendChild(componentNameElementChild);
            Element statusElementChild = document.createElement("Status");
            if (statusElementChild != null) {
                statusElementChild.setTextContent(data.getStatus());
            }
            endpointInformationElement.appendChild(statusElementChild);
            Element missingAppVarsElementChild = document.createElement("MissingApplicationVariables");
            String[] missingAppVars = data.getMissingApplicationVariables();
            if (missingAppVars != null && missingAppVars.length > 0) {
                for (int i = 0; i < missingAppVars.length; ++i) {
                    Element appVariableElementChild = document.createElement("ApplicationVariable");
                    if (appVariableElementChild != null) {
                        appVariableElementChild.setTextContent(missingAppVars[i]);
                    }
                    missingAppVarsElementChild.appendChild(appVariableElementChild);
                }
            }
            endpointInformationElement.appendChild(missingAppVarsElementChild);
            Element missingAppConfigsElementChild = document.createElement("MissingApplicationConfigurations");
            String[] missingAppConfigs = data.getMissingApplicationConfigurations();
            if (missingAppConfigs != null && missingAppConfigs.length > 0) {
                for (int i = 0; i < missingAppConfigs.length; ++i) {
                    Element appConfigurationElementChild = document.createElement("ApplicationConfiguration");
                    if (appConfigurationElementChild != null) {
                        appConfigurationElementChild.setTextContent(missingAppConfigs[i]);
                    }
                    missingAppConfigsElementChild.appendChild(appConfigurationElementChild);
                }
            }
            endpointInformationElement.appendChild(missingAppConfigsElementChild);
        }
        return endpointInformationElement;
    }

    protected static Element createJavaEEVerifierReports(Document document, ApplicationVerificationReport data) {
        Element javaEEVerifierReportsListElement = null;
        if (document != null && data != null) {
            javaEEVerifierReportsListElement = document.createElement("JavaEEVerifierReports");
            for (JavaEEVerifierReport javaEEReport : data.getJavaEEVerifierReports()) {
                Element reportElementChild = ApplicationVerificationReportWriter.createJavaEEVerifierReport(document, javaEEReport);
                if (reportElementChild == null) continue;
                javaEEVerifierReportsListElement.appendChild(reportElementChild);
            }
        }
        return javaEEVerifierReportsListElement;
    }

    protected static Element createJavaEEVerifierReport(Document document, JavaEEVerifierReport data) {
        Element javaEEReportElement = null;
        if (document != null && data != null) {
            javaEEReportElement = document.createElement("JavaEEVerifierReport");
            Element serviceUnitNameChild = document.createElement("JavaEESUName");
            if (serviceUnitNameChild != null) {
                serviceUnitNameChild.setTextContent(data.getServiceUnitName());
            }
            javaEEReportElement.appendChild(serviceUnitNameChild);
            Element reportTableChildElement = document.createElement("JavaEEReportTable");
            ArrayList reportTable = data.getJavaEEVerifierReport();
            for (JavaEEVerifierReport.JavaEEReportItem item : reportTable) {
                Element reportItemChildElement = document.createElement("ReportItem");
                Element earFileName = document.createElement("EarFileName");
                if (earFileName != null) {
                    earFileName.setTextContent(item.getEarFileName());
                }
                reportItemChildElement.appendChild(earFileName);
                Element referenceBy = document.createElement("ReferenceBy");
                if (referenceBy != null) {
                    referenceBy.setTextContent(item.getReferenceBy());
                }
                reportItemChildElement.appendChild(referenceBy);
                Element referenceClass = document.createElement("ReferenceClass");
                if (referenceClass != null) {
                    referenceClass.setTextContent(item.getReferenceClass());
                }
                reportItemChildElement.appendChild(referenceClass);
                Element jndiName = document.createElement("JndiName");
                if (jndiName != null) {
                    jndiName.setTextContent(item.getJndiName());
                }
                reportItemChildElement.appendChild(jndiName);
                Element jndiClass = document.createElement("JndiClass");
                if (jndiClass != null) {
                    jndiClass.setTextContent(item.getJndiClass());
                }
                reportItemChildElement.appendChild(jndiClass);
                Element message = document.createElement("Message");
                if (message != null) {
                    message.setTextContent(item.getMessage());
                }
                reportItemChildElement.appendChild(message);
                Element status = document.createElement("JavaEEStat");
                if (status != null) {
                    status.setTextContent(new Integer(item.getStatus()).toString());
                }
                reportItemChildElement.appendChild(status);
                reportTableChildElement.appendChild(reportItemChildElement);
            }
            javaEEReportElement.appendChild(reportTableChildElement);
        }
        return javaEEReportElement;
    }

    protected String writeToString(Document document) throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(document);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("media-type", "text/xml");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    public static void main(String[] args) {
        String uri = "C:/test/schema/verification/ApplicationVerificationReport.xml";
        try {
            ApplicationVerificationReport report = ApplicationVerificationReportReader.parseFromFile(uri);
            System.out.println(report.getDisplayString());
            String content = ApplicationVerificationReportWriter.serialize(report);
            System.out.println(content);
            ApplicationVerificationReportWriter.setContents(new File(uri), content);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }
}

