/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.catalog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTree;
import org.netbeans.modules.xml.catalog.AddCatalogEntryAction;
import org.netbeans.modules.xml.catalog.CatalogEntryNode;
import org.netbeans.modules.xml.catalog.CatalogNode;
import org.netbeans.modules.xml.catalog.CatalogRootNode;
import org.netbeans.modules.xml.catalog.spi.CatalogWriter;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class CatalogPanel
extends TopComponent
implements ExplorerManager.Provider {
    private ExplorerManager manager;
    private CatalogTreeView view;
    private JTree tree;
    private static Set newlyCreatedFolders;
    private static FileObject catalogRoot;
    private JButton addButton;
    private JButton addLocalButton;
    private JPanel buttonsPanel;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JButton removeButton;
    private JLabel templatesLabel;
    private JPanel treePanel;

    public CatalogPanel() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.getExplorerManager()));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.getExplorerManager()));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.getExplorerManager()));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.getExplorerManager(), (boolean)true));
        this.initComponents();
        this.createCatalogView();
        this.treePanel.add((Component)((Object)this.view), "Center");
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.getExplorerManager(), (ActionMap)actionMap));
        this.initialize();
    }

    public ExplorerManager getExplorerManager() {
        if (this.manager == null) {
            this.manager = new ExplorerManager();
        }
        return this.manager;
    }

    private void createCatalogView() {
        if (this.view == null) {
            this.view = new CatalogTreeView();
        }
        this.view.setRootVisible(true);
        this.view.setPopupAllowed(true);
        this.view.setDefaultActionAllowed(false);
    }

    private void initialize() {
        this.getExplorerManager().setRootContext(CatalogPanel.getCatalogRootNode());
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)new SelectionListener());
        this.removeButton.setEnabled(false);
        this.addButton.setEnabled(true);
        this.addLocalButton.setEnabled(false);
    }

    static Node getCatalogRootNode() {
        return new CatalogRootNode();
    }

    private void initComponents() {
        this.templatesLabel = new JLabel();
        this.treePanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.addButton = new JButton();
        this.addLocalButton = new JButton();
        this.removeButton = new JButton();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.setPreferredSize(new Dimension(500, 300));
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.templatesLabel, (String)NbBundle.getBundle(CatalogPanel.class).getString("LBL_CatalogPanel_CatalogLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add(this.templatesLabel, gridBagConstraints);
        this.treePanel.setBorder(BorderFactory.createEtchedBorder());
        this.treePanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 11, 0);
        this.add(this.treePanel, gridBagConstraints);
        this.buttonsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getBundle(CatalogPanel.class).getString("BTN_CatalogPanel_Add"));
        this.addButton.setToolTipText(NbBundle.getMessage(CatalogPanel.class, (String)"ACD_CatalogPanel_Add"));
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CatalogPanel.this.addButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.addButton, gridBagConstraints);
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogPanel.class, (String)"ACD_CatalogPanel_Add"));
        Mnemonics.setLocalizedText((AbstractButton)this.addLocalButton, (String)NbBundle.getBundle(CatalogPanel.class).getString("BTN_CatalogPanel_AddLocal"));
        this.addLocalButton.setToolTipText(NbBundle.getMessage(CatalogPanel.class, (String)"ACD_CatalogPanel_AddLocal"));
        this.addLocalButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CatalogPanel.this.addLocalButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.addLocalButton, gridBagConstraints);
        this.addLocalButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogPanel.class, (String)"ACD_CatalogPanel_AddLocal"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getBundle(CatalogPanel.class).getString("BTN_CatalogPanel_RemoveButton"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CatalogPanel.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 3, 0);
        this.buttonsPanel.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CatalogPanel.class, (String)"ACD_CatalogPanel_Remove"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(4, 8, 4, 0);
        this.buttonsPanel.add((Component)this.jSeparator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 11, 11, 8);
        this.add(this.buttonsPanel, gridBagConstraints);
    }

    private void addLocalButtonActionPerformed(ActionEvent actionEvent) {
        AddCatalogEntryAction.perform(this.manager.getSelectedNodes());
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.manager.getSelectedNodes();
        try {
            for (Node node : nodeArray) {
                node.destroy();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(CatalogPanel.class.getName()).log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
        }
    }

    private void addButtonActionPerformed(ActionEvent actionEvent) {
        CatalogRootNode.mountCatalog(new Node[]{this.manager.getRootContext()});
    }

    private static DataObject getDOFromNode(Node node) {
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        assert (dataObject != null) : "DataObject for node " + node;
        return dataObject;
    }

    private static DataFolder getTargetFolder(Node[] nodeArray) {
        DataFolder dataFolder = null;
        if (nodeArray == null || nodeArray.length == 0) {
            dataFolder = DataFolder.findFolder((FileObject)CatalogPanel.getCatalogRoot());
        } else {
            dataFolder = (DataFolder)nodeArray[0].getLookup().lookup(DataFolder.class);
            if (dataFolder == null && nodeArray[0].isLeaf()) {
                Node node = nodeArray[0].getParentNode();
                dataFolder = (DataFolder)node.getLookup().lookup(DataFolder.class);
            }
        }
        return dataFolder;
    }

    static DataObject createTemplateFromFile(File file, DataFolder dataFolder) {
        if (file == null) {
            throw new IllegalArgumentException("Argument file cannot be null!");
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        assert (fileObject != null) : "FileObject found for file " + file;
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Logger.getLogger(CatalogPanel.class.getName()).log(Level.WARNING, null, dataObjectNotFoundException);
        }
        assert (dataObject != null) : "DataObject found for FileObject " + fileObject;
        DataFolder dataFolder2 = dataFolder == null ? DataFolder.findFolder((FileObject)CatalogPanel.getCatalogRoot()) : dataFolder;
        DataObject dataObject2 = null;
        try {
            dataObject2 = dataObject.copy(dataFolder2);
            dataObject2.setTemplate(true);
        }
        catch (IOException iOException) {
            Logger.getLogger(CatalogPanel.class.getName()).log(Level.WARNING, null, iOException);
        }
        return dataObject2;
    }

    private static DataFolder doNewFolder(Node[] nodeArray) {
        DataFolder dataFolder = null;
        DataFolder dataFolder2 = CatalogPanel.getTargetFolder(nodeArray);
        if (dataFolder2 == null) {
            dataFolder2 = DataFolder.findFolder((FileObject)CatalogPanel.getCatalogRoot());
            assert (dataFolder2 != null) : "DataFolder found for FO " + CatalogPanel.getCatalogRoot();
        }
        try {
            dataFolder = DataFolder.create((DataFolder)dataFolder2, (String)NbBundle.getBundle(CatalogPanel.class).getString("TXT_CatalogPanel_NewFolderName"));
            assert (dataFolder != null) : "New subfolder found in folder " + dataFolder2;
        }
        catch (IOException iOException) {
            Logger.getLogger(CatalogPanel.class.getName()).log(Level.WARNING, null, iOException);
        }
        return dataFolder;
    }

    static DataObject createDuplicateFromNode(Node node) {
        DataObject dataObject = CatalogPanel.getDOFromNode(node);
        try {
            return dataObject.copy(dataObject.getFolder());
        }
        catch (IOException iOException) {
            Logger.getLogger(CatalogPanel.class.getName()).log(Level.WARNING, null, iOException);
            return null;
        }
    }

    static FileObject getCatalogRoot() {
        if (catalogRoot == null) {
            catalogRoot = Repository.getDefault().getDefaultFileSystem().findResource("Catalog");
        }
        return catalogRoot;
    }

    private int getNodePosition(Node node) {
        Index index = this.getIndexSupport(node);
        DataFolder dataFolder = (DataFolder)node.getParentNode().getLookup().lookup(DataFolder.class);
        dataFolder.getNodeDelegate().getChildren().getNodes(true);
        int n = index.indexOf(node);
        assert (n != -1) : "Node " + node + " has position " + n + " in children " + Arrays.asList(node.getParentNode().getChildren().getNodes());
        return n;
    }

    private Index getIndexSupport(Node node) {
        Node node2 = node.getParentNode();
        assert (node2 != null) : "Node " + node + " has a parent.";
        Index index = (Index)node2.getLookup().lookup(Index.class);
        assert (index != null) : "Node " + node2 + " has Index cookie.";
        return index;
    }

    private static final class TemplateFilter
    implements DataFilter {
        private TemplateFilter() {
        }

        public boolean acceptDataObject(DataObject dataObject) {
            return this.acceptTemplate(dataObject);
        }

        private boolean acceptTemplate(DataObject dataObject) {
            if (dataObject.isTemplate() || dataObject instanceof DataFolder) {
                Object object = dataObject.getPrimaryFile().getAttribute("simple");
                return object == null || Boolean.TRUE.equals(object);
            }
            return false;
        }
    }

    private class SelectionListener
    implements PropertyChangeListener {
        private SelectionListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                Node node;
                Node[] nodeArray = (Node[])propertyChangeEvent.getNewValue();
                boolean bl = nodeArray != null && nodeArray.length > 0;
                int n = 0;
                while (bl && n < nodeArray.length) {
                    if ((node = nodeArray[n++]) instanceof CatalogNode && ((CatalogNode)node).isRemovable()) {
                        bl = true;
                        break;
                    }
                    Node.Cookie cookie = node.getCookie(CatalogEntryNode.class);
                    bl = cookie instanceof CatalogEntryNode && ((CatalogEntryNode)cookie).isCatalogWriter();
                }
                CatalogPanel.this.removeButton.setEnabled(bl);
                if (nodeArray.length > 0) {
                    node = nodeArray[0].getCookie(CatalogNode.class);
                    CatalogPanel.this.addLocalButton.setEnabled(node instanceof CatalogNode && ((CatalogNode)node).getCatalogReader() instanceof CatalogWriter);
                }
            }
        }
    }

    private static class CatalogTreeView
    extends BeanTreeView {
        private Action startEditing;

        private CatalogTreeView() {
        }

        private void invokeInplaceEditing() {
            Action action;
            if (this.startEditing == null && (action = this.tree.getActionMap().get("startEditing")) != null && action instanceof Action) {
                this.startEditing = action;
            }
            assert (this.startEditing != null) : "startEditing is on tree ActionMap " + Arrays.asList(this.tree.getActionMap().keys());
            this.startEditing.actionPerformed(new ActionEvent(this.tree, 0, "startEditing"));
        }
    }
}

