/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.palette;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.netbeans.modules.bpel.mapper.model.customitems.BpelXPathCustomFunction;
import org.netbeans.modules.bpel.mapper.model.customitems.WrapServiceRefHandler;
import org.netbeans.modules.bpel.mapper.palette.Handler;
import org.netbeans.modules.bpel.mapper.palette.Item;
import org.netbeans.modules.bpel.model.api.support.BpelXPathExtFunctionMetadata;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.xml.ui.UI;
import org.netbeans.modules.xml.xpath.ext.CoreFunctionType;
import org.netbeans.modules.xml.xpath.ext.CoreOperationType;

public final class Palette {
    private JMenuBar myBar;
    private Mapper myMapper;

    public Palette(Mapper mapper) {
        this.myMapper = mapper;
    }

    public JPanel getPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.createMenuBar(), gridBagConstraints);
        jPanel.setBorder(new Border());
        jPanel.setOpaque(true);
        jPanel.addMouseMotionListener(new MouseMotionAdapter(){});
        return jPanel;
    }

    public JMenuBar createMenuBar() {
        this.myBar = new JMenuBar();
        this.myBar.setBorder(BorderFactory.createEmptyBorder());
        this.myBar.add(this.createOperatorMenu());
        this.myBar.add(this.createBooleanMenu());
        this.myBar.add(this.createStringMenu());
        this.myBar.add(this.createNodeMenu());
        this.myBar.add(this.createNumberMenu());
        this.myBar.add(this.createDateTimeMenu());
        this.myBar.add(this.createBPELMenu());
        this.myBar.setBorder(new Border());
        return this.myBar;
    }

    public void hideMenu() {
        for (int i = 0; i < this.myBar.getMenuCount(); ++i) {
            JMenu jMenu = this.myBar.getMenu(i);
            if (!jMenu.isSelected()) continue;
            jMenu.setSelected(false);
            jMenu.getPopupMenu().setVisible(false);
            return;
        }
    }

    public Mapper getMapper() {
        return this.myMapper;
    }

    private JMenu createOperatorMenu() {
        JMenu jMenu = this.createMenu("LBL_Operator", "operator");
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_GT)));
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_GE)));
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_LT)));
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_LE)));
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_SUM)));
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_MINUS)));
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_MULT)));
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_DIV)));
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_MOD)));
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_NEGATIVE)));
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_NE)));
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_EQ)));
        return jMenu;
    }

    private JMenu createBooleanMenu() {
        JMenu jMenu = this.createMenu("LBL_Boolean", "boolean");
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_AND)));
        jMenu.add(new Item(this, new Handler(CoreOperationType.OP_OR)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_NOT)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_LANG)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_FALSE)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_TRUE)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_BOOLEAN)));
        return jMenu;
    }

    private JMenu createStringMenu() {
        JMenu jMenu = this.createMenu("LBL_String", "string");
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_CONTAINS)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_NORMALIZE_SPACE)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_STRING)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_STARTS_WITH)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_STRING_LENGTH)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_SUBSTRING)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_SUBSTRING_BEFORE)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_SUBSTRING_AFTER)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_TRANSLATE)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_CONCAT)));
        jMenu.add(new Item(this, new Handler(new String())));
        return jMenu;
    }

    private JMenu createNodeMenu() {
        JMenu jMenu = this.createMenu("LBL_Node", "node");
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_LOCAL_NAME)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_NAME)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_NAMESPACE_URI)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_POSITION)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_LAST)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_COUNT)));
        return jMenu;
    }

    private JMenu createNumberMenu() {
        JMenu jMenu = this.createMenu("LBL_Number", "number");
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_NUMBER)));
        jMenu.add(new Item(this, new Handler(new Integer(0))));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_ROUND)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_SUM)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_FLOOR)));
        jMenu.add(new Item(this, new Handler(CoreFunctionType.FUNC_CEILING)));
        return jMenu;
    }

    private JMenu createDateTimeMenu() {
        JMenu jMenu = this.createMenu("LBL_Date_Time", "date_time");
        jMenu.add(new Item(this, new Handler(BpelXPathExtFunctionMetadata.CURRENT_DATE_METADATA)));
        jMenu.add(new Item(this, new Handler(BpelXPathExtFunctionMetadata.CURRENT_TIME_METADATA)));
        jMenu.add(new Item(this, new Handler(BpelXPathExtFunctionMetadata.CURRENT_DATE_TIME_METADATA)));
        jMenu.add(new Item(this, new Handler.Duration()));
        return jMenu;
    }

    private JMenu createBPELMenu() {
        JMenu jMenu = this.createMenu("LBL_BPEL", "bpel");
        jMenu.add(new Item(this, new Handler(BpelXPathExtFunctionMetadata.DO_XSL_TRANSFORM_METADATA)));
        jMenu.add(new Item(this, new WrapServiceRefHandler(BpelXPathCustomFunction.WRAP_WITH_SERVICE_REF_METADATA)));
        jMenu.add(new Item(this, new Handler(BpelXPathExtFunctionMetadata.DO_MARSHAL_METADATA)));
        jMenu.add(new Item(this, new Handler(BpelXPathExtFunctionMetadata.DO_UNMARSHAL_METADATA)));
        return jMenu;
    }

    private JMenu createMenu(String string, String string2) {
        String string3 = UI.i18n(Palette.class, (String)string);
        MyMenu myMenu = new MyMenu(string3);
        myMenu.setToolTipText(string3);
        myMenu.setIcon(UI.icon(Palette.class, (String)string2));
        return myMenu;
    }

    private static class MyMenu
    extends JMenu {
        MyMenu(String string) {
            super(string);
        }

        public String getToolTipText() {
            Dimension dimension = this.getPreferredSize();
            if (this.getWidth() < dimension.width) {
                return super.getToolTipText();
            }
            return null;
        }
    }

    private static class Border
    implements javax.swing.border.Border {
        private Border() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(component.getBackground().darker());
            graphics.drawLine(n, n2 += n4 - 1, n + n3 - 1, n2);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 1, 0);
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

