/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.multiview;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModelFactory;
import org.netbeans.modules.bpel.mapper.model.GraphExpandProcessor;
import org.netbeans.modules.bpel.mapper.model.MapperTcContext;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.multiview.BpelModelSynchListener;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextController;
import org.netbeans.modules.bpel.mapper.tree.TreeExpandedStateImpl;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.xml.xam.Model;
import org.openide.nodes.Node;

public class DesignContextControllerImpl
implements DesignContextController {
    private static int RELOAD_DELAY = 100;
    private static int NODE_UPDATE_DELAY = 200;
    private BpelDesignContext mContext;
    private MapperTcContext mMapperTcContext;
    private BpelModelSynchListener mBpelModelSynchListener;
    private ReloadProcessor mReloadProcessor;
    private Timer reloadTimer;
    private Timer nodeUpdateTimer;
    private BpelDesignContext mNewContext;
    private boolean mNeedReload;
    private WeakReference<Object> mBpelModelUpdateSourceRef;

    public DesignContextControllerImpl(MapperTcContext mapperTcContext) {
        this.mMapperTcContext = mapperTcContext;
        this.mBpelModelSynchListener = new BpelModelSynchListener(this);
        this.reloadTimer = new Timer(RELOAD_DELAY, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                ReloadProcessor reloadProcessor = new ReloadProcessor();
                DesignContextControllerImpl designContextControllerImpl = DesignContextControllerImpl.this;
                synchronized (designContextControllerImpl) {
                    DesignContextControllerImpl.this.mReloadProcessor = reloadProcessor;
                }
                reloadProcessor.reloadMapperImpl();
                if (!reloadProcessor.isInterrupted()) {
                    designContextControllerImpl = DesignContextControllerImpl.this;
                    synchronized (designContextControllerImpl) {
                        DesignContextControllerImpl.this.mNeedReload = false;
                    }
                }
            }
        });
        this.reloadTimer.setRepeats(false);
        this.nodeUpdateTimer = new Timer(NODE_UPDATE_DELAY, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                ReloadProcessor reloadProcessor = new ReloadProcessor();
                DesignContextControllerImpl designContextControllerImpl = DesignContextControllerImpl.this;
                synchronized (designContextControllerImpl) {
                    DesignContextControllerImpl.this.mReloadProcessor = reloadProcessor;
                }
                reloadProcessor.setContextImpl();
                if (!reloadProcessor.isInterrupted()) {
                    designContextControllerImpl = DesignContextControllerImpl.this;
                    synchronized (designContextControllerImpl) {
                        DesignContextControllerImpl.this.mNeedReload = false;
                    }
                }
            }
        });
        this.nodeUpdateTimer.setRepeats(false);
    }

    public MapperTcContext getMapperTcContext() {
        return this.mMapperTcContext;
    }

    public synchronized void setBpelModelUpdateSource(Object object) {
        this.mBpelModelUpdateSourceRef = new WeakReference<Object>(object);
    }

    private synchronized Object getBpelModelUpdateSource() {
        if (this.mBpelModelUpdateSourceRef == null) {
            return this.mMapperTcContext.getMapper();
        }
        return this.mBpelModelUpdateSourceRef.get();
    }

    public synchronized BpelDesignContext getContext() {
        return this.mContext;
    }

    public synchronized void setContext(BpelDesignContext bpelDesignContext) {
        BpelModel bpelModel;
        if (bpelDesignContext == null) {
            return;
        }
        Node node = bpelDesignContext.getActivatedNode();
        if (node != null && this.mMapperTcContext != null && (bpelModel = this.mMapperTcContext.getTopComponent()) != null) {
            bpelModel.setActivatedNodes(new Node[]{node});
        }
        bpelModel = this.getCurrBpelModel();
        BpelEntity bpelEntity = bpelDesignContext.getSelectedEntity();
        if (bpelModel != null && bpelEntity != null && !bpelModel.equals(bpelEntity.getBpelModel()) || bpelEntity == null) {
            return;
        }
        this.reloadTimer.stop();
        this.nodeUpdateTimer.stop();
        if (this.mReloadProcessor != null) {
            this.mReloadProcessor.interrupt();
        }
        this.mNewContext = bpelDesignContext;
        this.nodeUpdateTimer.start();
    }

    public synchronized void reloadMapper(EventObject eventObject) {
        if (eventObject.getSource() == this.getBpelModelUpdateSource()) {
            return;
        }
        if (!this.nodeUpdateTimer.isRunning()) {
            this.reloadTimer.stop();
            if (this.mReloadProcessor != null) {
                this.mReloadProcessor.interrupt();
            }
            this.reloadTimer.start();
        }
        this.mNeedReload = true;
    }

    private synchronized BpelModel getCurrBpelModel() {
        if (this.mContext != null) {
            return this.mContext.getBpelModel();
        }
        return null;
    }

    private void setMapperModel(MapperModel mapperModel) {
        this.mMapperTcContext.setMapperModel(mapperModel);
    }

    public void showMapper() {
    }

    public void hideMapper() {
    }

    public void cleanup() {
    }

    public void processDataObject(Object object) {
    }

    private class ReloadProcessor {
        private boolean isInterrupted = false;

        private ReloadProcessor() {
        }

        public void interrupt() {
            this.isInterrupted = true;
        }

        public boolean isInterrupted() {
            return this.isInterrupted;
        }

        public void reloadMapperImpl() {
            if (DesignContextControllerImpl.this.mContext == null) {
                return;
            }
            if (this.isModelInvalid()) {
                this.disableMapper();
                return;
            }
            MapperModel mapperModel = new BpelMapperModelFactory(DesignContextControllerImpl.this.mMapperTcContext, DesignContextControllerImpl.this.mContext).constructModel();
            TreeExpandedStateImpl treeExpandedStateImpl = null;
            Mapper mapper = DesignContextControllerImpl.this.mMapperTcContext.getMapper();
            if (mapper != null) {
                treeExpandedStateImpl = new TreeExpandedStateImpl(mapper);
                treeExpandedStateImpl.save();
            }
            DesignContextControllerImpl.this.setMapperModel(mapperModel);
            final TreeExpandedStateImpl treeExpandedStateImpl2 = treeExpandedStateImpl;
            if (treeExpandedStateImpl2 != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        treeExpandedStateImpl2.restore();
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setContextImpl() {
            BpelDesignContext bpelDesignContext = DesignContextControllerImpl.this.mNewContext;
            if (bpelDesignContext == null || bpelDesignContext.getSelectedEntity() == null) {
                this.disableMapper();
                return;
            }
            if (this.isModelInvalid()) {
                this.disableMapper();
                return;
            }
            if (!bpelDesignContext.equals(DesignContextControllerImpl.this.mContext)) {
                if (bpelDesignContext.getBpelModel() != DesignContextControllerImpl.this.getCurrBpelModel()) {
                    this.setListenBpelModel(DesignContextControllerImpl.this.getCurrBpelModel(), false);
                    this.setListenBpelModel(bpelDesignContext.getBpelModel(), true);
                }
                MapperModel mapperModel = new BpelMapperModelFactory(DesignContextControllerImpl.this.mMapperTcContext, bpelDesignContext).constructModel();
                DesignContextControllerImpl.this.mContext = bpelDesignContext;
                DesignContextControllerImpl.this.setMapperModel(mapperModel);
                GraphExpandProcessor.expandGraph(DesignContextControllerImpl.this.mMapperTcContext, DesignContextControllerImpl.this.mContext);
                DesignContextControllerImpl.this.mMapperTcContext.showMapperTcGroup(true);
            } else {
                boolean bl;
                DesignContextControllerImpl designContextControllerImpl = DesignContextControllerImpl.this;
                synchronized (designContextControllerImpl) {
                    bl = DesignContextControllerImpl.this.mNeedReload;
                }
                if (bl) {
                    this.reloadMapperImpl();
                }
            }
        }

        private void setListenBpelModel(BpelModel bpelModel, boolean bl) {
            if (bpelModel == null) {
                return;
            }
            if (bl) {
                if (DesignContextControllerImpl.this.mBpelModelSynchListener != null) {
                    bpelModel.addEntityChangeListener((ChangeEventListener)DesignContextControllerImpl.this.mBpelModelSynchListener);
                }
            } else if (DesignContextControllerImpl.this.mBpelModelSynchListener != null) {
                bpelModel.removeEntityChangeListener((ChangeEventListener)DesignContextControllerImpl.this.mBpelModelSynchListener);
            }
        }

        private void disableMapper() {
            DesignContextControllerImpl.this.mMapperTcContext.showMapperTcGroup(false);
            DesignContextControllerImpl.this.mMapperTcContext.setMapper(null);
            this.setListenBpelModel(DesignContextControllerImpl.this.getCurrBpelModel(), false);
            DesignContextControllerImpl.this.mContext = null;
        }

        private boolean isModelInvalid() {
            BpelModel bpelModel = DesignContextControllerImpl.this.getCurrBpelModel();
            if (bpelModel != null) {
                return bpelModel.getState().equals((Object)Model.State.NOT_WELL_FORMED);
            }
            return false;
        }
    }
}

