/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.util.ArrayList;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModelFactory;
import org.netbeans.modules.bpel.mapper.model.EditorExtensionProcessor;
import org.netbeans.modules.bpel.mapper.model.LocationPathBuilder;
import org.netbeans.modules.bpel.mapper.model.VertexFactory;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.search.EndpointRefFinder;
import org.netbeans.modules.bpel.mapper.tree.search.FinderListBuilder;
import org.netbeans.modules.bpel.mapper.tree.search.PartFinder;
import org.netbeans.modules.bpel.mapper.tree.search.PartnerLinkFinder;
import org.netbeans.modules.bpel.mapper.tree.search.VariableFinder;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Expression;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.FromChild;
import org.netbeans.modules.bpel.model.api.FromHolder;
import org.netbeans.modules.bpel.model.api.Literal;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Query;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.model.api.references.WSDLReference;
import org.netbeans.modules.bpel.model.api.support.Roles;
import org.netbeans.modules.soa.mappercore.model.Constant;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.ui.tree.ExtTreeModel;
import org.netbeans.modules.soa.ui.tree.TreeItemFinder;
import org.netbeans.modules.soa.ui.tree.impl.TreeFinderProcessor;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xpath.ext.AbstractLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FromProcessor {
    private BpelMapperModelFactory mFactory;
    private FromHolder mContextEntity;
    private FromForm mCopyFromForm;

    public FromProcessor(BpelMapperModelFactory bpelMapperModelFactory, FromHolder fromHolder) {
        assert (bpelMapperModelFactory != null && fromHolder != null);
        this.mFactory = bpelMapperModelFactory;
        this.mContextEntity = fromHolder;
    }

    public From getFrom() {
        assert (this.mContextEntity != null);
        return this.mContextEntity.getFrom();
    }

    public synchronized FromForm getFromForm() {
        if (this.mCopyFromForm == null) {
            this.calculateFromForm();
        }
        return this.mCopyFromForm;
    }

    public Graph populateGraph(Graph graph, MapperSwingTreeModel mapperSwingTreeModel, EditorExtensionProcessor.BpelEditorExtensions bpelEditorExtensions) {
        assert (this.getFrom() != null);
        switch (this.getFromForm()) {
            case EXPRESSION: {
                this.mFactory.populateGraph(graph, mapperSwingTreeModel, (BpelEntity)this.mContextEntity, (Expression)this.getFrom(), bpelEditorExtensions);
                break;
            }
            case LITERAL: {
                FromChild fromChild = this.getFrom().getFromChild();
                if (fromChild == null || !(fromChild instanceof Literal)) break;
                String string = ((Literal)fromChild).getContent();
                Constant constant = VertexFactory.getInstance().createStringLiteral(string);
                graph.addVertex((Vertex)constant);
                Link link = new Link((SourcePin)constant, (TargetPin)graph);
                graph.addLink(link);
                break;
            }
            case UNKNOWN: {
                return null;
            }
            default: {
                ArrayList<TreeItemFinder> arrayList = this.constructFindersList((BpelEntity)this.mContextEntity);
                TreeFinderProcessor treeFinderProcessor = new TreeFinderProcessor((ExtTreeModel)mapperSwingTreeModel);
                TreePath treePath = treeFinderProcessor.findFirstNode(arrayList);
                if (treePath == null) break;
                TreeSourcePin treeSourcePin = new TreeSourcePin(treePath);
                Link link = new Link((SourcePin)treeSourcePin, (TargetPin)graph);
                graph.addLink(link);
            }
        }
        return graph;
    }

    private void calculateFromForm() {
        this.mCopyFromForm = FromForm.UNKNOWN;
        if (this.mContextEntity == null) {
            return;
        }
        From from = this.getFrom();
        if (from == null) {
            return;
        }
        this.mCopyFromForm = FromProcessor.calculateFromForm(from);
    }

    public static FromForm calculateFromForm(From from) {
        if (from == null) {
            return FromForm.UNKNOWN;
        }
        BpelReference bpelReference = from.getVariable();
        if (bpelReference != null) {
            WSDLReference wSDLReference = from.getPart();
            if (wSDLReference != null) {
                FromChild fromChild = from.getFromChild();
                if (fromChild != null && fromChild instanceof Query) {
                    return FromForm.VAR_PART_QUERY;
                }
                return FromForm.VAR_PART;
            }
            FromChild fromChild = from.getFromChild();
            if (fromChild != null && fromChild instanceof Query) {
                return FromForm.VAR_QUERY;
            }
            return FromForm.VAR;
        }
        BpelReference bpelReference2 = from.getPartnerLink();
        if (bpelReference2 != null) {
            return FromForm.PARTNER_LINK;
        }
        FromChild fromChild = from.getFromChild();
        if (fromChild != null && fromChild instanceof Literal) {
            return FromForm.LITERAL;
        }
        String string = from.getContent();
        if (string != null && string.length() != 0) {
            return FromForm.EXPRESSION;
        }
        return FromForm.UNKNOWN;
    }

    public static ArrayList<TreeItemFinder> constructFindersList(From from, FromForm fromForm, BpelEntity bpelEntity) {
        ArrayList<TreeItemFinder> arrayList = new ArrayList<TreeItemFinder>();
        if (from == null || fromForm == null) {
            return arrayList;
        }
        switch (fromForm) {
            case VAR: {
                VariableDeclaration variableDeclaration;
                BpelReference bpelReference = from.getVariable();
                if (bpelReference == null || (variableDeclaration = (VariableDeclaration)bpelReference.get()) == null) break;
                arrayList.add((TreeItemFinder)new VariableFinder((AbstractVariableDeclaration)variableDeclaration));
                break;
            }
            case VAR_PART: {
                Part part;
                WSDLReference wSDLReference;
                BpelReference bpelReference = from.getVariable();
                if (bpelReference != null && (wSDLReference = (VariableDeclaration)bpelReference.get()) != null) {
                    arrayList.add((TreeItemFinder)new VariableFinder((AbstractVariableDeclaration)wSDLReference));
                }
                if ((wSDLReference = from.getPart()) == null || (part = (Part)wSDLReference.get()) == null) break;
                arrayList.add((TreeItemFinder)new PartFinder(part));
                break;
            }
            case VAR_PART_QUERY: {
                LocationPathBuilder locationPathBuilder;
                XPathLocationPath xPathLocationPath;
                Part part;
                WSDLReference wSDLReference;
                BpelReference bpelReference = from.getVariable();
                if (bpelReference != null && (wSDLReference = (VariableDeclaration)bpelReference.get()) != null) {
                    arrayList.add((TreeItemFinder)new VariableFinder((AbstractVariableDeclaration)wSDLReference));
                }
                if ((wSDLReference = from.getPart()) == null || (part = (Part)wSDLReference.get()) == null) break;
                arrayList.add((TreeItemFinder)new PartFinder(part));
                FromChild fromChild = from.getFromChild();
                if (fromChild == null || !(fromChild instanceof Query) || (xPathLocationPath = (locationPathBuilder = new LocationPathBuilder(bpelEntity, part, (Query)fromChild)).build()) == null) break;
                arrayList.addAll(FinderListBuilder.build((AbstractLocationPath)xPathLocationPath));
                break;
            }
            case VAR_QUERY: {
                LocationPathBuilder locationPathBuilder;
                XPathLocationPath xPathLocationPath;
                VariableDeclaration variableDeclaration;
                BpelReference bpelReference = from.getVariable();
                if (bpelReference == null || (variableDeclaration = (VariableDeclaration)bpelReference.get()) == null) break;
                arrayList.add((TreeItemFinder)new VariableFinder((AbstractVariableDeclaration)variableDeclaration));
                FromChild fromChild = from.getFromChild();
                if (fromChild == null || !(fromChild instanceof Query) || (xPathLocationPath = (locationPathBuilder = new LocationPathBuilder(bpelEntity, (AbstractVariableDeclaration)variableDeclaration, (Query)fromChild)).build()) == null) break;
                arrayList.addAll(FinderListBuilder.build((AbstractLocationPath)xPathLocationPath));
                break;
            }
            case PARTNER_LINK: {
                PartnerLink partnerLink;
                BpelReference bpelReference = from.getPartnerLink();
                if (bpelReference == null || (partnerLink = (PartnerLink)bpelReference.get()) == null) break;
                arrayList.add((TreeItemFinder)new PartnerLinkFinder(partnerLink));
                Roles roles = from.getEndpointReference();
                arrayList.add((TreeItemFinder)new EndpointRefFinder(roles));
                break;
            }
        }
        return arrayList;
    }

    public ArrayList<TreeItemFinder> constructFindersList(BpelEntity bpelEntity) {
        From from = this.getFrom();
        FromForm fromForm = this.getFromForm();
        return FromProcessor.constructFindersList(from, fromForm, bpelEntity);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FromForm {
        UNKNOWN,
        VAR,
        VAR_PART,
        VAR_PART_QUERY,
        VAR_QUERY,
        PARTNER_LINK,
        VAR_PROPERTY,
        EXPRESSION,
        LITERAL;

    }
}

