/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.cast;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.Collections;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.mapper.cast.GlobalSchemaComponentFinder;
import org.netbeans.modules.bpel.mapper.cast.TypeCastTreeModel;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.soa.ui.SoaUtil;
import org.netbeans.modules.soa.ui.form.ChooserLifeCycle;
import org.netbeans.modules.soa.ui.form.valid.DefaultDialogDescriptor;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.SoaDialogDisplayer;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.soa.ui.tree.DataObjectHolder;
import org.netbeans.modules.soa.ui.tree.ExtTreeModel;
import org.netbeans.modules.soa.ui.tree.SoaTreeModel;
import org.netbeans.modules.soa.ui.tree.impl.SoaTreeCellRenderer;
import org.netbeans.modules.soa.ui.tree.impl.SoaTreeModelImpl;
import org.netbeans.modules.soa.ui.tree.impl.TreeFinderProcessor;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubtypeChooser
extends JPanel
implements ChooserLifeCycle<GlobalType>,
Validator.Provider,
ValidStateManager.Provider {
    private GlobalType mRootGType;
    private BpelModel mBpelModel;
    private DefaultValidator mValidator;
    private ValidStateManager mVSM;
    private JTree subtypesTree;
    private JScrollPane treeScrollPane;

    public SubtypeChooser(GlobalType globalType, BpelModel bpelModel) {
        this.mRootGType = globalType;
        this.mBpelModel = bpelModel;
        this.createContent();
        this.initControls();
    }

    public void createContent() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        SoaTreeModelImpl soaTreeModelImpl = new SoaTreeModelImpl((SoaTreeModel)new TypeCastTreeModel(this.mRootGType, this.mBpelModel));
        this.subtypesTree.setModel((TreeModel)soaTreeModelImpl);
        this.subtypesTree.setRootVisible(true);
        this.subtypesTree.setShowsRootHandles(false);
        this.subtypesTree.setCellRenderer((TreeCellRenderer)new SoaTreeCellRenderer(soaTreeModelImpl));
        this.subtypesTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                SubtypeChooser.this.getValidStateManager(true).clearReasons();
                SubtypeChooser.this.getValidator().revalidate(true);
            }
        });
        SoaUtil.activateInlineMnemonics((Container)this);
    }

    public boolean initControls() {
        this.getValidator().revalidate(true);
        return true;
    }

    public void setSelectedValue(GlobalType globalType) {
        TreeModel treeModel = this.subtypesTree.getModel();
        assert (treeModel instanceof ExtTreeModel);
        TreeFinderProcessor treeFinderProcessor = new TreeFinderProcessor((ExtTreeModel)treeModel);
        GlobalSchemaComponentFinder globalSchemaComponentFinder = new GlobalSchemaComponentFinder((SchemaComponent)globalType);
        TreePath treePath = treeFinderProcessor.findFirstNode(Collections.singletonList(globalSchemaComponentFinder));
        if (treePath != null) {
            this.subtypesTree.setSelectionPath(treePath);
        } else {
            this.subtypesTree.setSelectionRow(0);
        }
    }

    public GlobalType getSelectedValue() {
        Object object;
        Object object2;
        TreePath treePath = this.subtypesTree.getSelectionPath();
        if (treePath != null && (object2 = treePath.getLastPathComponent()) != null && object2 instanceof DataObjectHolder && (object = ((DataObjectHolder)object2).getDataObject()) != null && object instanceof GlobalType) {
            return (GlobalType)object;
        }
        return null;
    }

    public boolean subscribeListeners() {
        return true;
    }

    public boolean unsubscribeListeners() {
        return true;
    }

    public boolean afterClose() {
        return true;
    }

    public static boolean showDlg(SubtypeChooser subtypeChooser) {
        String string = NbBundle.getMessage(SubtypeChooser.class, (String)"SUBTYPE_CHOOSER_TITLE");
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor((Object)subtypeChooser, string);
        Dialog dialog = SoaDialogDisplayer.getDefault().createDialog((DialogDescriptor)defaultDialogDescriptor);
        SoaUtil.setInitialFocusComponentFor((Container)subtypeChooser);
        dialog.setVisible(true);
        return defaultDialogDescriptor.isOkHasPressed();
    }

    public Validator getValidator() {
        if (this.mValidator == null) {
            this.mValidator = new DefaultValidator(this, SubtypeChooser.class){

                public void doFastValidation() {
                    GlobalType globalType = SubtypeChooser.this.getSelectedValue();
                    if (globalType == null) {
                        this.addReasonKey(Validator.Severity.ERROR, "EMPTY_SELECTION");
                    } else if (globalType.equals(SubtypeChooser.this.mRootGType)) {
                        this.addReasonKey(Validator.Severity.ERROR, "CAST_TO_SELF");
                    }
                }
            };
        }
        return this.mValidator;
    }

    public ValidStateManager getValidStateManager(boolean bl) {
        if (this.mVSM == null) {
            this.mVSM = new DefaultValidStateManager();
        }
        return this.mVSM;
    }

    private void initComponents() {
        this.treeScrollPane = new JScrollPane();
        this.subtypesTree = new JTree();
        this.treeScrollPane.setViewportView(this.subtypesTree);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.treeScrollPane, -1, 268, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.treeScrollPane, -1, 302, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(SubtypeChooser.class).getString("ACSN_DLG_TypeCastChooser"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SubtypeChooser.class).getString("ACSD_DLG_TypeCastChooser"));
    }
}

