/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.project.libraries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.project.libraries.LibraryAccessor;
import org.netbeans.modules.project.libraries.ui.LibrariesModel;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation2;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Library {
    public static final String PROP_NAME = "name";
    public static final String PROP_DESCRIPTION = "description";
    public static final String PROP_CONTENT = "content";
    private LibraryImplementation impl;
    private List<PropertyChangeListener> listeners;
    private final LibraryManager manager;

    Library(LibraryImplementation libraryImplementation, LibraryManager libraryManager) {
        this.impl = libraryImplementation;
        this.impl.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                Library.this.fireChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        });
        this.manager = libraryManager;
    }

    public LibraryManager getManager() {
        return this.manager;
    }

    public List<URL> getContent(String string) {
        return this.impl.getContent(string);
    }

    public List<URI> getURIContent(String string) {
        if (this.impl instanceof LibraryImplementation2) {
            return ((LibraryImplementation2)this.impl).getURIContent(string);
        }
        return LibrariesModel.convertURLsToURIs(this.impl.getContent(string));
    }

    public String getName() {
        return this.impl.getName();
    }

    public String getDescription() {
        return this.getLocalizedString(this.impl.getLocalizingBundle(), this.impl.getDescription());
    }

    public String getDisplayName() {
        return this.getLocalizedString(this.impl.getLocalizingBundle(), this.impl.getName());
    }

    public String getType() {
        return this.impl.getType();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Library) {
            Library library = (Library)object;
            return library.impl.equals(this.impl);
        }
        return false;
    }

    public int hashCode() {
        return this.impl.hashCode();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        this.listeners.add(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(propertyChangeListener);
    }

    LibraryImplementation getLibraryImplementation() {
        return this.impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange(String string, Object object, Object object2) {
        ArrayList<PropertyChangeListener> arrayList;
        Object object3 = this;
        synchronized (object3) {
            if (this.listeners == null) {
                return;
            }
            arrayList = new ArrayList<PropertyChangeListener>(this.listeners);
        }
        object3 = new PropertyChangeEvent(this, string, object, object2);
        for (PropertyChangeListener propertyChangeListener : arrayList) {
            propertyChangeListener.propertyChange((PropertyChangeEvent)object3);
        }
    }

    private String getLocalizedString(String string, String string2) {
        ResourceBundle resourceBundle;
        if (string2 == null) {
            return null;
        }
        if (string == null) {
            return string2;
        }
        try {
            resourceBundle = NbBundle.getBundle((String)string);
        }
        catch (MissingResourceException missingResourceException) {
            Logger.getLogger(Library.class.getName()).warning("No such bundle " + string + " for " + this.getName());
            return string2;
        }
        try {
            return resourceBundle.getString(string2);
        }
        catch (MissingResourceException missingResourceException) {
            Logger.getLogger(Library.class.getName()).warning("No such key " + string2 + " in " + string + " for " + this.getName());
            return string2;
        }
    }

    public String toString() {
        return "Library[" + this.getName() + "]";
    }

    static {
        LibraryAccessor.setInstance(new LibraryAccessor(){

            public Library createLibrary(LibraryImplementation libraryImplementation) {
                return new Library(libraryImplementation, LibraryManager.getDefault());
            }
        });
    }
}

