/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.faces.dt.converter;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignProperty;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Currency;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import org.netbeans.modules.visualweb.faces.dt.converter.ISO4217CurrencyCode;
import org.netbeans.modules.visualweb.faces.dt.util.ComponentBundle;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class NumberConverterCustomizerPanel
extends JPanel {
    private static final ComponentBundle bundle = ComponentBundle.getBundle(NumberConverterCustomizerPanel.class);
    protected DesignProperty prop;
    protected DesignBean designBean;
    private Locale[] locales;
    private static final String[] typeValues = new String[]{"number", "currency", "percent"};
    private static final String[] typeDisplayNames = new String[]{NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"number"), NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"currency"), NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"percent")};
    private JButton btnTest;
    private JCheckBox cbIntegerOnly;
    private JCheckBox cbUseGrouping;
    private JComboBox cmbCurrencyCode;
    private JComboBox cmbExample;
    private JComboBox cmbLocale;
    private JComboBox cmbMaxFractional;
    private JComboBox cmbMaxInteger;
    private JComboBox cmbMinFractional;
    private JComboBox cmbMinInteger;
    private JComboBox cmbPattern;
    private JComboBox cmbType;
    private ButtonGroup currencyGroup;
    private JSeparator jSeparator1;
    private JLabel lblChooseCurrency;
    private JLabel lblExample;
    private JLabel lblFractional;
    private JLabel lblInteger;
    private JLabel lblLocale;
    private JLabel lblMaxFractional;
    private JLabel lblMaxInteger;
    private JLabel lblMinFractional;
    private JLabel lblMinInteger;
    private JLabel lblResults;
    private JPanel pnlExample;
    private JPanel pnlFractional;
    private JPanel pnlInteger;
    private JPanel pnlLocale;
    private JPanel pnlType;
    private JPanel pnlTypePattern;
    private JRadioButton rbCurrencyCode;
    private JRadioButton rbPattern;
    private JRadioButton rbSymbol;
    private JRadioButton rbType;
    private JTextField txtEnterSymbol;
    private JTextPane txtExampleInstructions;
    private JTextField txtResults;
    private ButtonGroup typePatternGroup;

    public NumberConverterCustomizerPanel(DesignBean designBean) {
        this.designBean = designBean;
        String[] stringArray = this.getLocaleDisplayNames();
        this.initComponents();
        NumberFormat numberFormat = NumberFormat.getInstance();
        NumberFormat numberFormat2 = NumberFormat.getIntegerInstance();
        NumberFormat numberFormat3 = NumberFormat.getCurrencyInstance();
        NumberFormat numberFormat4 = NumberFormat.getPercentInstance();
        this.cmbPattern.setModel(new DefaultComboBoxModel<String>(new String[]{"", ((DecimalFormat)numberFormat).toPattern(), ((DecimalFormat)numberFormat2).toPattern(), ((DecimalFormat)numberFormat3).toPattern(), ((DecimalFormat)numberFormat4).toPattern()}));
        this.cmbType.setModel(new DefaultComboBoxModel<String>(typeDisplayNames));
        this.cmbLocale.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbCurrencyCode.setModel(new DefaultComboBoxModel<String>(ISO4217CurrencyCode.getDisplayNames()));
        String[] stringArray2 = new String[]{"", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "30", "40", "50"};
        this.cmbMinInteger.setModel(new DefaultComboBoxModel<String>(stringArray2));
        this.cmbMaxInteger.setModel(new DefaultComboBoxModel<String>(stringArray2));
        this.cmbMinFractional.setModel(new DefaultComboBoxModel<String>(stringArray2));
        this.cmbMaxFractional.setModel(new DefaultComboBoxModel<String>(stringArray2));
        ((JTextField)this.cmbMinInteger.getEditor().getEditorComponent()).setHorizontalAlignment(4);
        ((JTextField)this.cmbMaxInteger.getEditor().getEditorComponent()).setHorizontalAlignment(4);
        ((JTextField)this.cmbMinFractional.getEditor().getEditorComponent()).setHorizontalAlignment(4);
        ((JTextField)this.cmbMaxFractional.getEditor().getEditorComponent()).setHorizontalAlignment(4);
        this.fillPanel();
        this.cmbExample.setModel(new DefaultComboBoxModel<String>(new String[]{"1234.56", "-1234.56", "123.4567", "0.123", "01234"}));
        this.cmbExample.getEditor().getEditorComponent().addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                NumberConverterCustomizerPanel.this.cmbExampleFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                NumberConverterCustomizerPanel.this.cmbExampleFocusLost(focusEvent);
            }
        });
    }

    public boolean isModified() {
        return true;
    }

    public void customizerApply() {
        if (!this.validateUserInput()) {
            return;
        }
        DesignProperty designProperty = null;
        if (this.rbType.isSelected()) {
            designProperty = this.designBean.getProperty("type");
            designProperty.setValue((Object)typeValues[this.cmbType.getSelectedIndex()]);
            designProperty = this.designBean.getProperty("minIntegerDigits");
            Integer n = this.getInteger((String)this.cmbMinInteger.getSelectedItem());
            if (n != null) {
                designProperty.setValue((Object)n);
            } else {
                designProperty.unset();
            }
            designProperty = this.designBean.getProperty("maxIntegerDigits");
            Integer n2 = this.getInteger((String)this.cmbMaxInteger.getSelectedItem());
            if (n2 != null) {
                designProperty.setValue((Object)n2);
            } else {
                designProperty.unset();
            }
            designProperty = this.designBean.getProperty("minFractionDigits");
            Integer n3 = this.getInteger((String)this.cmbMinFractional.getSelectedItem());
            if (n3 != null) {
                designProperty.setValue((Object)n3);
            } else {
                designProperty.unset();
            }
            designProperty = this.designBean.getProperty("maxFractionDigits");
            Integer n4 = this.getInteger((String)this.cmbMaxFractional.getSelectedItem());
            if (n4 != null) {
                designProperty.setValue((Object)n4);
            } else {
                designProperty.unset();
            }
            designProperty = this.designBean.getProperty("groupingUsed");
            designProperty.setValue((Object)new Boolean(this.cbUseGrouping.isSelected()));
            designProperty = this.designBean.getProperty("locale");
            Locale locale = this.getLocaleBasedOnComboBoxIndex(this.cmbLocale.getSelectedIndex());
            if (locale == null) {
                designProperty.unset();
            } else {
                designProperty.setValue((Object)locale);
            }
            if (this.cmbType.getSelectedIndex() == 1) {
                if (this.rbSymbol.isSelected()) {
                    String string = this.txtEnterSymbol.getText().trim();
                    this.designBean.getProperty("currencySymbol").setValue((Object)string);
                    this.designBean.getProperty("currencyCode").unset();
                } else {
                    String string = null;
                    if (this.cmbCurrencyCode.getModel().getSize() == 1) {
                        string = Currency.getInstance(locale).getCurrencyCode();
                    } else {
                        int n5 = this.cmbCurrencyCode.getSelectedIndex();
                        string = ISO4217CurrencyCode.getCode(n5);
                    }
                    this.designBean.getProperty("currencyCode").setValue((Object)string);
                    this.designBean.getProperty("currencySymbol").unset();
                }
            } else {
                this.designBean.getProperty("currencyCode").unset();
                this.designBean.getProperty("currencySymbol").unset();
            }
            this.designBean.getProperty("pattern").unset();
        } else {
            designProperty = this.designBean.getProperty("pattern");
            designProperty.setValue(this.cmbPattern.getSelectedItem());
            this.designBean.getProperty("type").unset();
            this.designBean.getProperty("minIntegerDigits").unset();
            this.designBean.getProperty("maxIntegerDigits").unset();
            this.designBean.getProperty("minFractionDigits").unset();
            this.designBean.getProperty("maxFractionDigits").unset();
            this.designBean.getProperty("groupingUsed").unset();
            this.designBean.getProperty("currencyCode").unset();
            this.designBean.getProperty("currencySymbol").unset();
            this.designBean.getProperty("locale").unset();
        }
        designProperty = this.designBean.getProperty("integerOnly");
        designProperty.setValue((Object)new Boolean(this.cbIntegerOnly.isSelected()));
    }

    private Locale getLocaleBasedOnComboBoxIndex(int n) {
        if (n == 0) {
            return null;
        }
        return this.locales[n - 1];
    }

    private Integer getInteger(String string) {
        if (string != null && string.trim().length() != 0) {
            int n = Integer.parseInt(string.trim());
            return new Integer(n);
        }
        return null;
    }

    private String[] getLocaleDisplayNames() {
        this.locales = Locale.getAvailableLocales();
        Arrays.sort(this.locales, new LocaleComparator());
        String[] stringArray = new String[this.locales.length + 1];
        ArrayList arrayList = new ArrayList();
        stringArray[0] = "";
        for (int i = 0; i < this.locales.length; ++i) {
            stringArray[i + 1] = this.locales[i].getDisplayName();
        }
        return stringArray;
    }

    private void fillPanel() {
        DesignProperty designProperty = null;
        designProperty = this.designBean.getProperty("pattern");
        if (designProperty.getValue() != null && ((String)designProperty.getValue()).trim().length() != 0) {
            this.rbPattern.setSelected(true);
            this.rbType.setSelected(false);
            designProperty = this.designBean.getProperty("pattern");
            this.cmbPattern.setSelectedItem((String)designProperty.getValue());
        } else {
            this.rbType.setSelected(true);
            this.rbPattern.setSelected(false);
        }
        this.fillTypePanel();
        designProperty = this.designBean.getProperty("integerOnly");
        Boolean bl = (Boolean)designProperty.getValue();
        this.cbIntegerOnly.setSelected(bl);
        this.enableTypePanel();
        this.enablePatternPanel();
    }

    private void fillTypePanel() {
        Object var1_1 = null;
        String string = (String)this.designBean.getProperty("type").getValue();
        int n = this.getTypeIndex(string);
        this.cmbType.setSelectedIndex(n);
        Integer n2 = (Integer)this.designBean.getProperty("minIntegerDigits").getValue();
        this.cmbMinInteger.setSelectedItem(n2.toString());
        Integer n3 = (Integer)this.designBean.getProperty("maxIntegerDigits").getValue();
        this.cmbMaxInteger.setSelectedItem(n3.toString());
        Integer n4 = (Integer)this.designBean.getProperty("minFractionDigits").getValue();
        this.cmbMinFractional.setSelectedItem(n4.toString());
        Integer n5 = (Integer)this.designBean.getProperty("maxFractionDigits").getValue();
        this.cmbMaxFractional.setSelectedItem(n5.toString());
        Boolean bl = (Boolean)this.designBean.getProperty("groupingUsed").getValue();
        this.cbUseGrouping.setSelected(bl);
        Locale locale = (Locale)this.designBean.getProperty("locale").getValue();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.cmbLocale.setSelectedItem(locale.getDisplayName());
        if (n == 1) {
            String string2 = (String)this.designBean.getProperty("currencyCode").getValue();
            String string3 = (String)this.designBean.getProperty("currencySymbol").getValue();
            if (string2 != null) {
                this.rbCurrencyCode.setSelected(true);
                this.cmbCurrencyCode.setSelectedItem(ISO4217CurrencyCode.getDisplayName(string2));
            } else {
                this.rbSymbol.setSelected(true);
                this.txtEnterSymbol.setText(string3);
            }
        } else {
            try {
                Currency currency = Currency.getInstance(locale);
                this.cmbCurrencyCode.setSelectedItem(ISO4217CurrencyCode.getDisplayName(currency.getCurrencyCode()));
                this.txtEnterSymbol.setText(currency.getSymbol());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.rbCurrencyCode.setSelected(true);
            this.rbSymbol.setSelected(false);
        }
    }

    private int getTypeIndex(String string) {
        if (string.equals(typeValues[0])) {
            return 0;
        }
        if (string.equals(typeValues[1])) {
            return 1;
        }
        if (string.equals(typeValues[2])) {
            return 2;
        }
        return 0;
    }

    private boolean validateUserInput() {
        String string;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.rbType.isSelected()) {
            string = null;
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            try {
                string = (String)this.cmbMinInteger.getSelectedItem();
                n = string != null && string.trim().length() != 0 ? Integer.parseInt(string) : 1;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                stringBuffer.append(NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"badMinIntegerDigits"));
            }
            try {
                string = (String)this.cmbMaxInteger.getSelectedItem();
                n2 = string != null && string.trim().length() != 0 ? Integer.parseInt(string) : 40;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                stringBuffer.append(NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"badMaxIntegerDigits"));
            }
            try {
                string = (String)this.cmbMaxFractional.getSelectedItem();
                n4 = string != null && string.trim().length() != 0 ? Integer.parseInt(string) : 3;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                stringBuffer.append(NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"badMaxFractionalDigits"));
            }
            try {
                string = (String)this.cmbMinFractional.getSelectedItem();
                n3 = string != null && string.trim().length() != 0 ? Integer.parseInt(string) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
                stringBuffer.append(NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"badMinFractionalDigits"));
            }
            if (n2 == 0) {
                n2 = 40;
            }
            if (n == 0) {
                n = 1;
            }
            if (n4 == 0) {
                n4 = 3;
            }
            if (n3 == 0) {
                n3 = 0;
            }
            if (n2 < n) {
                bl = false;
                stringBuffer.append(NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"badIntegerDigits"));
            }
            if (n4 < n3) {
                bl = false;
                stringBuffer.append(NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"badFractionalDigits"));
            }
            if (this.cmbType.getSelectedIndex() == 1 && this.rbSymbol.isSelected() && (this.txtEnterSymbol.getText() == null || this.txtEnterSymbol.getText().trim().length() == 0)) {
                bl = false;
                stringBuffer.append(NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"emptySymbol"));
            }
        }
        if (this.rbPattern.isSelected()) {
            string = (String)this.cmbPattern.getSelectedItem();
            if (string == null || string.trim().length() == 0) {
                bl = false;
                stringBuffer.append(NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"emptyPattern"));
            }
            try {
                ((DecimalFormat)DecimalFormat.getInstance()).applyPattern(((String)this.cmbPattern.getSelectedItem()).trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
                stringBuffer.append(NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"badPattern", (Object)string));
            }
        }
        if (!bl) {
            string = new NotifyDescriptor.Message((Object)stringBuffer, 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)string);
        }
        return bl;
    }

    private void enableTypePanel() {
        boolean bl = this.rbType.isSelected();
        this.cmbType.setEnabled(bl);
        this.cmbMinInteger.setEnabled(bl);
        this.cmbMaxInteger.setEnabled(bl);
        this.cmbMinFractional.setEnabled(bl);
        this.cmbMaxFractional.setEnabled(bl);
        this.cmbLocale.setEnabled(bl);
        this.cbUseGrouping.setEnabled(bl);
        this.lblMinFractional.setEnabled(bl);
        this.lblMaxFractional.setEnabled(bl);
        this.lblMinInteger.setEnabled(bl);
        this.lblMaxInteger.setEnabled(bl);
        this.lblFractional.setEnabled(bl);
        this.lblInteger.setEnabled(bl);
        this.lblLocale.setEnabled(bl);
        this.lblChooseCurrency.setEnabled(bl);
        this.enableCurrencyCombos();
    }

    private void enablePatternPanel() {
        boolean bl = this.rbPattern.isSelected();
        this.cmbPattern.setEnabled(bl);
    }

    private void enableCurrencyCombos() {
        boolean bl = false;
        Locale locale = this.getLocaleBasedOnComboBoxIndex(this.cmbLocale.getSelectedIndex());
        if (locale == null) {
            bl = true;
            locale = Locale.getDefault();
        }
        String string = null;
        String string2 = null;
        try {
            Currency currency = Currency.getInstance(locale);
            string = ISO4217CurrencyCode.getDisplayName(currency.getCurrencyCode());
            string2 = currency.getSymbol(locale);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
            for (int i = this.cmbLocale.getSelectedIndex(); i < this.locales.length; ++i) {
                try {
                    Locale locale2 = this.getLocaleBasedOnComboBoxIndex(i);
                    Currency currency = Currency.getInstance(locale2);
                    string = ISO4217CurrencyCode.getDisplayName(currency.getCurrencyCode());
                    string2 = currency.getSymbol(locale2);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        boolean bl2 = this.cmbType.getSelectedIndex() == 1 && this.rbType.isSelected();
        this.rbCurrencyCode.setEnabled(bl2);
        this.rbSymbol.setEnabled(bl2);
        this.lblChooseCurrency.setEnabled(bl2);
        this.cmbCurrencyCode.setEnabled(bl2);
        this.txtEnterSymbol.setEnabled(bl2);
        this.txtEnterSymbol.setText(string2);
        this.cmbCurrencyCode.removeAllItems();
        if (!bl) {
            this.cmbCurrencyCode.setModel(new DefaultComboBoxModel<String>(new String[]{string}));
            this.txtEnterSymbol.setEditable(false);
        } else {
            this.cmbCurrencyCode.setModel(new DefaultComboBoxModel<String>(ISO4217CurrencyCode.getDisplayNames()));
            this.txtEnterSymbol.setEditable(true);
        }
        this.cmbCurrencyCode.setSelectedItem(string);
        if (bl2) {
            if (this.rbCurrencyCode.isSelected()) {
                this.txtEnterSymbol.setEnabled(false);
            } else {
                this.cmbCurrencyCode.setEnabled(false);
            }
        }
    }

    private void cmbExampleFocusLost(FocusEvent focusEvent) {
        this.btnTest.setDefaultCapable(false);
    }

    private void upateSampleResult() {
        if (!this.validateUserInput()) {
            return;
        }
        double d = 0.0;
        try {
            d = Double.parseDouble((String)this.cmbExample.getSelectedItem());
        }
        catch (NumberFormatException numberFormatException) {
            this.txtResults.setText(NbBundle.getMessage(NumberConverterCustomizerPanel.class, (String)"notANumber", (Object)((String)this.cmbExample.getSelectedItem())));
            return;
        }
        if (this.rbType.isSelected()) {
            Object object;
            Serializable serializable;
            NumberFormat numberFormat;
            Locale locale = this.getLocaleBasedOnComboBoxIndex(this.cmbLocale.getSelectedIndex());
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (this.cmbType.getSelectedIndex() == 0) {
                numberFormat = NumberFormat.getNumberInstance(locale);
            } else if (this.cmbType.getSelectedIndex() == 1) {
                numberFormat = NumberFormat.getCurrencyInstance(locale);
                serializable = null;
                if (this.rbCurrencyCode.isSelected()) {
                    object = null;
                    if (this.cmbCurrencyCode.getModel().getSize() == 1) {
                        object = Currency.getInstance(locale).getCurrencyCode();
                    } else {
                        int n = this.cmbCurrencyCode.getSelectedIndex();
                        object = ISO4217CurrencyCode.getCode(n);
                    }
                    serializable = Currency.getInstance((String)object);
                    numberFormat.setCurrency((Currency)serializable);
                } else {
                    object = (DecimalFormat)numberFormat;
                    DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)object).getDecimalFormatSymbols();
                    decimalFormatSymbols.setCurrencySymbol(this.txtEnterSymbol.getText().trim());
                    ((DecimalFormat)object).setDecimalFormatSymbols(decimalFormatSymbols);
                }
            } else {
                numberFormat = NumberFormat.getPercentInstance(locale);
            }
            serializable = this.getInteger((String)this.cmbMinInteger.getSelectedItem());
            object = this.getInteger((String)this.cmbMaxInteger.getSelectedItem());
            Integer n = this.getInteger((String)this.cmbMinFractional.getSelectedItem());
            Integer n2 = this.getInteger((String)this.cmbMaxFractional.getSelectedItem());
            if (serializable != null && (Integer)serializable != 0) {
                numberFormat.setMinimumIntegerDigits((Integer)serializable);
            }
            if (object != null && (Integer)object != 0) {
                numberFormat.setMaximumIntegerDigits((Integer)object);
            }
            if (n != null && n != 0) {
                numberFormat.setMinimumFractionDigits(n);
            }
            if (n2 != null && n2 != 0) {
                numberFormat.setMaximumFractionDigits(n2);
            }
            numberFormat.setGroupingUsed(this.cbUseGrouping.isSelected());
            numberFormat.setParseIntegerOnly(this.cbIntegerOnly.isSelected());
            this.txtResults.setText(numberFormat.format(d));
        } else {
            DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getInstance();
            decimalFormat.applyPattern(((String)this.cmbPattern.getSelectedItem()).trim());
            decimalFormat.setParseIntegerOnly(this.cbIntegerOnly.isSelected());
            this.txtResults.setText(decimalFormat.format(d));
        }
    }

    private void initComponents() {
        this.typePatternGroup = new ButtonGroup();
        this.currencyGroup = new ButtonGroup();
        this.pnlTypePattern = new JPanel();
        this.cmbType = new JComboBox();
        this.cmbPattern = new JComboBox();
        this.rbType = new JRadioButton();
        this.rbPattern = new JRadioButton();
        this.pnlType = new JPanel();
        this.pnlFractional = new JPanel();
        this.lblMinFractional = new JLabel();
        this.lblMaxFractional = new JLabel();
        this.cmbMinFractional = new JComboBox();
        this.cmbMaxFractional = new JComboBox();
        this.pnlInteger = new JPanel();
        this.lblMinInteger = new JLabel();
        this.lblMaxInteger = new JLabel();
        this.cmbMinInteger = new JComboBox();
        this.cmbMaxInteger = new JComboBox();
        this.lblFractional = new JLabel();
        this.lblInteger = new JLabel();
        this.cbUseGrouping = new JCheckBox();
        this.pnlLocale = new JPanel();
        this.rbCurrencyCode = new JRadioButton();
        this.cmbLocale = new JComboBox();
        this.lblLocale = new JLabel();
        this.lblChooseCurrency = new JLabel();
        this.rbSymbol = new JRadioButton();
        this.txtEnterSymbol = new JTextField();
        this.cmbCurrencyCode = new JComboBox();
        this.cbIntegerOnly = new JCheckBox();
        this.pnlExample = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.lblExample = new JLabel();
        this.txtResults = new JTextField();
        this.lblResults = new JLabel();
        this.cmbExample = new JComboBox();
        this.btnTest = new JButton();
        this.txtExampleInstructions = new JTextPane();
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                NumberConverterCustomizerPanel.this.formFocusGained(focusEvent);
            }
        });
        this.setLayout(new GridBagLayout());
        this.pnlTypePattern.setLayout(new GridBagLayout());
        this.cmbType.setMinimumSize(new Dimension(100, 19));
        this.cmbType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberConverterCustomizerPanel.this.cmbTypeActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.pnlTypePattern.add((Component)this.cmbType, gridBagConstraints);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/faces/dt/converter/Bundle");
        this.cmbType.getAccessibleContext().setAccessibleName(resourceBundle.getString("type"));
        this.cmbType.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("typeDescription"));
        this.cmbPattern.setEditable(true);
        this.cmbPattern.setEnabled(false);
        this.cmbPattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberConverterCustomizerPanel.this.cmbPatternActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.pnlTypePattern.add((Component)this.cmbPattern, gridBagConstraints);
        this.cmbPattern.getAccessibleContext().setAccessibleName(resourceBundle.getString("pattern"));
        this.cmbPattern.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("pattern"));
        this.typePatternGroup.add(this.rbType);
        this.rbType.setMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("type_mnemonic").charAt(0));
        this.rbType.setSelected(true);
        this.rbType.setText(resourceBundle.getString("type"));
        this.rbType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberConverterCustomizerPanel.this.rbTypeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.pnlTypePattern.add((Component)this.rbType, gridBagConstraints);
        this.rbType.getAccessibleContext().setAccessibleName(resourceBundle.getString("type"));
        this.rbType.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("typeDescription"));
        this.typePatternGroup.add(this.rbPattern);
        this.rbPattern.setMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("pattern_mnemonic").charAt(0));
        this.rbPattern.setText(resourceBundle.getString("pattern"));
        this.rbPattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberConverterCustomizerPanel.this.rbPatternActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.pnlTypePattern.add((Component)this.rbPattern, gridBagConstraints);
        this.rbPattern.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("pattern"));
        this.pnlType.setLayout(new GridBagLayout());
        this.pnlFractional.setLayout(new GridBagLayout());
        this.lblMinFractional.setDisplayedMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("minFractional_mnemonic").charAt(0));
        this.lblMinFractional.setLabelFor(this.cmbMinFractional);
        this.lblMinFractional.setText(resourceBundle.getString("minFractional"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.pnlFractional.add((Component)this.lblMinFractional, gridBagConstraints);
        this.lblMinFractional.getAccessibleContext().setAccessibleName(resourceBundle.getString("minFractional"));
        this.lblMinFractional.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("minFractional"));
        this.lblMaxFractional.setDisplayedMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("maxFractional_mnemonic").charAt(0));
        this.lblMaxFractional.setLabelFor(this.cmbMaxFractional);
        this.lblMaxFractional.setText(resourceBundle.getString("maxFractional"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.pnlFractional.add((Component)this.lblMaxFractional, gridBagConstraints);
        this.lblMaxFractional.getAccessibleContext().setAccessibleName(resourceBundle.getString("maxFractional"));
        this.lblMaxFractional.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("maxFractional"));
        this.cmbMinFractional.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        this.pnlFractional.add((Component)this.cmbMinFractional, gridBagConstraints);
        this.cmbMaxFractional.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        this.pnlFractional.add((Component)this.cmbMaxFractional, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.pnlType.add((Component)this.pnlFractional, gridBagConstraints);
        this.pnlInteger.setLayout(new GridBagLayout());
        this.lblMinInteger.setDisplayedMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("minInteger_mnemonic").charAt(0));
        this.lblMinInteger.setLabelFor(this.cmbMinInteger);
        this.lblMinInteger.setText(resourceBundle.getString("minInteger"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.pnlInteger.add((Component)this.lblMinInteger, gridBagConstraints);
        this.lblMinInteger.getAccessibleContext().setAccessibleName(resourceBundle.getString("minInteger"));
        this.lblMinInteger.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("minInteger"));
        this.lblMaxInteger.setDisplayedMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("maxInteger_mnemonic").charAt(0));
        this.lblMaxInteger.setLabelFor(this.cmbMaxInteger);
        this.lblMaxInteger.setText(resourceBundle.getString("maxInteger"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.pnlInteger.add((Component)this.lblMaxInteger, gridBagConstraints);
        this.lblMaxInteger.getAccessibleContext().setAccessibleName(resourceBundle.getString("maxInteger"));
        this.lblMaxInteger.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("maxInteger"));
        this.cmbMinInteger.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        this.pnlInteger.add((Component)this.cmbMinInteger, gridBagConstraints);
        this.cmbMaxInteger.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.3;
        this.pnlInteger.add((Component)this.cmbMaxInteger, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.pnlType.add((Component)this.pnlInteger, gridBagConstraints);
        this.lblFractional.setDisplayedMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("fractionalDigits_mnemonic").charAt(0));
        this.lblFractional.setLabelFor(this.cmbMinFractional);
        this.lblFractional.setText(resourceBundle.getString("fracDigits"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.pnlType.add((Component)this.lblFractional, gridBagConstraints);
        this.lblFractional.getAccessibleContext().setAccessibleName(resourceBundle.getString("fractionalDigits"));
        this.lblFractional.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("fractionalDigits"));
        this.lblInteger.setDisplayedMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("integerDigits_mnemonic").charAt(0));
        this.lblInteger.setLabelFor(this.cmbMinInteger);
        this.lblInteger.setText(resourceBundle.getString("intDigits"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.pnlType.add((Component)this.lblInteger, gridBagConstraints);
        this.lblInteger.getAccessibleContext().setAccessibleName(resourceBundle.getString("integerDigits"));
        this.lblInteger.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("integerDigits"));
        this.cbUseGrouping.setMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("groupingUsed_mnemonic").charAt(0));
        this.cbUseGrouping.setSelected(true);
        this.cbUseGrouping.setText(resourceBundle.getString("groupingUsed"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlType.add((Component)this.cbUseGrouping, gridBagConstraints);
        this.cbUseGrouping.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("groupingUsed"));
        this.pnlLocale.setLayout(new GridBagLayout());
        this.currencyGroup.add(this.rbCurrencyCode);
        this.rbCurrencyCode.setMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("currencyCode_mnemonic").charAt(0));
        this.rbCurrencyCode.setSelected(true);
        this.rbCurrencyCode.setText(resourceBundle.getString("currencyCode"));
        this.rbCurrencyCode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberConverterCustomizerPanel.this.rbCurrencyCodeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.pnlLocale.add((Component)this.rbCurrencyCode, gridBagConstraints);
        this.rbCurrencyCode.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("currencyCode"));
        this.cmbLocale.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberConverterCustomizerPanel.this.cmbLocaleActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.pnlLocale.add((Component)this.cmbLocale, gridBagConstraints);
        this.cmbLocale.getAccessibleContext().setAccessibleName(resourceBundle.getString("locale"));
        this.cmbLocale.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("locale"));
        this.lblLocale.setDisplayedMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("locale_mnemonic").charAt(0));
        this.lblLocale.setLabelFor(this.cmbLocale);
        this.lblLocale.setText(resourceBundle.getString("locale"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.pnlLocale.add((Component)this.lblLocale, gridBagConstraints);
        this.lblChooseCurrency.setDisplayedMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("chooseCurrency_mnemonic").charAt(0));
        this.lblChooseCurrency.setLabelFor(this.cmbCurrencyCode);
        this.lblChooseCurrency.setText(resourceBundle.getString("chooseCurrency"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.pnlLocale.add((Component)this.lblChooseCurrency, gridBagConstraints);
        this.lblChooseCurrency.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("currencyCode"));
        this.currencyGroup.add(this.rbSymbol);
        this.rbSymbol.setMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("symbol_mnemonic").charAt(0));
        this.rbSymbol.setText(resourceBundle.getString("symbol"));
        this.rbSymbol.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberConverterCustomizerPanel.this.rbSymbolActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.pnlLocale.add((Component)this.rbSymbol, gridBagConstraints);
        this.rbSymbol.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("symbol"));
        this.txtEnterSymbol.setColumns(10);
        this.txtEnterSymbol.setHorizontalAlignment(2);
        this.txtEnterSymbol.setMinimumSize(new Dimension(35, 20));
        this.txtEnterSymbol.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberConverterCustomizerPanel.this.txtEnterSymbolActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(2, 10, 0, 0);
        this.pnlLocale.add((Component)this.txtEnterSymbol, gridBagConstraints);
        this.txtEnterSymbol.getAccessibleContext().setAccessibleName(resourceBundle.getString("symbol"));
        this.txtEnterSymbol.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("symbol"));
        this.cmbCurrencyCode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberConverterCustomizerPanel.this.cmbCurrencyCodeActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.pnlLocale.add((Component)this.cmbCurrencyCode, gridBagConstraints);
        this.cmbCurrencyCode.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("currencyCode"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlType.add((Component)this.pnlLocale, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 30, 6, 10);
        this.pnlTypePattern.add((Component)this.pnlType, gridBagConstraints);
        this.cbIntegerOnly.setMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("integerOnly_mnemonic").charAt(0));
        this.cbIntegerOnly.setText(resourceBundle.getString("intOnly"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.pnlTypePattern.add((Component)this.cbIntegerOnly, gridBagConstraints);
        this.cbIntegerOnly.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("intOnly"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.add((Component)this.pnlTypePattern, gridBagConstraints);
        this.pnlExample.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.pnlExample.add((Component)this.jSeparator1, gridBagConstraints);
        this.lblExample.setDisplayedMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("example_mnemonic").charAt(0));
        this.lblExample.setLabelFor(this.cmbExample);
        this.lblExample.setText(resourceBundle.getString("example"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.pnlExample.add((Component)this.lblExample, gridBagConstraints);
        this.lblExample.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("example"));
        this.txtResults.setEditable(false);
        this.txtResults.setText("1234.56");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.pnlExample.add((Component)this.txtResults, gridBagConstraints);
        this.txtResults.getAccessibleContext().setAccessibleName(resourceBundle.getString("results"));
        this.txtResults.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("results"));
        this.lblResults.setDisplayedMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("result_mnemonic").charAt(0));
        this.lblResults.setLabelFor(this.txtResults);
        this.lblResults.setText(resourceBundle.getString("results"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.pnlExample.add((Component)this.lblResults, gridBagConstraints);
        this.lblResults.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("results"));
        this.cmbExample.setEditable(true);
        this.cmbExample.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberConverterCustomizerPanel.this.cmbExampleActionPerformed(actionEvent);
            }
        });
        this.cmbExample.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                NumberConverterCustomizerPanel.this.cmbExampleFocusGained(focusEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.pnlExample.add((Component)this.cmbExample, gridBagConstraints);
        this.cmbExample.getAccessibleContext().setAccessibleName(resourceBundle.getString("example"));
        this.cmbExample.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("example"));
        this.btnTest.setMnemonic(NbBundle.getBundle(NumberConverterCustomizerPanel.class).getString("testBtn_mnemonic").charAt(0));
        this.btnTest.setText(resourceBundle.getString("testText"));
        this.btnTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NumberConverterCustomizerPanel.this.btnTestActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.pnlExample.add((Component)this.btnTest, gridBagConstraints);
        this.btnTest.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("testText"));
        this.txtExampleInstructions.setBackground(this.getBackground());
        this.txtExampleInstructions.setBorder(null);
        this.txtExampleInstructions.setEditable(false);
        this.txtExampleInstructions.setText(resourceBundle.getString("exampleInstructionsText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 11);
        this.pnlExample.add((Component)this.txtExampleInstructions, gridBagConstraints);
        this.txtExampleInstructions.getAccessibleContext().setAccessibleName(resourceBundle.getString("exampleInstructionsText"));
        this.txtExampleInstructions.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("exampleInstructionsText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.add((Component)this.pnlExample, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName("NumberFormat");
        this.getAccessibleContext().setAccessibleDescription("Number Format...");
    }

    private void btnTestActionPerformed(ActionEvent actionEvent) {
        this.upateSampleResult();
    }

    private void cmbExampleActionPerformed(ActionEvent actionEvent) {
        this.upateSampleResult();
    }

    private void cmbPatternActionPerformed(ActionEvent actionEvent) {
    }

    private void txtEnterSymbolActionPerformed(ActionEvent actionEvent) {
    }

    private void cmbLocaleActionPerformed(ActionEvent actionEvent) {
        this.enableCurrencyCombos();
    }

    private void cmbCurrencyCodeActionPerformed(ActionEvent actionEvent) {
    }

    private void rbCurrencyCodeActionPerformed(ActionEvent actionEvent) {
        this.enableCurrencyCombos();
    }

    private void rbSymbolActionPerformed(ActionEvent actionEvent) {
        this.enableCurrencyCombos();
    }

    private void cmbTypeActionPerformed(ActionEvent actionEvent) {
        this.enableCurrencyCombos();
    }

    private void rbPatternActionPerformed(ActionEvent actionEvent) {
        if (this.rbPattern.isSelected()) {
            this.rbType.setSelected(false);
        } else {
            this.rbType.setSelected(true);
        }
        this.enablePatternPanel();
        this.enableTypePanel();
    }

    private void rbTypeActionPerformed(ActionEvent actionEvent) {
        if (this.rbType.isSelected()) {
            this.rbPattern.setSelected(false);
        } else {
            this.rbPattern.setSelected(true);
        }
        this.enablePatternPanel();
        this.enableTypePanel();
    }

    private void cmbExampleFocusGained(FocusEvent focusEvent) {
        this.btnTest.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(this.btnTest);
    }

    private void formFocusGained(FocusEvent focusEvent) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LocaleComparator
    implements Comparator<Locale> {
        LocaleComparator() {
        }

        @Override
        public int compare(Locale locale, Locale locale2) {
            return locale.getDisplayName().compareTo(locale2.getDisplayName());
        }
    }
}

