/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.remoting.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shale.remoting.faces.ResponseFactory;
import org.apache.shale.remoting.impl.FilteringProcessor;

public abstract class AbstractResourceProcessor
extends FilteringProcessor {
    private transient Log log = null;
    private int bufferSize = 1024;
    private long lastModified = 0L;
    private String lastModifiedString = null;
    protected Map mimeTypes = new HashMap();
    private static SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);

    public AbstractResourceProcessor() {
        this.mimeTypes.put(".css", "text/css");
        this.mimeTypes.put(".gif", "image/gif");
        this.mimeTypes.put(".ico", "image/vnd.microsoft.icon");
        this.mimeTypes.put(".jpeg", "image/jpeg");
        this.mimeTypes.put(".jpg", "image/jpeg");
        this.mimeTypes.put(".js", "text/javascript");
        this.mimeTypes.put(".png", "image/png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(FacesContext context, String resourceId) throws IOException {
        if (resourceId == null) {
            throw new NullPointerException();
        }
        if (!resourceId.startsWith("/")) {
            throw new IllegalArgumentException(resourceId);
        }
        if (context.getResponseComplete()) {
            return;
        }
        if (!this.accept(resourceId)) {
            if (this.log().isTraceEnabled()) {
                this.log().trace((Object)("Resource id '" + resourceId + "' rejected by include/exclude rules"));
            }
            this.sendNotFound(context, resourceId);
            context.responseComplete();
            return;
        }
        URL url = this.getResourceURL(context, resourceId);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)("Translated resource id '" + resourceId + "' to URL '" + url + "'"));
        }
        if (url == null) {
            if (this.log().isTraceEnabled()) {
                this.log().trace((Object)("Resource '" + resourceId + "' not found, returning 404"));
            }
            this.sendNotFound(context, resourceId);
            context.responseComplete();
            return;
        }
        long ifModifiedSince = this.ifModifiedSince(context);
        if (ifModifiedSince >= 0L && ifModifiedSince + 1000L >= this.getLastModified()) {
            if (this.log().isTraceEnabled()) {
                this.log().trace((Object)("Resource '" + resourceId + "' not modified, returning 304"));
            }
            this.sendNotModified(context, resourceId);
            context.responseComplete();
            return;
        }
        this.sendLastModified(context, this.getLastModifiedString());
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = this.inputStream(context, url);
            String contentType = this.mimeType(context, resourceId);
            outputStream = this.outputStream(context, contentType);
            this.copyStream(context, inputStream, outputStream);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {}
            }
        }
        context.responseComplete();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public long getLastModified() {
        if (this.lastModified == 0L) {
            this.setLastModified(new Date().getTime());
        }
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
        this.lastModifiedString = this.httpTimestamp(lastModified);
    }

    public String getLastModifiedString() {
        if (this.lastModified == 0L) {
            this.setLastModified(new Date().getTime());
        }
        return this.lastModifiedString;
    }

    protected abstract URL getResourceURL(FacesContext var1, String var2);

    protected void copyStream(FacesContext context, InputStream inputStream, OutputStream outputStream) throws IOException {
        int len;
        byte[] buffer = new byte[this.getBufferSize()];
        while ((len = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String httpTimestamp(Date timestamp) {
        SimpleDateFormat simpleDateFormat = format;
        synchronized (simpleDateFormat) {
            return format.format(timestamp);
        }
    }

    protected String httpTimestamp(long timestamp) {
        return this.httpTimestamp(new Date(timestamp));
    }

    protected long ifModifiedSince(FacesContext context) {
        Object request = context.getExternalContext().getRequest();
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).getDateHeader("If-Modified-Since");
        }
        return -1L;
    }

    protected InputStream inputStream(FacesContext context, URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setUseCaches(false);
        return conn.getInputStream();
    }

    protected String mimeType(FacesContext context, String resourceId) {
        Object ctxt = context.getExternalContext().getContext();
        Class<?> clazz = ctxt.getClass();
        Method method = null;
        try {
            method = clazz.getMethod("getMimeType", String.class);
            String result = (String)method.invoke(ctxt, resourceId);
            if (result != null) {
                return result;
            }
            Iterator entries = this.mimeTypes.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (!resourceId.endsWith((String)entry.getKey())) continue;
                return (String)entry.getValue();
            }
            return null;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"mimeType.exception", (Throwable)e);
            }
            return null;
        }
    }

    protected OutputStream outputStream(FacesContext context, String contentType) throws IOException {
        return new ResponseFactory().getResponseStream(context, contentType);
    }

    protected boolean servletRequest(FacesContext context) {
        return context.getExternalContext().getContext() instanceof ServletContext;
    }

    protected void sendContentType(FacesContext context, String contentType) {
        block2: {
            Object response = context.getExternalContext().getResponse();
            try {
                Method method = response.getClass().getMethod("setResponseType", String.class);
                method.invoke(response, contentType);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) break block2;
                this.log.error((Object)"contentType.exception", (Throwable)e);
            }
        }
    }

    protected void sendLastModified(FacesContext context, String timestamp) {
        Object response = context.getExternalContext().getResponse();
        if (response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).setHeader("Last-Modified", timestamp);
        }
    }

    protected void sendNotFound(FacesContext context, String resourceId) throws IOException {
        if (!this.servletRequest(context)) {
            throw new IllegalArgumentException(resourceId);
        }
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.sendError(404, resourceId);
    }

    protected void sendNotModified(FacesContext context, String resourceId) throws IOException {
        if (!this.servletRequest(context)) {
            throw new IllegalArgumentException(resourceId);
        }
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        response.sendError(304, resourceId);
    }

    private Log log() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)AbstractResourceProcessor.class);
        }
        return this.log;
    }

    static {
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
    }
}

