/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.core.spi.multiview.SourceViewMarker;
import org.netbeans.modules.form.ComponentInspector;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.PersistenceException;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.GuardedSectionsFactory;
import org.netbeans.spi.editor.guards.GuardedSectionsProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.text.PositionRef;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Task;
import org.openide.util.UserQuestionException;
import org.openide.windows.CloneableOpenSupport;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public class FormEditorSupport
extends DataEditorSupport
implements EditorCookie.Observable,
CloseCookie,
PrintCookie {
    private static final String MV_FORM_ID = "form";
    private static final String MV_JAVA_ID = "java";
    private static final int JAVA_ELEMENT_INDEX = 0;
    private static final int FORM_ELEMENT_INDEX = 1;
    private int elementToOpen;
    private static final String SECTION_INIT_COMPONENTS = "initComponents";
    private static final String SECTION_VARIABLES = "variables";
    private static final String iconURL = "org/netbeans/modules/form/resources/form.gif";
    private FormDataObject formDataObject;
    private CloneableTopComponent multiviewTC;
    private static PropertyChangeListener topcompsListener;
    private UndoRedo.Manager editorUndoManager;
    private FormEditor formEditor;
    private static Set<FormEditorSupport> opened;
    private static Map<FileSystem, FileStatusListener> fsToStatusListener;
    private boolean saving;
    private static Boolean groupVisible;
    private FormGEditor guardedEditor;
    private GuardedSectionsProvider guardedProvider;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            if (FormEditorSupport.this.formEditor == null) {
                this.doSave(false);
            } else if (EventQueue.isDispatchThread()) {
                this.doSave(true);
            } else {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        public void run() {
                            this.doSave(true);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(FormEditorSupport.class.getName()).log(Level.INFO, "", interruptedException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Logger.getLogger(FormEditorSupport.class.getName()).log(Level.INFO, "", invocationTargetException);
                }
            }
        }

        private void doSave(boolean bl) {
            try {
                if (bl) {
                    FormEditorSupport.this.saveDocument();
                } else {
                    FormEditorSupport.this.saveSourceOnly();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(FormEditorSupport.class.getName()).log(Level.INFO, "", iOException);
            }
        }
    };
    private final CookieSet cookies;

    public FormEditorSupport(MultiDataObject.Entry entry, FormDataObject formDataObject, CookieSet cookieSet) {
        super((DataObject)formDataObject, (CloneableEditorSupport.Env)new Environment((DataObject)formDataObject));
        this.setMIMEType("text/x-java");
        this.formDataObject = formDataObject;
        this.cookies = cookieSet;
    }

    public void openFormEditor(boolean bl) {
        boolean bl2;
        boolean bl3 = opened.contains((Object)this);
        boolean bl4 = bl2 = bl || !bl3;
        if (bl2) {
            this.elementToOpen = 1;
        }
        this.multiviewTC = this.openCloneableTopComponent();
        this.multiviewTC.requestActive();
        if (bl2) {
            MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)this.multiviewTC);
            multiViewHandler.requestActive(multiViewHandler.getPerspectives()[1]);
        }
    }

    private void addStatusListener(FileSystem fileSystem) {
        FileStatusListener fileStatusListener = fsToStatusListener.get(fileSystem);
        if (fileStatusListener == null) {
            fileStatusListener = new FileStatusListener(){

                public void annotationChanged(FileStatusEvent fileStatusEvent) {
                    for (FormEditorSupport formEditorSupport : opened) {
                        if (!fileStatusEvent.hasChanged(formEditorSupport.getFormDataObject().getPrimaryFile()) && !fileStatusEvent.hasChanged(formEditorSupport.getFormDataObject().getFormFile())) continue;
                        formEditorSupport.updateMVTCDisplayName();
                    }
                }
            };
            fileSystem.addFileStatusListener(fileStatusListener);
            fsToStatusListener.put(fileSystem, fileStatusListener);
        }
    }

    private static void detachStatusListeners() {
        for (Map.Entry<FileSystem, FileStatusListener> entry : fsToStatusListener.entrySet()) {
            FileSystem fileSystem = entry.getKey();
            FileStatusListener fileStatusListener = entry.getValue();
            fileSystem.removeFileStatusListener(fileStatusListener);
        }
        fsToStatusListener.clear();
    }

    void selectJavaEditor() {
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)this.multiviewTC);
        if (multiViewHandler != null) {
            multiViewHandler.requestActive(multiViewHandler.getPerspectives()[0]);
        }
    }

    public void open() {
        if (EventQueue.isDispatchThread()) {
            this.openInAWT();
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FormEditorSupport.this.openInAWT();
                }
            });
        }
    }

    private void openInAWT() {
        if (!this.formDataObject.isValid()) {
            return;
        }
        if (Boolean.TRUE.equals(this.formDataObject.getPrimaryFile().getAttribute("nonEditableTemplate"))) {
            String string = FormUtils.getBundleString("MSG_NonEditableTemplate");
            String string2 = MessageFormat.format(string, this.formDataObject.getNodeDelegate().getName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2));
            return;
        }
        this.elementToOpen = 0;
        super.open();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)this.multiviewTC);
        if (multiViewHandler != null) {
            multiViewHandler.requestActive(multiViewHandler.getPerspectives()[0]);
        }
    }

    public void openAt(PositionRef positionRef) {
        this.elementToOpen = 0;
        this.openCloneableTopComponent();
        MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)this.multiviewTC);
        multiViewHandler.requestActive(multiViewHandler.getPerspectives()[0]);
        this.openAt(positionRef, -1).getComponent().requestActive();
    }

    public void openAt(Position position) {
        this.openAt(this.createPositionRef(position.getOffset(), Position.Bias.Forward));
    }

    public boolean loadForm() {
        this.getFormEditor(true);
        return this.formEditor.loadForm();
    }

    public boolean isOpened() {
        return this.formEditor != null && this.formEditor.isFormLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument() throws IOException {
        IOException iOException = null;
        try {
            if (this.formEditor != null) {
                this.formEditor.saveFormData();
            }
            this.saving = true;
            super.saveDocument();
        }
        catch (PersistenceException persistenceException) {
            Throwable throwable = persistenceException.getOriginalException();
            if (throwable instanceof IOException) {
                iOException = (IOException)throwable;
            } else {
                iOException = new IOException("Cannot save the form");
                ErrorManager.getDefault().annotate((Throwable)iOException, throwable != null ? throwable : persistenceException);
            }
        }
        finally {
            this.saving = false;
        }
        if (this.formEditor != null) {
            this.formEditor.reportErrors(2);
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveSourceOnly() throws IOException {
        try {
            this.saving = true;
            super.saveDocument();
        }
        finally {
            this.saving = false;
        }
    }

    public final FormDataObject getFormDataObject() {
        return this.formDataObject;
    }

    public static FormDataObject getFormDataObject(FormModel formModel) {
        return FormEditor.getFormDataObject(formModel);
    }

    public FormModel getFormModel() {
        FormEditor formEditor = this.getFormEditor();
        return formEditor == null ? null : formEditor.getFormModel();
    }

    public FormEditor getFormEditor() {
        return this.getFormEditor(false);
    }

    FormEditor getFormEditor(boolean bl) {
        if (this.formEditor == null && bl) {
            this.formEditor = new FormEditor(this.formDataObject);
        }
        return this.formEditor;
    }

    void markFormModified() {
        if (this.formEditor != null && this.formEditor.isFormLoaded() && !this.formDataObject.isModified()) {
            this.notifyModified();
        }
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        this.editorUndoManager = super.createUndoRedoManager();
        return this.editorUndoManager;
    }

    void discardEditorUndoableEdits() {
        if (this.editorUndoManager != null) {
            this.editorUndoManager.discardAllEdits();
        }
    }

    JEditorPane getEditorPane() {
        return this.multiviewTC != null ? ((CloneableEditorSupport.Pane)this.multiviewTC).getEditorPane() : null;
    }

    public void reloadForm() {
        if (this.canClose()) {
            this.reloadDocument();
        }
    }

    protected Task reloadDocument() {
        if (this.multiviewTC == null) {
            return super.reloadDocument();
        }
        Task task = super.reloadDocument();
        if (this.saving) {
            return task;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FormDesigner formDesigner = FormEditorSupport.this.getFormEditor(true).getFormDesigner();
                if (formDesigner == null) {
                    formDesigner = (FormDesigner)((Object)FormEditorSupport.this.multiviewTC.getClientProperty((Object)"formDesigner"));
                }
                if (formDesigner == null) {
                    return;
                }
                FormEditorSupport.this.getFormEditor().closeForm();
                FormEditorSupport.this.formEditor = null;
                formDesigner.reset(FormEditorSupport.this.getFormEditor(true));
                FormEditorSupport.this.getFormEditor().setFormDesigner(formDesigner);
                if (formDesigner.isShowing()) {
                    FormEditorSupport.this.loadForm();
                    FormEditor formEditor = FormEditorSupport.this.getFormEditor();
                    formEditor.reportErrors(1);
                    if (!formEditor.isFormLoaded()) {
                        formDesigner.removeAll();
                    } else {
                        formDesigner.initialize();
                    }
                    ComponentInspector.getInstance().focusForm(formEditor);
                    formDesigner.revalidate();
                    formDesigner.repaint();
                }
            }
        });
        return task;
    }

    public FormEditor reloadFormEditor() {
        if (this.formEditor == null || !this.formEditor.isFormLoaded()) {
            return null;
        }
        FormDesigner formDesigner = this.formEditor.getFormDesigner();
        if (formDesigner == null) {
            formDesigner = (FormDesigner)((Object)this.multiviewTC.getClientProperty((Object)"formDesigner"));
        }
        this.formEditor.closeForm();
        this.formEditor = null;
        this.formEditor = this.getFormEditor(true);
        if (formDesigner != null) {
            formDesigner.reset(this.formEditor);
            this.formEditor.setFormDesigner(formDesigner);
        }
        this.loadForm();
        this.formEditor.reportErrors(1);
        if (this.formEditor.isFormLoaded() && formDesigner != null && formDesigner.isShowing()) {
            formDesigner.initialize();
        }
        return this.formEditor;
    }

    public void closeFormEditor() {
        if (this.isOpened()) {
            final FormDesigner formDesigner = this.formEditor.getFormDesigner();
            this.formEditor.closeForm();
            Runnable runnable = new Runnable(){

                public void run() {
                    if (formDesigner != null) {
                        formDesigner.reset(FormEditorSupport.this.formEditor);
                    }
                    FormEditorSupport.this.selectJavaEditor();
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                try {
                    EventQueue.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
        }
    }

    protected void notifyClosed() {
        opened.remove((Object)this);
        if (opened.isEmpty()) {
            FormEditorSupport.detachTopComponentsListener();
            FormEditorSupport.detachStatusListeners();
        }
        super.notifyClosed();
        if (this.formEditor != null) {
            this.formEditor.closeForm();
            this.formEditor = null;
        }
        this.multiviewTC = null;
        this.guardedProvider = null;
        this.guardedEditor = null;
        this.elementToOpen = 0;
    }

    private void multiViewClosed(CloneableTopComponent cloneableTopComponent) {
        boolean bl;
        Enumeration enumeration = cloneableTopComponent.getReference().getComponents();
        boolean bl2 = bl = !enumeration.hasMoreElements();
        if (this.multiviewTC == cloneableTopComponent) {
            this.multiviewTC = null;
            FormDesigner formDesigner = null;
            while (enumeration.hasMoreElements()) {
                this.multiviewTC = (CloneableTopComponent)enumeration.nextElement();
                FormDesigner formDesigner2 = (FormDesigner)((Object)this.multiviewTC.getClientProperty((Object)"formDesigner"));
                if (formDesigner2 == null) continue;
                formDesigner = formDesigner2;
                break;
            }
            if (!bl && formDesigner == null && this.formEditor != null) {
                this.formEditor.closeForm();
                this.formEditor = null;
            }
        }
        if (bl) {
            this.notifyClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean notifyModified() {
        boolean bl = this.isModified();
        boolean bl2 = super.notifyModified();
        if (bl2) {
            this.addSaveCookie();
        }
        if (!bl) {
            FileObject fileObject = this.formDataObject.getFormFile();
            if (!fileObject.canWrite()) {
                FileLock fileLock = null;
                try {
                    fileLock = fileObject.lock();
                }
                catch (UserQuestionException userQuestionException) {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)userQuestionException.getLocalizedMessage(), FormUtils.getBundleString("TITLE_UserQuestion"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (NotifyDescriptor.YES_OPTION.equals(confirmation.getValue())) {
                        try {
                            userQuestionException.confirmed();
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    FormEditorSupport.this.reloadForm();
                                }
                            });
                        }
                        catch (IOException iOException) {
                            ErrorManager.getDefault().notify(1, (Throwable)iOException);
                        }
                    }
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(1, (Throwable)iOException);
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
            this.updateMVTCDisplayName();
        }
        return bl2;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
        this.updateMVTCDisplayName();
    }

    private static void attachTopComponentsListener() {
        if (topcompsListener != null) {
            return;
        }
        topcompsListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("activated".equals(propertyChangeEvent.getPropertyName())) {
                    FormEditorSupport formEditorSupport;
                    TopComponent topComponent = TopComponent.getRegistry().getActivated();
                    if (FormEditorSupport.getSelectedElementType(topComponent) != -1 && (formEditorSupport = FormEditorSupport.getFormEditor(topComponent)) != null) {
                        formEditorSupport.multiviewTC = (CloneableTopComponent)topComponent;
                        FormDesigner formDesigner = (FormDesigner)((Object)topComponent.getClientProperty((Object)"formDesigner"));
                        if (formDesigner != null) {
                            formEditorSupport.getFormEditor().setFormDesigner(formDesigner);
                        }
                    }
                    FormEditorSupport.checkFormGroupVisibility();
                } else if ("opened".equals(propertyChangeEvent.getPropertyName())) {
                    Object object;
                    TopComponent topComponent;
                    CloneableTopComponent cloneableTopComponent = null;
                    Set set = (Set)propertyChangeEvent.getOldValue();
                    Set set2 = (Set)propertyChangeEvent.getNewValue();
                    if (set2.size() < set.size()) {
                        topComponent = set.iterator();
                        while (topComponent.hasNext()) {
                            object = topComponent.next();
                            if (set2.contains(object)) continue;
                            if (!(object instanceof CloneableTopComponent)) break;
                            cloneableTopComponent = (CloneableTopComponent)object;
                            break;
                        }
                    }
                    if (FormEditorSupport.getSelectedElementType(cloneableTopComponent) != -1 && (topComponent = FormEditorSupport.getFormEditor(cloneableTopComponent)) != null) {
                        ((FormEditorSupport)topComponent).multiViewClosed(cloneableTopComponent);
                    }
                    if ((topComponent = TopComponent.getRegistry().getActivated()) != null && FormEditorSupport.getSelectedElementType(topComponent) != -1 && (object = FormEditorSupport.getFormEditor(topComponent)) != null) {
                        ((FormEditorSupport)((Object)object)).updateMVTCDisplayName();
                    }
                }
            }
        };
        TopComponent.getRegistry().addPropertyChangeListener(topcompsListener);
    }

    private static void detachTopComponentsListener() {
        if (topcompsListener != null) {
            TopComponent.getRegistry().removePropertyChangeListener(topcompsListener);
            topcompsListener = null;
            TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup(MV_FORM_ID);
            if (topComponentGroup != null) {
                topComponentGroup.close();
            }
        }
    }

    protected CloneableEditorSupport.Pane createPane() {
        if (!this.formDataObject.isValid()) {
            return super.createPane();
        }
        MultiViewDescription[] multiViewDescriptionArray = new MultiViewDescription[]{new JavaDesc((DataObject)this.formDataObject), new FormDesc((DataObject)this.formDataObject)};
        CloneableTopComponent cloneableTopComponent = MultiViewFactory.createCloneableMultiView((MultiViewDescription[])multiViewDescriptionArray, (MultiViewDescription)multiViewDescriptionArray[this.elementToOpen], (CloseOperationHandler)new CloseHandler((DataObject)this.formDataObject));
        Mode mode = WindowManager.getDefault().findMode("editor");
        if (mode != null) {
            mode.dockInto((TopComponent)cloneableTopComponent);
        }
        try {
            this.addStatusListener(this.formDataObject.getPrimaryFile().getFileSystem());
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            fileStateInvalidException.printStackTrace();
        }
        return (CloneableEditorSupport.Pane)cloneableTopComponent;
    }

    private static String getMVTCToolTipText(FormDataObject formDataObject) {
        String string = FileUtil.getFileDisplayName((FileObject)formDataObject.getFormFile());
        if (string.endsWith(".form")) {
            string = string.substring(0, string.length() - 5);
        }
        return string;
    }

    private static String[] getMVTCDisplayName(FormDataObject formDataObject) {
        FormDesigner formDesigner;
        boolean bl = !formDataObject.getPrimaryFile().canWrite();
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        FormEditorSupport formEditorSupport = formDataObject.getFormEditor();
        FormModel formModel = null;
        if (formEditorSupport != null) {
            formModel = formEditorSupport.getFormModel();
        }
        if (topComponent != null && FormEditorSupport.getSelectedElementType(topComponent) == 1 && formModel != null) {
            boolean bl2 = bl = bl || formModel.isReadOnly();
        }
        int n = formDataObject.isModified() ? (bl ? 2 : 1) : (bl ? 0 : 3);
        Node node = formDataObject.getNodeDelegate();
        String string = node.getHtmlDisplayName();
        String string2 = node.getDisplayName();
        if (formModel != null && (formDesigner = FormEditor.getFormDesigner(formDataObject.getFormEditor().getFormModel())) != null && formDesigner.getFormModel() != null && formDesigner.isShowing() && !formDesigner.isTopRADComponent() && formDesigner.getTopDesignComponent() != null) {
            string2 = FormUtils.getFormattedBundleString("FMT_FormTitleWithContainerName", new Object[]{string2, formDesigner.getTopDesignComponent().getName()});
        }
        if (string != null && !string.trim().startsWith("<html>")) {
            string = "<html>" + string;
        }
        return new String[]{FormUtils.getFormattedBundleString("FMT_FormMVTCTitle", new Object[]{new Integer(n), string2}), string == null ? null : FormUtils.getFormattedBundleString("FMT_FormMVTCTitle", new Object[]{new Integer(n), string})};
    }

    void updateMVTCDisplayName() {
        if (EventQueue.isDispatchThread()) {
            this.updateMVTCDisplayNameInAWT();
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    FormEditorSupport.this.updateMVTCDisplayNameInAWT();
                }
            });
        }
    }

    private void updateMVTCDisplayNameInAWT() {
        if (this.multiviewTC == null || !this.formDataObject.isValid()) {
            return;
        }
        String[] stringArray = FormEditorSupport.getMVTCDisplayName(this.formDataObject);
        Enumeration enumeration = this.multiviewTC.getReference().getComponents();
        while (enumeration.hasMoreElements()) {
            TopComponent topComponent = (TopComponent)enumeration.nextElement();
            topComponent.setDisplayName(stringArray[0]);
            topComponent.setHtmlDisplayName(stringArray[1]);
        }
    }

    void updateMVTCToolTipText() {
        if (EventQueue.isDispatchThread()) {
            if (this.multiviewTC == null) {
                return;
            }
            String string = FormEditorSupport.getMVTCToolTipText(this.formDataObject);
            Enumeration enumeration = this.multiviewTC.getReference().getComponents();
            while (enumeration.hasMoreElements()) {
                TopComponent topComponent = (TopComponent)enumeration.nextElement();
                topComponent.setToolTipText(string);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    if (FormEditorSupport.this.multiviewTC == null) {
                        return;
                    }
                    String string = FormEditorSupport.getMVTCToolTipText(FormEditorSupport.this.formDataObject);
                    Enumeration enumeration = FormEditorSupport.this.multiviewTC.getReference().getComponents();
                    while (enumeration.hasMoreElements()) {
                        TopComponent topComponent = (TopComponent)enumeration.nextElement();
                        topComponent.setToolTipText(string);
                    }
                }
            });
        }
    }

    static boolean isLastView(TopComponent topComponent) {
        if (!(topComponent instanceof CloneableTopComponent)) {
            return false;
        }
        boolean bl = true;
        Enumeration enumeration = ((CloneableTopComponent)topComponent).getReference().getComponents();
        if (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                bl = false;
            }
        }
        return bl;
    }

    void setTopComponent(TopComponent topComponent) {
        this.multiviewTC = (CloneableTopComponent)topComponent;
        String[] stringArray = FormEditorSupport.getMVTCDisplayName(this.formDataObject);
        this.multiviewTC.setDisplayName(stringArray[0]);
        this.multiviewTC.setHtmlDisplayName(stringArray[1]);
        this.multiviewTC.setToolTipText(FormEditorSupport.getMVTCToolTipText(this.formDataObject));
        opened.add(this);
        FormEditorSupport.attachTopComponentsListener();
    }

    public static FormEditorSupport getFormEditor(TopComponent topComponent) {
        Object object = topComponent.getLookup().lookup(DataObject.class);
        return object instanceof FormDataObject ? ((FormDataObject)((Object)object)).getFormEditorSupport() : null;
    }

    static void checkFormGroupVisibility() {
        TopComponent topComponent;
        WindowManager windowManager = WindowManager.getDefault();
        TopComponentGroup topComponentGroup = windowManager.findTopComponentGroup(MV_FORM_ID);
        if (topComponentGroup == null) {
            return;
        }
        boolean bl = false;
        for (Mode mode : windowManager.getModes()) {
            topComponent = mode.getSelectedTopComponent();
            if (FormEditorSupport.getSelectedElementType(topComponent) != 1) continue;
            bl = true;
            break;
        }
        if (bl && !Boolean.TRUE.equals(groupVisible)) {
            Mode mode;
            groupVisible = Boolean.FALSE;
            topComponentGroup.open();
            groupVisible = Boolean.TRUE;
            mode = windowManager.findTopComponentGroup("commonpalette");
            if (null != mode) {
                mode.open();
            }
            if (!Boolean.TRUE.equals((topComponent = ComponentInspector.getInstance()).getClientProperty((Object)"isSliding"))) {
                topComponent.requestVisible();
            }
        } else if (!bl && !Boolean.FALSE.equals(groupVisible)) {
            topComponentGroup.close();
            groupVisible = Boolean.FALSE;
        }
    }

    static int getSelectedElementType(TopComponent topComponent) {
        MultiViewHandler multiViewHandler;
        if (topComponent != null && (multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent)) != null) {
            String string = multiViewHandler.getSelectedPerspective().preferredID();
            if (MV_JAVA_ID.equals(string)) {
                return 0;
            }
            if (MV_FORM_ID.equals(string)) {
                return 1;
            }
        }
        return -1;
    }

    public SimpleSection getVariablesSection() {
        return this.getGuardedSectionManager().findSimpleSection(SECTION_VARIABLES);
    }

    public SimpleSection getInitComponentSection() {
        return this.getGuardedSectionManager().findSimpleSection(SECTION_INIT_COMPONENTS);
    }

    public GuardedSectionManager getGuardedSectionManager() {
        try {
            StyledDocument styledDocument;
            block4: {
                styledDocument = null;
                try {
                    styledDocument = this.openDocument();
                }
                catch (UserQuestionException userQuestionException) {
                    Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)userQuestionException.getLocalizedMessage(), 0));
                    if (NotifyDescriptor.YES_OPTION != object) break block4;
                    userQuestionException.confirmed();
                    styledDocument = this.openDocument();
                }
            }
            return styledDocument == null ? null : GuardedSectionManager.getInstance((StyledDocument)styledDocument);
        }
        catch (IOException iOException) {
            throw (IllegalStateException)new IllegalStateException("cannot open document").initCause(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        Charset charset;
        if (this.guardedEditor == null) {
            this.guardedEditor = new FormGEditor();
            charset = GuardedSectionsFactory.find((String)((DataEditorSupport.Env)this.env).getMimeType());
            if (charset != null) {
                this.guardedProvider = charset.create(this.guardedEditor);
            }
        }
        if (this.guardedProvider != null) {
            this.guardedEditor.doc = styledDocument;
            charset = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
            Reader reader = this.guardedProvider.createGuardedReader(inputStream, charset);
            try {
                editorKit.read(reader, (Document)styledDocument, 0);
            }
            finally {
                reader.close();
            }
        } else {
            super.loadFromStreamToKit(styledDocument, inputStream, editorKit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        if (this.guardedProvider != null) {
            Charset charset = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
            Writer writer = this.guardedProvider.createGuardedWriter(outputStream, charset);
            try {
                editorKit.write(writer, (Document)styledDocument, 0, styledDocument.getLength());
            }
            finally {
                writer.close();
            }
        } else {
            super.saveFromKitToStream(styledDocument, editorKit, outputStream);
        }
    }

    public void addSaveCookie() {
        DataObject dataObject = this.getDataObject();
        if (dataObject.getCookie(SaveCookie.class) == null) {
            this.cookies.add((Node.Cookie)this.saveCookie);
            dataObject.setModified(true);
        }
    }

    public void removeSaveCookie() {
        DataObject dataObject = this.getDataObject();
        if (dataObject.getCookie(SaveCookie.class) != null) {
            this.cookies.remove((Node.Cookie)this.saveCookie);
            dataObject.setModified(false);
        }
    }

    static {
        opened = Collections.synchronizedSet(new HashSet());
        fsToStatusListener = new HashMap<FileSystem, FileStatusListener>();
        groupVisible = null;
    }

    private static final class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -1L;

        public Environment(DataObject dataObject) {
            super(dataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((FormDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getCookie(FormEditorSupport.class);
        }
    }

    private static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -3126744315424172415L;
        private DataObject dataObject;

        private CloseHandler() {
        }

        public CloseHandler(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        private FormEditorSupport getFormEditor() {
            return this.dataObject != null && this.dataObject instanceof FormDataObject ? ((FormDataObject)this.dataObject).getFormEditorSupport() : null;
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            FormEditorSupport formEditorSupport = this.getFormEditor();
            return formEditorSupport != null ? formEditorSupport.canClose() : true;
        }
    }

    private static class JavaEditorTopComponent
    extends CloneableEditor
    implements MultiViewElement {
        private static final long serialVersionUID = -3126744316624172415L;
        private transient JComponent toolbar;
        private transient MultiViewElementCallback multiViewObserver;

        JavaEditorTopComponent() {
        }

        JavaEditorTopComponent(DataEditorSupport dataEditorSupport) {
            super((CloneableEditorSupport)dataEditorSupport);
        }

        public JComponent getToolbarRepresentation() {
            if (this.toolbar == null) {
                Document document;
                JEditorPane jEditorPane = this.getEditorPane();
                if (jEditorPane != null && (document = jEditorPane.getDocument()) instanceof NbDocument.CustomToolbar) {
                    this.toolbar = ((NbDocument.CustomToolbar)document).createToolbar(jEditorPane);
                }
                if (this.toolbar == null) {
                    this.toolbar = new JPanel();
                }
            }
            return this.toolbar;
        }

        public JComponent getVisualRepresentation() {
            return this;
        }

        public void componentDeactivated() {
            super.componentDeactivated();
        }

        public void componentActivated() {
            super.componentActivated();
        }

        public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
            this.multiViewObserver = multiViewElementCallback;
            if (((DataEditorSupport)this.cloneableEditorSupport()).getDataObject() instanceof FormDataObject) {
                ((FormDataObject)((DataEditorSupport)this.cloneableEditorSupport()).getDataObject()).getFormEditorSupport().setTopComponent(multiViewElementCallback.getTopComponent());
            }
        }

        public void requestVisible() {
            if (this.multiViewObserver != null) {
                this.multiViewObserver.requestVisible();
            } else {
                super.requestVisible();
            }
        }

        public void requestActive() {
            if (this.multiViewObserver != null) {
                this.multiViewObserver.requestActive();
            } else {
                super.requestActive();
            }
        }

        public void componentClosed() {
            super.canClose(null, true);
            super.componentClosed();
        }

        public void componentShowing() {
            FormEditorSupport formEditorSupport;
            super.componentShowing();
            DataObject dataObject = ((DataEditorSupport)this.cloneableEditorSupport()).getDataObject();
            FormDataObject formDataObject = (FormDataObject)dataObject;
            FormModel formModel = null;
            if (formDataObject != null && (formEditorSupport = formDataObject.getFormEditor()) != null && (formModel = formEditorSupport.getFormModel()) != null) {
                JavaCodeGenerator javaCodeGenerator = (JavaCodeGenerator)FormEditor.getCodeGenerator(formModel);
                javaCodeGenerator.regenerateCode();
            }
        }

        public void componentHidden() {
            super.componentHidden();
        }

        public void componentOpened() {
            super.componentOpened();
            DataObject dataObject = ((DataEditorSupport)this.cloneableEditorSupport()).getDataObject();
            if (this.multiViewObserver != null && !(dataObject instanceof FormDataObject)) {
                this.multiViewObserver.getTopComponent().close();
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                editorCookie.open();
            }
        }

        public void updateName() {
            super.updateName();
            if (this.multiViewObserver != null) {
                FormDataObject formDataObject = (FormDataObject)((DataEditorSupport)this.cloneableEditorSupport()).getDataObject();
                String[] stringArray = FormEditorSupport.getMVTCDisplayName(formDataObject);
                this.setDisplayName(stringArray[0]);
                this.setHtmlDisplayName(stringArray[1]);
            }
        }

        protected boolean closeLast() {
            return true;
        }

        public CloseOperationState canCloseElement() {
            if (!FormEditorSupport.isLastView(this.multiViewObserver.getTopComponent())) {
                return CloseOperationState.STATE_OK;
            }
            return MultiViewFactory.createUnsafeCloseState((String)"ID_JAVA_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
        }

        protected boolean isActiveTC() {
            TopComponent topComponent = JavaEditorTopComponent.getRegistry().getActivated();
            if (topComponent == null) {
                return false;
            }
            if (topComponent == this) {
                return true;
            }
            MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
            return multiViewHandler != null && FormEditorSupport.MV_JAVA_ID.equals(multiViewHandler.getSelectedPerspective().preferredID());
        }
    }

    private static class JavaDesc
    implements MultiViewDescription,
    SourceViewMarker,
    Serializable {
        private static final long serialVersionUID = -3126744316624172415L;
        private DataObject dataObject;

        private JavaDesc() {
        }

        public JavaDesc(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        private FormEditorSupport getJavaEditor() {
            return this.dataObject != null && this.dataObject instanceof FormDataObject ? ((FormDataObject)this.dataObject).getFormEditorSupport() : null;
        }

        public MultiViewElement createElement() {
            FormEditorSupport formEditorSupport = this.getJavaEditor();
            if (formEditorSupport != null) {
                formEditorSupport.prepareDocument();
                JavaEditorTopComponent javaEditorTopComponent = new JavaEditorTopComponent((DataEditorSupport)this.dataObject.getCookie(FormEditorSupport.class));
                Node[] nodeArray = javaEditorTopComponent.getActivatedNodes();
                if (nodeArray == null || nodeArray.length == 0) {
                    javaEditorTopComponent.setActivatedNodes(new Node[]{this.dataObject.getNodeDelegate()});
                }
                return javaEditorTopComponent;
            }
            return MultiViewFactory.BLANK_ELEMENT;
        }

        public String getDisplayName() {
            return FormUtils.getBundleString("CTL_SourceTabCaption");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)FormEditorSupport.iconURL);
        }

        public int getPersistenceType() {
            return 1;
        }

        public String preferredID() {
            return FormEditorSupport.MV_JAVA_ID;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this.dataObject);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            Object object = objectInput.readObject();
            if (object instanceof FormDataObject) {
                this.dataObject = (DataObject)object;
            }
        }
    }

    private static class FormDesc
    implements MultiViewDescription,
    Serializable {
        private static final long serialVersionUID = -3126744316624172415L;
        private DataObject dataObject;

        private FormDesc() {
        }

        public FormDesc(DataObject dataObject) {
            this.dataObject = dataObject;
        }

        private FormEditorSupport getFormEditor() {
            return this.dataObject != null && this.dataObject instanceof FormDataObject ? ((FormDataObject)this.dataObject).getFormEditorSupport() : null;
        }

        public MultiViewElement createElement() {
            FormEditorSupport formEditorSupport = this.getFormEditor();
            return new FormDesigner(formEditorSupport == null ? null : formEditorSupport.getFormEditor(true));
        }

        public String getDisplayName() {
            return FormUtils.getBundleString("CTL_DesignTabCaption");
        }

        public HelpCtx getHelpCtx() {
            return HelpCtx.DEFAULT_HELP;
        }

        public Image getIcon() {
            return ImageUtilities.loadImage((String)FormEditorSupport.iconURL);
        }

        public int getPersistenceType() {
            return 2;
        }

        public String preferredID() {
            return FormEditorSupport.MV_FORM_ID;
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeObject(this.dataObject);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            Object object = objectInput.readObject();
            if (object instanceof FormDataObject) {
                this.dataObject = (DataObject)object;
            }
        }
    }

    private final class FormGEditor
    implements GuardedEditorSupport {
        StyledDocument doc = null;

        private FormGEditor() {
        }

        public StyledDocument getDocument() {
            return this.doc;
        }
    }
}

