/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Validator;
import org.netbeans.modules.form.BindingCustomizer;
import org.netbeans.modules.form.BindingDescriptor;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormNode;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaBinding;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingProperty
extends PropertySupport.ReadWrite<MetaBinding> {
    public static final String PROP_NAME = "name";
    public static final String PROP_NULL_VALUE = "nullValue";
    public static final String PROP_INCOMPLETE_VALUE = "incompleteValue";
    public static final String PROP_VALIDATOR = "validator";
    public static final String PROP_CONVERTER = "converter";
    private RADComponent bindingComponent;
    private BindingDescriptor bindingDescriptor;
    private MetaBinding binding;
    private Property nameProperty;
    private Property nullValueProperty;
    private Property incompleteValueProperty;
    private Property validatorProperty;
    private Property converterProperty;

    public BindingProperty(RADComponent rADComponent, BindingDescriptor bindingDescriptor) {
        super(bindingDescriptor.getPath(), MetaBinding.class, bindingDescriptor.getDisplayName(), bindingDescriptor.getShortDescription());
        Object object;
        this.bindingComponent = rADComponent;
        this.bindingDescriptor = bindingDescriptor;
        FormProperty formProperty = (FormProperty)this.bindingComponent.getPropertyByName(this.bindingDescriptor.getPath());
        if (formProperty == null && ((RADProperty[])(object = this.bindingComponent.getAllBeanProperties())).length > 0) {
            formProperty = object[0];
        }
        if (formProperty != null) {
            object = FormUtils.getBundleString("MSG_Binding_NullProperty");
            this.nullValueProperty = new Property(formProperty, PROP_NULL_VALUE, bindingDescriptor.getValueType(), (String)object, (String)object, false);
            object = FormUtils.getBundleString("MSG_Binding_IncompletePathProperty");
            this.incompleteValueProperty = new Property(formProperty, "incompletePathValue", bindingDescriptor.getValueType(), (String)object, (String)object, false);
            object = FormUtils.getBundleString("MSG_Binding_Validator");
            this.validatorProperty = new Property(formProperty, PROP_VALIDATOR, Validator.class, (String)object, (String)object, true);
            object = FormUtils.getBundleString("MSG_Binding_Converter");
            this.converterProperty = new Property(formProperty, PROP_CONVERTER, Converter.class, (String)object, (String)object, true);
            object = FormUtils.getBundleString("MSG_Binding_Name");
            this.nameProperty = new Property(formProperty, PROP_NAME, String.class, (String)object, (String)object, true);
        }
    }

    public String getHtmlDisplayName() {
        return this.binding != null ? "<b>" + this.getDisplayName() : null;
    }

    public MetaBinding getValue() {
        return this.binding;
    }

    public void setValue(MetaBinding object) {
        Object object2;
        Object object3;
        MetaBinding metaBinding = this.binding;
        if (metaBinding == null && object != null) {
            FormEditor.updateProjectForBeansBinding(this.bindingComponent.getFormModel());
            this.getFormModel().raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
            object3 = this.bindingComponent.getPropertyByName(this.bindingDescriptor.getPath());
            if (object3 instanceof FormProperty) {
                object2 = (FormProperty)((Object)object3);
                if (object2.isChanged()) {
                    try {
                        object2.restoreDefaultValue();
                    }
                    catch (Exception exception) {}
                }
            } else {
                try {
                    object3.restoreDefaultValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (object != null && !this.bindingComponent.equals(((MetaBinding)object).getTarget())) {
            object3 = new MetaBinding(((MetaBinding)object).getSource(), ((MetaBinding)object).getSourcePath(), this.bindingComponent, ((MetaBinding)object).getTargetPath());
            ((MetaBinding)object3).setBindImmediately(((MetaBinding)object).isBindImmediately());
            ((MetaBinding)object3).setIncompletePathValueSpecified(((MetaBinding)object).isIncompletePathValueSpecified());
            ((MetaBinding)object3).setNullValueSpecified(((MetaBinding)object).isNullValueSpecified());
            ((MetaBinding)object3).setUpdateStrategy(((MetaBinding)object).getUpdateStrategy());
            object2 = ((MetaBinding)object).getParameters();
            for (Map.Entry object52 : object2.entrySet()) {
                ((MetaBinding)object3).setParameter((String)object52.getKey(), (String)object52.getValue());
            }
            Collection<MetaBinding> collection = ((MetaBinding)object).getSubBindings();
            if (collection != null) {
                for (MetaBinding metaBinding2 : collection) {
                    ((MetaBinding)object3).addSubBinding(metaBinding2.getSourcePath(), metaBinding2.getTargetPath());
                }
            }
            RADComponent rADComponent = ((MetaBinding)object).getTarget();
            BindingProperty bindingProperty = rADComponent.getBindingProperty(this.getName());
            this.copy(bindingProperty.getNameProperty(), this.getNameProperty());
            this.copy(bindingProperty.getConverterProperty(), this.getConverterProperty());
            this.copy(bindingProperty.getValidatorProperty(), this.getValidatorProperty());
            if (((MetaBinding)object).isNullValueSpecified()) {
                this.copy(bindingProperty.getNullValueProperty(), this.getNullValueProperty());
            }
            if (((MetaBinding)object).isIncompletePathValueSpecified()) {
                this.copy(bindingProperty.getIncompleteValueProperty(), this.getIncompleteValueProperty());
            }
            object = object3;
        }
        this.binding = object;
        FormEditor.getBindingSupport(this.getFormModel()).changeBindingInModel(metaBinding, this.binding);
        this.getFormModel().fireBindingChanged(this.getBindingComponent(), this.getBindingPath(), null, metaBinding, this.binding);
        object3 = this.getBindingComponent().getNodeReference();
        if (object3 != null) {
            ((FormNode)object3).firePropertyChangeHelper(null, null, null);
        }
    }

    private void copy(FormProperty formProperty, FormProperty formProperty2) {
        try {
            PropertyEditor propertyEditor = formProperty.getCurrentEditor();
            Object object = formProperty.getValue();
            formProperty2.setValue(new FormProperty.ValueWithEditor(object, propertyEditor));
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
        }
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public void restoreDefaultValue() {
        this.setValue(null);
        try {
            this.validatorProperty.restoreDefaultValue();
            this.converterProperty.restoreDefaultValue();
            this.nameProperty.restoreDefaultValue();
            this.nullValueProperty.setValue(null);
            this.incompleteValueProperty.setValue(null);
        }
        catch (Exception exception) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
        }
        Node.Property property = this.bindingComponent.getPropertyByName(this.bindingDescriptor.getPath());
        if (property != null && property.supportsDefaultValue()) {
            try {
                property.restoreDefaultValue();
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
            }
        }
    }

    public boolean isDefaultValue() {
        return this.getValue() == null;
    }

    public PropertyEditor getPropertyEditor() {
        return new BindingPropertyEditor();
    }

    public RADComponent getBindingComponent() {
        return this.bindingComponent;
    }

    public BindingDescriptor getBindingDescriptor() {
        return this.bindingDescriptor;
    }

    String getBindingPath() {
        return this.bindingDescriptor.getPath();
    }

    Class getBindingValueType() {
        return this.bindingDescriptor.getValueType();
    }

    private FormModel getFormModel() {
        return this.bindingComponent.getFormModel();
    }

    FormProperty getNullValueProperty() {
        return this.nullValueProperty;
    }

    FormProperty getIncompleteValueProperty() {
        return this.incompleteValueProperty;
    }

    FormProperty getValidatorProperty() {
        return this.validatorProperty;
    }

    FormProperty getConverterProperty() {
        return this.converterProperty;
    }

    FormProperty getNameProperty() {
        return this.nameProperty;
    }

    public FormProperty getSubProperty(String string) {
        if (PROP_NAME.equals(string)) {
            return this.getNameProperty();
        }
        if (PROP_NULL_VALUE.equals(string)) {
            return this.getNullValueProperty();
        }
        if (PROP_INCOMPLETE_VALUE.equals(string)) {
            return this.getIncompleteValueProperty();
        }
        if (PROP_CONVERTER.equals(string)) {
            return this.getConverterProperty();
        }
        if (PROP_VALIDATOR.equals(string)) {
            return this.getValidatorProperty();
        }
        return null;
    }

    static class Property
    extends FormProperty {
        private Object value;
        private boolean supportsDefaultValue;

        Property(FormProperty formProperty, String string, Class clazz, String string2, String string3, boolean bl) {
            super(new FormPropertyContext.SubProperty(formProperty), string, clazz, string2, string3);
            this.supportsDefaultValue = bl;
        }

        public Object getTargetValue() throws IllegalAccessException, InvocationTargetException {
            return this.value;
        }

        public void setTargetValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.value = object;
        }

        public boolean supportsDefaultValue() {
            return this.supportsDefaultValue;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            super.restoreDefaultValue();
            this.getCurrentEditor().setValue(this.getValue());
        }
    }

    private class BindingPropertyEditor
    extends PropertyEditorSupport {
        private BindingCustomizer customizer;
        private ActionListener customizerListener;

        private BindingPropertyEditor() {
        }

        public String getAsText() {
            RADComponent rADComponent = null;
            String string = null;
            if (BindingProperty.this.binding != null) {
                rADComponent = BindingProperty.this.binding.getSource();
                string = BindingProperty.this.binding.getSourcePath();
            }
            if (rADComponent == null) {
                return "";
            }
            return string != null ? rADComponent.getName() + "[" + string + "]" : rADComponent.getName();
        }

        public void setAsText(String string) {
            if ("".equals(string)) {
                this.setValue(null);
            } else {
                int n = string.indexOf(91);
                String string2 = n >= 0 ? string.substring(0, n) : string;
                RADComponent rADComponent = BindingProperty.this.getFormModel().findRADComponent(string2);
                if (rADComponent != null) {
                    String string3;
                    String string4 = string3 = n >= 0 ? string.substring(n + 1, string.length() - 1) : "";
                    if (!string3.equals("")) {
                        if (rADComponent != BindingProperty.this.getBindingComponent() || !string3.equals(BindingProperty.this.getBindingPath())) {
                            this.setValue(new MetaBinding(rADComponent, string3, BindingProperty.this.getBindingComponent(), BindingProperty.this.getBindingPath()));
                        }
                    } else if (rADComponent != BindingProperty.this.getBindingComponent() && Collection.class.isAssignableFrom(BindingProperty.this.getBindingValueType()) && BindingProperty.this.getBindingValueType().equals(rADComponent.getBeanClass())) {
                        this.setValue(new MetaBinding(rADComponent, null, BindingProperty.this.getBindingComponent(), BindingProperty.this.getBindingPath()));
                    }
                }
            }
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            if (this.customizer == null) {
                this.customizer = new BindingCustomizer(BindingProperty.this);
                this.customizerListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        BindingPropertyEditor.this.setValue(BindingPropertyEditor.this.customizer.getBinding());
                    }
                };
            }
            this.customizer.setBinding((MetaBinding)this.getValue());
            return this.customizer.getDialog(this.customizerListener);
        }
    }
}

