/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.propertyeditors.css;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.netbeans.modules.visualweb.propertyeditors.css.model.MarginPaddingModel;
import org.netbeans.modules.visualweb.propertyeditors.css.model.PropertyWithUnitData;
import org.netbeans.modules.visualweb.propertyeditors.css.model.Utils;

public class PaddingWidthField
extends JPanel {
    PropertyWithUnitData borderPaddingData = new PropertyWithUnitData();
    MarginPaddingModel marginPaddingModel = new MarginPaddingModel();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JComboBox borderPaddingCombo;
    private JComboBox borderPaddingUnitCombo;

    public PaddingWidthField() {
        this.initComponents();
        this.borderPaddingCombo.setModel(this.marginPaddingModel.getPaddingList());
        this.borderPaddingUnitCombo.setModel(this.marginPaddingModel.getPaddingUnitList());
        final JTextField jTextField = (JTextField)this.borderPaddingCombo.getEditor().getEditorComponent();
        jTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PaddingWidthField.this.borderPaddingUnitCombo.setEnabled(Utils.isInteger(jTextField.getText()));
                    }
                });
            }
        });
    }

    public void addCssPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeCssPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setPaddingString(String string) {
        if (string != null && !string.equals("")) {
            if (Utils.isInteger(string)) {
                this.setWidthValue(string);
            } else {
                String string2 = this.getUnit(string);
                this.setWidthUnit(string2);
                this.setWidthValue(string.replaceAll(string2, "").trim());
            }
        } else {
            this.setWidthValue(null);
            this.setWidthUnit(null);
        }
    }

    public String getPaddingString() {
        return this.borderPaddingData.toString();
    }

    private String getUnit(String string) {
        DefaultComboBoxModel defaultComboBoxModel = this.marginPaddingModel.getPaddingUnitList();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            String string2 = (String)defaultComboBoxModel.getElementAt(i);
            if (!string.trim().endsWith(string2)) continue;
            return string2;
        }
        return "";
    }

    public void setWidthValue(String string) {
        if (string == null || string.equals("")) {
            this.borderPaddingCombo.setSelectedIndex(0);
        } else {
            this.borderPaddingCombo.setSelectedItem(string);
            this.borderPaddingData.setValue(string);
        }
    }

    public void setWidthUnit(String string) {
        if (string == null || string.equals("")) {
            this.borderPaddingUnitCombo.setSelectedIndex(this.marginPaddingModel.getPaddingUnitList().getIndexOf("px"));
        } else {
            if (this.marginPaddingModel.getMarginUnitList().getIndexOf(string) != -1) {
                this.borderPaddingUnitCombo.setSelectedIndex(this.marginPaddingModel.getPaddingUnitList().getIndexOf(string));
            } else {
                this.borderPaddingUnitCombo.setSelectedIndex(this.marginPaddingModel.getPaddingUnitList().getIndexOf("px"));
            }
            this.borderPaddingData.setUnit(string);
        }
    }

    private void initComponents() {
        this.borderPaddingCombo = new JComboBox();
        this.borderPaddingUnitCombo = new JComboBox();
        this.setLayout(new BorderLayout(5, 0));
        this.borderPaddingCombo.setEditable(true);
        this.borderPaddingCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PaddingWidthField.this.borderPaddingComboItemStateChanged(itemEvent);
            }
        });
        this.borderPaddingCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PaddingWidthField.this.borderPaddingComboActionPerformed(actionEvent);
            }
        });
        this.borderPaddingCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PaddingWidthField.this.borderPaddingComboFocusLost(focusEvent);
            }
        });
        this.add((Component)this.borderPaddingCombo, "Center");
        this.borderPaddingUnitCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PaddingWidthField.this.borderPaddingUnitComboItemStateChanged(itemEvent);
            }
        });
        this.borderPaddingUnitCombo.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                PaddingWidthField.this.borderPaddingUnitComboFocusLost(focusEvent);
            }
        });
        this.add((Component)this.borderPaddingUnitCombo, "East");
    }

    private void borderPaddingUnitComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setborderPadding();
        }
    }

    private void borderPaddingUnitComboFocusLost(FocusEvent focusEvent) {
        this.setborderPadding();
    }

    public void setAccessibleName(String string, String string2) {
        this.borderPaddingCombo.getAccessibleContext().setAccessibleName(string);
        this.borderPaddingUnitCombo.getAccessibleContext().setAccessibleName(string2);
    }

    public void setAccessibleDescription(String string, String string2) {
        this.borderPaddingCombo.getAccessibleContext().setAccessibleDescription(string);
        this.borderPaddingUnitCombo.getAccessibleContext().setAccessibleDescription(string2);
    }

    private void borderPaddingComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() != 2) {
            this.setborderPadding();
        }
    }

    private void borderPaddingComboFocusLost(FocusEvent focusEvent) {
        this.setborderPadding();
    }

    private void borderPaddingComboActionPerformed(ActionEvent actionEvent) {
        this.setborderPadding();
    }

    private void setborderPadding() {
        String string = this.borderPaddingData.toString();
        this.borderPaddingData.setUnit(this.borderPaddingUnitCombo.getSelectedItem().toString());
        this.borderPaddingData.setValue(this.borderPaddingCombo.getSelectedItem().toString());
        this.propertyChangeSupport.firePropertyChange("padding-width", string, this.borderPaddingData.toString());
    }
}

