/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsfcl.std.reference;

import com.sun.jsfcl.std.reference.BaseReferenceData;
import com.sun.jsfcl.std.reference.CharacterSetsReferenceDataDefiner;
import com.sun.jsfcl.std.reference.CommandButtonTypesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.ComponentIdsReferenceDataDefiner;
import com.sun.jsfcl.std.reference.CompositeReferenceData;
import com.sun.jsfcl.std.reference.ConcurrencyTypesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.DataSourceNamesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.DateTimeStylesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.DateTimeTypesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.DesignPropertyAttachedReferenceData;
import com.sun.jsfcl.std.reference.FrameTargetsReferenceDataDefiner;
import com.sun.jsfcl.std.reference.ImageMapNamesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.LanguageCodesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.LinkTypesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.LocalesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.ManyCheckboxLayoutStylesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.MediaTypesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.MessagesLayoutsReferenceDataDefiner;
import com.sun.jsfcl.std.reference.ProjectAttachedReferenceData;
import com.sun.jsfcl.std.reference.ReferenceDataDefiner;
import com.sun.jsfcl.std.reference.RegionShapesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.StyleClassesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.TFramesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.TableRulesReferenceDataDefiner;
import com.sun.jsfcl.std.reference.TextDirectionsReferenceDataDefiner;
import com.sun.jsfcl.std.reference.TimeZonesReferenceDataDefiner;
import com.sun.jsfcl.util.LoggerUtil;
import com.sun.rave.designtime.DesignProject;
import com.sun.rave.designtime.DesignProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public class ReferenceDataManager {
    public static final String CHARACTER_SETS = "character-sets";
    public static final String COMMAND_BUTTON_TYPES = "command-button-types";
    public static final String COMPONENT_IDS = "component-ids";
    public static final String CONCURRENCY_TYPES = "concurrency-types";
    public static final String DATASOURCE_NAMES = "datasource-names";
    public static final String DATETIME_STYLES = "datetime-style";
    public static final String DATETIME_TYPES = "datetime-type";
    public static final String FRAME_TARGETS = "frame-targets";
    public static final String IMAGE_MAP_NAMES = "image-map-names";
    public static final String LANGUAGE_CODES = "language-code";
    public static final String LINK_TYPES = "link-types";
    public static final String LOCALES = "locales";
    public static final String MANY_CHECKBOX_LAYOUT_STYLES = "many-chekbox-layout-styles";
    public static final String MEDIA_TYPES = "media-types";
    public static final String MESSAGES_LAYOUTS = "messages-layouts";
    public static final String REGION_SHAPES = "region-shape";
    public static final String STYLE_CLASSES = "style-classes";
    public static final String TABLE_RULES = "table-rules";
    public static final String TEXT_DIRECTIONS = "text-direction";
    public static final String TFRAMES = "tframes";
    public static final String TIME_ZONES = "time-zones";
    protected static ReferenceDataManager instance;
    public static LoggerUtil loggerUtil;
    protected static WeakHashMap projectRelatedReferenceDataMap;
    protected Map definersByName;
    protected Map referenceDataByName = new HashMap();
    protected Map referenceDataByProperty = new WeakHashMap();

    public static ReferenceDataManager getInstance() {
        return instance;
    }

    protected static void setInstance(ReferenceDataManager referenceDataManager) {
        instance = referenceDataManager;
    }

    protected ReferenceDataManager() {
    }

    public BaseReferenceData getBaseReferenceData(String string) {
        BaseReferenceData baseReferenceData = (BaseReferenceData)this.referenceDataByName.get(string);
        if (baseReferenceData == null) {
            ReferenceDataDefiner referenceDataDefiner = this.getDefiner(string);
            if (referenceDataDefiner == null) {
                throw new RuntimeException("No definer defined for: " + string);
            }
            if (!referenceDataDefiner.definesBaseItems()) {
                return null;
            }
            baseReferenceData = new BaseReferenceData(this, referenceDataDefiner, string);
            this.referenceDataByName.put(string, baseReferenceData);
        }
        return baseReferenceData;
    }

    public ReferenceDataDefiner getDefiner(String string) {
        ReferenceDataDefiner referenceDataDefiner = (ReferenceDataDefiner)this.getDefinersByName().get(string);
        if (referenceDataDefiner == null) assert (loggerUtil.warning("Found no ReferenceDataDefiner registered under: " + string));
        return referenceDataDefiner;
    }

    protected Map getDefinersByName() {
        if (this.definersByName == null) {
            this.initializeDefinersByName();
        }
        return this.definersByName;
    }

    public DesignPropertyAttachedReferenceData getDesignPropertyAttachedReferenceData(String string, DesignProperty designProperty) {
        DesignPropertyAttachedReferenceData designPropertyAttachedReferenceData;
        HashMap<String, DesignPropertyAttachedReferenceData> hashMap = (HashMap<String, DesignPropertyAttachedReferenceData>)this.referenceDataByProperty.get(designProperty);
        if (hashMap == null) {
            hashMap = new HashMap<String, DesignPropertyAttachedReferenceData>();
            this.referenceDataByProperty.put(designProperty, hashMap);
        }
        if ((designPropertyAttachedReferenceData = (DesignPropertyAttachedReferenceData)hashMap.get(string)) == null) {
            ReferenceDataDefiner referenceDataDefiner = this.getDefiner(string);
            if (referenceDataDefiner == null) {
                throw new RuntimeException("No definer defined for: " + string);
            }
            if (!referenceDataDefiner.definesDesignPropertyItems()) {
                return null;
            }
            designPropertyAttachedReferenceData = new DesignPropertyAttachedReferenceData(this, referenceDataDefiner, string, designProperty);
            hashMap.put(string, designPropertyAttachedReferenceData);
        }
        return designPropertyAttachedReferenceData;
    }

    public CompositeReferenceData getCompositeReferenceData(String string, DesignProject designProject, DesignProperty designProperty) {
        return new CompositeReferenceData(this, string, this.getDefiner(string), this.getBaseReferenceData(string), this.getProjectAttachedReferenceData(string, designProject), this.getDesignPropertyAttachedReferenceData(string, designProperty));
    }

    public ProjectAttachedReferenceData getProjectAttachedReferenceData(String string, DesignProject designProject) {
        ProjectAttachedReferenceData projectAttachedReferenceData;
        HashMap<String, ProjectAttachedReferenceData> hashMap = (HashMap<String, ProjectAttachedReferenceData>)projectRelatedReferenceDataMap.get(designProject);
        if (hashMap == null) {
            hashMap = new HashMap<String, ProjectAttachedReferenceData>();
            projectRelatedReferenceDataMap.put(designProject, hashMap);
        }
        if ((projectAttachedReferenceData = (ProjectAttachedReferenceData)hashMap.get(string)) != null) {
            return projectAttachedReferenceData;
        }
        ReferenceDataDefiner referenceDataDefiner = this.getDefiner(string);
        if (referenceDataDefiner == null) {
            throw new RuntimeException("No definer defined for: " + string);
        }
        if (!referenceDataDefiner.definesProjectItems()) {
            return null;
        }
        projectAttachedReferenceData = new ProjectAttachedReferenceData(this, referenceDataDefiner, string, designProject);
        hashMap.put(string, projectAttachedReferenceData);
        return projectAttachedReferenceData;
    }

    protected void initializeDefinersByName() {
        this.definersByName = new HashMap();
        this.definersByName.put(CHARACTER_SETS, new CharacterSetsReferenceDataDefiner());
        this.definersByName.put(COMMAND_BUTTON_TYPES, new CommandButtonTypesReferenceDataDefiner());
        this.definersByName.put(COMPONENT_IDS, new ComponentIdsReferenceDataDefiner());
        this.definersByName.put(CONCURRENCY_TYPES, new ConcurrencyTypesReferenceDataDefiner());
        this.definersByName.put(DATASOURCE_NAMES, new DataSourceNamesReferenceDataDefiner());
        this.definersByName.put(DATETIME_STYLES, new DateTimeStylesReferenceDataDefiner());
        this.definersByName.put(DATETIME_TYPES, new DateTimeTypesReferenceDataDefiner());
        this.definersByName.put(FRAME_TARGETS, new FrameTargetsReferenceDataDefiner());
        this.definersByName.put(IMAGE_MAP_NAMES, new ImageMapNamesReferenceDataDefiner());
        this.definersByName.put(LANGUAGE_CODES, new LanguageCodesReferenceDataDefiner());
        this.definersByName.put(LINK_TYPES, new LinkTypesReferenceDataDefiner());
        this.definersByName.put(LOCALES, new LocalesReferenceDataDefiner());
        this.definersByName.put(MANY_CHECKBOX_LAYOUT_STYLES, new ManyCheckboxLayoutStylesReferenceDataDefiner());
        this.definersByName.put(MEDIA_TYPES, new MediaTypesReferenceDataDefiner());
        this.definersByName.put(MESSAGES_LAYOUTS, new MessagesLayoutsReferenceDataDefiner());
        this.definersByName.put(REGION_SHAPES, new RegionShapesReferenceDataDefiner());
        this.definersByName.put(STYLE_CLASSES, new StyleClassesReferenceDataDefiner());
        this.definersByName.put(TABLE_RULES, new TableRulesReferenceDataDefiner());
        this.definersByName.put(TEXT_DIRECTIONS, new TextDirectionsReferenceDataDefiner());
        this.definersByName.put(TFRAMES, new TFramesReferenceDataDefiner());
        this.definersByName.put(TIME_ZONES, new TimeZonesReferenceDataDefiner());
    }

    static {
        projectRelatedReferenceDataMap = new WeakHashMap();
        instance = new ReferenceDataManager();
        loggerUtil = LoggerUtil.getLogger(ReferenceDataManager.class.getName());
    }
}

