/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import java.util.LinkedList;
import java.util.Stack;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTStream;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.utils.APTTraceUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public abstract class APTWalker {
    private APTMacroMap macros;
    private APT root;
    private boolean walkerInUse = false;
    private boolean stopped = false;
    private APT curAPT;
    private boolean curWasInChild;
    private LinkedList<TokenStream> tokens = new LinkedList();
    private Stack<WalkerState> visits = new Stack();

    public APTWalker(APT aPT, APTMacroMap aPTMacroMap) {
        assert (aPT != null) : "how can we work on null tree?";
        this.root = aPT;
        this.macros = aPTMacroMap;
    }

    public void visit() {
        if (this.walkerInUse) {
            throw new IllegalStateException("walker could be used only once");
        }
        if (APTTraceFlags.APT_NON_RECURSE_VISIT) {
            this.nonRecurseVisit();
        } else {
            this.walkerInUse = true;
            this.visit(this.root.getFirstChild());
        }
    }

    public void nonRecurseVisit() {
        this.init(false);
        while (!this.finished()) {
            this.toNextNode();
        }
    }

    public TokenStream getTokenStream() {
        if (this.walkerInUse) {
            throw new IllegalStateException("walker could be used only once");
        }
        return new WalkerTokenStream();
    }

    protected abstract void onInclude(APT var1);

    protected abstract void onIncludeNext(APT var1);

    protected abstract void onDefine(APT var1);

    protected abstract void onUndef(APT var1);

    protected abstract boolean onIf(APT var1);

    protected abstract boolean onIfdef(APT var1);

    protected abstract boolean onIfndef(APT var1);

    protected abstract boolean onElif(APT var1, boolean var2);

    protected abstract boolean onElse(APT var1, boolean var2);

    protected abstract void onEndif(APT var1, boolean var2);

    protected void onStreamNode(APT aPT) {
    }

    protected void onErrorNode(APT aPT) {
    }

    protected void onOtherNode(APT aPT) {
    }

    protected void onEOF() {
    }

    protected boolean stopOnErrorDirective() {
        return true;
    }

    private void visit(APT aPT) {
        if (aPT == null || this.isStopped()) {
            return;
        }
        boolean bl = false;
        for (APT aPT2 = aPT; aPT2 != null && !this.isStopped(); aPT2 = aPT2.getNextSibling()) {
            if (aPT2.getType() == 7) {
                assert (aPT2.getFirstChild() != null);
                this.visit(aPT2.getFirstChild());
                continue;
            }
            boolean bl2 = this.onAPT(aPT2, bl);
            if (bl2 && aPT2.getFirstChild() != null) {
                assert (APTUtils.isStartOrSwitchConditionNode(aPT2.getType()));
                this.visit(aPT2.getFirstChild());
            }
            bl |= bl2;
        }
    }

    protected boolean onAPT(APT aPT, boolean bl) {
        boolean bl2 = false;
        switch (aPT.getType()) {
            case 10: {
                bl2 = this.onIf(aPT);
                break;
            }
            case 8: {
                bl2 = this.onIfdef(aPT);
                break;
            }
            case 9: {
                bl2 = this.onIfndef(aPT);
                break;
            }
            case 11: {
                bl2 = this.onElif(aPT, bl);
                break;
            }
            case 12: {
                bl2 = this.onElse(aPT, bl);
                break;
            }
            case 13: {
                this.onEndif(aPT, bl);
                break;
            }
            case 5: {
                this.onDefine(aPT);
                break;
            }
            case 6: {
                this.onUndef(aPT);
                break;
            }
            case 3: {
                this.onInclude(aPT);
                break;
            }
            case 4: {
                this.onIncludeNext(aPT);
                break;
            }
            case 2: {
                break;
            }
            case 16: {
                this.onErrorNode(aPT);
                break;
            }
            case 0: 
            case 14: 
            case 15: 
            case 17: {
                this.onOtherNode(aPT);
                break;
            }
            default: {
                assert (false) : "unsupported " + APTTraceUtils.getTypeName(aPT);
                break;
            }
        }
        APTUtils.LOG.log(Level.FINE, "onAPT: {0}; {1} {2}", new Object[]{aPT, bl ? "Was before;" : "", bl2 ? "Will visit children" : ""});
        return bl2;
    }

    private void pushState() {
        this.visits.push(new WalkerState(this.curAPT, this.curWasInChild));
    }

    private boolean popState() {
        if (this.visits.isEmpty()) {
            return false;
        }
        WalkerState walkerState = this.visits.pop();
        this.curAPT = walkerState.lastNode;
        this.curWasInChild = walkerState.wasInChild;
        return true;
    }

    private void init(boolean bl) {
        this.curAPT = this.root.getFirstChild();
        if (bl) {
            this.fillTokens();
        }
        this.curWasInChild = false;
        this.pushState();
        this.walkerInUse = true;
    }

    private Token nextTokenImpl() throws TokenStreamException {
        Token token = null;
        while (true) {
            if (!this.tokens.isEmpty()) {
                TokenStream tokenStream = this.tokens.peek();
                token = tokenStream.nextToken();
                if (!APTUtils.isEOF(token)) {
                    return token;
                }
                this.tokens.removeFirst();
                continue;
            }
            if (this.finished()) {
                this.onEOF();
                return APTUtils.EOF_TOKEN;
            }
            this.toNextNode();
            this.fillTokens();
        }
    }

    private void toNextNode() {
        this.popState();
        if (this.finished()) {
            return;
        }
        if (this.curAPT == null) {
            APTUtils.LOG.log(Level.SEVERE, "incomplete APT {0}", new Object[]{this.root});
            do {
                this.popState();
                this.curAPT = this.curAPT.getNextSibling();
            } while (this.curAPT == null && !this.finished());
            if (this.curAPT == null) {
                return;
            }
        }
        if (this.curAPT.getType() == 7) {
            this.curWasInChild = false;
            this.pushState();
            assert (this.curAPT.getFirstChild() != null);
            this.curAPT = this.curAPT.getFirstChild();
        }
        boolean bl = this.onAPT(this.curAPT, this.curWasInChild);
        this.curWasInChild |= bl;
        if (bl) {
            assert (APTUtils.isStartOrSwitchConditionNode(this.curAPT.getType()));
            if (this.curAPT.getFirstChild() != null) {
                this.pushState();
                this.curAPT = this.curAPT.getFirstChild();
                this.curWasInChild = false;
            } else {
                this.curAPT = this.curAPT.getNextSibling();
            }
        } else {
            if (this.curAPT.getType() == 13) {
                APT aPT = this.curAPT;
                this.popState();
                if (this.curAPT.getType() != 7) {
                    APTUtils.LOG.log(Level.SEVERE, "#endif directive {0} without starting #if in APT {1}", new Object[]{aPT, this.root});
                }
                this.curWasInChild = false;
            } else if (this.curAPT.getType() == 16 && this.stopOnErrorDirective()) {
                this.stop();
                return;
            }
            this.curAPT = this.curAPT.getNextSibling();
            while (this.curAPT == null && !this.finished()) {
                this.popState();
                this.curAPT = this.curAPT.getNextSibling();
            }
        }
        if (!this.finished()) {
            this.pushState();
        }
    }

    private void fillTokens() {
        if (this.curAPT != null && this.curAPT.getType() == 2) {
            this.onStreamNode(this.curAPT);
            TokenStream tokenStream = ((APTStream)this.curAPT).getTokenStream();
            this.tokens.addFirst(tokenStream);
        }
    }

    private boolean finished() {
        return this.curAPT == null && this.visits.isEmpty() || this.isStopped();
    }

    protected APTMacroMap getMacroMap() {
        return this.macros;
    }

    protected APT getCurNode() {
        return this.curAPT;
    }

    protected final boolean isStopped() {
        return this.stopped;
    }

    protected final void stop() {
        this.stopped = true;
    }

    private static final class WalkerState {
        APT lastNode;
        boolean wasInChild;

        private WalkerState(APT aPT, boolean bl) {
            this.lastNode = aPT;
            this.wasInChild = bl;
        }
    }

    private class WalkerTokenStream
    implements TokenStream {
        public WalkerTokenStream() {
            APTWalker.this.init(true);
        }

        public Token nextToken() throws TokenStreamException {
            return APTWalker.this.nextTokenImpl();
        }
    }
}

