/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.testrunner.ui.Report;
import org.netbeans.modules.ruby.testrunner.ui.Status;

public class TestSession {
    private long failuresCount = 0L;
    private final List<Report.Testcase> testCases = new ArrayList<Report.Testcase>();
    private String suiteName;
    private final FileLocator fileLocator;
    private final SessionType sessionType;
    private final String name;
    private final SessionResult result;
    private final Project project;
    private String startingMsg;

    public TestSession(String string, Project project, SessionType sessionType) {
        this.name = string;
        this.project = project;
        this.fileLocator = (FileLocator)project.getLookup().lookup(FileLocator.class);
        this.sessionType = sessionType;
        this.result = new SessionResult();
    }

    public void setStartingMsg(String string) {
        this.startingMsg = string;
    }

    String getStartingMsg() {
        return this.startingMsg;
    }

    Project getProject() {
        return this.project;
    }

    void setSuiteName(String string) {
        this.testCases.clear();
        this.suiteName = string;
    }

    void addTestCase(Report.Testcase testcase) {
        for (Report.Testcase testcase2 : this.testCases) {
            if (!testcase.className.equals(testcase2.className) || !testcase.name.equals(testcase2.name)) continue;
            return;
        }
        this.testCases.add(testcase);
    }

    Report getReport(long l) {
        Report report = new Report(this.suiteName, this.project);
        report.elapsedTimeMillis = l;
        for (Report.Testcase testcase : this.testCases) {
            report.reportTest(testcase);
            ++report.totalTests;
            if (testcase.getStatus() == Status.ERROR) {
                ++report.errors;
                continue;
            }
            if (testcase.getStatus() == Status.FAILED) {
                ++report.failures;
                continue;
            }
            if (testcase.getStatus() != Status.PENDING) continue;
            ++report.pending;
        }
        this.addReportToSessionResult(report);
        return report;
    }

    private void addReportToSessionResult(Report report) {
        this.result.elapsedTime(report.elapsedTimeMillis);
        this.result.failed(report.failures);
        this.result.passed(report.detectedPassedTests);
        this.result.pending(report.pending);
        this.result.errors(report.errors);
    }

    String getSuiteName() {
        return this.suiteName;
    }

    SessionType getSessionType() {
        return this.sessionType;
    }

    synchronized long incrementFailuresCount() {
        return ++this.failuresCount;
    }

    FileLocator getFileLocator() {
        return this.fileLocator;
    }

    String getName() {
        return this.name;
    }

    SessionResult getSessionResult() {
        return this.result;
    }

    static final class SessionResult {
        private int passed;
        private int failed;
        private int errors;
        private int pending;
        private long elapsedTime;

        SessionResult() {
        }

        private int failed(int n) {
            return this.failed += n;
        }

        private int errors(int n) {
            return this.errors += n;
        }

        private int passed(int n) {
            return this.passed += n;
        }

        private int pending(int n) {
            return this.pending += n;
        }

        private long elapsedTime(long l) {
            return this.elapsedTime += l;
        }

        public int getErrors() {
            return this.errors;
        }

        public int getFailed() {
            return this.failed;
        }

        public int getPassed() {
            return this.passed;
        }

        public int getPending() {
            return this.pending;
        }

        public int getTotal() {
            return this.getPassed() + this.getFailed() + this.getErrors() + this.getPending();
        }

        public long getElapsedTime() {
            return this.elapsedTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SessionType {
        TEST,
        DEBUG;

    }
}

