/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.ObjectStreamException;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.ruby.testrunner.ui.StatisticsPanel;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ResultWindow
extends TopComponent {
    private static final String ID = "ruby-testrunner-results";
    private static WeakReference<ResultWindow> instance = null;
    private JSplitPane view;

    static synchronized ResultWindow getInstance() {
        final ResultWindow[] resultWindowArray = new ResultWindow[1];
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        resultWindowArray[0] = ResultWindow.getResultWindow();
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Exceptions.printStackTrace((Throwable)invocationTargetException);
            }
        } else {
            resultWindowArray[0] = ResultWindow.getResultWindow();
        }
        return resultWindowArray[0];
    }

    private static ResultWindow getResultWindow() {
        ResultWindow resultWindow = (ResultWindow)WindowManager.getDefault().findTopComponent(ID);
        if (resultWindow == null) {
            resultWindow = ResultWindow.getDefault();
        }
        return resultWindow;
    }

    public static synchronized ResultWindow getDefault() {
        ResultWindow resultWindow;
        ResultWindow resultWindow2 = resultWindow = instance != null ? (ResultWindow)((Object)instance.get()) : null;
        if (resultWindow == null) {
            resultWindow = new ResultWindow();
            resultWindow.initActions();
            instance = new WeakReference<ResultWindow>(resultWindow);
        }
        return resultWindow;
    }

    private void initActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("jumpNext", new PrevNextFailure(true));
        actionMap.put("jumpPrev", new PrevNextFailure(false));
    }

    public ResultWindow() {
        this.setFocusable(true);
        this.setLayout(new BorderLayout());
        this.setName(ID);
        this.setDisplayName(NbBundle.getMessage(ResultWindow.class, (String)"TITLE_TEST_RESULTS"));
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/ruby/testrunner/ui/res/testResults.png", (boolean)true));
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSN_TestResults"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ACSD_TestResults"));
    }

    void addDisplayComponent(JSplitPane jSplitPane) {
        assert (EventQueue.isDispatchThread());
        this.removeAll();
        this.addView(jSplitPane);
        this.revalidate();
    }

    private void addView(JSplitPane jSplitPane) {
        assert (EventQueue.isDispatchThread());
        this.view = jSplitPane;
        this.add(jSplitPane);
    }

    private boolean isActivated() {
        return TopComponent.getRegistry().getActivated() == this;
    }

    void promote() {
        assert (EventQueue.isDispatchThread());
        this.open();
        this.requestVisible();
    }

    void setOrientation(int n) {
        if (this.view == null) {
            return;
        }
        if (this.view.getOrientation() != n) {
            this.view.setOrientation(n);
        }
    }

    protected String preferredID() {
        return ID;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    public int getPersistenceType() {
        return 0;
    }

    private Object readResolve() throws ObjectStreamException {
        return ResultWindow.getDefault();
    }

    private static final class PrevNextFailure
    extends AbstractAction {
        private final boolean next;

        public PrevNextFailure(boolean bl) {
            this.next = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSplitPane jSplitPane = ResultWindow.getInstance().view;
            if (jSplitPane == null || !(jSplitPane.getLeftComponent() instanceof StatisticsPanel)) {
                return;
            }
            StatisticsPanel statisticsPanel = (StatisticsPanel)jSplitPane.getLeftComponent();
            if (this.next) {
                statisticsPanel.selectNextFailure();
            } else {
                statisticsPanel.selectPreviousFailure();
            }
        }
    }
}

