/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.ruby.testrunner.ui.CallstackFrameNode;
import org.netbeans.modules.ruby.testrunner.ui.Report;
import org.netbeans.modules.ruby.testrunner.ui.ResultDisplayHandler;
import org.netbeans.modules.ruby.testrunner.ui.ResultTreeView;
import org.netbeans.modules.ruby.testrunner.ui.RootNode;
import org.netbeans.modules.ruby.testrunner.ui.TestMethodNode;
import org.netbeans.modules.ruby.testrunner.ui.TestsuiteNode;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ResultPanelTree
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private static ResourceBundle bundle = NbBundle.getBundle(ResultPanelTree.class);
    private final ExplorerManager explorerManager;
    private final RootNode rootNode;
    private final ResultTreeView treeView = new ResultTreeView();
    private boolean filtered = false;
    private ChangeListener changeListener;
    private ChangeEvent changeEvent;
    private final ResultDisplayHandler displayHandler;

    ResultPanelTree(ResultDisplayHandler resultDisplayHandler) {
        super(new BorderLayout());
        this.treeView.getAccessibleContext().setAccessibleName(bundle.getString("ACSN_TestResults"));
        this.treeView.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TestResults"));
        this.add((Component)((Object)this.treeView), "Center");
        this.explorerManager = new ExplorerManager();
        this.rootNode = new RootNode(this.filtered);
        this.explorerManager.setRootContext((Node)this.rootNode);
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.initAccessibility();
        this.displayHandler = resultDisplayHandler;
    }

    private void initAccessibility() {
        AccessibleContext accessibleContext = this.getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_ResultPanelTree"));
        accessibleContext.setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_ResultPanelTree"));
        accessibleContext = this.treeView.getHorizontalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_HorizontalScrollbar"));
        accessibleContext = this.treeView.getVerticalScrollBar().getAccessibleContext();
        accessibleContext.setAccessibleName(NbBundle.getMessage(this.getClass(), (String)"ACSN_HorizontalScrollbar"));
    }

    void displayMsg(String string) {
        assert (EventQueue.isDispatchThread());
        this.rootNode.displayMessage(string);
    }

    void displayMsgSessionFinished(String string) {
        assert (EventQueue.isDispatchThread());
        this.rootNode.displayMessageSessionFinished(string);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.displayHandler.setTreePanel(this);
    }

    void displaySuiteRunning(String string) {
        assert (EventQueue.isDispatchThread());
        this.rootNode.displaySuiteRunning(string);
    }

    void displayReport(Report report) {
        assert (EventQueue.isDispatchThread());
        TestsuiteNode testsuiteNode = this.rootNode.displayReport(report);
        if (testsuiteNode != null && report.containsFailed()) {
            this.treeView.expandReportNode(testsuiteNode);
        }
    }

    void displayReports(List<Report> list) {
        assert (EventQueue.isDispatchThread());
        if (list.size() == 1) {
            this.displayReport(list.get(0));
        } else {
            this.rootNode.displayReports(list);
        }
    }

    int getSuccessDisplayedLevel() {
        return this.rootNode.getSuccessDisplayedLevel();
    }

    void viewOpened() {
        assert (EventQueue.isDispatchThread());
    }

    void setFiltered(boolean bl) {
        if (bl == this.filtered) {
            return;
        }
        this.filtered = bl;
        this.rootNode.setFiltered(bl);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
            this.nodeSelectionChanged();
        }
    }

    private void nodeSelectionChanged() {
        assert (EventQueue.isDispatchThread());
        this.fireChange();
    }

    void setChangeListener(ChangeListener changeListener) {
        assert (EventQueue.isDispatchThread());
        this.changeListener = changeListener;
        if (this.changeListener == null) {
            this.changeEvent = null;
        } else if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
    }

    private void fireNodeSelectionChange() {
        this.fireChange();
    }

    private void fireChange() {
        assert (EventQueue.isDispatchThread());
        if (this.changeListener != null) {
            this.changeListener.stateChanged(this.changeEvent);
        }
    }

    Node[] getSelectedNodes() {
        return this.explorerManager.getSelectedNodes();
    }

    private void selectAndActivateNode(Node node) {
        Node[] nodeArray = new Node[]{node};
        try {
            this.explorerManager.setSelectedNodes(nodeArray);
            this.fireNodeSelectionChange();
        }
        catch (PropertyVetoException propertyVetoException) {
            ErrorManager.getDefault().notify(4096, (Throwable)propertyVetoException);
            nodeArray = new Node[]{};
            try {
                this.explorerManager.setSelectedNodes(nodeArray);
                this.fireNodeSelectionChange();
            }
            catch (PropertyVetoException propertyVetoException2) {
                ErrorManager.getDefault().notify(4096, (Throwable)propertyVetoException2);
            }
        }
        node.getPreferredAction().actionPerformed(null);
    }

    private List<TestMethodNode> getFailedTestMethodNodes() {
        ArrayList<TestMethodNode> arrayList = new ArrayList<TestMethodNode>();
        for (Node node : this.explorerManager.getRootContext().getChildren().getNodes()) {
            if (!(node instanceof TestsuiteNode)) continue;
            TestsuiteNode testsuiteNode = (TestsuiteNode)node;
            for (Node node2 : testsuiteNode.getChildren().getNodes()) {
                TestMethodNode testMethodNode;
                if (!(node2 instanceof TestMethodNode) || !(testMethodNode = (TestMethodNode)node2).failed()) continue;
                arrayList.add(testMethodNode);
            }
        }
        return arrayList;
    }

    private TestMethodNode getFirstFailedTestMethodNode() {
        List<TestMethodNode> list = this.getFailedTestMethodNodes();
        return list.isEmpty() ? null : list.get(0);
    }

    private List<TestsuiteNode> getFailedSuiteNodes(TestsuiteNode testsuiteNode) {
        ArrayList<TestsuiteNode> arrayList = new ArrayList<TestsuiteNode>();
        ArrayList<TestsuiteNode> arrayList2 = new ArrayList<TestsuiteNode>();
        boolean bl = false;
        block0: for (Node node : this.explorerManager.getRootContext().getChildren().getNodes()) {
            if (!(node instanceof TestsuiteNode)) continue;
            TestsuiteNode testsuiteNode2 = (TestsuiteNode)node;
            if (testsuiteNode2.equals((Object)testsuiteNode)) {
                bl = true;
            }
            for (Node node2 : testsuiteNode2.getChildren().getNodes()) {
                TestMethodNode testMethodNode;
                if (!(node2 instanceof TestMethodNode) || !(testMethodNode = (TestMethodNode)node2).failed()) continue;
                if (bl) {
                    arrayList2.add(testsuiteNode2);
                    continue block0;
                }
                arrayList.add(testsuiteNode2);
                continue block0;
            }
        }
        arrayList2.addAll(arrayList);
        return arrayList2;
    }

    void selectPreviousFailure() {
        Node[] nodeArray = this.getSelectedNodes();
        if (nodeArray.length == 0) {
            List<TestMethodNode> list = this.getFailedTestMethodNodes();
            if (!list.isEmpty()) {
                this.selectAndActivateNode((Node)list.get(list.size() - 1));
            }
            return;
        }
        Node node = nodeArray[0];
        TestsuiteNode testsuiteNode = this.getSelectedSuite(node);
        if (testsuiteNode == null) {
            return;
        }
        Node[] nodeArray2 = testsuiteNode.getChildren().getNodes();
        boolean bl = false;
        for (int i = nodeArray2.length; i > 0; --i) {
            Object object = (TestMethodNode)nodeArray2[i - 1];
            if (this.isSelected((TestMethodNode)((Object)object), node)) {
                bl = true;
                continue;
            }
            if (!bl || !object.failed()) continue;
            this.selectAndActivateNode((Node)object);
            return;
        }
        List<TestsuiteNode> list = this.getFailedSuiteNodes(testsuiteNode);
        list.remove((Object)testsuiteNode);
        Collections.reverse(list);
        for (TestsuiteNode testsuiteNode2 : list) {
            nodeArray2 = testsuiteNode2.getChildren().getNodes();
            for (int i = nodeArray2.length; i > 0; --i) {
                TestMethodNode testMethodNode = (TestMethodNode)nodeArray2[i - 1];
                if (!testMethodNode.failed()) continue;
                this.selectAndActivateNode((Node)testMethodNode);
                return;
            }
        }
    }

    void selectNextFailure() {
        Node[] nodeArray = this.getSelectedNodes();
        if (nodeArray.length == 0) {
            TestMethodNode testMethodNode = this.getFirstFailedTestMethodNode();
            if (testMethodNode != null) {
                this.selectAndActivateNode((Node)testMethodNode);
            }
            return;
        }
        Node node = nodeArray[0];
        TestsuiteNode testsuiteNode = this.getSelectedSuite(node);
        if (testsuiteNode == null) {
            return;
        }
        boolean bl = node.equals((Object)testsuiteNode);
        for (Node nodeArray2 : testsuiteNode.getChildren().getNodes()) {
            TestMethodNode testMethodNode = (TestMethodNode)nodeArray2;
            if (!bl && this.isSelected(testMethodNode, node)) {
                bl = true;
                continue;
            }
            if (!bl || !testMethodNode.failed()) continue;
            this.selectAndActivateNode((Node)testMethodNode);
            return;
        }
        List<TestsuiteNode> list = this.getFailedSuiteNodes(testsuiteNode);
        if (bl) {
            list.remove((Object)testsuiteNode);
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TestsuiteNode testsuiteNode2 = (TestsuiteNode)((Object)iterator.next());
            for (Node node2 : testsuiteNode2.getChildren().getNodes()) {
                TestMethodNode testMethodNode = (TestMethodNode)node2;
                if (!testMethodNode.failed()) continue;
                this.selectAndActivateNode((Node)testMethodNode);
                return;
            }
        }
    }

    private boolean isSelected(TestMethodNode testMethodNode, Node node) {
        if (testMethodNode.equals(node)) {
            return true;
        }
        for (Node node2 : testMethodNode.getChildren().getNodes()) {
            if (!node2.equals((Object)node)) continue;
            return true;
        }
        return false;
    }

    private TestsuiteNode getSelectedSuite(Node node) {
        if (node instanceof TestMethodNode) {
            return (TestsuiteNode)node.getParentNode();
        }
        if (node instanceof TestsuiteNode) {
            return (TestsuiteNode)node;
        }
        if (node instanceof CallstackFrameNode) {
            return (TestsuiteNode)node.getParentNode().getParentNode();
        }
        return this.getFirstFailedSuite();
    }

    private TestsuiteNode getFirstFailedSuite() {
        List<TestsuiteNode> list = this.getFailedSuiteNodes(null);
        return list.isEmpty() ? null : list.get(0);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }
}

