/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.netbeans.modules.ruby.testrunner.ui.Report;
import org.netbeans.modules.ruby.testrunner.ui.ResultDisplayHandler;
import org.netbeans.modules.ruby.testrunner.ui.ResultWindow;
import org.netbeans.modules.ruby.testrunner.ui.TestSession;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;

public final class Manager {
    private static Reference<Manager> instanceRef;
    private final Set<TestSession> testSessions = new WeakSet(5);
    private final boolean lateWindowPromotion;
    private static final Logger LOGGER;
    private Map<TestSession, ResultDisplayHandler> displayHandlers;
    private Map<TestSession, Boolean> displaysMap;

    public static Manager getInstance() {
        if (instanceRef != null && instanceRef.get() != null) {
            return instanceRef.get();
        }
        final Manager manager = new Manager();
        ResultWindow.getInstance().addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                manager.updateDisplayHandlerLayouts();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                manager.updateDisplayHandlerLayouts();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                manager.updateDisplayHandlerLayouts();
            }
        });
        instanceRef = new WeakReference<Manager>(manager);
        return manager;
    }

    private void updateDisplayHandlerLayouts() {
        int n;
        int n2 = ResultWindow.getInstance().getWidth();
        int n3 = n2 > (n = ResultWindow.getInstance().getHeight()) ? 1 : 0;
        ResultWindow.getInstance().setOrientation(n3);
    }

    private Manager() {
        this.lateWindowPromotion = true;
    }

    public synchronized void emptyTestRun(TestSession testSession) {
        this.testStarted(testSession);
        this.sessionFinished(testSession);
    }

    synchronized void testStarted(TestSession testSession) {
        this.displayMessage(testSession, NbBundle.getMessage(this.getClass(), (String)"LBL_RunningTests"));
        if (testSession.getStartingMsg() != null) {
            this.displayOutput(testSession, testSession.getStartingMsg(), true);
        }
    }

    synchronized void sessionFinished(TestSession testSession) {
        if (!this.testSessions.contains(testSession)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Finishing an unknown session: " + testSession);
            }
            return;
        }
        this.displayMessage(testSession, null, true);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Finishing session: " + testSession);
        }
        this.testSessions.remove(testSession);
    }

    synchronized void displayOutput(TestSession testSession, String string, boolean bl) {
        ResultDisplayHandler resultDisplayHandler = this.getDisplayHandler(testSession);
        resultDisplayHandler.displayOutput(string, bl);
        this.displayInWindow(testSession, resultDisplayHandler);
    }

    synchronized void displaySuiteRunning(TestSession testSession, String string) {
        ResultDisplayHandler resultDisplayHandler = this.getDisplayHandler(testSession);
        resultDisplayHandler.displaySuiteRunning(string);
        this.displayInWindow(testSession, resultDisplayHandler);
    }

    synchronized void displayReport(TestSession testSession, Report report) {
        ResultDisplayHandler resultDisplayHandler = this.getDisplayHandler(testSession);
        resultDisplayHandler.displayReport(report);
        this.displayInWindow(testSession, resultDisplayHandler);
    }

    private void displayMessage(TestSession testSession, String string) {
        this.displayMessage(testSession, string, false);
    }

    private void displayMessage(TestSession testSession, String string, boolean bl) {
        ResultDisplayHandler resultDisplayHandler = this.getDisplayHandler(testSession);
        if (!bl) {
            resultDisplayHandler.displayMessage(string);
        } else {
            resultDisplayHandler.displayMessageSessionFinished(string);
        }
        this.displayInWindow(testSession, resultDisplayHandler, bl);
    }

    private void displayInWindow(TestSession testSession, ResultDisplayHandler resultDisplayHandler) {
        this.displayInWindow(testSession, resultDisplayHandler, false);
    }

    private void displayInWindow(TestSession testSession, ResultDisplayHandler resultDisplayHandler, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.testSessions.add(testSession);
        boolean bl4 = testSession.getSessionType() == TestSession.SessionType.TEST ? bl2 || bl : bl;
        int n = this.getDisplayIndex(testSession);
        if (n == -1) {
            this.addDisplay(testSession);
            Mutex.EVENT.writeAccess((Runnable)new Displayer(resultDisplayHandler, bl4));
        } else if (bl4) {
            Mutex.EVENT.writeAccess((Runnable)new Displayer(null, bl4));
        }
    }

    private synchronized ResultDisplayHandler getDisplayHandler(TestSession testSession) {
        ResultDisplayHandler resultDisplayHandler;
        ResultDisplayHandler resultDisplayHandler2 = resultDisplayHandler = this.displayHandlers != null ? this.displayHandlers.get(testSession) : null;
        if (resultDisplayHandler == null) {
            if (this.displayHandlers == null) {
                this.displayHandlers = new WeakHashMap<TestSession, ResultDisplayHandler>(7);
            }
            resultDisplayHandler = new ResultDisplayHandler();
            this.displayHandlers.put(testSession, resultDisplayHandler);
        }
        return resultDisplayHandler;
    }

    private int getDisplayIndex(TestSession testSession) {
        if (this.displaysMap == null) {
            return -1;
        }
        Boolean bl = this.displaysMap.get(testSession);
        return bl != null ? 0 : -1;
    }

    private void addDisplay(TestSession testSession) {
        if (this.displaysMap == null) {
            this.displaysMap = new WeakHashMap<TestSession, Boolean>(4);
        }
        this.displaysMap.put(testSession, Boolean.TRUE);
    }

    static {
        LOGGER = Logger.getLogger(Manager.class.getName());
    }

    private class Displayer
    implements Runnable {
        private final ResultDisplayHandler displayHandler;
        private final boolean promote;

        Displayer(ResultDisplayHandler resultDisplayHandler, boolean bl) {
            this.displayHandler = resultDisplayHandler;
            this.promote = bl;
        }

        public void run() {
            ResultWindow resultWindow = ResultWindow.getInstance();
            if (this.displayHandler != null) {
                resultWindow.addDisplayComponent(this.displayHandler.getDisplayComponent());
            }
            if (this.promote) {
                resultWindow.promote();
            }
        }
    }
}

