/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.execution.ExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.FileLocator;
import org.netbeans.modules.ruby.platform.execution.OutputRecognizer;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyProjectUtil;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.netbeans.modules.ruby.rubyproject.spi.RakeTaskCustomizer;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.TestExecutionManager;
import org.netbeans.modules.ruby.testrunner.TestRunnerUtilities;
import org.netbeans.modules.ruby.testrunner.ui.Manager;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizer;
import org.netbeans.modules.ruby.testrunner.ui.TestSession;
import org.netbeans.modules.ruby.testrunner.ui.TestUnitHandlerFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestUnitRunner
implements TestRunner,
RakeTaskCustomizer {
    private static final Logger LOGGER = Logger.getLogger(TestUnitRunner.class.getName());
    private static final String NB_TEST_RUNNER = "NB_TEST_RUNNER";
    public static final String MEDIATOR_SCRIPT_NAME = "nb_test_mediator.rb";
    public static final String RUNNER_SCRIPT_NAME = "nb_test_runner.rb";
    private static final TestRunner INSTANCE = new TestUnitRunner();
    static final int DEFAULT_WAIT_TIME = 5000;

    public TestRunner getInstance() {
        return INSTANCE;
    }

    public void runSingleTest(FileObject fileObject, String string, boolean bl) {
        List<String> list = this.getTestFileArgs(fileObject);
        list.add("-m");
        list.add(string);
        this.run(FileOwnerQuery.getOwner((FileObject)fileObject), list, string, bl);
    }

    public void runTest(FileObject fileObject, boolean bl) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (!fileObject.isFolder()) {
            this.run(project, this.getTestFileArgs(fileObject), fileObject.getName(), bl);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("-d");
            arrayList.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
            String string = ProjectUtils.getInformation((Project)project).getDisplayName();
            this.run(project, arrayList, string, bl);
        }
    }

    private List<String> getTestFileArgs(FileObject fileObject) {
        String string = FileUtil.toFile((FileObject)fileObject).getAbsolutePath();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-f");
        arrayList.add(string);
        return arrayList;
    }

    private static File getScript(String string) {
        File file = InstalledFileLocator.getDefault().locate(string, "org.netbeans.modules.ruby.testrunner", false);
        if (file == null) {
            throw new IllegalStateException("Could not locate " + string);
        }
        return file;
    }

    static void addTestUnitRunnerToEnv(Map<String, String> map) {
        map.put(NB_TEST_RUNNER, TestUnitRunner.getScript(RUNNER_SCRIPT_NAME).getAbsolutePath());
    }

    public void runAllTests(Project project, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        RubyBaseProject rubyBaseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
        for (FileObject fileObject : rubyBaseProject.getTestSourceRootFiles()) {
            arrayList.add("-d");
            arrayList.add(FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        }
        String string = ProjectUtils.getInformation((Project)project).getDisplayName();
        this.run(project, arrayList, string, bl);
    }

    private void run(Project project, List<String> list, String string, boolean bl) {
        FileLocator fileLocator = (FileLocator)project.getLookup().lookup(FileLocator.class);
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        String string2 = TestUnitRunner.getScript(MEDIATOR_SCRIPT_NAME).getAbsolutePath();
        ExecutionDescriptor executionDescriptor = null;
        Object var9_9 = null;
        executionDescriptor = new ExecutionDescriptor(rubyPlatform, string, FileUtil.toFile((FileObject)project.getProjectDirectory()), string2);
        executionDescriptor.additionalArgs(list.toArray(new String[list.size()]));
        executionDescriptor.initialArgs(RubyProjectUtil.getLoadPath((Project)project));
        executionDescriptor.debug(bl);
        executionDescriptor.allowInput();
        executionDescriptor.fileLocator(fileLocator);
        executionDescriptor.addStandardRecognizers();
        executionDescriptor.setRerun(false);
        TestSession testSession = new TestSession(string, project, bl ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST);
        TestRecognizer testRecognizer = new TestRecognizer(Manager.getInstance(), TestUnitHandlerFactory.getHandlers(), testSession, true);
        TestExecutionManager.getInstance().start(executionDescriptor, testRecognizer);
    }

    public boolean supports(TestRunner.TestType testType) {
        return testType == TestRunner.TestType.TEST_UNIT;
    }

    public void customize(Project project, RakeTask rakeTask, ExecutionDescriptor executionDescriptor, boolean bl) {
        boolean bl2 = TestRunnerUtilities.useTestRunner(project, "test.tasks", rakeTask, new TestRunnerUtilities.DefaultTaskEvaluator(){

            public boolean isDefault(RakeTask rakeTask) {
                return "test".equals(rakeTask.getTask()) || rakeTask.getTask().startsWith("test:");
            }
        });
        if (!bl2) {
            return;
        }
        TestExecutionManager.getInstance().reset();
        rakeTask.addRakeParameters(new String[]{"-r \"" + TestUnitRunner.getScript(RUNNER_SCRIPT_NAME).getAbsolutePath() + "\""});
        TestSession testSession = new TestSession(rakeTask.getDisplayName(), project, bl ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST);
        TestRecognizer testRecognizer = new TestRecognizer(Manager.getInstance(), TestUnitHandlerFactory.getHandlers(), testSession, true);
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        TestUnitRunner.addTestUnitRunnerToEnv(hashMap);
        executionDescriptor.addAdditionalEnv(hashMap);
        executionDescriptor.addOutputRecognizer((OutputRecognizer)testRecognizer);
        executionDescriptor.setReadMaxWaitTime(5000);
        executionDescriptor.setRerun(false);
    }

    static {
        System.setProperty(NB_TEST_RUNNER, TestUnitRunner.getScript(RUNNER_SCRIPT_NAME).getAbsolutePath());
    }
}

