/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.reglib.NbBundle;
import org.netbeans.modules.reglib.NbConnectionSupport;
import org.netbeans.modules.reglib.Util;
import org.netbeans.modules.servicetag.RegistrationData;
import org.netbeans.modules.servicetag.Registry;
import org.netbeans.modules.servicetag.ServiceTag;

public class NbServiceTagSupport {
    private static String NB_CLUSTER;
    private static String NB_VERSION;
    private static final String USER_HOME;
    private static final String SUPER_IDENTITY_FILE_NAME = ".superId";
    private static final String DEFAULT_NETBEANS_DIR = ".netbeans";
    private static final String USER_DIR;
    private static final String ST_DIR = "servicetag";
    private static final String ST_FILE = "servicetag";
    private static final String REG_FILE = "registration.xml";
    private static File svcTagDirHome;
    private static File svcTagDirNb;
    private static File serviceTagFileHome;
    private static File serviceTagFileNb;
    private static File nbClusterDir;
    private static File nbInstallDir;
    private static File regXmlFileHome;
    private static File regXmlFileNb;
    private static RegistrationData registration;
    private static final Logger LOG;
    private static File registerHtmlParent;
    private static final String REGISTRATION_HTML_NAME = "register";
    private static boolean inited;
    private static final String NB_HEADER_PNG_KEY = "@@NB_HEADER_PNG@@";
    private static final String PRODUCT_KEY = "@@PRODUCT@@";
    private static final String PRODUCT_TITLE_KEY = "@@PRODUCT_TITLE@@";
    private static final String REGISTRATION_URL_KEY = "@@REGISTRATION_URL@@";
    private static final String REGISTRATION_PAYLOAD_KEY = "@@REGISTRATION_PAYLOAD@@";

    private static void init() {
        LOG.log(Level.FINE, "Initializing");
        NB_CLUSTER = NbBundle.getMessage(NbServiceTagSupport.class, "nb.cluster");
        NB_VERSION = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.version");
        File file = new File(System.getProperty("netbeans.home"));
        nbInstallDir = file.getParentFile();
        LOG.log(Level.FINE, "NetBeans install dir is:" + nbInstallDir);
        nbClusterDir = new File(nbInstallDir, NB_CLUSTER);
        LOG.log(Level.FINE, "nb cluster dir is:" + nbClusterDir);
        svcTagDirNb = new File(nbClusterDir.getPath() + File.separator + "servicetag");
        svcTagDirHome = new File(USER_HOME + File.separator + ".netbeans-registration" + File.separator + NB_VERSION);
        if (nbClusterDir.canWrite() && !svcTagDirNb.exists()) {
            svcTagDirNb.mkdirs();
        }
        if (!svcTagDirHome.exists()) {
            svcTagDirHome.mkdirs();
        }
        regXmlFileNb = new File(svcTagDirNb, REG_FILE);
        regXmlFileHome = new File(svcTagDirHome, REG_FILE);
        serviceTagFileNb = new File(svcTagDirNb, "servicetag");
        serviceTagFileHome = new File(svcTagDirHome, "servicetag");
        inited = true;
    }

    public static String getProductName() {
        return NbBundle.getMessage(NbServiceTagSupport.class, "nb.product.name");
    }

    public static String[] getProductNames(RegistrationData registrationData) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.urn");
        boolean bl = false;
        boolean bl2 = false;
        Set<ServiceTag> set = registrationData.getServiceTags();
        block0: for (ServiceTag serviceTag : set) {
            if (string.equals(serviceTag.getProductURN())) {
                arrayList.add(NbServiceTagSupport.getProductName());
                continue;
            }
            if (serviceTag.getProductDefinedInstanceID().contains("glassfish.home")) {
                String[] stringArray;
                for (String string2 : stringArray = serviceTag.getProductDefinedInstanceID().split(",")) {
                    if (!string2.contains("glassfish.home")) continue;
                    String[] stringArray2 = string2.split("=");
                    if (stringArray2.length < 2) continue block0;
                    if (stringArray2[1].toUpperCase(Locale.ENGLISH).contains("GLASSFISH")) {
                        if (bl) continue block0;
                        arrayList.add("GlassFish V2 UR2");
                        bl = true;
                        continue block0;
                    }
                    if (!stringArray2[1].toUpperCase(Locale.ENGLISH).contains("APPSERVER") && !stringArray2[1].toUpperCase(Locale.ENGLISH).contains("SDK") || bl2) continue block0;
                    arrayList.add("Sun Java System Application Server 9.1 Update 2");
                    bl2 = true;
                    continue block0;
                }
                continue;
            }
            if (serviceTag.getProductName().contains("Sun Java System Application Server")) {
                if (bl2) continue;
                arrayList.add("Sun Java System Application Server 9.1 Update 2");
                bl2 = true;
                continue;
            }
            if (serviceTag.getProductName().contains("Sun GlassFish Enterprise Server")) {
                if (bl) continue;
                arrayList.add("GlassFish V2 UR2");
                bl = true;
                continue;
            }
            if (serviceTag.getProductName().contains("J2SE 5.0 Development Kit")) {
                arrayList.add(serviceTag.getProductName());
                continue;
            }
            if (!serviceTag.getProductName().contains("Java SE 6 Development Kit")) continue;
            arrayList.add(serviceTag.getProductName());
        }
        return arrayList.toArray(new String[0]);
    }

    public static String getProductId(RegistrationData registrationData) {
        String string = "nb";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Set<ServiceTag> set = registrationData.getServiceTags();
        block0: for (ServiceTag serviceTag : set) {
            if (serviceTag.getProductDefinedInstanceID().contains("glassfish.home")) {
                String[] stringArray;
                for (String string2 : stringArray = serviceTag.getProductDefinedInstanceID().split(",")) {
                    if (!string2.contains("glassfish.home")) continue;
                    String[] stringArray2 = string2.split("=");
                    if (stringArray2.length < 2) continue block0;
                    if (stringArray2[1].toUpperCase(Locale.ENGLISH).contains("GLASSFISH")) {
                        bl2 = true;
                        continue block0;
                    }
                    if (!stringArray2[1].toUpperCase(Locale.ENGLISH).contains("APPSERVER") && !stringArray2[1].toUpperCase(Locale.ENGLISH).contains("SDK")) continue block0;
                    bl3 = true;
                    continue block0;
                }
                continue;
            }
            if (serviceTag.getProductName().contains("Sun Java System Application Server")) {
                bl3 = true;
                continue;
            }
            if (serviceTag.getProductName().contains("Sun GlassFish Enterprise Server")) {
                bl2 = true;
                continue;
            }
            if (serviceTag.getProductName().contains("J2SE 5.0 Development Kit")) {
                bl = true;
                continue;
            }
            if (!serviceTag.getProductName().contains("Java SE 6 Development Kit")) continue;
            bl = true;
        }
        if (bl && (bl2 || bl3)) {
            string = "nbgfjdk";
        } else if (bl) {
            string = "nbjdk";
        } else if (bl2) {
            string = "nbgf";
        } else if (bl3) {
            string = "nbas";
        }
        return string;
    }

    public static ServiceTag createNbServiceTag(String string, String string2) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating NetBeans service tag");
        ServiceTag serviceTag = NbServiceTagSupport.getNbServiceTag();
        if (serviceTag == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            serviceTag = NbServiceTagSupport.newNbServiceTag(string, string2);
            NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
            NbServiceTagSupport.writeRegistrationXml();
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport.installSystemServiceTag(serviceTag);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return serviceTag;
    }

    public static ServiceTag createJavaFXServiceTag(String string, String string2) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating JavaFX service tag");
        ServiceTag serviceTag = NbServiceTagSupport.getJavaFXServiceTag();
        if (serviceTag == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            serviceTag = NbServiceTagSupport.newJavaFXServiceTag(string, string2);
            NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
            NbServiceTagSupport.writeRegistrationXml();
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport.installSystemServiceTag(serviceTag);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return serviceTag;
    }

    public static ServiceTag createJavaFXSdkServiceTag(String string, String string2) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating JavaFX SDK service tag");
        ServiceTag serviceTag = NbServiceTagSupport.getJavaFXSdkServiceTag();
        if (serviceTag == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            serviceTag = NbServiceTagSupport.newJavaFXSdkServiceTag(string, string2);
            NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
            NbServiceTagSupport.writeRegistrationXml();
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport.installSystemServiceTag(serviceTag);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return serviceTag;
    }

    public static ServiceTag createCndServiceTag(String string, String string2) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating CND service tag");
        ServiceTag serviceTag = NbServiceTagSupport.getCndServiceTag();
        if (serviceTag == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            serviceTag = NbServiceTagSupport.newCndServiceTag(string, string2);
            NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
            NbServiceTagSupport.writeRegistrationXml();
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport.installSystemServiceTag(serviceTag);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return serviceTag;
    }

    public static ServiceTag createGfServiceTag(String string, String string2, String string3, String string4, String string5) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating GlassFish service tag");
        ServiceTag serviceTag = NbServiceTagSupport.getGfServiceTag(string5);
        if (serviceTag != null) {
            if (serviceTagFileNb.exists() || serviceTagFileHome.exists()) {
                LOG.log(Level.FINE, "GlassFish service tag is already created and saved in registration.xml");
            } else {
                LOG.log(Level.FINE, "GlassFish service tag is already created");
            }
        } else {
            LOG.log(Level.FINE, "Creating new GlassFish service tag");
            serviceTag = NbServiceTagSupport.newGfServiceTag(string, string2, string3, string4, string5);
            NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
            NbServiceTagSupport.writeRegistrationXml();
        }
        return serviceTag;
    }

    public static ServiceTag createGfServiceTag(ServiceTag serviceTag, String string) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating GlassFish service tag");
        ServiceTag serviceTag2 = NbServiceTagSupport.getGfServiceTag(string);
        if (serviceTag2 != null) {
            if (!serviceTag2.equals(serviceTag)) {
                NbServiceTagSupport.getRegistrationData().removeServiceTag(serviceTag2.getInstanceURN());
                NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
                NbServiceTagSupport.writeRegistrationXml();
            }
        } else {
            NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
            NbServiceTagSupport.writeRegistrationXml();
        }
        return serviceTag;
    }

    public static ServiceTag createJdkServiceTag(String string) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        LOG.log(Level.FINE, "Creating JDK service tag");
        ServiceTag serviceTag = NbServiceTagSupport.getJdkServiceTag();
        if (serviceTag != null) {
            if (serviceTagFileNb.exists() || serviceTagFileHome.exists()) {
                LOG.log(Level.FINE, "JDK service tag is already created and saved in registration.xml");
                return serviceTag;
            }
            LOG.log(Level.FINE, "JDK service tag is already created");
        }
        if (serviceTag == null) {
            LOG.log(Level.FINE, "Creating new JDK service tag");
            serviceTag = ServiceTag.getJavaServiceTag(string);
            NbServiceTagSupport.getRegistrationData().addServiceTag(serviceTag);
            NbServiceTagSupport.writeRegistrationXml();
        }
        return serviceTag;
    }

    private static void writeRegistrationXml() throws IOException {
        Object object;
        File file = null;
        if (svcTagDirNb.exists() && svcTagDirNb.canWrite()) {
            object = null;
            try {
                object = File.createTempFile("regtmp", null, svcTagDirNb);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Warning: Cannot create file in " + svcTagDirNb + " Will use user home dir", iOException);
            }
            if (object != null && ((File)object).exists()) {
                ((File)object).delete();
                file = regXmlFileNb;
            } else {
                file = regXmlFileHome;
            }
        } else {
            file = regXmlFileHome;
        }
        object = null;
        try {
            object = new BufferedOutputStream(new FileOutputStream(file));
            NbServiceTagSupport.getRegistrationData().storeToXML((OutputStream)object);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Error: Cannot save registration data to \"" + file + "\":" + iOException.getMessage());
            throw iOException;
        }
        finally {
            if (object != null) {
                ((FilterOutputStream)object).close();
            }
        }
    }

    public static RegistrationData getRegistrationData() throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        if (registration != null) {
            return registration;
        }
        File file = null;
        if (regXmlFileNb.exists()) {
            file = regXmlFileNb;
            LOG.log(Level.FINE, "Service tag will be loaded from NB install dir: " + file);
        } else if (regXmlFileHome.exists()) {
            file = regXmlFileHome;
            LOG.log(Level.FINE, "Service tag will be loaded from user home dir: " + file);
        } else {
            registration = new RegistrationData();
            LOG.log(Level.FINE, "Service tag file not found");
            return registration;
        }
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            registration = RegistrationData.loadFromXML(bufferedInputStream);
        }
        catch (IOException iOException) {
            LOG.log(Level.INFO, "Error: Bad registration data \"" + file + "\":" + iOException.getMessage());
            throw iOException;
        }
        finally {
            if (bufferedInputStream != null) {
                bufferedInputStream.close();
            }
        }
        return registration;
    }

    private static ServiceTag newNbServiceTag(String string, String string2) throws IOException {
        String string3 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.urn");
        String string4 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.name");
        String string5 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.parent.urn");
        String string6 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), string4, NB_VERSION, string3, string6, string5, NbServiceTagSupport.getNbProductDefinedId(string2, true), "NetBeans.org", System.getProperty("os.arch"), NbServiceTagSupport.getZoneName(), string);
    }

    private static ServiceTag newJavaFXServiceTag(String string, String string2) throws IOException {
        String string3 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafx.urn");
        String string4 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafx.name");
        String string5 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafx.version");
        String string6 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafx.parent.urn");
        String string7 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafx.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), string4, string5, string3, string7, string6, NbServiceTagSupport.getNbProductDefinedId(string2, false), "NetBeans.org", System.getProperty("os.arch"), NbServiceTagSupport.getZoneName(), string);
    }

    private static ServiceTag newJavaFXSdkServiceTag(String string, String string2) throws IOException {
        String string3 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafxsdk.urn");
        String string4 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafxsdk.name");
        String string5 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafxsdk.version");
        String string6 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafxsdk.parent.urn");
        String string7 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafxsdk.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), string4, string5, string3, string7, string6, NbServiceTagSupport.getNbProductDefinedId(string2, false), "Sun Microsystems", System.getProperty("os.arch"), NbServiceTagSupport.getZoneName(), string);
    }

    private static ServiceTag newCndServiceTag(String string, String string2) throws IOException {
        String string3 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.cnd.urn");
        String string4 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.cnd.name");
        String string5 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.cnd.parent.urn");
        String string6 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.cnd.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), string4, NB_VERSION, string3, string6, string5, NbServiceTagSupport.getNbProductDefinedId(string2, false), "NetBeans.org", System.getProperty("os.arch"), NbServiceTagSupport.getZoneName(), string);
    }

    private static ServiceTag newGfServiceTag(String string, String string2, String string3, String string4, String string5) throws IOException {
        String string6 = "";
        if (!"".equals(string5)) {
            string6 = string6 + "." + string5;
        }
        String string7 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.urn" + string6);
        String string8 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.name" + string6);
        String string9 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.version" + string6);
        String string10 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.parent.urn" + string6);
        String string11 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.parent.name" + string6);
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), string8, string9, string7, string11, string10, NbServiceTagSupport.getGfProductDefinedId(string2, string3, string4), "Sun Microsystems Inc.", System.getProperty("os.arch"), NbServiceTagSupport.getZoneName(), string);
    }

    private static ServiceTag getNbServiceTag() throws IOException {
        String string = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.nb.urn");
        RegistrationData registrationData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> set = registrationData.getServiceTags();
        for (ServiceTag serviceTag : set) {
            if (!string.equals(serviceTag.getProductURN())) continue;
            return serviceTag;
        }
        return null;
    }

    private static ServiceTag getJavaFXServiceTag() throws IOException {
        String string = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafx.urn");
        RegistrationData registrationData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> set = registrationData.getServiceTags();
        for (ServiceTag serviceTag : set) {
            if (!string.equals(serviceTag.getProductURN())) continue;
            return serviceTag;
        }
        return null;
    }

    private static ServiceTag getJavaFXSdkServiceTag() throws IOException {
        String string = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.javafxsdk.urn");
        RegistrationData registrationData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> set = registrationData.getServiceTags();
        for (ServiceTag serviceTag : set) {
            if (!string.equals(serviceTag.getProductURN())) continue;
            return serviceTag;
        }
        return null;
    }

    private static ServiceTag getCndServiceTag() throws IOException {
        String string = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.cnd.urn");
        RegistrationData registrationData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> set = registrationData.getServiceTags();
        for (ServiceTag serviceTag : set) {
            if (!string.equals(serviceTag.getProductURN())) continue;
            return serviceTag;
        }
        return null;
    }

    private static ServiceTag getGfServiceTag(String string) throws IOException {
        RegistrationData registrationData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> set = registrationData.getServiceTags();
        String string2 = "";
        if (!"".equals(string)) {
            string2 = string2 + "." + string;
        }
        String string3 = NbBundle.getMessage(NbServiceTagSupport.class, "servicetag.gf.urn" + string2);
        for (ServiceTag serviceTag : set) {
            if (!serviceTag.getProductURN().equals(string3)) continue;
            return serviceTag;
        }
        return null;
    }

    private static ServiceTag getJdkServiceTag() throws IOException {
        RegistrationData registrationData = NbServiceTagSupport.getRegistrationData();
        Set<ServiceTag> set = registrationData.getServiceTags();
        for (ServiceTag serviceTag : set) {
            if (!serviceTag.getProductName().startsWith("J2SE") && !serviceTag.getProductName().startsWith("Java SE")) continue;
            return serviceTag;
        }
        return null;
    }

    private static String getNbProductDefinedId(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id=");
        stringBuilder.append(NB_VERSION);
        if (bl) {
            stringBuilder.append(",uuid=");
            stringBuilder.append(NbServiceTagSupport.getSuperId());
        }
        stringBuilder.append(",java.version=");
        stringBuilder.append(string);
        String string2 = ",dir=" + nbInstallDir.getPath();
        if (stringBuilder.length() + string2.length() < 256) {
            stringBuilder.append(string2);
        } else {
            LOG.log(Level.INFO, "Warning: Product defined instance ID exceeds the field limit:");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSuperId() {
        String string = "";
        File file = new File(USER_HOME + File.separator + DEFAULT_NETBEANS_DIR + File.separator + SUPER_IDENTITY_FILE_NAME);
        if (file.exists()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                string = bufferedReader.readLine().trim();
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Error: Cannot read from file:" + file, iOException);
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    LOG.log(Level.INFO, "Error: Cannot close input stream of file:" + file, iOException);
                }
            }
        } else {
            File file2 = new File(USER_HOME + File.separator + DEFAULT_NETBEANS_DIR);
            if (!file2.exists()) {
                file2.mkdirs();
            }
            Writer writer = null;
            try {
                writer = new BufferedWriter(new FileWriter(file));
                string = UUID.randomUUID().toString();
                writer.write(string);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Error: Cannot write to file:" + file, iOException);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {
                    LOG.log(Level.INFO, "Error: Cannot close writer to file:" + file, iOException);
                }
            }
        }
        return string;
    }

    private static String getGfProductDefinedId(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("os.name=");
        stringBuilder.append(System.getProperty("os.name"));
        stringBuilder.append(",os.version=");
        stringBuilder.append(System.getProperty("os.version"));
        stringBuilder.append(",java.version=");
        stringBuilder.append(string2);
        stringBuilder.append(",glassfish.home=");
        stringBuilder.append(string3);
        stringBuilder.append(",java.home=");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private static String getZoneName() throws IOException {
        String string = "global";
        String string2 = "/usr/bin/zonename";
        File file = new File(string2);
        if (file.exists()) {
            ProcessBuilder processBuilder = new ProcessBuilder(string2);
            Process process = processBuilder.start();
            String string3 = Util.commandOutput(process);
            if (process.exitValue() == 0) {
                string = string3.trim();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInstalledURN(String string) throws IOException {
        if (serviceTagFileNb.exists() || serviceTagFileHome.exists()) {
            File file = null;
            if (serviceTagFileNb.exists()) {
                file = serviceTagFileNb;
            } else if (serviceTagFileHome.exists()) {
                file = serviceTagFileHome;
            }
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    if (string.equals(string2.trim())) {
                        String string3 = string;
                        return string3;
                    }
                    string2 = bufferedReader.readLine();
                }
                String string4 = "";
                return string4;
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installSystemServiceTag(ServiceTag serviceTag) throws IOException {
        File file;
        Object object;
        if (NbServiceTagSupport.getInstalledURN(serviceTag.getInstanceURN()).length() > 0) {
            LOG.log(Level.INFO, "ST is already installed ie. we have file servicetag.");
            return;
        }
        if (svcTagDirNb.exists() && svcTagDirNb.canWrite()) {
            object = null;
            try {
                object = File.createTempFile("regtmp", null, svcTagDirNb);
            }
            catch (IOException iOException) {
                LOG.log(Level.INFO, "Error: Cannot create file in " + svcTagDirNb + " Will use user home dir", iOException);
            }
            if (object != null && ((File)object).exists()) {
                ((File)object).delete();
                file = serviceTagFileNb;
            } else {
                file = serviceTagFileHome;
            }
        } else {
            file = serviceTagFileHome;
        }
        if (Registry.isSupported()) {
            if (Registry.getSystemRegistry().getServiceTag(serviceTag.getInstanceURN()) != null) {
                LOG.log(Level.FINE, "Service tag: " + serviceTag.getInstanceURN() + " is already installed in system registry.");
                return;
            }
            Registry.getSystemRegistry().addServiceTag(serviceTag);
            object = null;
            try {
                LOG.log(Level.FINE, "Creating file: " + file);
                object = new BufferedWriter(new FileWriter(file, true));
                ((Writer)object).write(serviceTag.getInstanceURN());
                ((BufferedWriter)object).newLine();
            }
            finally {
                if (object != null) {
                    ((BufferedWriter)object).close();
                }
            }
            if ("6.0".equals(NB_VERSION)) {
                file = new File(USER_DIR + File.separator + "servicetag");
                try {
                    LOG.log(Level.FINE, "Creating file: " + file + " Specific for 6.0.");
                    object = new BufferedWriter(new FileWriter(file));
                    ((Writer)object).write(serviceTag.getInstanceURN());
                    ((BufferedWriter)object).newLine();
                }
                finally {
                    if (object != null) {
                        ((BufferedWriter)object).close();
                    }
                }
            }
        }
    }

    private static File getRegisterHtmlParent() {
        if (registerHtmlParent == null) {
            registerHtmlParent = svcTagDirHome;
        }
        return registerHtmlParent;
    }

    public static File getServiceTagDirHome() {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        return svcTagDirHome;
    }

    public static File getRegistrationHtmlPage(String string, String[] stringArray) throws IOException {
        if (!inited) {
            NbServiceTagSupport.init();
        }
        File file = NbServiceTagSupport.getRegisterHtmlParent();
        File file2 = new File(file, "register.html");
        NbServiceTagSupport.generateRegisterHtml(file, string, stringArray);
        return file2;
    }

    private static void deleteRegistrationHtmlPage() {
        File file = NbServiceTagSupport.getRegisterHtmlParent();
        if (file == null) {
            return;
        }
        String string = REGISTRATION_HTML_NAME;
        File file2 = new File(file, string + ".html");
        if (file2.exists()) {
            file2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void generateRegisterHtml(File file, String string, String[] stringArray) throws IOException {
        void var19_25;
        Object object2;
        Object object3;
        RegistrationData registrationData = NbServiceTagSupport.getRegistrationData();
        String string2 = NbConnectionSupport.getRegistrationURL(registrationData.getRegistrationURN(), string).toString();
        String string3 = "/org/netbeans/modules/reglib/resources/nb_header.png";
        File file2 = new File(svcTagDirHome, "nb_header.png");
        String string4 = file2.toURI().toURL().toString();
        InputStream inputStream = NbServiceTagSupport.class.getResourceAsStream(string3);
        if (inputStream == null) {
            LOG.log(Level.FINE, "Missing resource file: " + string3);
        } else {
            LOG.log(Level.FINE, "Generating " + file2 + " from " + string3);
            object3 = new BufferedInputStream(inputStream);
            object2 = new FileOutputStream(file2);
            try {
                int n;
                while ((n = ((BufferedInputStream)object3).read()) != -1) {
                    ((FileOutputStream)object2).write(n);
                }
            }
            finally {
                if (object3 != null) {
                    ((BufferedInputStream)object3).close();
                }
                if (object2 != null) {
                    ((FileOutputStream)object2).close();
                }
            }
        }
        object3 = registrationData.toString();
        object2 = System.getProperty("line.separator");
        String string5 = ((String)object3).replaceAll("\"", "%22").replaceAll((String)object2, " ");
        String string6 = REGISTRATION_HTML_NAME;
        File file3 = new File(file, string6 + ".html");
        inputStream = null;
        Locale locale = Locale.getDefault();
        Locale[] localeArray = new Locale[]{new Locale(locale.getLanguage(), locale.getCountry(), locale.getVariant()), new Locale(locale.getLanguage(), locale.getCountry()), new Locale(locale.getLanguage()), new Locale("")};
        for (Locale object4 : localeArray) {
            string3 = "/org/netbeans/modules/reglib/resources/register" + (object4.toString().equals("") ? "" : "_" + object4) + ".html";
            LOG.log(Level.FINE, "Looking for html in: " + string3);
            inputStream = NbServiceTagSupport.class.getResourceAsStream(string3);
            if (inputStream != null) break;
        }
        LOG.log(Level.FINE, "Found html in: " + string3);
        LOG.log(Level.FINE, "Generating " + file3);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        PrintWriter printWriter = new PrintWriter(file3, "UTF-8");
        String string7 = null;
        String string8 = "";
        String string9 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            void var19_27;
            if (i > 0) {
                String string10 = (String)var19_25 + " " + NbBundle.getMessage(NbServiceTagSupport.class, "MSG_junction") + " ";
                string9 = string9 + " " + NbBundle.getMessage(NbServiceTagSupport.class, "MSG_junction") + " ";
            }
            String string11 = (String)var19_27 + "<strong>" + stringArray[i] + "</strong>";
            string9 = string9 + stringArray[i];
        }
        while ((string7 = bufferedReader.readLine()) != null) {
            String string12 = string7;
            if (string7.contains(PRODUCT_KEY)) {
                string12 = string7.replace(PRODUCT_KEY, (CharSequence)var19_25);
            } else if (string7.contains(PRODUCT_TITLE_KEY)) {
                string12 = string7.replace(PRODUCT_TITLE_KEY, string9);
            } else if (string7.contains(NB_HEADER_PNG_KEY)) {
                string12 = string7.replace(NB_HEADER_PNG_KEY, string4);
            } else if (string7.contains(REGISTRATION_URL_KEY)) {
                string12 = string7.replace(REGISTRATION_URL_KEY, string2);
            } else if (string7.contains(REGISTRATION_PAYLOAD_KEY)) {
                string12 = string7.replace(REGISTRATION_PAYLOAD_KEY, string5);
            }
            printWriter.println(string12);
        }
        printWriter.flush();
        printWriter.close();
        inputStream.close();
    }

    static {
        USER_HOME = System.getProperty("user.home");
        USER_DIR = System.getProperty("netbeans.user");
        LOG = Logger.getLogger("org.netbeans.modules.reglib.NbServiceTagSupport");
        inited = false;
    }
}

