/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.webui.themes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsf.services.RefreshService;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

final class ThemesFolderNode
extends AbstractNode {
    static final String BraveHeart_ThemeVersion = "1.0";
    static final RequestProcessor rp = new RequestProcessor();
    private final String displayName = NbBundle.getMessage(ThemesFolderNode.class, (String)"CTL_ThemesNode");
    private final Action[] themesNodeActions = new Action[0];
    private final Project project;

    ThemesFolderNode(Project project) {
        super((Children)new ThemesChildren(project));
        this.project = project;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.getDisplayName();
    }

    public Action[] getActions(boolean bl) {
        return this.themesNodeActions;
    }

    public Image getIcon(int n) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/webui/themes/resources/JSF-themesFolder.png");
    }

    public Image getOpenedIcon(int n) {
        return ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/webui/themes/resources/JSF-themesFolder.png");
    }

    public boolean canCopy() {
        return false;
    }

    public static Action createSetAsCurrentThemeAction(Library library, Project project) {
        return new SetAsCurrentThemeAction(library, project);
    }

    private static String getThemeLibraryVersion(Library library) {
        for (URL uRL : library.getContent("classpath")) {
            try {
                if (!uRL.getProtocol().equals("jar")) continue;
                FileObject fileObject = URLMapper.findFileObject((URL)(uRL = FileUtil.getArchiveFile((URL)uRL)));
                if (fileObject != null) {
                    File file = FileUtil.toFile((FileObject)fileObject);
                    if (file == null) continue;
                    return ThemesFolderNode.getThemeJarFileVersion(new JarFile(file));
                }
                ErrorManager.getDefault().log("Cannot find file object for " + uRL.toString());
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
        }
        return null;
    }

    private static String getThemeJarFileVersion(JarFile jarFile) {
        if (jarFile == null) {
            return null;
        }
        try {
            Manifest manifest = jarFile.getManifest();
            if (manifest != null) {
                Map<String, Attributes> map = manifest.getEntries();
                for (Attributes attributes : map.values()) {
                    String string = attributes.getValue("X-SJWUIC-Theme-Version");
                    if (!BraveHeart_ThemeVersion.equals(string)) continue;
                    return string;
                }
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        return null;
    }

    private static class SetAsCurrentThemeAction
    extends AbstractAction {
        private final Project project;
        private final Library theme;

        public SetAsCurrentThemeAction(Library library, Project project) {
            super(NbBundle.getMessage(ThemesFolderNode.class, (String)"LBL_SetAsCurrentTheme_Action"));
            this.project = project;
            this.theme = library;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Library library;
            String string = JsfProjectUtils.getProjectProperty((Project)this.project, (String)"jsf.current.theme");
            if (string == null) {
                string = "theme-default";
            }
            if ((library = JsfProjectUtils.getProjectLibraryManager((Project)this.project).getLibrary(string)) != null) {
                try {
                    JsfProjectUtils.removeLibraryReferences((Project)this.project, (Library[])new Library[]{library});
                    JsfProjectUtils.removeLocalizedTheme((Project)this.project, (String)string);
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify((Throwable)exception);
                }
            }
            JsfProjectUtils.putProjectProperty((Project)this.project, (String)"jsf.current.theme", (String)this.theme.getName());
            try {
                JsfProjectUtils.addLibraryReferences((Project)this.project, (Library[])new Library[]{this.theme});
                JsfProjectUtils.addLocalizedTheme((Project)this.project, (String)this.theme.getName());
                object = NbBundle.getMessage(ThemesFolderNode.class, (String)(Utilities.isWindows() ? "MSG_ThemeChangeRestartIDE" : "MSG_ThemeChangeRebuild"));
                DialogDescriptor dialogDescriptor = new DialogDescriptor(object, NbBundle.getMessage(NotifyDescriptor.class, (String)"NTF_InformationTitle"), true, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION, 0, new HelpCtx("projrave_ui_elements_dialogs_theme_switch_info_db"), null);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
            object = RefreshService.getDefault();
            if (object != null) {
                object.refresh(this.project);
            }
        }
    }

    private static class ThemeNode
    extends AbstractNode
    implements PropertyChangeListener {
        Project project;
        Library theme;
        Action setCurrentThemeAction = null;
        String version;

        public ThemeNode(Library library, Project project, String string) {
            super(Children.LEAF);
            this.setDisplayName(library.getDisplayName());
            this.project = project;
            this.theme = library;
            this.version = string;
            this.updateToolTip();
            this.updateIcon();
            JsfProjectUtils.addProjectPropertyListener((Project)project, (PropertyChangeListener)this);
            library.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)library));
        }

        public void destroy() throws IOException {
            JsfProjectUtils.removeProjectPropertyListener((Project)this.project, (PropertyChangeListener)this);
            super.destroy();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("jsf.current.theme")) {
                this.fireIconChange();
            } else if ("content".equals(propertyChangeEvent.getPropertyName())) {
                this.version = ThemesFolderNode.getThemeLibraryVersion(this.theme);
                this.updateToolTip();
                this.updateIcon();
            }
        }

        public Action[] getActions(boolean bl) {
            return new Action[]{this.getAction()};
        }

        public Action getAction() {
            if (this.setCurrentThemeAction == null) {
                this.setCurrentThemeAction = ThemesFolderNode.createSetAsCurrentThemeAction(this.theme, this.project);
            }
            return this.setCurrentThemeAction;
        }

        public Image getIcon(int n) {
            Image image = ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/webui/themes/resources/JSF-theme.png");
            String string = JsfProjectUtils.getProjectProperty((Project)this.project, (String)"jsf.current.theme");
            if (string != null && string.equals(this.theme.getName())) {
                Image image2 = ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/webui/themes/resources/JSF-currentThemeBadge.png");
                image = ImageUtilities.mergeImages((Image)image, (Image)image2, (int)image.getWidth(null), (int)(image.getHeight(null) - image2.getHeight(null) + 1));
                this.getAction().setEnabled(false);
            } else if (this.version != null) {
                this.getAction().setEnabled(true);
            } else {
                Image image3 = ImageUtilities.loadImage((String)"org/netbeans/modules/visualweb/webui/themes/resources/JSF-error-badge.gif");
                image = ImageUtilities.mergeImages((Image)image, (Image)image3, (int)image.getWidth(null), (int)(image.getHeight(null) - image3.getHeight(null) + 1));
                this.getAction().setEnabled(false);
            }
            return image;
        }

        private void updateToolTip() {
            String string = this.version != null ? NbBundle.getMessage(ThemesFolderNode.class, (String)"LBL_ThemeLibraryDescription") : NbBundle.getMessage(ThemesFolderNode.class, (String)"LBL_ThemeLibraryDescription_Invalid");
            this.setShortDescription(string);
        }

        private void updateIcon() {
            this.fireIconChange();
        }
    }

    private static class ThemesChildren
    extends Children.Keys
    implements PropertyChangeListener {
        private final Project project;
        private final LibraryManager projectLibraryManager;
        private final LibraryManager globalLibraryManager;

        ThemesChildren(Project project) {
            this.project = project;
            this.projectLibraryManager = JsfProjectUtils.getProjectLibraryManager((Project)project);
            this.globalLibraryManager = LibraryManager.getDefault();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setKeys(this.getKeys());
        }

        protected void addNotify() {
            this.projectLibraryManager.addPropertyChangeListener((PropertyChangeListener)this);
            this.globalLibraryManager.addPropertyChangeListener((PropertyChangeListener)this);
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.projectLibraryManager.removePropertyChangeListener((PropertyChangeListener)this);
            this.globalLibraryManager.removePropertyChangeListener((PropertyChangeListener)this);
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            String string = ThemesFolderNode.getThemeLibraryVersion((Library)object);
            if (ThemesFolderNode.BraveHeart_ThemeVersion.equals(string)) {
                ThemeNode themeNode = new ThemeNode((Library)object, this.project, string);
                return new Node[]{themeNode};
            }
            return new Node[0];
        }

        private Collection getKeys() {
            HashMap<String, Library> hashMap = new HashMap<String, Library>();
            Library[] libraryArray = this.projectLibraryManager.getLibraries();
            for (int i = 0; i < libraryArray.length; ++i) {
                Library library = libraryArray[i];
                if (!"theme".equals(library.getType()) || hashMap.containsKey(library.getName())) continue;
                hashMap.put(library.getName(), library);
            }
            Library[] libraryArray2 = this.globalLibraryManager.getLibraries();
            for (int i = 0; i < libraryArray2.length; ++i) {
                Library library = libraryArray2[i];
                if (!"theme".equals(library.getType()) || hashMap.containsKey(library.getName())) continue;
                hashMap.put(library.getName(), library);
            }
            return hashMap.values();
        }
    }
}

