/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.ant.AntArtifactQuery;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.api.ejbjar.EjbReference;
import org.netbeans.modules.j2ee.common.method.MethodModel;
import org.netbeans.modules.j2ee.common.method.MethodModelSupport;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.api.methodcontroller.EjbMethodController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static String toClasspathString(File[] fileArray) {
        if (fileArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer.append(fileArray[i].getAbsolutePath());
            if (i + 1 >= fileArray.length) continue;
            stringBuffer.append(':');
        }
        return stringBuffer.toString();
    }

    public static void notifyError(Exception exception) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)exception.getMessage(), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    public static boolean areInSameJ2EEApp(Project project, Project project2) {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            List<J2eeModuleProvider> list;
            J2eeApplicationProvider j2eeApplicationProvider;
            J2eeModuleProvider[] j2eeModuleProviderArray;
            Project project3 = projectArray[i];
            Object object = project3.getLookup().lookup(J2eeApplicationProvider.class);
            if (object == null || (j2eeModuleProviderArray = (j2eeApplicationProvider = (J2eeApplicationProvider)object).getChildModuleProviders()) == null || j2eeModuleProviderArray.length <= 0) continue;
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            J2eeModuleProvider j2eeModuleProvider2 = (J2eeModuleProvider)project2.getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider == null || j2eeModuleProvider2 == null || !(list = Arrays.asList(j2eeModuleProviderArray)).contains(j2eeModuleProvider) || !list.contains(j2eeModuleProvider2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPartOfJ2eeApp(J2eeModuleProvider j2eeModuleProvider) {
        for (Project project : OpenProjects.getDefault().getOpenProjects()) {
            J2eeApplicationProvider j2eeApplicationProvider = (J2eeApplicationProvider)project.getLookup().lookup(J2eeApplicationProvider.class);
            if (j2eeApplicationProvider == null || !Arrays.asList(j2eeApplicationProvider.getChildModuleProviders()).contains(j2eeModuleProvider)) continue;
            return true;
        }
        return false;
    }

    public static boolean canExposeInLocal(FileObject fileObject, final ElementHandle<ExecutableElement> elementHandle) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final String[] stringArray = new String[1];
        final MethodModel[] methodModelArray = new MethodModel[1];
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                boolean bl;
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)workingCopy);
                Set<Modifier> set = executableElement.getModifiers();
                boolean bl2 = bl = set.contains((Object)Modifier.PUBLIC) && !set.contains((Object)Modifier.STATIC);
                if (bl) {
                    Element element = executableElement.getEnclosingElement();
                    stringArray[0] = ((TypeElement)element).getQualifiedName().toString();
                    methodModelArray[0] = MethodModelSupport.createMethodModel((CompilationController)workingCopy, (ExecutableElement)executableElement);
                }
            }
        });
        if (methodModelArray[0] != null) {
            EjbMethodController ejbMethodController = EjbMethodController.createFromClass(fileObject, stringArray[0]);
            return ejbMethodController != null && ejbMethodController.hasLocal() && !ejbMethodController.hasMethodInInterface(methodModelArray[0], ejbMethodController.getMethodTypeFromImpl(methodModelArray[0]), true);
        }
        return false;
    }

    public static void exposeInLocal(FileObject fileObject, final ElementHandle<ExecutableElement> elementHandle) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final String[] stringArray = new String[1];
        final MethodModel[] methodModelArray = new MethodModel[1];
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)workingCopy);
                Element element = executableElement.getEnclosingElement();
                stringArray[0] = ((TypeElement)element).getQualifiedName().toString();
                methodModelArray[0] = MethodModelSupport.createMethodModel((CompilationController)workingCopy, (ExecutableElement)executableElement);
            }
        });
        EjbMethodController ejbMethodController = EjbMethodController.createFromClass(fileObject, stringArray[0]);
        ejbMethodController.createAndAddInterface(methodModelArray[0], true);
    }

    public static boolean canExposeInRemote(FileObject fileObject, final ElementHandle<ExecutableElement> elementHandle) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final String[] stringArray = new String[1];
        final MethodModel[] methodModelArray = new MethodModel[1];
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                boolean bl;
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)workingCopy);
                Set<Modifier> set = executableElement.getModifiers();
                boolean bl2 = bl = set.contains((Object)Modifier.PUBLIC) && !set.contains((Object)Modifier.STATIC);
                if (bl) {
                    Element element = executableElement.getEnclosingElement();
                    stringArray[0] = ((TypeElement)element).getQualifiedName().toString();
                    methodModelArray[0] = MethodModelSupport.createMethodModel((CompilationController)workingCopy, (ExecutableElement)executableElement);
                }
            }
        });
        if (methodModelArray[0] != null) {
            EjbMethodController ejbMethodController = EjbMethodController.createFromClass(fileObject, stringArray[0]);
            return ejbMethodController != null && ejbMethodController.hasRemote() && !ejbMethodController.hasMethodInInterface(methodModelArray[0], ejbMethodController.getMethodTypeFromImpl(methodModelArray[0]), true);
        }
        return false;
    }

    public static void exposeInRemote(FileObject fileObject, final ElementHandle<ExecutableElement> elementHandle) throws IOException {
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final String[] stringArray = new String[1];
        final MethodModel[] methodModelArray = new MethodModel[1];
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ExecutableElement executableElement = (ExecutableElement)elementHandle.resolve((CompilationInfo)workingCopy);
                Element element = executableElement.getEnclosingElement();
                stringArray[0] = ((TypeElement)element).getQualifiedName().toString();
                methodModelArray[0] = MethodModelSupport.createMethodModel((CompilationController)workingCopy, (ExecutableElement)executableElement);
            }
        });
        EjbMethodController ejbMethodController = EjbMethodController.createFromClass(fileObject, stringArray[0]);
        ejbMethodController.createAndAddInterface(methodModelArray[0], false);
    }

    public static Project[] getCallableEjbProjects(Project project) {
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        boolean bl = project.getClass().getName().equals("org.netbeans.modules.ant.freeform.FreeformProject");
        ArrayList<Project> arrayList = new ArrayList<Project>(projectArray.length);
        for (int i = 0; i < projectArray.length; ++i) {
            boolean bl2 = false;
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)projectArray[i].getLookup().lookup(J2eeModuleProvider.class);
            if (j2eeModuleProvider != null && j2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.EJB)) {
                bl2 = true;
            }
            if ((!bl2 || bl) && (!bl || !project.equals(projectArray[i]))) continue;
            arrayList.add(projectArray[i]);
        }
        return arrayList.toArray(new Project[arrayList.size()]);
    }

    public static boolean isJavaEE5orHigher(Project project) {
        J2eeModule j2eeModule;
        if (project == null) {
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (j2eeModule = j2eeModuleProvider.getJ2eeModule()) != null) {
            Object object = j2eeModule.getModuleType();
            double d = Double.parseDouble(j2eeModule.getModuleVersion());
            if (J2eeModule.EJB.equals(object) && d > 2.1) {
                return true;
            }
            if (J2eeModule.WAR.equals(object) && d > 2.4) {
                return true;
            }
            if (J2eeModule.CLIENT.equals(object) && d > 1.4) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAppClient(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        return j2eeModuleProvider != null ? j2eeModuleProvider.getJ2eeModule().getModuleType().equals(J2eeModule.CLIENT) : false;
    }

    public static boolean isTargetJavaSE(FileObject fileObject, final String string) throws IOException {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project.getLookup().lookup(J2eeModuleProvider.class) == null) {
            return true;
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        if (javaSource == null) {
            return false;
        }
        final boolean[] blArray = new boolean[]{false};
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController compilationController) throws IOException {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = compilationController.getElements().getTypeElement(string);
                TypeElement typeElement2 = compilationController.getElements().getTypeElement("junit.framework.TestCase");
                if (typeElement2 != null) {
                    blArray[0] = compilationController.getTypes().isSubtype(typeElement.asType(), typeElement2.asType());
                }
            }
        }, true);
        return blArray[0];
    }

    public static String jndiNameToCamelCase(String string, boolean bl, String string2) {
        String string3 = string;
        if (string2 != null && string.startsWith(string2)) {
            string3 = string.substring(string.indexOf(string2) + string2.length());
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : string3.split("/")) {
            if (string4.length() == 0) continue;
            char c = string4.charAt(0);
            c = bl && stringBuilder.length() == 0 && !Utils.isAllUpperCase(string4) ? Character.toLowerCase(c) : Character.toUpperCase(c);
            stringBuilder.append(c);
            stringBuilder.append(string4.substring(1));
        }
        return stringBuilder.toString();
    }

    public static AntArtifact getAntArtifact(final EjbReference ejbReference) throws IOException {
        MetadataModel metadataModel = ejbReference.getEjbModule().getMetadataModel();
        FileObject fileObject = (FileObject)metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, FileObject>(){

            public FileObject run(EjbJarMetadata ejbJarMetadata) throws Exception {
                return ejbJarMetadata.findResource(Utils.toResourceName(ejbReference.getEjbClass()));
            }
        });
        if (fileObject == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        AntArtifact[] antArtifactArray = AntArtifactQuery.findArtifactsByType((Project)project, (String)"jar");
        boolean bl = antArtifactArray != null && antArtifactArray.length > 0;
        return bl ? antArtifactArray[0] : null;
    }

    public static String toResourceName(String string) {
        assert (string != null) : "cannot find null className";
        return string.replace('.', '/') + ".java";
    }

    private static boolean isAllUpperCase(String string) {
        if (string.length() <= 1) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }
}

